/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.ibatis;

import java.sql.Connection;
import org.alfresco.ibatis.SqlSessionMetricsWrapper;
import org.alfresco.metrics.db.DBMetricsReporter;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.TransactionIsolationLevel;
import org.apache.ibatis.session.defaults.DefaultSqlSessionFactory;

public class AlfrescoDefaultSqlSessionFactory
extends DefaultSqlSessionFactory {
    private final DBMetricsReporter dbMetricsReporter;

    public AlfrescoDefaultSqlSessionFactory(Configuration configuration, DBMetricsReporter dbMetricsReporter) {
        super(configuration);
        this.dbMetricsReporter = dbMetricsReporter;
    }

    public SqlSession openSession() {
        SqlSession sqlSession = super.openSession();
        return this.buildSqlSessionMetricsWrapper(sqlSession);
    }

    public SqlSession openSession(boolean autoCommit) {
        SqlSession sqlSession = super.openSession(autoCommit);
        return this.buildSqlSessionMetricsWrapper(sqlSession);
    }

    public SqlSession openSession(ExecutorType execType) {
        SqlSession sqlSession = super.openSession(execType);
        return this.buildSqlSessionMetricsWrapper(sqlSession);
    }

    public SqlSession openSession(TransactionIsolationLevel level) {
        SqlSession sqlSession = super.openSession(level);
        return this.buildSqlSessionMetricsWrapper(sqlSession);
    }

    public SqlSession openSession(ExecutorType execType, TransactionIsolationLevel level) {
        SqlSession sqlSession = super.openSession(execType, level);
        return this.buildSqlSessionMetricsWrapper(sqlSession);
    }

    public SqlSession openSession(ExecutorType execType, boolean autoCommit) {
        SqlSession sqlSession = super.openSession(execType, autoCommit);
        return this.buildSqlSessionMetricsWrapper(sqlSession);
    }

    public SqlSession openSession(Connection connection) {
        SqlSession sqlSession = super.openSession(connection);
        return this.buildSqlSessionMetricsWrapper(sqlSession);
    }

    public SqlSession openSession(ExecutorType execType, Connection connection) {
        SqlSession sqlSession = super.openSession(execType, connection);
        return this.buildSqlSessionMetricsWrapper(sqlSession);
    }

    private SqlSession buildSqlSessionMetricsWrapper(SqlSession sqlSession) {
        return new SqlSessionMetricsWrapper(sqlSession, this.dbMetricsReporter);
    }
}

