/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2.script;

import java.util.List;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.rendition2.RenditionService2;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptRenditionService2
extends BaseScopableProcessorExtension {
    private static final Log logger = LogFactory.getLog(ScriptRenditionService2.class);
    private ServiceRegistry serviceRegistry;
    private RenditionService2 renditionService;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.renditionService = serviceRegistry.getRenditionService2();
    }

    public void render(ScriptNode sourceNode, String renditionName) {
        if (logger.isDebugEnabled()) {
            String msg = "Rendering source node '" + String.valueOf(sourceNode) + "' with renditionDef '" + renditionName + "'";
            logger.debug((Object)msg);
        }
        this.renditionService.render(sourceNode.getNodeRef(), renditionName);
    }

    public ScriptNode[] getRenditions(ScriptNode node) {
        List<ChildAssociationRef> renditions = this.renditionService.getRenditions(node.getNodeRef());
        ScriptNode[] renditionObjs = new ScriptNode[renditions.size()];
        int i = 0;
        while (i < renditions.size()) {
            renditionObjs[i] = new ScriptNode(renditions.get(i).getChildRef(), this.serviceRegistry);
            ++i;
        }
        return renditionObjs;
    }

    public ScriptNode getRenditionByName(ScriptNode node, String renditionName) {
        ChildAssociationRef result = this.renditionService.getRenditionByName(node.getNodeRef(), renditionName);
        return result == null ? null : new ScriptNode(result.getChildRef(), this.serviceRegistry);
    }
}

