/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import jakarta.transaction.UserTransaction;
import java.util.Date;
import junit.framework.TestCase;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.opencmis.search.CMISQueryService;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={LuceneTests.class})
public abstract class BaseCMISTest
extends TestCase {
    protected ApplicationContext ctx;
    protected CMISMapping cmisMapping;
    protected CMISConnector cmisConnector;
    protected CMISDictionaryService cmisDictionaryService;
    protected DictionaryService dictionaryService;
    protected TransactionService transactionService;
    protected AuthenticationComponent authenticationComponent;
    protected UserTransaction testTX;
    protected NodeService nodeService;
    protected NodeRef rootNodeRef;
    protected FileFolderService fileFolderService;
    protected ServiceRegistry serviceRegistry;
    protected NamespaceService namespaceService;
    protected CMISQueryService cmisQueryService;
    protected MutableAuthenticationService authenticationService;
    protected MutableAuthenticationDao authenticationDAO;
    protected SearchService searchService;
    protected ContentService contentService;
    protected PermissionService permissionService;
    protected ThumbnailService thumbnailService;
    protected ModelDAO permissionModelDao;
    protected DictionaryDAO dictionaryDAO;
    protected NamespaceDAO namespaceDao;
    protected VersionService versionService;
    protected StoreRef storeRef;

    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        this.serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.cmisDictionaryService = (CMISDictionaryService)this.ctx.getBean("OpenCMISDictionaryService");
        this.cmisMapping = (CMISMapping)this.ctx.getBean("OpenCMISMapping");
        this.cmisQueryService = (CMISQueryService)this.ctx.getBean("OpenCMISQueryService");
        this.cmisConnector = (CMISConnector)this.ctx.getBean("CMISConnector");
        this.dictionaryService = (DictionaryService)this.ctx.getBean("dictionaryService");
        this.nodeService = (NodeService)this.ctx.getBean("nodeService");
        this.fileFolderService = (FileFolderService)this.ctx.getBean("fileFolderService");
        this.namespaceService = (NamespaceService)this.ctx.getBean("namespaceService");
        this.transactionService = (TransactionService)this.ctx.getBean("transactionComponent");
        this.authenticationComponent = (AuthenticationComponent)this.ctx.getBean("authenticationComponent");
        this.searchService = (SearchService)this.ctx.getBean("searchService");
        this.contentService = (ContentService)this.ctx.getBean("contentService");
        this.permissionService = (PermissionService)this.ctx.getBean("permissionService");
        this.versionService = (VersionService)this.ctx.getBean("versionService");
        this.authenticationService = (MutableAuthenticationService)this.ctx.getBean("authenticationService");
        this.authenticationDAO = (MutableAuthenticationDao)this.ctx.getBean("authenticationDao");
        this.thumbnailService = (ThumbnailService)this.ctx.getBean("thumbnailService");
        this.permissionModelDao = (ModelDAO)this.ctx.getBean("permissionsModelDAO");
        this.dictionaryDAO = (DictionaryDAO)this.ctx.getBean("dictionaryDAO");
        this.namespaceDao = (NamespaceDAO)this.ctx.getBean("namespaceDAO");
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        String storeName = "CMISTest-" + this.getStoreName() + "-" + new Date().getTime();
        this.storeRef = this.nodeService.createStore("workspace", storeName);
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        if (this.authenticationDAO.userExists("cmis")) {
            this.authenticationService.deleteAuthentication("cmis");
        }
        this.authenticationService.createAuthentication("cmis", "cmis".toCharArray());
    }

    private String getStoreName() {
        String testName = this.getName();
        testName = testName.replace("_", "-");
        testName = testName.replace("%", "-");
        return testName;
    }

    protected void runAs(String userName) {
        this.authenticationService.authenticate(userName, userName.toCharArray());
        BaseCMISTest.assertNotNull((Object)this.authenticationService.getCurrentUserName());
    }

    protected void tearDown() throws Exception {
        if (this.testTX.getStatus() == 0) {
            this.testTX.rollback();
        }
        super.tearDown();
        AuthenticationUtil.clearCurrentSecurityContext();
    }
}

