/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.PathHelper;
import org.alfresco.repo.transfer.TestTransferCallback;
import org.alfresco.repo.transfer.TransferContext;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.TransferServiceImpl2;
import org.alfresco.repo.transfer.TransferTransmitter;
import org.alfresco.repo.transfer.UnitTestInProcessTransmitterImpl;
import org.alfresco.repo.transfer.UnitTestTransferManifestNodeFactory;
import org.alfresco.repo.transfer.manifest.TransferManifestNodeFactory;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.cmr.transfer.TransferCallback;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferEvent;
import org.alfresco.service.cmr.transfer.TransferEventBegin;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.cmr.transfer.TransferService;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.testing.category.RedundantTests;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.springframework.test.context.transaction.TestTransaction;

@Category(value={BaseSpringTestsCategory.class})
public class TransferServiceImplTest
extends BaseAlfrescoSpringTest {
    private TransferService transferService;
    private ContentService contentService;
    private TransferServiceImpl2 transferServiceImpl;
    private SearchService searchService;
    private TransactionService transactionService;
    private TransferReceiver receiver;
    private TransferManifestNodeFactory transferManifestNodeFactory;
    private PermissionService permissionService;
    private LockService lockService;
    private PersonService personService;
    private DescriptorService descriptorService;
    private CopyService copyService;
    private Descriptor serverDescriptor;
    private TaggingService taggingService;
    private CategoryService categoryService;
    private Repository repositoryHelper;
    String COMPANY_HOME_XPATH_QUERY = "/{http://www.alfresco.org/model/application/1.0}company_home";
    String GUEST_HOME_XPATH_QUERY = "/{http://www.alfresco.org/model/application/1.0}company_home/{http://www.alfresco.org/model/application/1.0}guest_home";
    String REPO_ID_A = "RepoIdA";
    String REPO_ID_B;
    String REPO_ID_C = "RepoIdC";

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.transferService = (TransferService)this.applicationContext.getBean("TransferService");
        this.contentService = (ContentService)this.applicationContext.getBean("ContentService");
        this.transferServiceImpl = (TransferServiceImpl2)this.applicationContext.getBean("transferService2");
        this.searchService = (SearchService)this.applicationContext.getBean("SearchService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("TransactionService");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        this.receiver = (TransferReceiver)this.applicationContext.getBean("transferReceiver");
        this.transferManifestNodeFactory = (TransferManifestNodeFactory)this.applicationContext.getBean("transferManifestNodeFactory");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.lockService = (LockService)this.applicationContext.getBean("lockService");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.descriptorService = (DescriptorService)this.applicationContext.getBean("DescriptorService");
        this.copyService = (CopyService)this.applicationContext.getBean("CopyService");
        this.taggingService = (TaggingService)this.applicationContext.getBean("TaggingService");
        this.categoryService = (CategoryService)this.applicationContext.getBean("CategoryService");
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.serverDescriptor = this.descriptorService.getServerDescriptor();
        this.REPO_ID_B = this.descriptorService.getCurrentRepositoryDescriptor().getId();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        TransferServiceImplTest.assertNotNull((String)"receiver is null", (Object)this.receiver);
        TestTransaction.flagForCommit();
        TestTransaction.end();
    }

    @Test
    public void testSetup() {
        TransferServiceImplTest.assertEquals((String)"Must run without transactions", (Object)AlfrescoTransactionSupport.TxnReadState.TXN_NONE, (Object)AlfrescoTransactionSupport.getTransactionReadState());
    }

    @Test
    public void testCreateTarget() throws Exception {
        String name = "Test Transfer Target " + GUID.generate();
        String title = "title";
        String description = "description";
        String endpointProtocol = "http";
        String endpointHost = "localhost";
        int endpointPort = 8080;
        String endpointPath = "rhubarb";
        String username = "admin";
        char[] password = "password".toCharArray();
        TransferTarget ret = this.transferService.createAndSaveTransferTarget(name, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
        TransferServiceImplTest.assertNotNull((String)"return value is null", (Object)ret);
        TransferServiceImplTest.assertNotNull((String)"node ref is null", (Object)ret.getNodeRef());
        TransferServiceImplTest.assertEquals((String)"name not equal", (String)ret.getName(), (String)name);
        TransferServiceImplTest.assertEquals((String)"title not equal", (String)ret.getTitle(), (String)title);
        TransferServiceImplTest.assertEquals((String)"description not equal", (String)ret.getDescription(), (String)description);
        TransferServiceImplTest.assertEquals((String)"endpointProtocol not equal", (String)ret.getEndpointProtocol(), (String)endpointProtocol);
        TransferServiceImplTest.assertEquals((String)"endpointHost not equal", (String)ret.getEndpointHost(), (String)endpointHost);
        TransferServiceImplTest.assertEquals((String)"endpointPort not equal", (int)ret.getEndpointPort(), (int)endpointPort);
        TransferServiceImplTest.assertEquals((String)"endpointPath not equal", (String)ret.getEndpointPath(), (String)endpointPath);
        TransferServiceImplTest.assertEquals((String)"username not equal", (String)ret.getUsername(), (String)username);
        char[] password2 = ret.getPassword();
        TransferServiceImplTest.assertEquals((int)password.length, (int)password2.length);
        int i = 0;
        while (i < password.length) {
            if (password[i] != password2[i]) {
                TransferServiceImplTest.fail((String)("password not equal:" + new String(password) + new String(password2)));
            }
            ++i;
        }
        try {
            this.transferService.createAndSaveTransferTarget(name, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
            TransferServiceImplTest.fail((String)"duplicate name not detected");
        }
        catch (TransferException transferException) {}
    }

    @Test
    public void testCreateTargetSyntax2() throws Exception {
        String name = "Test Transfer Target " + GUID.generate();
        String title = "title";
        String description = "description";
        String endpointProtocol = "http";
        String endpointHost = "localhost";
        int endpointPort = 8080;
        String endpointPath = "rhubarb";
        String username = "admin";
        char[] password = "password".toCharArray();
        TransferTarget newValue = this.transferService.createTransferTarget(name);
        newValue.setDescription(description);
        newValue.setEndpointHost(endpointHost);
        newValue.setEndpointPort(endpointPort);
        newValue.setEndpointPath(endpointPath);
        newValue.setEndpointProtocol(endpointProtocol);
        newValue.setPassword(password);
        newValue.setTitle(title);
        newValue.setUsername(username);
        TransferTarget ret = this.transferService.saveTransferTarget(newValue);
        TransferServiceImplTest.assertNotNull((String)"return value is null", (Object)ret);
        TransferServiceImplTest.assertNotNull((String)"node ref is null", (Object)ret.getNodeRef());
        TransferServiceImplTest.assertEquals((String)"name not equal", (String)ret.getName(), (String)name);
        TransferServiceImplTest.assertEquals((String)"title not equal", (String)ret.getTitle(), (String)title);
        TransferServiceImplTest.assertEquals((String)"description not equal", (String)ret.getDescription(), (String)description);
        TransferServiceImplTest.assertEquals((String)"endpointProtocol not equal", (String)ret.getEndpointProtocol(), (String)endpointProtocol);
        TransferServiceImplTest.assertEquals((String)"endpointHost not equal", (String)ret.getEndpointHost(), (String)endpointHost);
        TransferServiceImplTest.assertEquals((String)"endpointPort not equal", (int)ret.getEndpointPort(), (int)endpointPort);
        TransferServiceImplTest.assertEquals((String)"endpointPath not equal", (String)ret.getEndpointPath(), (String)endpointPath);
        TransferServiceImplTest.assertEquals((String)"username not equal", (String)ret.getUsername(), (String)username);
        char[] password2 = ret.getPassword();
        TransferServiceImplTest.assertEquals((int)password.length, (int)password2.length);
        int i = 0;
        while (i < password.length) {
            if (password[i] != password2[i]) {
                TransferServiceImplTest.fail((String)("password not equal:" + new String(password) + new String(password2)));
            }
            ++i;
        }
        try {
            this.transferService.createAndSaveTransferTarget(name, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
            TransferServiceImplTest.fail((String)"duplicate name not detected");
        }
        catch (TransferException transferException) {}
    }

    @Test
    public void testGetTransferTargets() throws Exception {
        String nameA = "Test Transfer Target " + GUID.generate();
        String nameB = "Test Transfer Target " + GUID.generate();
        String title = "title";
        String description = "description";
        String endpointProtocol = "http";
        String endpointHost = "localhost";
        int endpointPort = 8080;
        String endpointPath = "rhubarb";
        String username = "admin";
        char[] password = "password".toCharArray();
        TransferTarget targetA = this.transferService.createAndSaveTransferTarget(nameA, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
        TransferTarget targetB = this.transferService.createAndSaveTransferTarget(nameB, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
        Set targets = this.transferService.getTransferTargets();
        TransferServiceImplTest.assertTrue((String)"targets is empty", (targets.size() > 0 ? 1 : 0) != 0);
        TransferServiceImplTest.assertTrue((String)"didn't find target A", (boolean)targets.contains(targetA));
        TransferServiceImplTest.assertTrue((String)"didn't find target B", (boolean)targets.contains(targetB));
        for (TransferTarget target : targets) {
            System.out.println("found target: " + target.getName());
        }
    }

    @Test
    public void testALF6565() throws Exception {
        String nameA = GUID.generate();
        String nameB = GUID.generate();
        String title = "title";
        String description = "description";
        String endpointProtocol = "http";
        String endpointHost = "localhost";
        int endpointPort = 8080;
        String endpointPath = "rhubarb";
        String username = "admin";
        char[] password = "password".toCharArray();
        TransferTarget targetA = this.transferService.createAndSaveTransferTarget(nameA, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
        TransferTarget targetB = this.transferService.createAndSaveTransferTarget(nameB, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
        NodeRef transferHome = this.transferServiceImpl.getTransferHome();
        NodeRef defaultGroup = this.transferServiceImpl.getDefaultGroup();
        TransferServiceImplTest.assertNotNull((Object)defaultGroup);
        this.copyService.copyAndRename(defaultGroup, transferHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"test"), true);
        Set targets = this.transferService.getTransferTargets();
        int targetACount = 0;
        int targetBCount = 0;
        for (TransferTarget target : targets) {
            if (target.getName().equals(nameA)) {
                ++targetACount;
            }
            if (!target.getName().equals(nameB)) continue;
            ++targetBCount;
        }
        TransferServiceImplTest.assertEquals((int)2, (int)targetACount);
        TransferServiceImplTest.assertEquals((int)2, (int)targetBCount);
        TransferServiceImplTest.assertEquals((Object)targetA.getNodeRef(), (Object)this.transferService.getTransferTarget(nameA).getNodeRef());
        TransferServiceImplTest.assertEquals((Object)targetB.getNodeRef(), (Object)this.transferService.getTransferTarget(nameB).getNodeRef());
    }

    @Test
    public void testGetAllTransferTargetsByGroup() throws Exception {
        String getMe = "Test Transfer Target " + GUID.generate();
        String title = "title";
        String description = "description";
        String endpointProtocol = "http";
        String endpointHost = "localhost";
        int endpointPort = 8080;
        String endpointPath = "rhubarb";
        String username = "admin";
        char[] password = "password".toCharArray();
        this.transferService.createAndSaveTransferTarget(getMe, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
        Set targets = this.transferService.getTransferTargets("Default Group");
        TransferServiceImplTest.assertTrue((String)"targets is empty", (targets.size() > 0 ? 1 : 0) != 0);
        try {
            targets = this.transferService.getTransferTargets("Rubbish");
            TransferServiceImplTest.assertTrue((String)"targets is empty", (targets.size() > 0 ? 1 : 0) != 0);
            TransferServiceImplTest.fail((String)"group does not exist");
        }
        catch (TransferException transferException) {}
    }

    @Test
    public void testUpdateTransferTarget() throws Exception {
        String updateMe = "Test Transfer Target " + GUID.generate();
        String title = "title";
        String description = "description";
        String endpointProtocol = "http";
        String endpointHost = "localhost";
        int endpointPort = 8080;
        String endpointPath = "rhubarb";
        String username = "admin";
        char[] password = "password".toCharArray();
        TransferTarget target = this.transferService.createAndSaveTransferTarget(updateMe, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
        TransferTarget update1 = this.transferService.saveTransferTarget(target);
        TransferServiceImplTest.assertNotNull((String)"return value is null", (Object)update1);
        TransferServiceImplTest.assertNotNull((String)"node ref is null", (Object)update1.getNodeRef());
        TransferServiceImplTest.assertEquals((String)"name not equal", (String)update1.getName(), (String)updateMe);
        TransferServiceImplTest.assertEquals((String)"title not equal", (String)update1.getTitle(), (String)title);
        TransferServiceImplTest.assertEquals((String)"description not equal", (String)update1.getDescription(), (String)description);
        TransferServiceImplTest.assertEquals((String)"endpointProtocol not equal", (String)update1.getEndpointProtocol(), (String)endpointProtocol);
        TransferServiceImplTest.assertEquals((String)"endpointHost not equal", (String)update1.getEndpointHost(), (String)endpointHost);
        TransferServiceImplTest.assertEquals((String)"endpointPort not equal", (int)update1.getEndpointPort(), (int)endpointPort);
        TransferServiceImplTest.assertEquals((String)"endpointPath not equal", (String)update1.getEndpointPath(), (String)endpointPath);
        TransferServiceImplTest.assertEquals((String)"username not equal", (String)update1.getUsername(), (String)username);
        char[] pass = update1.getPassword();
        TransferServiceImplTest.assertEquals((int)password.length, (int)pass.length);
        int i = 0;
        while (i < password.length) {
            if (password[i] != pass[i]) {
                TransferServiceImplTest.fail((String)("password not equal:" + new String(password) + new String(pass)));
            }
            ++i;
        }
        String title2 = "Two";
        String description2 = "descriptionTwo";
        String endpointProtocol2 = "https";
        String endpointHost2 = "1.0.0.127";
        int endpointPort2 = 4040;
        String endpointPath2 = "custard";
        String username2 = "admin_two";
        char[] password2 = "two".toCharArray();
        target.setDescription(description2);
        target.setTitle(title2);
        target.setEndpointHost(endpointHost2);
        target.setEndpointPath(endpointPath2);
        target.setEndpointPort(endpointPort2);
        target.setEndpointProtocol(endpointProtocol2);
        target.setPassword(password2);
        target.setUsername(username2);
        TransferTarget update2 = this.transferService.saveTransferTarget(target);
        TransferServiceImplTest.assertNotNull((String)"return value is null", (Object)update2);
        TransferServiceImplTest.assertNotNull((String)"node ref is null", (Object)update2.getNodeRef());
        TransferServiceImplTest.assertEquals((String)"name not equal", (String)update2.getName(), (String)updateMe);
        TransferServiceImplTest.assertEquals((String)"title not equal", (String)update2.getTitle(), (String)title2);
        TransferServiceImplTest.assertEquals((String)"description not equal", (String)update2.getDescription(), (String)description2);
        TransferServiceImplTest.assertEquals((String)"endpointProtocol not equal", (String)update2.getEndpointProtocol(), (String)endpointProtocol2);
        TransferServiceImplTest.assertEquals((String)"endpointHost not equal", (String)update2.getEndpointHost(), (String)endpointHost2);
        TransferServiceImplTest.assertEquals((String)"endpointPort not equal", (int)update2.getEndpointPort(), (int)endpointPort2);
        TransferServiceImplTest.assertEquals((String)"endpointPath not equal", (String)update2.getEndpointPath(), (String)endpointPath2);
        TransferServiceImplTest.assertEquals((String)"username not equal", (String)update2.getUsername(), (String)username2);
        pass = update2.getPassword();
        TransferServiceImplTest.assertEquals((int)password2.length, (int)pass.length);
        int i2 = 0;
        while (i2 < pass.length) {
            if (pass[i2] != password2[i2]) {
                TransferServiceImplTest.fail((String)("password not equal:" + new String(pass) + new String(password2)));
            }
            ++i2;
        }
    }

    @Test
    public void testDeleteTransferTarget() throws Exception {
        String deleteMe = "deleteMe";
        String title = "title";
        String description = "description";
        String endpointProtocol = "http";
        String endpointHost = "localhost";
        int endpointPort = 8080;
        String endpointPath = "rhubarb";
        String username = "admin";
        char[] password = "password".toCharArray();
        this.transferService.createAndSaveTransferTarget(deleteMe, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
        this.transferService.deleteTransferTarget(deleteMe);
        try {
            this.transferService.deleteTransferTarget(deleteMe);
            TransferServiceImplTest.fail((String)"duplicate name not detected");
        }
        catch (TransferException transferException) {}
        try {
            this.transferService.deleteTransferTarget("rubbish");
            TransferServiceImplTest.fail((String)"rubbish deleted");
        }
        catch (TransferException transferException) {}
    }

    @Test
    public void testEnableTransferTarget() throws Exception {
        String targetName = "enableMe";
        TransferTarget enableMe = this.createTransferTarget(targetName);
        try {
            TransferTarget target = this.transferService.getTransferTarget(targetName);
            TransferServiceImplTest.assertTrue((String)"new target is not enabled", (boolean)enableMe.isEnabled());
            this.transferService.enableTransferTarget(targetName, false);
            target = this.transferService.getTransferTarget(targetName);
            TransferServiceImplTest.assertFalse((String)"target is not disabled", (boolean)target.isEnabled());
            this.transferService.enableTransferTarget(targetName, true);
            target = this.transferService.getTransferTarget(targetName);
            TransferServiceImplTest.assertTrue((String)"re-enabled target is not enabled", (boolean)target.isEnabled());
        }
        finally {
            this.transferService.deleteTransferTarget(targetName);
        }
    }

    @Test
    public void testTransferOneNode() throws Exception {
        HashSet<NodeRef> nodes;
        TransferDefinition definition;
        final Locale CONTENT_LOCALE = Locale.GERMAN;
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        final UnitTestTransferManifestNodeFactory testNodeFactory = this.unitTestKludgeToTransferGuestHomeToCompanyHome();
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        class TestContext {
            TransferTarget transferMe;
            NodeRef contentNodeRef;
            NodeRef destNodeRef;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext ctx = new TestContext();
                NodeRef guestHome = TransferServiceImplTest.this.repositoryHelper.getGuestHome();
                String name = GUID.generate();
                ChildAssociationRef child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_CONTENT);
                ctx.contentNodeRef = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                ctx.transferMe = !TransferServiceImplTest.this.transferService.targetExists("testXferOneNode") ? TransferServiceImplTest.this.createTransferTarget("testXferOneNode") : TransferServiceImplTest.this.transferService.getTransferTarget("testXferOneNode");
                TransferServiceImplTest.this.transferService.enableTransferTarget("testXferOneNode", true);
                return ctx;
            }
        };
        final TestContext testContext = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB);
        this.logger.debug((Object)"First transfer - create new node (no content yet)");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> transferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.contentNodeRef);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer("testXferOneNode", definition);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateStep1CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testContext.destNodeRef = testNodeFactory.getMappedNodeRef(testContext.contentNodeRef);
                TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testContext.destNodeRef.equals((Object)testContext.transferMe.getNodeRef()));
                TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(testContext.destNodeRef));
                TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)TransferServiceImplTest.this.nodeService.getProperty(testContext.destNodeRef, ContentModel.PROP_TITLE))), (String)"ContentTitle");
                TransferServiceImplTest.assertEquals((String)"type is wrong", (Object)TransferServiceImplTest.this.nodeService.getType(testContext.contentNodeRef), (Object)TransferServiceImplTest.this.nodeService.getType(testContext.destNodeRef));
                Date destModifiedDate = (Date)TransferServiceImplTest.this.nodeService.getProperty(testContext.destNodeRef, ContentModel.PROP_MODIFIED);
                Date srcModifiedDate = (Date)TransferServiceImplTest.this.nodeService.getProperty(testContext.contentNodeRef, ContentModel.PROP_MODIFIED);
                TransferServiceImplTest.this.logger.debug((Object)("srcModifiedDate : " + String.valueOf(srcModifiedDate) + " destModifiedDate : " + String.valueOf(destModifiedDate)));
                TransferServiceImplTest.assertTrue((String)"dest modified date is not correct", (destModifiedDate.compareTo(srcModifiedDate) == 0 ? 1 : 0) != 0);
                Date destCreatedDate = (Date)TransferServiceImplTest.this.nodeService.getProperty(testContext.destNodeRef, ContentModel.PROP_CREATED);
                Date srcCreatedDate = (Date)TransferServiceImplTest.this.nodeService.getProperty(testContext.contentNodeRef, ContentModel.PROP_CREATED);
                TransferServiceImplTest.this.logger.debug((Object)("srcCreatedDate : " + String.valueOf(srcCreatedDate) + " destCreatedDate : " + String.valueOf(destCreatedDate)));
                TransferServiceImplTest.assertTrue((String)"dest created date is not correct", (destCreatedDate.compareTo(srcCreatedDate) == 0 ? 1 : 0) != 0);
                TransferServiceImplTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)TransferServiceImplTest.this.nodeService.getProperty(testContext.destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitleUpdated"));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateStep1CB);
        this.logger.debug((Object)"Second transfer - update title property (no content yet)");
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateStep2CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testContext.destNodeRef.equals((Object)testContext.transferMe.getNodeRef()));
                TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(testContext.destNodeRef));
                TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)TransferServiceImplTest.this.nodeService.getProperty(testContext.destNodeRef, ContentModel.PROP_TITLE))), (String)"ContentTitleUpdated");
                TransferServiceImplTest.assertEquals((String)"type is wrong", (Object)TransferServiceImplTest.this.nodeService.getType(testContext.contentNodeRef), (Object)TransferServiceImplTest.this.nodeService.getType(testContext.destNodeRef));
                Date destModifiedDate = (Date)TransferServiceImplTest.this.nodeService.getProperty(testContext.destNodeRef, ContentModel.PROP_MODIFIED);
                Date srcModifiedDate = (Date)TransferServiceImplTest.this.nodeService.getProperty(testContext.contentNodeRef, ContentModel.PROP_MODIFIED);
                TransferServiceImplTest.this.logger.debug((Object)("srcModifiedDate : " + String.valueOf(srcModifiedDate) + " destModifiedDate : " + String.valueOf(destModifiedDate)));
                TransferServiceImplTest.assertTrue((String)"after update, modified date is not correct", (destModifiedDate.compareTo(srcModifiedDate) == 0 ? 1 : 0) != 0);
                Date destCreatedDate = (Date)TransferServiceImplTest.this.nodeService.getProperty(testContext.destNodeRef, ContentModel.PROP_CREATED);
                Date srcCreatedDate = (Date)TransferServiceImplTest.this.nodeService.getProperty(testContext.contentNodeRef, ContentModel.PROP_CREATED);
                TransferServiceImplTest.this.logger.debug((Object)("srcCreatedDate : " + String.valueOf(srcCreatedDate) + " destCreatedDate : " + String.valueOf(destCreatedDate)));
                TransferServiceImplTest.assertTrue((String)"after update, created date is not correct", (destCreatedDate.compareTo(srcCreatedDate) == 0 ? 1 : 0) != 0);
                TransferServiceImplTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)TransferServiceImplTest.this.nodeService.getProperty(testContext.destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateStep2CB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> step3WriteContentCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentWriter writer = TransferServiceImplTest.this.contentService.getWriter(testContext.contentNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello World");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)step3WriteContentCB);
        this.logger.debug((Object)"Transfer again - this is an update to add new content");
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateStep3CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentReader reader = TransferServiceImplTest.this.contentService.getReader(testContext.destNodeRef, ContentModel.PROP_CONTENT);
                TransferServiceImplTest.assertNotNull((String)"reader is null", (Object)reader);
                String contentStr = reader.getContentString();
                TransferServiceImplTest.assertEquals((String)"Content is wrong", (String)contentStr, (String)"Hello World");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateStep3CB);
        this.logger.debug((Object)"Transfer again - with no new content");
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateStep4CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testContext.destNodeRef.equals((Object)testContext.transferMe.getNodeRef()));
                TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(testContext.destNodeRef));
                TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)TransferServiceImplTest.this.nodeService.getProperty(testContext.destNodeRef, ContentModel.PROP_TITLE))), (String)"ContentTitleUpdated");
                TransferServiceImplTest.assertEquals((String)"type is wrong", (Object)TransferServiceImplTest.this.nodeService.getType(testContext.contentNodeRef), (Object)TransferServiceImplTest.this.nodeService.getType(testContext.destNodeRef));
                ContentReader reader = TransferServiceImplTest.this.contentService.getReader(testContext.destNodeRef, ContentModel.PROP_CONTENT);
                TransferServiceImplTest.assertNotNull((String)"reader is null", (Object)reader);
                String contentStr = reader.getContentString();
                TransferServiceImplTest.assertEquals((String)"Content is wrong", (String)contentStr, (String)"Hello World");
                TransferServiceImplTest.assertNotNull((String)"transferredAspect", (Object)((String)((Object)TransferServiceImplTest.this.nodeService.getProperty(testContext.destNodeRef, TransferModel.PROP_REPOSITORY_ID))));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateStep4CB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> step5UpdateContentCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentWriter writer = TransferServiceImplTest.this.contentService.getWriter(testContext.contentNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Foo Bar");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)step5UpdateContentCB);
        this.logger.debug((Object)"Transfer again - this is an update to add new content");
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateStep5CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentReader reader = TransferServiceImplTest.this.contentService.getReader(testContext.destNodeRef, ContentModel.PROP_CONTENT);
                TransferServiceImplTest.assertNotNull((String)"reader is null", (Object)reader);
                String contentStr = reader.getContentString();
                TransferServiceImplTest.assertEquals((String)"Content is wrong", (String)"Foo Bar", (String)contentStr);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateStep5CB);
        this.logger.debug((Object)"Transfer again - to delete a node through transferring an archive node");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> step6CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceImplTest.this.nodeService.deleteNode(testContext.contentNodeRef);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)step6CB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> transferDeletedCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef deletedContentNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, testContext.contentNodeRef.getId());
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodesToRemove = new HashSet<NodeRef>();
                nodesToRemove.add(deletedContentNodeRef);
                definition.setNodesToRemove(nodesToRemove);
                TransferServiceImplTest.this.transferService.transfer("testXferOneNode", definition);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferDeletedCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateStep6CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceImplTest.assertFalse((String)"dest node still exists", (boolean)TransferServiceImplTest.this.nodeService.exists(testContext.destNodeRef));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateStep6CB);
        this.logger.debug((Object)"Transfer again - with no content - should throw exception");
        try {
            definition = new TransferDefinition();
            nodes = new HashSet<NodeRef>();
            definition.setNodes(nodes);
            this.transferService.transfer("testXferOneNode", definition);
            TransferServiceImplTest.fail((String)"exception not thrown");
        }
        catch (TransferException transferException) {}
        this.logger.debug((Object)"Transfer again - with no content - should throw exception");
        try {
            this.transferService.enableTransferTarget("testXferOneNode", false);
            definition = new TransferDefinition();
            nodes = new HashSet();
            nodes.add(testContext.contentNodeRef);
            definition.setNodes(nodes);
            this.transferService.transfer("testXferOneNode", definition);
            TransferServiceImplTest.fail((String)"target not enabled exception not thrown");
        }
        catch (TransferException te) {
            TransferServiceImplTest.assertTrue((String)("check contents of exception message :" + te.toString()), (boolean)te.getCause().getMessage().contains("enabled"));
        }
    }

    @Test
    public void testMoveNode() throws Exception {
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        final UnitTestTransferManifestNodeFactory testNodeFactory = this.unitTestKludgeToTransferGuestHomeToCompanyHome();
        class TestContext {
            TransferTarget transferMe;
            NodeRef contentNodeRef;
            NodeRef parentNodeRef;
            NodeRef destNodeRef;
            NodeRef moveToNodeRef;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext ctx = new TestContext();
                NodeRef guestHome = TransferServiceImplTest.this.repositoryHelper.getGuestHome();
                String name = GUID.generate();
                ChildAssociationRef newParent = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
                ctx.parentNodeRef = newParent.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.parentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.parentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                ChildAssociationRef child = TransferServiceImplTest.this.nodeService.createNode(ctx.parentNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"TransferOneNode"), ContentModel.TYPE_CONTENT);
                ctx.contentNodeRef = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"TransferOneNode"));
                ChildAssociationRef moveTo = TransferServiceImplTest.this.nodeService.createNode(ctx.parentNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"moveTo"), ContentModel.TYPE_FOLDER);
                ctx.moveToNodeRef = moveTo.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.moveToNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.moveToNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"moveTo"));
                ctx.transferMe = !TransferServiceImplTest.this.transferService.targetExists("testTransferMoveNode") ? TransferServiceImplTest.this.createTransferTarget("testTransferMoveNode") : TransferServiceImplTest.this.transferService.getTransferTarget("testTransferMoveNode");
                TransferServiceImplTest.this.transferService.enableTransferTarget("testTransferMoveNode", true);
                return ctx;
            }
        };
        final TestContext testContext = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB);
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> firstTransferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceImplTest.this.logger.debug((Object)"First transfer - create new node (no content yet)");
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.parentNodeRef);
                nodes.add(testContext.contentNodeRef);
                nodes.add(testContext.moveToNodeRef);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer("testTransferMoveNode", definition);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)firstTransferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateTransferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef destNodeRef = testNodeFactory.getMappedNodeRef(testContext.contentNodeRef);
                NodeRef destParentNodeRef = testNodeFactory.getMappedNodeRef(testContext.parentNodeRef);
                ChildAssociationRef destParent = TransferServiceImplTest.this.nodeService.getPrimaryParent(destNodeRef);
                TransferServiceImplTest.assertEquals((String)"parent node ref not correct prior to test", (Object)destParentNodeRef, (Object)destParent.getParentRef());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateTransferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNodeCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceImplTest.this.logger.debug((Object)"Transfer again with moved node");
                TransferServiceImplTest.this.nodeService.moveNode(testContext.contentNodeRef, testContext.moveToNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"testOneNode"));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)moveNodeCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> secondTransferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceImplTest.this.logger.debug((Object)"Second transfer");
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.contentNodeRef);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer("testTransferMoveNode", definition);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)secondTransferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> secondValidateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef destNodeRef = testNodeFactory.getMappedNodeRef(testContext.contentNodeRef);
                NodeRef destParentNodeRef = testNodeFactory.getMappedNodeRef(testContext.moveToNodeRef);
                ChildAssociationRef destParent = TransferServiceImplTest.this.nodeService.getPrimaryParent(destNodeRef);
                TransferServiceImplTest.assertEquals((String)"node not moved", (Object)destParentNodeRef, (Object)destParent.getParentRef());
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)secondValidateCB);
    }

    @Test
    public void testManyNodes() throws Exception {
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        final Locale CONTENT_LOCALE = Locale.GERMAN;
        final HashSet nodes = new HashSet();
        final UnitTestTransferManifestNodeFactory testNodeFactory = this.unitTestKludgeToTransferGuestHomeToCompanyHome();
        class TestContext {
            TransferTarget transferMe;
            NodeRef nodeA = null;
            NodeRef nodeB = null;
            NodeRef nodeAA = null;
            NodeRef nodeAB = null;
            NodeRef nodeABA = null;
            NodeRef nodeABB = null;
            NodeRef nodeABC = null;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext ctx = new TestContext();
                NodeRef guestHome = TransferServiceImplTest.this.repositoryHelper.getGuestHome();
                String guid = GUID.generate();
                ChildAssociationRef child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)guid), ContentModel.TYPE_FOLDER);
                NodeRef testRootNode = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(testRootNode, ContentModel.PROP_TITLE, (Serializable)((Object)guid));
                TransferServiceImplTest.this.nodeService.setProperty(testRootNode, ContentModel.PROP_NAME, (Serializable)((Object)guid));
                nodes.add(testRootNode);
                child = TransferServiceImplTest.this.nodeService.createNode(testRootNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"testNodeAC"), ContentModel.TYPE_CONTENT);
                NodeRef nodeAC = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(nodeAC, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitleAC"));
                TransferServiceImplTest.this.nodeService.setProperty(nodeAC, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeAC"));
                ContentWriter writer = TransferServiceImplTest.this.contentService.getWriter(nodeAC, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("The quick brown fox");
                nodes.add(nodeAC);
                child = TransferServiceImplTest.this.nodeService.createNode(testRootNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeA"), ContentModel.TYPE_FOLDER);
                ctx.nodeA = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeA, ContentModel.PROP_TITLE, (Serializable)((Object)"TestNodeA"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeA, ContentModel.PROP_NAME, (Serializable)((Object)"TestNodeA"));
                nodes.add(ctx.nodeA);
                child = TransferServiceImplTest.this.nodeService.createNode(testRootNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeB"), ContentModel.TYPE_FOLDER);
                ctx.nodeB = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeB, ContentModel.PROP_TITLE, (Serializable)((Object)"TestNodeB"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeB, ContentModel.PROP_NAME, (Serializable)((Object)"TestNodeB"));
                nodes.add(ctx.nodeB);
                child = TransferServiceImplTest.this.nodeService.createNode(ctx.nodeA, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeAA"), ContentModel.TYPE_FOLDER);
                ctx.nodeAA = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeAA, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeAA, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeAA"));
                nodes.add(ctx.nodeAA);
                child = TransferServiceImplTest.this.nodeService.createNode(ctx.nodeA, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeAB"), ContentModel.TYPE_FOLDER);
                ctx.nodeAB = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeAB, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeAB, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeAB"));
                nodes.add(ctx.nodeAB);
                child = TransferServiceImplTest.this.nodeService.createNode(ctx.nodeAB, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeABA"), ContentModel.TYPE_FOLDER);
                ctx.nodeABA = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeABA, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeABA, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeABA"));
                nodes.add(ctx.nodeABA);
                child = TransferServiceImplTest.this.nodeService.createNode(ctx.nodeAB, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeABB"), ContentModel.TYPE_FOLDER);
                ctx.nodeABB = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeABB, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeABB, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeABB"));
                nodes.add(ctx.nodeABB);
                child = TransferServiceImplTest.this.nodeService.createNode(ctx.nodeAB, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testNodeABC"), ContentModel.TYPE_FOLDER);
                ctx.nodeABC = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeABC, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeABC, ContentModel.PROP_NAME, (Serializable)((Object)"DemoNodeABC"));
                nodes.add(ctx.nodeABC);
                ctx.transferMe = !TransferServiceImplTest.this.transferService.targetExists("testManyNodes") ? TransferServiceImplTest.this.createTransferTarget("testManyNodes") : TransferServiceImplTest.this.transferService.getTransferTarget("testManyNodes");
                return ctx;
            }
        };
        final TestContext testContext = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> transferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                definition.setNodes((Collection)nodes);
                TransferServiceImplTest.this.transferService.transfer("testManyNodes", definition);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> checkTransferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef destNodeA = testNodeFactory.getMappedNodeRef(testContext.nodeA);
                TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeA.equals((Object)testContext.transferMe.getNodeRef()));
                TransferServiceImplTest.assertTrue((String)"dest node ref A does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(destNodeA));
                TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)TransferServiceImplTest.this.nodeService.getProperty(destNodeA, ContentModel.PROP_TITLE))), (String)"TestNodeA");
                TransferServiceImplTest.assertEquals((String)"type is wrong", (Object)TransferServiceImplTest.this.nodeService.getType(testContext.nodeA), (Object)TransferServiceImplTest.this.nodeService.getType(destNodeA));
                NodeRef destNodeB = testNodeFactory.getMappedNodeRef(testContext.nodeB);
                TransferServiceImplTest.assertTrue((String)"dest node B does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(destNodeB));
                NodeRef destNodeAA = testNodeFactory.getMappedNodeRef(testContext.nodeAA);
                TransferServiceImplTest.assertTrue((String)"dest node AA ref does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(destNodeAA));
                NodeRef destNodeAB = testNodeFactory.getMappedNodeRef(testContext.nodeAB);
                TransferServiceImplTest.assertTrue((String)"dest node AB ref does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(destNodeAB));
                NodeRef destNodeABA = testNodeFactory.getMappedNodeRef(testContext.nodeABA);
                TransferServiceImplTest.assertTrue((String)"dest node ABA ref does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(destNodeABA));
                NodeRef destNodeABB = testNodeFactory.getMappedNodeRef(testContext.nodeABB);
                TransferServiceImplTest.assertTrue((String)"dest node ABB ref does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(destNodeABB));
                NodeRef destNodeABC = testNodeFactory.getMappedNodeRef(testContext.nodeABC);
                TransferServiceImplTest.assertTrue((String)"dest node ABC ref does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(destNodeABC));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)checkTransferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> updateSingleNodeCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceImplTest.this.nodeService.setProperty(testContext.nodeAB, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitleUpdated"));
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> toUpdate = new HashSet<NodeRef>();
                toUpdate.add(testContext.nodeAB);
                definition.setNodes(toUpdate);
                TransferServiceImplTest.this.transferService.transfer("testManyNodes", definition);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)updateSingleNodeCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> generateLotsOfNodesCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                int i = 0;
                while (i < 100) {
                    ChildAssociationRef child = TransferServiceImplTest.this.nodeService.createNode(testContext.nodeABA, ContentModel.ASSOC_CONTAINS, QName.createQName((String)(GUID.generate() + i)), ContentModel.TYPE_CONTENT);
                    NodeRef nodeX = child.getChildRef();
                    TransferServiceImplTest.this.nodeService.setProperty(nodeX, ContentModel.PROP_TITLE, (Serializable)((Object)("ContentTitle" + i)));
                    TransferServiceImplTest.this.nodeService.setProperty(nodeX, ContentModel.PROP_NAME, (Serializable)((Object)("Demo Node 1" + i)));
                    nodes.add(nodeX);
                    ContentWriter writer = TransferServiceImplTest.this.contentService.getWriter(nodeX, ContentModel.PROP_CONTENT, true);
                    writer.setLocale(CONTENT_LOCALE);
                    writer.putContent("The quick brown fox" + i);
                    ++i;
                }
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)generateLotsOfNodesCB);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
    }

    @Test
    public void testPathBasedUpdate() throws Exception {
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        final String CONTENT_NAME = GUID.generate();
        final Locale CONTENT_LOCALE = Locale.GERMAN;
        final QName TEST_QNAME = QName.createQName((String)CONTENT_NAME);
        class TestContext {
            String targetName;
            NodeRef contentNodeRef;
            NodeRef newContentNodeRef;
            NodeRef guestHome;
            ChildAssociationRef child;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext ctx = new TestContext();
                ctx.targetName = GUID.generate();
                ctx.guestHome = TransferServiceImplTest.this.repositoryHelper.getGuestHome();
                ctx.child = TransferServiceImplTest.this.nodeService.createNode(ctx.guestHome, ContentModel.ASSOC_CONTAINS, TEST_QNAME, ContentModel.TYPE_CONTENT);
                ctx.contentNodeRef = ctx.child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)CONTENT_NAME));
                ContentWriter writer = TransferServiceImplTest.this.contentService.getWriter(ctx.contentNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent("Hello");
                if (!TransferServiceImplTest.this.transferService.targetExists(ctx.targetName)) {
                    TransferServiceImplTest.this.createTransferTarget(ctx.targetName);
                } else {
                    TransferServiceImplTest.this.transferService.getTransferTarget(ctx.targetName);
                }
                return ctx;
            }
        };
        final TestContext testContext = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB);
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        final UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath((String)this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath((String)this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> step1CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.contentNodeRef);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer(testContext.targetName, definition);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)step1CB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> transfer1CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef destNodeRef = testNodeFactory.getMappedNodeRef(testContext.contentNodeRef);
                TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)destNodeRef.equals((Object)testContext.contentNodeRef));
                TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(destNodeRef));
                TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)TransferServiceImplTest.this.nodeService.getProperty(destNodeRef, ContentModel.PROP_TITLE))), (String)"ContentTitle");
                TransferServiceImplTest.assertEquals((String)"type is wrong", (Object)TransferServiceImplTest.this.nodeService.getType(testContext.contentNodeRef), (Object)TransferServiceImplTest.this.nodeService.getType(destNodeRef));
                TransferServiceImplTest.this.nodeService.deleteNode(testContext.contentNodeRef);
                testContext.child = TransferServiceImplTest.this.nodeService.createNode(testContext.guestHome, ContentModel.ASSOC_CONTAINS, TEST_QNAME, ContentModel.TYPE_CONTENT);
                testContext.newContentNodeRef = testContext.child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(testContext.newContentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitleUpdated"));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transfer1CB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> transfer1CB2 = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.newContentNodeRef);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer(testContext.targetName, definition);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transfer1CB2);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateStep1CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef oldDestNodeRef = testNodeFactory.getMappedNodeRef(testContext.contentNodeRef);
                NodeRef newDestNodeRef = testNodeFactory.getMappedNodeRef(testContext.newContentNodeRef);
                TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)oldDestNodeRef.equals((Object)newDestNodeRef));
                TransferServiceImplTest.assertFalse((String)"new dest node ref exists", (boolean)TransferServiceImplTest.this.nodeService.exists(newDestNodeRef));
                TransferServiceImplTest.assertTrue((String)"old dest node does not exists", (boolean)TransferServiceImplTest.this.nodeService.exists(oldDestNodeRef));
                TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)TransferServiceImplTest.this.nodeService.getProperty(oldDestNodeRef, ContentModel.PROP_TITLE))), (String)"ContentTitleUpdated");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateStep1CB);
    }

    @Test
    public void testAsyncCallback() throws Exception {
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        this.unitTestKludgeToTransferGuestHomeToCompanyHome();
        final Locale CONTENT_LOCALE = Locale.GERMAN;
        class TestContext {
            TransferTarget transferMe;
            NodeRef nodeRefA = null;
            NodeRef nodeRefB = null;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                ContentWriter writer;
                ChildAssociationRef child;
                TestContext ctx = new TestContext();
                NodeRef guestHome = TransferServiceImplTest.this.repositoryHelper.getGuestHome();
                ctx.nodeRefA = TransferServiceImplTest.this.nodeService.getChildByName(guestHome, ContentModel.ASSOC_CONTAINS, "Demo Node A");
                if (ctx.nodeRefA == null) {
                    child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ContentModel.TYPE_CONTENT);
                    ctx.nodeRefA = child.getChildRef();
                    TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeRefA, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                    TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeRefA, ContentModel.PROP_NAME, (Serializable)((Object)"Demo Node A"));
                    writer = TransferServiceImplTest.this.contentService.getWriter(ctx.nodeRefA, ContentModel.PROP_CONTENT, true);
                    writer.setLocale(CONTENT_LOCALE);
                    writer.putContent("Hello");
                }
                ctx.nodeRefB = TransferServiceImplTest.this.nodeService.getChildByName(guestHome, ContentModel.ASSOC_CONTAINS, "Demo Node B");
                if (ctx.nodeRefB == null) {
                    child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ContentModel.TYPE_CONTENT);
                    ctx.nodeRefB = child.getChildRef();
                    TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeRefB, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                    TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeRefB, ContentModel.PROP_NAME, (Serializable)((Object)"Demo Node B"));
                    writer = TransferServiceImplTest.this.contentService.getWriter(ctx.nodeRefB, ContentModel.PROP_CONTENT, true);
                    writer.setLocale(CONTENT_LOCALE);
                    writer.putContent("Hello");
                }
                if (!TransferServiceImplTest.this.transferService.targetExists("testAsyncCallback")) {
                    TransferServiceImplTest.this.createTransferTarget("testAsyncCallback");
                } else {
                    TransferServiceImplTest.this.transferService.getTransferTarget("testAsyncCallback");
                }
                return ctx;
            }
        };
        final TestContext testContext = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB);
        RetryingTransactionHelper.RetryingTransactionCallback<List<TransferEvent>> transferCB = new RetryingTransactionHelper.RetryingTransactionCallback<List<TransferEvent>>(){
            {
            }

            public List<TransferEvent> execute() throws Throwable {
                ArrayList<TransferEvent> transferReport = new ArrayList<TransferEvent>(50);
                TestTransferCallback callback = new TestTransferCallback();
                HashSet<TestTransferCallback> callbacks = new HashSet<TestTransferCallback>();
                callbacks.add(callback);
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.nodeRefA);
                nodes.add(testContext.nodeRefB);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transferAsync("testAsyncCallback", definition, callbacks);
                TransferServiceImplTest.this.logger.debug((Object)"transfer async has returned");
                Queue<TransferEvent> events = callback.getEvents();
                int sleepCount = 5;
                boolean ended = false;
                TransferEvent event = events.poll();
                while (!ended) {
                    TransferServiceImplTest.this.logger.debug((Object)("polling loop:" + sleepCount));
                    while (event != null) {
                        sleepCount = 5;
                        TransferServiceImplTest.this.logger.debug((Object)("Got an event" + event.toString()));
                        transferReport.add(event);
                        if (event.isLast()) {
                            TransferServiceImplTest.this.logger.debug((Object)"got last event");
                            ended = true;
                        }
                        event = events.poll();
                    }
                    if (event != null || ended) continue;
                    if (sleepCount <= 0) {
                        TransferServiceImplTest.fail((String)"timed out without receiving last event");
                        ended = true;
                    } else if (sleepCount-- > 0) {
                        Thread.sleep(5000L);
                    }
                    event = events.poll();
                }
                return transferReport;
            }
        };
        List transferReport = (List)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        TransferServiceImplTest.assertTrue((String)"transfer report is too small", (transferReport.size() > 2 ? 1 : 0) != 0);
        TransferServiceImplTest.assertTrue((String)"transfer report does not start with START", (boolean)((TransferEvent)transferReport.get(0)).getTransferState().equals((Object)TransferEvent.TransferState.START));
        boolean success = false;
        for (TransferEvent event : transferReport) {
            if (event.getTransferState() != TransferEvent.TransferState.SUCCESS) continue;
            success = true;
        }
        TransferServiceImplTest.assertTrue((String)"transfer report does not contain SUCCESS", (boolean)success);
    }

    @Test
    public void testAsyncCancel() throws Exception {
        final Locale CONTENT_LOCALE = Locale.GERMAN;
        final NodeRef guestHome = this.repositoryHelper.getGuestHome();
        this.unitTestKludgeToTransferGuestHomeToCompanyHome();
        class TestContext {
            TransferTarget transferMe;
            NodeRef nodeRefA = null;
            NodeRef nodeRefB = null;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                ContentWriter writer;
                ChildAssociationRef child;
                TestContext ctx = new TestContext();
                ctx.nodeRefA = TransferServiceImplTest.this.nodeService.getChildByName(guestHome, ContentModel.ASSOC_CONTAINS, "Demo Node A");
                if (ctx.nodeRefA == null) {
                    child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ContentModel.TYPE_CONTENT);
                    ctx.nodeRefA = child.getChildRef();
                    TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeRefA, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                    TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeRefA, ContentModel.PROP_NAME, (Serializable)((Object)"Demo Node A"));
                    writer = TransferServiceImplTest.this.contentService.getWriter(ctx.nodeRefA, ContentModel.PROP_CONTENT, true);
                    writer.setLocale(CONTENT_LOCALE);
                    writer.putContent("Hello");
                }
                ctx.nodeRefB = TransferServiceImplTest.this.nodeService.getChildByName(guestHome, ContentModel.ASSOC_CONTAINS, "Demo Node B");
                if (ctx.nodeRefB == null) {
                    child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ContentModel.TYPE_CONTENT);
                    ctx.nodeRefB = child.getChildRef();
                    TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeRefB, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                    TransferServiceImplTest.this.nodeService.setProperty(ctx.nodeRefB, ContentModel.PROP_NAME, (Serializable)((Object)"Demo Node B"));
                    writer = TransferServiceImplTest.this.contentService.getWriter(ctx.nodeRefB, ContentModel.PROP_CONTENT, true);
                    writer.setLocale(CONTENT_LOCALE);
                    writer.putContent("Hello");
                }
                if (!TransferServiceImplTest.this.transferService.targetExists("testAsyncCallback")) {
                    TransferServiceImplTest.this.createTransferTarget("testAsyncCallback");
                } else {
                    TransferServiceImplTest.this.transferService.getTransferTarget("testAsyncCallback");
                }
                return ctx;
            }
        };
        final TestContext testContext = (TestContext)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB, false, true);
        final ArrayList transferReport = new ArrayList(50);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> transferAsyncCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferCallback poison = new TransferCallback(){
                    String transferId = null;

                    public void processEvent(TransferEvent event) {
                        (this).TransferServiceImplTest.this.logger.debug((Object)event.toString());
                        if (event instanceof TransferEventBegin) {
                            TransferEventBegin beginEvent = (TransferEventBegin)event;
                            this.transferId = beginEvent.getTransferId();
                            (this).TransferServiceImplTest.this.transferService.cancelAsync(this.transferId);
                        }
                    }
                };
                TestTransferCallback callback = new TestTransferCallback();
                HashSet<Object> callbacks = new HashSet<Object>();
                callbacks.add(callback);
                callbacks.add(poison);
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.nodeRefA);
                nodes.add(testContext.nodeRefB);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transferAsync("testAsyncCallback", definition, callbacks);
                TransferServiceImplTest.this.logger.debug((Object)"transfer async has returned");
                Queue<TransferEvent> events = callback.getEvents();
                int sleepCount = 5;
                boolean ended = false;
                TransferEvent event = events.poll();
                while (!ended) {
                    TransferServiceImplTest.this.logger.debug((Object)("polling loop:" + sleepCount));
                    while (event != null) {
                        sleepCount = 5;
                        TransferServiceImplTest.this.logger.debug((Object)("Got an event" + event.toString()));
                        transferReport.add(event);
                        if (event.isLast()) {
                            TransferServiceImplTest.this.logger.debug((Object)"got last event");
                            ended = true;
                        }
                        event = events.poll();
                    }
                    if (event != null || ended) continue;
                    if (sleepCount <= 0) {
                        TransferServiceImplTest.fail((String)"timed out without receiving last event");
                        ended = true;
                    } else if (sleepCount-- > 0) {
                        Thread.sleep(5000L);
                    }
                    event = events.poll();
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferAsyncCB);
        TransferServiceImplTest.assertTrue((String)"transfer report is too small", (transferReport.size() > 3 ? 1 : 0) != 0);
        TransferServiceImplTest.assertTrue((String)"transfer report does not start with START", (boolean)((TransferEvent)transferReport.get(0)).getTransferState().equals((Object)TransferEvent.TransferState.START));
        TransferServiceImplTest.assertTrue((String)"transfer report does not end with CANCELLED", (boolean)((TransferEvent)transferReport.get(transferReport.size() - 1)).getTransferState().equals((Object)TransferEvent.TransferState.CANCELLED));
    }

    private void dumpToSystemOut(NodeRef nodeRef) throws IOException {
        ContentReader reader2 = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        TransferServiceImplTest.assertNotNull((String)"transfer reader is null", (Object)reader2);
        InputStream is = reader2.getContentInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String s = br.readLine();
        while (s != null) {
            System.out.println(s);
            s = br.readLine();
        }
    }

    private UnitTestTransferManifestNodeFactory unitTestKludgeToTransferGuestHomeToCompanyHome() {
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath((String)this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath((String)this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        return testNodeFactory;
    }

    @Test
    public void testTransferOneNodeWithBigContent() throws Exception {
        boolean runTest = false;
        if (runTest || this.logger.isDebugEnabled()) {
            final Locale CONTENT_LOCALE = Locale.UK;
            this.logger.debug((Object)"testTransferOneNodeWithBigContent starting");
            RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
            final UnitTestTransferManifestNodeFactory testNodeFactory = this.unitTestKludgeToTransferGuestHomeToCompanyHome();
            class TestContext {
                TransferTarget transferMe;
                NodeRef contentNodeRef;
                NodeRef destNodeRef;

                TestContext() {
                }
            }
            RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

                public TestContext execute() throws Throwable {
                    TestContext ctx = new TestContext();
                    NodeRef guestHome = TransferServiceImplTest.this.repositoryHelper.getGuestHome();
                    ctx.contentNodeRef = TransferServiceImplTest.this.nodeService.getChildByName(guestHome, ContentModel.ASSOC_CONTAINS, "BigContent");
                    if (ctx.contentNodeRef == null) {
                        ChildAssociationRef child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"BigContent"), ContentModel.TYPE_CONTENT);
                        File tempFile = TempFileProvider.createTempFile((String)"test", (String)".dat");
                        FileWriter fw = new FileWriter(tempFile);
                        int i = 0;
                        while (i < 100000000) {
                            fw.write("hello world this is my text, I wonder how much text I can transfer?" + i);
                            ++i;
                        }
                        System.out.println("Temp File Size is:" + tempFile.length());
                        fw.close();
                        ctx.contentNodeRef = child.getChildRef();
                        ContentWriter writer = TransferServiceImplTest.this.contentService.getWriter(ctx.contentNodeRef, ContentModel.PROP_CONTENT, true);
                        writer.setLocale(CONTENT_LOCALE);
                        writer.setMimetype("application/data");
                        writer.putContent(tempFile);
                        tempFile.delete();
                        TransferServiceImplTest.this.nodeService.setProperty(ctx.contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                        TransferServiceImplTest.this.nodeService.setProperty(ctx.contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"BigContent"));
                    }
                    if (!TransferServiceImplTest.this.transferService.targetExists("testTransferOneNodeWithBigContent")) {
                        TransferServiceImplTest.this.createTransferTarget("testTransferOneNodeWithBigContent");
                    }
                    return ctx;
                }
            };
            final TestContext testContext = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB);
            RetryingTransactionHelper.RetryingTransactionCallback<Void> transferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
                {
                }

                public Void execute() throws Throwable {
                    TransferDefinition definition = new TransferDefinition();
                    HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                    nodes.add(testContext.contentNodeRef);
                    definition.setNodes(nodes);
                    TransferServiceImplTest.this.transferService.transfer("testTransferOneNodeWithBigContent", definition);
                    return null;
                }
            };
            RetryingTransactionHelper.RetryingTransactionCallback<Void> finishCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
                {
                }

                public Void execute() throws Throwable {
                    NodeRef oldDestNodeRef = testNodeFactory.getMappedNodeRef(testContext.contentNodeRef);
                    ContentReader source = TransferServiceImplTest.this.contentService.getReader(testContext.contentNodeRef, ContentModel.PROP_CONTENT);
                    ContentReader destination = TransferServiceImplTest.this.contentService.getReader(oldDestNodeRef, ContentModel.PROP_CONTENT);
                    TransferServiceImplTest.assertNotNull((String)"source is null", (Object)source);
                    TransferServiceImplTest.assertNotNull((String)"destination is null", (Object)destination);
                    TransferServiceImplTest.assertEquals((String)"size different", (long)source.getSize(), (long)destination.getSize());
                    TransferServiceImplTest.this.nodeService.deleteNode(oldDestNodeRef);
                    return null;
                }
            };
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
            tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)finishCB);
        } else {
            System.out.println("test supressed");
        }
    }

    @Test
    public void testEmptyContent() throws Exception {
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        final Locale CONTENT_LOCALE = Locale.ENGLISH;
        final UnitTestTransferManifestNodeFactory testNodeFactory = this.unitTestKludgeToTransferGuestHomeToCompanyHome();
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        class TestContext {
            TransferTarget transferMe;
            NodeRef contentNodeRef;
            NodeRef savedDestinationNodeRef;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext ctx = new TestContext();
                NodeRef guestHome = TransferServiceImplTest.this.repositoryHelper.getGuestHome();
                String name = GUID.generate();
                ChildAssociationRef child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_CONTENT);
                ctx.contentNodeRef = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                ContentData cd = new ContentData(null, null, 0L, null);
                TransferServiceImplTest.this.nodeService.setProperty(ctx.contentNodeRef, ContentModel.PROP_CONTENT, (Serializable)cd);
                ctx.transferMe = !TransferServiceImplTest.this.transferService.targetExists("testTransferEmptyContent") ? TransferServiceImplTest.this.createTransferTarget("testTransferEmptyContent") : TransferServiceImplTest.this.transferService.getTransferTarget("testTransferEmptyContent");
                TransferServiceImplTest.this.transferService.enableTransferTarget("testTransferEmptyContent", true);
                return ctx;
            }
        };
        final TestContext testContext = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB);
        final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        this.logger.debug((Object)"testEmptyContent : First transfer - create new node (empty content)");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> step1CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentReader reader = TransferServiceImplTest.this.contentService.getReader(testContext.contentNodeRef, ContentModel.PROP_CONTENT);
                TransferServiceImplTest.assertNull((String)"test setup content reader not null", (Object)reader);
                Map props = TransferServiceImplTest.this.nodeService.getProperties(testContext.contentNodeRef);
                TransferServiceImplTest.assertTrue((boolean)props.containsKey(ContentModel.PROP_CONTENT));
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.contentNodeRef);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer("testTransferEmptyContent", definition);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)step1CB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateStep1CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef destinationNodeRef;
                Serializable modifiedDate = TransferServiceImplTest.this.nodeService.getProperty(testContext.contentNodeRef, ContentModel.PROP_MODIFIED);
                if (modifiedDate instanceof Date) {
                    TransferServiceImplTest.this.logger.debug((Object)("srcModified: " + SDF.format(modifiedDate)));
                }
                testContext.savedDestinationNodeRef = destinationNodeRef = testNodeFactory.getMappedNodeRef(testContext.contentNodeRef);
                TransferServiceImplTest.assertTrue((String)"content node (dest) does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(destinationNodeRef));
                ContentReader reader = TransferServiceImplTest.this.contentService.getReader(destinationNodeRef, ContentModel.PROP_CONTENT);
                TransferServiceImplTest.assertNull((String)"content reader not null", (Object)reader);
                Map props = TransferServiceImplTest.this.nodeService.getProperties(destinationNodeRef);
                TransferServiceImplTest.assertTrue((boolean)props.containsKey(ContentModel.PROP_CONTENT));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateStep1CB);
        this.logger.debug((Object)"testEmptyContent : Second transfer - replace empty content with some content");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> step2CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                Serializable modifiedDate = TransferServiceImplTest.this.nodeService.getProperty(testContext.contentNodeRef, ContentModel.PROP_MODIFIED);
                if (modifiedDate instanceof Date) {
                    TransferServiceImplTest.this.logger.debug((Object)("srcModified: " + SDF.format(modifiedDate)));
                }
                ContentWriter writer = TransferServiceImplTest.this.contentService.getWriter(testContext.contentNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.setEncoding("UTF-8");
                writer.putContent("The quick brown fox jumps over the lazy dog.");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)step2CB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> step2TransferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentReader reader = TransferServiceImplTest.this.contentService.getReader(testContext.contentNodeRef, ContentModel.PROP_CONTENT);
                TransferServiceImplTest.assertNotNull((String)"test setup content reader not null", (Object)reader);
                Map props = TransferServiceImplTest.this.nodeService.getProperties(testContext.contentNodeRef);
                TransferServiceImplTest.assertTrue((boolean)props.containsKey(ContentModel.PROP_CONTENT));
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.contentNodeRef);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer("testTransferEmptyContent", definition);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)step2TransferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> step2ValidateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef destinationNodeRef = testNodeFactory.getMappedNodeRef(testContext.contentNodeRef);
                TransferServiceImplTest.assertEquals((String)"test error destinationNodeRef not correct", (Object)testContext.savedDestinationNodeRef, (Object)destinationNodeRef);
                ContentReader reader = TransferServiceImplTest.this.contentService.getReader(destinationNodeRef, ContentModel.PROP_CONTENT);
                TransferServiceImplTest.assertNotNull((String)"content reader is null", (Object)reader);
                TransferServiceImplTest.assertTrue((String)"content encoding is wrong", (boolean)reader.getEncoding().equalsIgnoreCase("UTF-8"));
                TransferServiceImplTest.assertEquals((String)"content locale is wrong", (Object)reader.getLocale(), (Object)CONTENT_LOCALE);
                TransferServiceImplTest.assertTrue((String)"content does not exist", (boolean)reader.exists());
                String contentStr = reader.getContentString();
                TransferServiceImplTest.assertEquals((String)"Content is wrong", (String)contentStr, (String)"The quick brown fox jumps over the lazy dog.");
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)step2ValidateCB);
        this.logger.debug((Object)"testEmptyContent : Third transfer - remove existing content");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> step3SetupCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentData cd = new ContentData(null, null, 0L, null);
                TransferServiceImplTest.this.nodeService.setProperty(testContext.contentNodeRef, ContentModel.PROP_CONTENT, (Serializable)cd);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)step3SetupCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> step3TransferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentReader reader = TransferServiceImplTest.this.contentService.getReader(testContext.contentNodeRef, ContentModel.PROP_CONTENT);
                TransferServiceImplTest.assertNull((String)"test setup content reader not null", (Object)reader);
                Map props = TransferServiceImplTest.this.nodeService.getProperties(testContext.contentNodeRef);
                TransferServiceImplTest.assertTrue((boolean)props.containsKey(ContentModel.PROP_CONTENT));
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.contentNodeRef);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer("testTransferEmptyContent", definition);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)step3TransferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> step3ValidateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef destinationNodeRef = testNodeFactory.getMappedNodeRef(testContext.contentNodeRef);
                TransferServiceImplTest.assertTrue((String)"content node (dest) does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(destinationNodeRef));
                ContentReader reader = TransferServiceImplTest.this.contentService.getReader(destinationNodeRef, ContentModel.PROP_CONTENT);
                TransferServiceImplTest.assertNull((String)"content reader not null", (Object)reader);
                Map props = TransferServiceImplTest.this.nodeService.getProperties(destinationNodeRef);
                TransferServiceImplTest.assertTrue((boolean)props.containsKey(ContentModel.PROP_CONTENT));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)step3ValidateCB);
    }

    @Test
    public void testRepeatUpdateOfContent() throws Exception {
        final Locale CONTENT_LOCALE = Locale.GERMAN;
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        final UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath((String)this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath((String)this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        class TestContext {
            TransferTarget transferMe;
            NodeRef contentNodeRef;
            NodeRef destNodeRef;
            String contentString;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext testContext = new TestContext();
                NodeRef guestHome = TransferServiceImplTest.this.repositoryHelper.getGuestHome();
                String name = GUID.generate();
                ChildAssociationRef child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_CONTENT);
                testContext.contentNodeRef = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(testContext.contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                testContext.transferMe = !TransferServiceImplTest.this.transferService.targetExists("testRepeatUpdateOfContent") ? TransferServiceImplTest.this.createTransferTarget("testRepeatUpdateOfContent") : TransferServiceImplTest.this.transferService.getTransferTarget("testRepeatUpdateOfContent");
                TransferServiceImplTest.this.transferService.enableTransferTarget("testRepeatUpdateOfContent", true);
                return testContext;
            }
        };
        final TestContext testContext = (TestContext)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> updateContentCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                ContentWriter writer = TransferServiceImplTest.this.contentService.getWriter(testContext.contentNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.setEncoding("UTF-8");
                writer.putContent(testContext.contentString);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> transferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.contentNodeRef);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer("testRepeatUpdateOfContent", definition);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> checkTransferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                NodeRef destNodeRef = testNodeFactory.getMappedNodeRef(testContext.contentNodeRef);
                ContentReader reader = TransferServiceImplTest.this.contentService.getReader(destNodeRef, ContentModel.PROP_CONTENT);
                TransferServiceImplTest.assertNotNull((String)"content reader is null", (Object)reader);
                TransferServiceImplTest.assertTrue((String)"content encoding is wrong", (boolean)reader.getEncoding().equalsIgnoreCase("UTF-8"));
                TransferServiceImplTest.assertEquals((String)"content locale is wrong", (Object)reader.getLocale(), (Object)CONTENT_LOCALE);
                TransferServiceImplTest.assertTrue((String)"content does not exist", (boolean)reader.exists());
                String contentStr = reader.getContentString();
                TransferServiceImplTest.assertEquals((String)"Content is wrong", (String)contentStr, (String)testContext.contentString);
                return null;
            }
        };
        int i = 0;
        while (i < 6) {
            this.logger.debug((Object)("testRepeatUpdateContent - iteration:" + i));
            testContext.contentString = String.valueOf(i);
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)updateContentCB);
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)checkTransferCB);
            ++i;
        }
    }

    @Test
    public void testReplaceNode() throws Exception {
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath((String)this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath((String)this.COMPANY_HOME_XPATH_QUERY)));
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        final NodeRef guestHome = this.repositoryHelper.getGuestHome();
        class TestContext {
            TransferTarget transferMe;
            NodeRef parentNodeRef;
            NodeRef middleNodeRef;
            NodeRef childNodeRef;
            QName parentName;
            QName middleName;
            QName childName;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext testContext = new TestContext();
                String name = GUID.generate();
                testContext.parentName = QName.createQName((String)name);
                testContext.childName = QName.createQName((String)"Ermintrude");
                testContext.middleName = QName.createQName((String)"Matilda");
                ChildAssociationRef child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, testContext.parentName, ContentModel.TYPE_FOLDER);
                testContext.parentNodeRef = child.getChildRef();
                TransferServiceImplTest.this.logger.debug((Object)("parentNodeRef created:" + String.valueOf(testContext.parentNodeRef)));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.parentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.parentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)testContext.parentName.getLocalName()));
                ChildAssociationRef child2 = TransferServiceImplTest.this.nodeService.createNode(testContext.parentNodeRef, ContentModel.ASSOC_CONTAINS, testContext.childName, ContentModel.TYPE_FOLDER);
                testContext.middleNodeRef = child2.getChildRef();
                TransferServiceImplTest.this.logger.debug((Object)("middleNodeRef created:" + String.valueOf(testContext.middleNodeRef)));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.middleNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.middleNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)testContext.childName.getLocalName()));
                ChildAssociationRef child3 = TransferServiceImplTest.this.nodeService.createNode(testContext.middleNodeRef, ContentModel.ASSOC_CONTAINS, testContext.childName, ContentModel.TYPE_CONTENT);
                testContext.childNodeRef = child3.getChildRef();
                TransferServiceImplTest.this.logger.debug((Object)("childNodeRef created:" + String.valueOf(testContext.childNodeRef)));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.childNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.childNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)testContext.childName.getLocalName()));
                testContext.transferMe = !TransferServiceImplTest.this.transferService.targetExists("testRepeatUpdateOfContent") ? TransferServiceImplTest.this.createTransferTarget("testRepeatUpdateOfContent") : TransferServiceImplTest.this.transferService.getTransferTarget("testRepeatUpdateOfContent");
                TransferServiceImplTest.this.transferService.enableTransferTarget("testRepeatUpdateOfContent", true);
                return testContext;
            }
        };
        final TestContext testContext = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> transferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                ArrayList<NodeRef> nodes = new ArrayList<NodeRef>();
                nodes.add(testContext.childNodeRef);
                nodes.add(testContext.parentNodeRef);
                nodes.add(testContext.middleNodeRef);
                definition.setSync(true);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer("testRepeatUpdateOfContent", definition);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> checkTransferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> replaceNodesCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceImplTest.this.nodeService.deleteNode(testContext.middleNodeRef);
                TransferServiceImplTest.this.logger.debug((Object)"deleted node");
                ChildAssociationRef child2 = TransferServiceImplTest.this.nodeService.createNode(testContext.parentNodeRef, ContentModel.ASSOC_CONTAINS, testContext.childName, ContentModel.TYPE_FOLDER);
                testContext.middleNodeRef = child2.getChildRef();
                TransferServiceImplTest.this.logger.debug((Object)("middleNodeRef created:" + String.valueOf(testContext.middleNodeRef)));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.middleNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.middleNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)testContext.childName.getLocalName()));
                ChildAssociationRef child3 = TransferServiceImplTest.this.nodeService.createNode(testContext.middleNodeRef, ContentModel.ASSOC_CONTAINS, testContext.childName, ContentModel.TYPE_CONTENT);
                testContext.childNodeRef = child3.getChildRef();
                TransferServiceImplTest.this.logger.debug((Object)("childNodeRef created:" + String.valueOf(testContext.childNodeRef)));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.childNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.childNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)testContext.childName.getLocalName()));
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)replaceNodesCB);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)checkTransferCB);
    }

    @Test
    public void testPeerAssocs() throws Exception {
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        final UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath((String)this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath((String)this.COMPANY_HOME_XPATH_QUERY)));
        class TestContext {
            TransferTarget transferMe;
            NodeRef folderNodeRef;
            NodeRef sourceNodeRef;
            NodeRef targetNodeRef;
            NodeRef destSourceNodeRef;
            NodeRef destTargetNodeRef;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext testContext = new TestContext();
                NodeRef guestHome = TransferServiceImplTest.this.repositoryHelper.getGuestHome();
                String name = GUID.generate();
                TransferDefinition def = new TransferDefinition();
                ChildAssociationRef child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
                testContext.folderNodeRef = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(testContext.folderNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.folderNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                testNodeFactory.createTransferManifestNode(testContext.folderNodeRef, def, new TransferContext());
                child = TransferServiceImplTest.this.nodeService.createNode(testContext.folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"source"), ContentModel.TYPE_CONTENT);
                testContext.sourceNodeRef = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(testContext.sourceNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.sourceNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"source"));
                testNodeFactory.createTransferManifestNode(testContext.sourceNodeRef, def, new TransferContext());
                child = TransferServiceImplTest.this.nodeService.createNode(testContext.folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"target"), ContentModel.TYPE_CONTENT);
                testContext.targetNodeRef = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(testContext.targetNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.targetNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"target"));
                testNodeFactory.createTransferManifestNode(testContext.folderNodeRef, def, new TransferContext());
                TransferServiceImplTest.this.nodeService.createAssociation(testContext.sourceNodeRef, testContext.targetNodeRef, ContentModel.ASSOC_REFERENCES);
                testNodeFactory.createTransferManifestNode(testContext.targetNodeRef, def, new TransferContext());
                testContext.transferMe = !TransferServiceImplTest.this.transferService.targetExists("testPeerAssocs") ? TransferServiceImplTest.this.createTransferTarget("testPeerAssocs") : TransferServiceImplTest.this.transferService.getTransferTarget("testPeerAssocs");
                TransferServiceImplTest.this.transferService.enableTransferTarget("testPeerAssocs", true);
                return testContext;
            }
        };
        final TestContext testContext = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> addPeerAssocCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            public QName assocQName = ContentModel.ASSOC_ATTACHMENTS;
            {
            }

            public Void execute() throws Throwable {
                TransferServiceImplTest.this.nodeService.createAssociation(testContext.sourceNodeRef, testContext.targetNodeRef, this.assocQName);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> removePeerAssocCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                List refs = TransferServiceImplTest.this.nodeService.getTargetAssocs(testContext.sourceNodeRef, RegexQNamePattern.MATCH_ALL);
                if (refs.size() > 0) {
                    AssociationRef ref = (AssociationRef)refs.get(0);
                    TransferServiceImplTest.this.nodeService.removeAssociation(ref.getSourceRef(), ref.getTargetRef(), ref.getTypeQName());
                }
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> transferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.sourceNodeRef);
                nodes.add(testContext.targetNodeRef);
                nodes.add(testContext.folderNodeRef);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer("testPeerAssocs", definition);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<List<AssociationRef>> readAssocsCB = new RetryingTransactionHelper.RetryingTransactionCallback<List<AssociationRef>>(){
            {
            }

            public List<AssociationRef> execute() throws Throwable {
                List source = TransferServiceImplTest.this.nodeService.getSourceAssocs(testContext.sourceNodeRef, RegexQNamePattern.MATCH_ALL);
                List target = TransferServiceImplTest.this.nodeService.getTargetAssocs(testContext.sourceNodeRef, RegexQNamePattern.MATCH_ALL);
                NodeRef destNode = testNodeFactory.getMappedNodeRef(testContext.sourceNodeRef);
                List destSource = TransferServiceImplTest.this.nodeService.getSourceAssocs(destNode, RegexQNamePattern.MATCH_ALL);
                List destTarget = TransferServiceImplTest.this.nodeService.getTargetAssocs(destNode, RegexQNamePattern.MATCH_ALL);
                TransferServiceImplTest.assertEquals((String)"source peers different sizes", (int)destSource.size(), (int)source.size());
                TransferServiceImplTest.assertEquals((String)"target peers different sizes", (int)destTarget.size(), (int)target.size());
                if (destSource.size() == 1) {
                    TransferServiceImplTest.assertEquals((Object)((AssociationRef)destSource.get(0)).getTypeQName(), (Object)((AssociationRef)source.get(0)).getTypeQName());
                }
                if (destTarget.size() == 1) {
                    TransferServiceImplTest.assertEquals((Object)((AssociationRef)destTarget.get(0)).getTypeQName(), (Object)((AssociationRef)target.get(0)).getTypeQName());
                }
                return destTarget;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        List assocs = (List)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)readAssocsCB);
        TransferServiceImplTest.assertEquals((String)"assocs not one", (int)1, (int)assocs.size());
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)addPeerAssocCB);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        assocs = (List)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)readAssocsCB);
        TransferServiceImplTest.assertEquals((String)"assocs not two", (int)2, (int)assocs.size());
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)removePeerAssocCB);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)removePeerAssocCB);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
    }

    @Test
    public void testExistingNodes() throws Exception {
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        UnitTestInProcessTransmitterImpl transmitter = new UnitTestInProcessTransmitterImpl(this.receiver, this.contentService, this.transactionService);
        this.transferServiceImpl.setTransmitter((TransferTransmitter)transmitter);
        final UnitTestTransferManifestNodeFactory testNodeFactory = new UnitTestTransferManifestNodeFactory(this.transferManifestNodeFactory);
        this.transferServiceImpl.setTransferManifestNodeFactory((TransferManifestNodeFactory)testNodeFactory);
        List<Pair<Path, Path>> pathMap = testNodeFactory.getPathMap();
        pathMap.add((Pair<Path, Path>)new Pair((Object)PathHelper.stringToPath((String)this.GUEST_HOME_XPATH_QUERY), (Object)PathHelper.stringToPath((String)this.COMPANY_HOME_XPATH_QUERY)));
        class TestContext {
            TransferTarget transferMe;
            NodeRef folderNodeRef;
            NodeRef contentNodeRef;
            NodeRef rootNodeRef;
            NodeRef destFolderNodeRef;
            NodeRef destFileNodeRef;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext testContext = new TestContext();
                NodeRef guestHome = TransferServiceImplTest.this.repositoryHelper.getGuestHome();
                NodeRef companyHome = TransferServiceImplTest.this.repositoryHelper.getCompanyHome();
                String name = GUID.generate();
                TransferDefinition def = new TransferDefinition();
                ChildAssociationRef child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
                testContext.rootNodeRef = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(testContext.rootNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)name));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.rootNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                testNodeFactory.createTransferManifestNode(testContext.rootNodeRef, def, new TransferContext());
                child = TransferServiceImplTest.this.nodeService.createNode(testContext.rootNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A1"), ContentModel.TYPE_FOLDER);
                testContext.folderNodeRef = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(testContext.folderNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A1"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.folderNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A1"));
                testNodeFactory.createTransferManifestNode(testContext.folderNodeRef, def, new TransferContext());
                child = TransferServiceImplTest.this.nodeService.createNode(testContext.folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2"), ContentModel.TYPE_CONTENT);
                testContext.contentNodeRef = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(testContext.contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A2"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A2"));
                testNodeFactory.createTransferManifestNode(testContext.contentNodeRef, def, new TransferContext());
                child = TransferServiceImplTest.this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_FOLDER);
                TransferServiceImplTest.this.nodeService.setProperty(testContext.rootNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)name));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.rootNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                child = TransferServiceImplTest.this.nodeService.createNode(child.getChildRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A1"), ContentModel.TYPE_FOLDER);
                testContext.destFolderNodeRef = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(testContext.destFolderNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A1"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.destFolderNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A1"));
                child = TransferServiceImplTest.this.nodeService.createNode(testContext.destFolderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"A2"), ContentModel.TYPE_CONTENT);
                testContext.destFileNodeRef = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(testContext.destFileNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"A2"));
                TransferServiceImplTest.this.nodeService.setProperty(testContext.destFileNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"A2"));
                testContext.transferMe = !TransferServiceImplTest.this.transferService.targetExists("testExistingNodes") ? TransferServiceImplTest.this.createTransferTarget("testExistingNodes") : TransferServiceImplTest.this.transferService.getTransferTarget("testExistingNodes");
                TransferServiceImplTest.this.transferService.enableTransferTarget("testExistingNodes", true);
                return testContext;
            }
        };
        final TestContext testContext = (TestContext)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> transferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.rootNodeRef);
                nodes.add(testContext.folderNodeRef);
                nodes.add(testContext.contentNodeRef);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer("testExistingNodes", definition);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceImplTest.assertTrue((String)"folder has transferred aspect", (!TransferServiceImplTest.this.nodeService.hasAspect(testContext.destFolderNodeRef, TransferModel.ASPECT_TRANSFERRED) ? 1 : 0) != 0);
                TransferServiceImplTest.assertTrue((String)"file has transferred aspctet", (!TransferServiceImplTest.this.nodeService.hasAspect(testContext.destFileNodeRef, TransferModel.ASPECT_TRANSFERRED) ? 1 : 0) != 0);
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateCB);
    }

    @Category(value={RedundantTests.class})
    @Test
    public void testCategoriesAndTags() throws Exception {
        final UnitTestTransferManifestNodeFactory testNodeFactory = this.unitTestKludgeToTransferGuestHomeToCompanyHome();
        DescriptorService mockedDescriptorService = this.getMockDescriptorService(this.REPO_ID_A);
        this.transferServiceImpl.setDescriptorService(mockedDescriptorService);
        class TestContext {
            TransferTarget transferMe;
            NodeRef contentNodeRef;
            NodeRef destNodeRef;

            TestContext() {
            }
        }
        RetryingTransactionHelper.RetryingTransactionCallback<TestContext> setupCB = new RetryingTransactionHelper.RetryingTransactionCallback<TestContext>(){

            public TestContext execute() throws Throwable {
                TestContext ctx = new TestContext();
                NodeRef guestHome = TransferServiceImplTest.this.repositoryHelper.getGuestHome();
                String name = GUID.generate();
                ChildAssociationRef child = TransferServiceImplTest.this.nodeService.createNode(guestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ContentModel.TYPE_CONTENT);
                ctx.contentNodeRef = child.getChildRef();
                TransferServiceImplTest.this.nodeService.setProperty(ctx.contentNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"ContentTitle"));
                TransferServiceImplTest.this.nodeService.setProperty(ctx.contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                TransferServiceImplTest.this.taggingService.addTag(ctx.contentNodeRef, "tag1");
                ctx.transferMe = !TransferServiceImplTest.this.transferService.targetExists("testCategoriesAndTags") ? TransferServiceImplTest.this.createTransferTarget("testCategoriesAndTags") : TransferServiceImplTest.this.transferService.getTransferTarget("testCategoriesAndTags");
                TransferServiceImplTest.this.transferService.enableTransferTarget("testCategoriesAndTags", true);
                return ctx;
            }
        };
        final TestContext testContext = (TestContext)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCB);
        this.logger.debug((Object)"First transfer - create new node with a tag");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> transferCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferDefinition definition = new TransferDefinition();
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(testContext.contentNodeRef);
                definition.setNodes(nodes);
                TransferServiceImplTest.this.transferService.transfer("testCategoriesAndTags", definition);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateStep1CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                testContext.destNodeRef = testNodeFactory.getMappedNodeRef(testContext.contentNodeRef);
                TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testContext.destNodeRef.equals((Object)testContext.transferMe.getNodeRef()));
                TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(testContext.destNodeRef));
                TransferServiceImplTest.assertEquals((String)"title is wrong", (String)((String)((Object)TransferServiceImplTest.this.nodeService.getProperty(testContext.destNodeRef, ContentModel.PROP_TITLE))), (String)"ContentTitle");
                TransferServiceImplTest.assertEquals((String)"type is wrong", (Object)TransferServiceImplTest.this.nodeService.getType(testContext.contentNodeRef), (Object)TransferServiceImplTest.this.nodeService.getType(testContext.destNodeRef));
                List tags = TransferServiceImplTest.this.taggingService.getTags(testContext.contentNodeRef);
                TransferServiceImplTest.assertNotNull((Object)tags);
                TransferServiceImplTest.assertEquals((int)1, (int)tags.size());
                TransferServiceImplTest.assertTrue((boolean)tags.contains("tag1"));
                TransferServiceImplTest.this.taggingService.addTag(testContext.contentNodeRef, "tag2");
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateStep1CB);
        this.logger.debug((Object)"Second transfer - add a second tag");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateStep2CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testContext.destNodeRef.equals((Object)testContext.transferMe.getNodeRef()));
                TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(testContext.destNodeRef));
                List tags = TransferServiceImplTest.this.taggingService.getTags(testContext.contentNodeRef);
                TransferServiceImplTest.assertNotNull((Object)tags);
                TransferServiceImplTest.assertTrue((tags.size() == 2 ? 1 : 0) != 0);
                TransferServiceImplTest.assertTrue((boolean)tags.contains("tag1"));
                TransferServiceImplTest.assertTrue((boolean)tags.contains("tag2"));
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateStep2CB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteTagCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceImplTest.this.taggingService.removeTag(testContext.contentNodeRef, "tag2");
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteTagCB);
        this.logger.debug((Object)"Transfer again - this is to delete a tag");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        final QName ASPECT_GENERAL_CLASSIFIABLE = ContentModel.ASPECT_GEN_CLASSIFIABLE;
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateStep3CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testContext.destNodeRef.equals((Object)testContext.transferMe.getNodeRef()));
                TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(testContext.destNodeRef));
                List tags = TransferServiceImplTest.this.taggingService.getTags(testContext.destNodeRef);
                TransferServiceImplTest.assertNotNull((Object)tags);
                TransferServiceImplTest.assertTrue((tags.size() == 1 ? 1 : 0) != 0);
                TransferServiceImplTest.assertTrue((boolean)tags.contains("tag1"));
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateStep3CB);
        this.logger.debug((Object)"Step 4 - add a category");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> step4WriteContentCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                StoreRef workspaceSpacesStore = new StoreRef("workspace", "SpacesStore");
                Collection rootCategories = TransferServiceImplTest.this.categoryService.getRootCategories(workspaceSpacesStore, ASPECT_GENERAL_CLASSIFIABLE);
                NodeRef languageCategory = null;
                for (ChildAssociationRef ref : rootCategories) {
                    if (!ref.getQName().getLocalName().equalsIgnoreCase("LANGUAGES")) continue;
                    languageCategory = ref.getChildRef();
                }
                TransferServiceImplTest.assertNotNull((String)"language category is null", languageCategory);
                ChildAssociationRef categoryRef = TransferServiceImplTest.this.categoryService.getCategory(languageCategory, ASPECT_GENERAL_CLASSIFIABLE, "English");
                TransferServiceImplTest.assertNotNull((String)"ENGLISH CATEGORY REF is null", (Object)categoryRef);
                ArrayList<NodeRef> newCats = new ArrayList<NodeRef>();
                newCats.add(categoryRef.getChildRef());
                TransferServiceImplTest.this.nodeService.setProperty(testContext.contentNodeRef, ContentModel.PROP_CATEGORIES, (Serializable)newCats);
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateStep4CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                TransferServiceImplTest.assertFalse((String)"unit test stuffed up - comparing with self", (boolean)testContext.destNodeRef.equals((Object)testContext.transferMe.getNodeRef()));
                TransferServiceImplTest.assertTrue((String)"dest node ref does not exist", (boolean)TransferServiceImplTest.this.nodeService.exists(testContext.destNodeRef));
                TransferServiceImplTest.assertTrue((String)"destination node is missing aspect general classifiable", (boolean)TransferServiceImplTest.this.nodeService.hasAspect(testContext.destNodeRef, ContentModel.ASPECT_GEN_CLASSIFIABLE));
                Serializable categories = TransferServiceImplTest.this.nodeService.getProperty(testContext.destNodeRef, ContentModel.PROP_CATEGORIES);
                TransferServiceImplTest.assertNotNull((String)"categories is missing on destination node", (Object)categories);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)step4WriteContentCB);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)transferCB);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)validateStep4CB);
    }

    private TransferTarget createTransferTarget(String name) {
        String title = "title";
        String description = "description";
        String endpointProtocol = "http";
        String endpointHost = "MARKR02";
        int endpointPort = 7080;
        String endpointPath = "/alfresco/service/api/transfer";
        String username = "admin";
        char[] password = "admin".toCharArray();
        TransferTarget target = this.transferService.createAndSaveTransferTarget(name, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
        return target;
    }

    private DescriptorService getMockDescriptorService(String repositoryId) {
        DescriptorService descriptorService = (DescriptorService)Mockito.mock(DescriptorService.class);
        Descriptor descriptor = (Descriptor)Mockito.mock(Descriptor.class);
        Mockito.when((Object)descriptor.getId()).thenReturn((Object)repositoryId);
        Mockito.when((Object)descriptorService.getCurrentRepositoryDescriptor()).thenReturn((Object)descriptor);
        Mockito.when((Object)descriptorService.getServerDescriptor()).thenReturn((Object)this.serverDescriptor);
        return descriptorService;
    }
}

