/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import org.alfresco.repo.virtual.ref.HashStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HashStoreConfiguration {
    private static Log logger = LogFactory.getLog(HashStoreConfiguration.class);
    private static HashStoreConfiguration instance = null;
    private final HashStore classpathStore = new HashStore();
    private HashStore storeProtocolStore = new HashStore();
    private HashStore storeIdStore = new HashStore();

    public static synchronized HashStoreConfiguration getInstance() {
        if (instance == null) {
            instance = new HashStoreConfiguration();
        }
        return instance;
    }

    private HashStoreConfiguration() {
        this.storeProtocolStore.put("workspace", "1");
        this.storeProtocolStore.put("archive", "2");
        this.storeProtocolStore.put("avm", "3");
        this.storeProtocolStore.put("deleted", "4");
        this.storeProtocolStore.put("test", "5");
        this.storeProtocolStore.put("versionStore", "6");
        this.storeIdStore.put("SpacesStore", "1");
        this.storeIdStore.put("lightWeightVersionStore", "2");
        this.storeIdStore.put("version2Store", "3");
    }

    public HashStore getClasspathHashStore() {
        return this.classpathStore;
    }

    public HashStore getStoreIdStore() {
        return this.storeIdStore;
    }

    public HashStore getStoreProtocolStore() {
        return this.storeProtocolStore;
    }

    public static class HashStoreConfigurationBean {
        public void setClasspathsHashes(String classpathsHashes) {
            String[] hashes = classpathsHashes.split(",");
            int i = 0;
            while (i < hashes.length) {
                String[] pathHash = hashes[i].split("->");
                if (pathHash.length != 2) {
                    logger.error((Object)("Invalid classpath hash configuration " + hashes[i]));
                } else {
                    HashStoreConfiguration.getInstance().getClasspathHashStore().put(pathHash[0], pathHash[1]);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Configured classpath hash " + pathHash[0] + " -> " + pathHash[1]));
                    }
                }
                ++i;
            }
        }
    }
}

