/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.dictionary.CMMDownloadTestUtil;
import org.alfresco.repo.dictionary.CustomModelsInfo;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.CustomModelDefinition;
import org.alfresco.service.cmr.dictionary.CustomModelException;
import org.alfresco.service.cmr.dictionary.CustomModelService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.NamespaceDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.download.DownloadStatus;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class CustomModelServiceImplTest {
    private static final long PAUSE_TIME = 1000L;
    @ClassRule
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    @Rule
    public RunAsFullyAuthenticatedRule runAsRule = new RunAsFullyAuthenticatedRule(AuthenticationUtil.getAdminUserName());
    private static CustomModelService customModelService;
    private static RetryingTransactionHelper transactionHelper;
    private static PersonService personService;
    private static AuthorityService authorityService;
    private static CMMDownloadTestUtil cmmDownloadTestUtil;
    private List<String> modelNames = new ArrayList<String>();

    @BeforeClass
    public static void initStaticData() throws Exception {
        customModelService = (CustomModelService)APP_CONTEXT_INIT.getApplicationContext().getBean("customModelService", CustomModelService.class);
        transactionHelper = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        personService = (PersonService)APP_CONTEXT_INIT.getApplicationContext().getBean("personService", PersonService.class);
        authorityService = (AuthorityService)APP_CONTEXT_INIT.getApplicationContext().getBean("authorityService", AuthorityService.class);
        cmmDownloadTestUtil = new CMMDownloadTestUtil(APP_CONTEXT_INIT.getApplicationContext());
    }

    @AfterClass
    public static void cleanUp() {
        cmmDownloadTestUtil.cleanup();
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @After
    public void tearDown() throws Exception {
        final ArrayList activeModels = new ArrayList();
        for (final String model : this.modelNames) {
            transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Exception {
                    try {
                        customModelService.deleteCustomModel(model);
                    }
                    catch (CustomModelException.ActiveModelConstraintException activeModelConstraintException) {
                        activeModels.add(model);
                    }
                    catch (Exception exception) {}
                    return null;
                }
            });
        }
        for (final String am : activeModels) {
            try {
                transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Exception {
                        customModelService.deactivateCustomModel(am);
                        return null;
                    }
                });
                transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Exception {
                        customModelService.deleteCustomModel(am);
                        return null;
                    }
                });
            }
            catch (Exception exception) {}
        }
        this.modelNames.clear();
    }

    @Test
    public void testCreateBasicInactiveModel() throws Exception {
        String modelName1 = this.makeUniqueName("testCustomModel1");
        Pair<String, String> namespacePair = this.getTestNamespacePrefixPair();
        M2Model model = M2Model.createModel((String)((String)namespacePair.getSecond() + ":" + modelName1));
        model.createNamespace((String)namespacePair.getFirst(), (String)namespacePair.getSecond());
        model.setDescription("This is test custom model desc");
        model.setAuthor("John Doe");
        CustomModelDefinition modelDefinition = this.createModel(model, false);
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)modelName1, (Object)modelDefinition.getName().getLocalName());
        Assert.assertTrue((String)"There is no imported namespace.", (boolean)modelDefinition.getImportedNamespaces().isEmpty());
        NamespaceDefinition namespaceDefinition = (NamespaceDefinition)modelDefinition.getNamespaces().iterator().next();
        Assert.assertNotNull((Object)namespaceDefinition);
        Assert.assertEquals((Object)namespacePair.getFirst(), (Object)namespaceDefinition.getUri());
        Assert.assertEquals((Object)namespacePair.getSecond(), (Object)namespaceDefinition.getPrefix());
        Assert.assertEquals((Object)"This is test custom model desc", (Object)modelDefinition.getDescription());
        Assert.assertEquals((Object)"John Doe", (Object)modelDefinition.getAuthor());
        String modelName2 = this.makeUniqueName("testCustomModel2");
        model = M2Model.createModel((String)((String)namespacePair.getSecond() + ":" + modelName2));
        model.createNamespace((String)namespacePair.getFirst(), "newTestPrefix");
        try {
            this.createModel(model, false);
            Assert.fail((String)"Shouldn't be able to create a model with an already in-use namespace uri.");
        }
        catch (CustomModelException.NamespaceConstraintException namespaceConstraintException) {}
        String modelName3 = this.makeUniqueName("testCustomModel3");
        model = M2Model.createModel((String)((String)namespacePair.getSecond() + ":" + modelName3));
        model.createNamespace((String)this.getTestNamespacePrefixPair().getFirst(), (String)namespacePair.getSecond());
        try {
            this.createModel(model, false);
            Assert.fail((String)"Shouldn't be able to create a model with an already in-use namespace prefix.");
        }
        catch (CustomModelException.NamespaceConstraintException namespaceConstraintException) {}
        namespacePair = this.getTestNamespacePrefixPair();
        model = M2Model.createModel((String)((String)namespacePair.getSecond() + ":" + modelName2));
        model.createNamespace((String)namespacePair.getFirst(), (String)namespacePair.getSecond());
        modelDefinition = this.createModel(model, false);
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)modelName2, (Object)modelDefinition.getName().getLocalName());
        namespaceDefinition = (NamespaceDefinition)modelDefinition.getNamespaces().iterator().next();
        Assert.assertNotNull((Object)namespaceDefinition);
        Assert.assertEquals((Object)namespacePair.getFirst(), (Object)namespaceDefinition.getUri());
        Assert.assertEquals((Object)namespacePair.getSecond(), (Object)namespaceDefinition.getPrefix());
        try {
            this.createModel(model, false);
            Assert.fail((String)"Shouldn't be able to create a duplicate model.");
        }
        catch (Exception exception) {}
        try {
            model.setName("contentmodel");
            this.createModel(model, false);
            Assert.fail((String)"Shouldn't be able to create a model with the same name as the bootstrapped model.");
        }
        catch (Exception exception) {}
        try {
            customModelService.getCustomModels(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException as PagingRequest was null.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        final PagingRequest pagingRequest = new PagingRequest(0, Integer.MAX_VALUE);
        PagingResults result = (PagingResults)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<PagingResults<CustomModelDefinition>>(){

            public PagingResults<CustomModelDefinition> execute() throws Exception {
                return customModelService.getCustomModels(pagingRequest);
            }
        });
        Assert.assertTrue(((Integer)result.getTotalResultCount().getFirst() >= 2 ? 1 : 0) != 0);
    }

    @Test
    public void testListTypesAspects_Empty() throws Exception {
        String modelName = this.makeUniqueName("testCustomModel");
        Pair<String, String> namespacePair = this.getTestNamespacePrefixPair();
        M2Model model = M2Model.createModel((String)((String)namespacePair.getSecond() + ":" + modelName));
        model.createNamespace((String)namespacePair.getFirst(), (String)namespacePair.getSecond());
        this.createModel(model, false);
        CustomModelDefinition modelDefinition = this.getModel(modelName);
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)modelName, (Object)modelDefinition.getName().getLocalName());
        Collection types = modelDefinition.getTypeDefinitions();
        Assert.assertEquals((long)0L, (long)types.size());
        Collection aspects = modelDefinition.getAspectDefinitions();
        Assert.assertEquals((long)0L, (long)aspects.size());
    }

    @Test
    public void testModelAdmin() throws Exception {
        Assert.assertFalse((boolean)customModelService.isModelAdmin(null));
        final String userName = "testUser" + System.currentTimeMillis();
        final PropertyMap testUser = new PropertyMap();
        testUser.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
        testUser.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"John");
        testUser.put((Object)ContentModel.PROP_LASTNAME, (Object)"Doe");
        testUser.put((Object)ContentModel.PROP_PASSWORD, (Object)"password");
        final NodeRef personNodeRef = (NodeRef)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                NodeRef nodeRef = personService.createPerson((Map)testUser);
                Assert.assertNotNull((Object)nodeRef);
                Assert.assertFalse((boolean)customModelService.isModelAdmin(userName));
                authorityService.addAuthority("GROUP_ALFRESCO_MODEL_ADMINISTRATORS", userName);
                Assert.assertTrue((boolean)customModelService.isModelAdmin(userName));
                return nodeRef;
            }
        });
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Exception {
                personService.deletePerson(personNodeRef);
                return null;
            }
        });
    }

    @Test
    public void testActivateModel() throws Exception {
        final String modelName = this.makeUniqueName("testCustomModel");
        Pair<String, String> namespacePair = this.getTestNamespacePrefixPair();
        M2Model model = M2Model.createModel((String)((String)namespacePair.getSecond() + ":" + modelName));
        model.createNamespace((String)namespacePair.getFirst(), (String)namespacePair.getSecond());
        model.setDescription("This is test custom model desc");
        model.setAuthor("John Doe");
        CustomModelDefinition modelDefinition = this.createModel(model, false);
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)modelName, (Object)modelDefinition.getName().getLocalName());
        Assert.assertFalse((boolean)modelDefinition.isActive());
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Exception {
                customModelService.activateCustomModel(modelName);
                return null;
            }
        });
        modelDefinition = this.getModel(modelName);
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)modelName, (Object)modelDefinition.getName().getLocalName());
        Assert.assertTrue((boolean)modelDefinition.isActive());
        try {
            customModelService.activateCustomModel(modelName);
            Assert.fail((String)"Shouldn't be able to activate an already activated model.");
        }
        catch (Exception exception) {}
    }

    @Test
    public void testisNamespaceUriExists() {
        String modelName = this.makeUniqueName("testCustomModel");
        final Pair<String, String> namespacePair = this.getTestNamespacePrefixPair();
        M2Model model = M2Model.createModel((String)((String)namespacePair.getSecond() + ":" + modelName));
        model.createNamespace((String)namespacePair.getFirst(), (String)namespacePair.getSecond());
        model.setAuthor("John Doe");
        Assert.assertNull((Object)customModelService.getCustomModelByUri((String)namespacePair.getFirst()));
        CustomModelDefinition modelDefinition = this.createModel(model, false);
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)modelName, (Object)modelDefinition.getName().getLocalName());
        ModelDefinition modelDefinitionByUri = (ModelDefinition)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<ModelDefinition>(){

            public ModelDefinition execute() throws Throwable {
                Assert.assertTrue((boolean)customModelService.isNamespaceUriExists((String)namespacePair.getFirst()));
                return customModelService.getCustomModelByUri((String)namespacePair.getFirst());
            }
        });
        Assert.assertNotNull((Object)modelDefinitionByUri);
        Assert.assertEquals((Object)modelName, (Object)modelDefinitionByUri.getName().getLocalName());
    }

    @Test
    public void testCreateModelWithTypesAndAspects() throws Exception {
        String modelName = this.makeUniqueName("testCustomModelFailed");
        Pair<String, String> namespacePair = this.getTestNamespacePrefixPair();
        M2Model model = M2Model.createModel((String)((String)namespacePair.getSecond() + ":" + modelName));
        model.createNamespace((String)namespacePair.getFirst(), (String)namespacePair.getSecond());
        model.setAuthor("Average Joe");
        String typeName = "testType";
        M2Type m2Type = model.createType((String)namespacePair.getSecond() + ":" + typeName);
        m2Type.setTitle("Test type title");
        m2Type.setParentName("cm:content");
        String aspectName = "testMarkerAspect";
        model.createAspect((String)namespacePair.getSecond() + ":" + aspectName);
        try {
            this.createModel(model, false);
            Assert.fail((String)"Shouldn't be able to create a model without namespace imports, when type and/or aspect have parent name.");
        }
        catch (Exception exception) {}
        model.setName((String)namespacePair.getSecond() + ":" + modelName);
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        CustomModelDefinition modelDefinition = this.createModel(model, false);
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)modelName, (Object)modelDefinition.getName().getLocalName());
        Assert.assertEquals((long)1L, (long)modelDefinition.getTypeDefinitions().size());
        Assert.assertEquals((Object)typeName, (Object)((TypeDefinition)modelDefinition.getTypeDefinitions().iterator().next()).getName().getLocalName());
        Assert.assertEquals((Object)"cm:content", (Object)((TypeDefinition)modelDefinition.getTypeDefinitions().iterator().next()).getParentName().toPrefixString());
        Assert.assertEquals((long)1L, (long)modelDefinition.getAspectDefinitions().size());
        Assert.assertEquals((Object)aspectName, (Object)((AspectDefinition)modelDefinition.getAspectDefinitions().iterator().next()).getName().getLocalName());
        try {
            customModelService.getAllCustomTypes(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException as PagingRequest was null.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            customModelService.getAllCustomAspects(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException as PagingRequest was null.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        final PagingRequest pagingRequest = new PagingRequest(0, Integer.MAX_VALUE);
        PagingResults allTypes = (PagingResults)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<PagingResults<TypeDefinition>>(){

            public PagingResults<TypeDefinition> execute() throws Exception {
                return customModelService.getAllCustomTypes(pagingRequest);
            }
        });
        Assert.assertTrue(((Integer)allTypes.getTotalResultCount().getFirst() >= 1 ? 1 : 0) != 0);
        PagingResults allAspects = (PagingResults)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<PagingResults<AspectDefinition>>(){

            public PagingResults<AspectDefinition> execute() throws Exception {
                return customModelService.getAllCustomAspects(pagingRequest);
            }
        });
        Assert.assertTrue(((Integer)allAspects.getTotalResultCount().getFirst() >= 1 ? 1 : 0) != 0);
        QName aspectQName = QName.createQName((String)("{" + (String)namespacePair.getFirst() + "}" + aspectName));
        AspectDefinition aspectDefinition = this.getAspect(aspectQName);
        Assert.assertNotNull((Object)aspectDefinition);
        Assert.assertEquals((long)1L, (long)this.getModel(modelName).getAspectDefinitions().size());
        QName typeQName = QName.createQName((String)("{" + (String)namespacePair.getFirst() + "}" + typeName));
        TypeDefinition typeDefinition = this.getType(typeQName);
        Assert.assertNotNull((Object)typeDefinition);
        Assert.assertEquals((long)1L, (long)this.getModel(modelName).getTypeDefinitions().size());
        String aspectName2 = "testMarkerAspect2";
        model.createAspect((String)namespacePair.getSecond() + ":" + aspectName2);
        this.updateModel(modelName, model, false);
        aspectQName = QName.createQName((String)("{" + (String)namespacePair.getFirst() + "}" + aspectName2));
        aspectDefinition = this.getAspect(aspectQName);
        Assert.assertNotNull((Object)aspectDefinition);
        Assert.assertEquals((Object)aspectQName, (Object)aspectDefinition.getName());
        Assert.assertEquals((long)2L, (long)this.getModel(modelName).getAspectDefinitions().size());
        String typeName2 = "testType2";
        model.createType((String)namespacePair.getSecond() + ":" + typeName2);
        this.updateModel(modelName, model, false);
        typeQName = QName.createQName((String)("{" + (String)namespacePair.getFirst() + "}" + typeName2));
        typeDefinition = this.getType(typeQName);
        Assert.assertNotNull((Object)typeDefinition);
        Assert.assertEquals((Object)typeQName, (Object)typeDefinition.getName());
        Assert.assertEquals((long)2L, (long)this.getModel(modelName).getTypeDefinitions().size());
        model.createAspect((String)namespacePair.getSecond() + ":" + typeName);
        try {
            this.updateModel(modelName, model, false);
            Assert.fail((String)"Shouldn't be able to create a type and an aspect with the same name in a model.");
        }
        catch (Exception exception) {}
    }

    @Test
    public void testDeactivateModel() throws Exception {
        final String modelName = this.makeUniqueName("testDeactivateCustomModel");
        Pair<String, String> namespacePair = this.getTestNamespacePrefixPair();
        M2Model model = M2Model.createModel((String)((String)namespacePair.getSecond() + ":" + modelName));
        model.createNamespace((String)namespacePair.getFirst(), (String)namespacePair.getSecond());
        model.setDescription("This is test custom model desc");
        model.setAuthor("John Doe");
        CustomModelDefinition modelDefinition = this.createModel(model, true);
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)modelName, (Object)modelDefinition.getName().getLocalName());
        Assert.assertTrue((boolean)modelDefinition.isActive());
        customModelService.deactivateCustomModel(modelName);
        modelDefinition = (CustomModelDefinition)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<CustomModelDefinition>(){

            public CustomModelDefinition execute() throws Exception {
                return customModelService.getCustomModel(modelName);
            }
        });
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)modelName, (Object)modelDefinition.getName().getLocalName());
        Assert.assertFalse((boolean)modelDefinition.isActive());
        try {
            customModelService.deactivateCustomModel(modelName);
            Assert.fail((String)"Shouldn't be able to deactivate an already deactivated model.");
        }
        catch (Exception exception) {}
    }

    @Test
    public void testDeleteModel() throws Exception {
        final String modelName = this.makeUniqueName("testDeleteCustomModel");
        Pair<String, String> namespacePair = this.getTestNamespacePrefixPair();
        M2Model model = M2Model.createModel((String)((String)namespacePair.getSecond() + ":" + modelName));
        model.createNamespace((String)namespacePair.getFirst(), (String)namespacePair.getSecond());
        model.setAuthor("John Doe");
        CustomModelDefinition modelDefinition = this.createModel(model, false);
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)modelName, (Object)modelDefinition.getName().getLocalName());
        Assert.assertFalse((boolean)modelDefinition.isActive());
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Exception {
                try {
                    customModelService.deleteCustomModel(modelName + "someModel");
                    Assert.fail((String)"Should have thrown ModelDoesNotExistException.");
                }
                catch (CustomModelException.ModelDoesNotExistException modelDoesNotExistException) {}
                return null;
            }
        });
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Exception {
                customModelService.activateCustomModel(modelName);
                return null;
            }
        });
        try {
            customModelService.deleteCustomModel(modelName);
            Assert.fail((String)"Shouldn't be able to delete an active model.");
        }
        catch (CustomModelException.ActiveModelConstraintException activeModelConstraintException) {}
        customModelService.deactivateCustomModel(modelName);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Exception {
                customModelService.deleteCustomModel(modelName);
                return null;
            }
        });
        modelDefinition = this.getModel(modelName);
        Assert.assertNull((Object)modelDefinition);
    }

    @Test
    public void testUpdateModel() throws Exception {
        final String modelName = this.makeUniqueName("testUpdateCustomModel");
        Pair<String, String> namespacePair = this.getTestNamespacePrefixPair();
        M2Model model = M2Model.createModel((String)((String)namespacePair.getSecond() + ":" + modelName));
        model.createNamespace((String)namespacePair.getFirst(), (String)namespacePair.getSecond());
        model.setDescription("This is test custom model desc");
        model.setAuthor("John Doe");
        String aspectName = "testMarkerAspect";
        model.createAspect((String)namespacePair.getSecond() + ":" + aspectName);
        CustomModelDefinition modelDefinition = this.createModel(model, false);
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)modelName, (Object)modelDefinition.getName().getLocalName());
        Assert.assertFalse((boolean)modelDefinition.isActive());
        NamespaceDefinition namespaceDefinition = (NamespaceDefinition)modelDefinition.getNamespaces().iterator().next();
        Assert.assertEquals((Object)namespacePair.getFirst(), (Object)namespaceDefinition.getUri());
        Assert.assertEquals((Object)namespacePair.getSecond(), (Object)namespaceDefinition.getPrefix());
        Assert.assertEquals((Object)"This is test custom model desc", (Object)modelDefinition.getDescription());
        Assert.assertEquals((Object)"John Doe", (Object)modelDefinition.getAuthor());
        Assert.assertEquals((long)1L, (long)modelDefinition.getAspectDefinitions().size());
        model.removeNamespace((String)namespacePair.getFirst());
        try {
            this.updateModel(modelName, model, false);
            Assert.fail((String)"Shouldn't be able to update a custom model with an empty namespace.");
        }
        catch (CustomModelException.InvalidNamespaceException invalidNamespaceException) {}
        model.createNamespace((String)namespacePair.getFirst(), null);
        try {
            this.updateModel(modelName, model, false);
            Assert.fail((String)"Model validation should have failed, as the namespace prefix is null.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        model.createNamespace("http://www.alfresco.org/model/contenttest/1.0", (String)namespacePair.getSecond());
        try {
            this.updateModel(modelName, model, false);
            Assert.fail((String)"Shouldn't be able to add more than one namespace URI into a custom model.");
        }
        catch (CustomModelException.InvalidNamespaceException invalidNamespaceException) {}
        model.removeNamespace((String)namespacePair.getFirst());
        model.removeNamespace("http://www.alfresco.org/model/contenttest/1.0");
        model.createNamespace("http://www.alfresco.org/model/content/1.0", (String)namespacePair.getSecond());
        try {
            this.updateModel(modelName, model, false);
            Assert.fail((String)"Shouldn't be able to update a model with an already in-use namespace URI.");
        }
        catch (CustomModelException.NamespaceConstraintException namespaceConstraintException) {}
        model.removeNamespace("http://www.alfresco.org/model/content/1.0");
        model.createNamespace((String)namespacePair.getFirst(), "cm");
        try {
            this.updateModel(modelName, model, false);
            Assert.fail((String)"Shouldn't be able to update a model with an already in-use namespace Prefix.");
        }
        catch (CustomModelException.NamespaceConstraintException namespaceConstraintException) {}
        Pair<String, String> newNamespacePair = this.getTestNamespacePrefixPair();
        model = M2Model.createModel((String)((String)newNamespacePair.getSecond() + ":" + modelName));
        model.createNamespace((String)newNamespacePair.getFirst(), (String)newNamespacePair.getSecond());
        model.setDescription("This is test custom model desc");
        try {
            this.updateModel(modelName + "non-existing model", model, false);
            Assert.fail((String)"Should have thrown ModelDoesNotExistException.");
        }
        catch (CustomModelException.ModelDoesNotExistException modelDoesNotExistException) {}
        modelDefinition = this.updateModel(modelName, model, false);
        namespaceDefinition = (NamespaceDefinition)modelDefinition.getNamespaces().iterator().next();
        Assert.assertEquals((Object)newNamespacePair.getFirst(), (Object)namespaceDefinition.getUri());
        Assert.assertEquals((Object)newNamespacePair.getSecond(), (Object)namespaceDefinition.getPrefix());
        Assert.assertEquals((Object)"This is test custom model desc", (Object)modelDefinition.getDescription());
        Assert.assertNull((Object)modelDefinition.getAuthor());
        Assert.assertEquals((long)0L, (long)modelDefinition.getAspectDefinitions().size());
        QName aspectQName = QName.createQName((String)("{" + (String)namespacePair.getFirst() + "}" + aspectName));
        AspectDefinition aspectDefinition = this.getAspect(aspectQName);
        Assert.assertNull((Object)aspectDefinition);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Exception {
                customModelService.activateCustomModel(modelName);
                return null;
            }
        });
        modelDefinition = this.getModel(modelName);
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertTrue((boolean)modelDefinition.isActive());
        Pair<String, String> activeModelNamespacePair = this.getTestNamespacePrefixPair();
        model = M2Model.createModel((String)((String)newNamespacePair.getSecond() + ":" + modelName));
        model.createNamespace((String)activeModelNamespacePair.getFirst(), (String)newNamespacePair.getSecond());
        try {
            this.updateModel(modelName, model, true);
            Assert.fail((String)"Shouldn't be able to update the namespace URI of an active model.");
        }
        catch (CustomModelException.ActiveModelConstraintException activeModelConstraintException) {}
        activeModelNamespacePair = this.getTestNamespacePrefixPair();
        model = M2Model.createModel((String)((String)activeModelNamespacePair.getSecond() + ":" + modelName));
        model.createNamespace((String)newNamespacePair.getFirst(), (String)activeModelNamespacePair.getSecond());
        try {
            this.updateModel(modelName, model, true);
            Assert.fail((String)"Shouldn't be able to update the namespace prefix of an active model.");
        }
        catch (CustomModelException.ActiveModelConstraintException activeModelConstraintException) {}
        activeModelNamespacePair = this.getTestNamespacePrefixPair();
        model = M2Model.createModel((String)((String)activeModelNamespacePair.getSecond() + ":" + modelName));
        model.createNamespace((String)activeModelNamespacePair.getFirst(), (String)activeModelNamespacePair.getSecond());
        try {
            this.updateModel(modelName, model, true);
            Assert.fail((String)"Shouldn't be able to update the namespace URI and namespace prefix of an active model.");
        }
        catch (CustomModelException.ActiveModelConstraintException activeModelConstraintException) {}
        modelDefinition = this.getModel(modelName);
        namespaceDefinition = (NamespaceDefinition)modelDefinition.getNamespaces().iterator().next();
        model = M2Model.createModel((String)(namespaceDefinition.getPrefix() + ":" + modelName));
        model.createNamespace(namespaceDefinition.getUri(), namespaceDefinition.getPrefix());
        model.setDescription("This is test custom model desc");
        model.setAuthor("Admin Admin");
        modelDefinition = this.updateModel(modelName, model, true);
        Assert.assertEquals((Object)modelName, (Object)modelDefinition.getName().getLocalName());
        Assert.assertTrue((boolean)modelDefinition.isActive());
        Assert.assertEquals((Object)"This is test custom model desc", (Object)modelDefinition.getDescription());
        Assert.assertEquals((Object)"Admin Admin", (Object)modelDefinition.getAuthor());
    }

    @Test
    public void testCreateDownload() throws Exception {
        String modelName = this.makeUniqueName("testDownloadCustomModel");
        String modelExportFileName = modelName + ".xml";
        String shareExtExportFileName = "CMM_" + modelName + "_module.xml";
        Pair<String, String> namespacePair = this.getTestNamespacePrefixPair();
        M2Model model = M2Model.createModel((String)((String)namespacePair.getSecond() + ":" + modelName));
        model.createNamespace((String)namespacePair.getFirst(), (String)namespacePair.getSecond());
        model.setAuthor("Admin");
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        String typeName = "testType";
        M2Type m2Type = model.createType((String)namespacePair.getSecond() + ":" + typeName);
        m2Type.setTitle("Test type title");
        m2Type.setParentName("cm:content");
        CustomModelDefinition modelDefinition = this.createModel(model, false);
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)modelName, (Object)modelDefinition.getName().getLocalName());
        NodeRef downloadNode = this.createDownload(modelName, false);
        Assert.assertNotNull((Object)downloadNode);
        DownloadStatus status = cmmDownloadTestUtil.getDownloadStatus(downloadNode);
        while (status.getStatus() == DownloadStatus.Status.PENDING) {
            Thread.sleep(1000L);
            status = cmmDownloadTestUtil.getDownloadStatus(downloadNode);
        }
        Set<String> entries = cmmDownloadTestUtil.getDownloadEntries(downloadNode);
        Assert.assertEquals((long)1L, (long)entries.size());
        String modelEntry = cmmDownloadTestUtil.getDownloadEntry(entries, modelExportFileName);
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)modelEntry, (Object)modelExportFileName);
        cmmDownloadTestUtil.createShareExtModule(modelName);
        downloadNode = this.createDownload(modelName, true);
        Assert.assertNotNull((Object)downloadNode);
        status = cmmDownloadTestUtil.getDownloadStatus(downloadNode);
        while (status.getStatus() == DownloadStatus.Status.PENDING) {
            Thread.sleep(1000L);
            status = cmmDownloadTestUtil.getDownloadStatus(downloadNode);
        }
        entries = cmmDownloadTestUtil.getDownloadEntries(downloadNode);
        Assert.assertEquals((long)2L, (long)entries.size());
        modelEntry = cmmDownloadTestUtil.getDownloadEntry(entries, modelExportFileName);
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)modelEntry, (Object)modelExportFileName);
        String shareExtEntry = cmmDownloadTestUtil.getDownloadEntry(entries, shareExtExportFileName);
        Assert.assertNotNull((Object)shareExtEntry);
        Assert.assertEquals((Object)shareExtEntry, (Object)shareExtExportFileName);
        cmmDownloadTestUtil.createShareExtModule(modelName + System.currentTimeMillis());
        downloadNode = this.createDownload(modelName, true);
        Assert.assertNotNull((Object)downloadNode);
        status = cmmDownloadTestUtil.getDownloadStatus(downloadNode);
        while (status.getStatus() == DownloadStatus.Status.PENDING) {
            Thread.sleep(1000L);
            status = cmmDownloadTestUtil.getDownloadStatus(downloadNode);
        }
        entries = cmmDownloadTestUtil.getDownloadEntries(downloadNode);
        Assert.assertEquals((long)1L, (long)entries.size());
        modelEntry = cmmDownloadTestUtil.getDownloadEntry(entries, modelExportFileName);
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)modelEntry, (Object)modelExportFileName);
    }

    @Test
    public void testModelsInfo() throws Exception {
        CustomModelsInfo info = (CustomModelsInfo)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<CustomModelsInfo>(){

            public CustomModelsInfo execute() throws Exception {
                return customModelService.getCustomModelsInfo();
            }
        });
        String modelName = this.makeUniqueName("testCustomModelsInfo");
        Pair<String, String> namespacePair = this.getTestNamespacePrefixPair();
        M2Model model = M2Model.createModel((String)((String)namespacePair.getSecond() + ":" + modelName));
        model.createNamespace((String)namespacePair.getFirst(), (String)namespacePair.getSecond());
        model.setAuthor("Admin");
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        String typeName = "testType";
        M2Type m2Type = model.createType((String)namespacePair.getSecond() + ":" + typeName);
        m2Type.setTitle("Test type title");
        m2Type.setParentName("cm:content");
        String aspectName = "testMarkerAspect";
        model.createAspect((String)namespacePair.getSecond() + ":" + aspectName);
        this.createModel(model, true);
        CustomModelsInfo newInfo = (CustomModelsInfo)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<CustomModelsInfo>(){

            public CustomModelsInfo execute() throws Exception {
                return customModelService.getCustomModelsInfo();
            }
        });
        Assert.assertEquals((long)(info.getNumberOfActiveModels() + 1), (long)newInfo.getNumberOfActiveModels());
        Assert.assertEquals((long)(info.getNumberOfActiveTypes() + 1), (long)newInfo.getNumberOfActiveTypes());
        Assert.assertEquals((long)(info.getNumberOfActiveAspects() + 1), (long)newInfo.getNumberOfActiveAspects());
        String aspectNameTwo = "testMarkerAspectTwo";
        model.createAspect((String)namespacePair.getSecond() + ":" + aspectNameTwo);
        this.updateModel(modelName, model, true);
        newInfo = (CustomModelsInfo)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<CustomModelsInfo>(){

            public CustomModelsInfo execute() throws Exception {
                return customModelService.getCustomModelsInfo();
            }
        });
        Assert.assertEquals((long)(info.getNumberOfActiveModels() + 1), (long)newInfo.getNumberOfActiveModels());
        Assert.assertEquals((long)(info.getNumberOfActiveTypes() + 1), (long)newInfo.getNumberOfActiveTypes());
        Assert.assertEquals((long)(info.getNumberOfActiveAspects() + 2), (long)newInfo.getNumberOfActiveAspects());
    }

    private Pair<String, String> getTestNamespacePrefixPair() {
        long timeMillis = System.currentTimeMillis();
        String uri = "http://www.alfresco.org/model/testcmmservicenamespace" + timeMillis + "/1.0";
        String prefix = "testcmmservice" + timeMillis;
        return new Pair((Object)uri, (Object)prefix);
    }

    private String makeUniqueName(String modelName) {
        String name = modelName + System.currentTimeMillis();
        this.modelNames.add(name);
        return name;
    }

    private CustomModelDefinition createModel(final M2Model m2Model, final boolean activate) {
        return (CustomModelDefinition)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<CustomModelDefinition>(){

            public CustomModelDefinition execute() throws Exception {
                return customModelService.createCustomModel(m2Model, activate);
            }
        });
    }

    private CustomModelDefinition updateModel(final String modelName, final M2Model m2Model, final boolean activate) {
        return (CustomModelDefinition)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<CustomModelDefinition>(){

            public CustomModelDefinition execute() throws Exception {
                return customModelService.updateCustomModel(modelName, m2Model, activate);
            }
        });
    }

    private CustomModelDefinition getModel(final String modelName) {
        return (CustomModelDefinition)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<CustomModelDefinition>(){

            public CustomModelDefinition execute() throws Exception {
                return customModelService.getCustomModel(modelName);
            }
        });
    }

    private NodeRef createDownload(final String modelName, final boolean withShareExtModule) {
        return (NodeRef)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                NodeRef nodeRef = customModelService.createDownloadNode(modelName, withShareExtModule);
                return nodeRef;
            }
        });
    }

    private AspectDefinition getAspect(final QName aspectQName) {
        return (AspectDefinition)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<AspectDefinition>(){

            public AspectDefinition execute() throws Throwable {
                return customModelService.getCustomAspect(aspectQName);
            }
        });
    }

    private TypeDefinition getType(final QName typeQName) {
        return (TypeDefinition)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<TypeDefinition>(){

            public TypeDefinition execute() throws Throwable {
                return customModelService.getCustomType(typeQName);
            }
        });
    }
}

