/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import org.alfresco.repo.search.ResultSetRowIterator;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;

public abstract class AbstractResultSetRowIterator
implements ResultSetRowIterator {
    private ResultSet resultSet;
    private int position = -1;
    private int max;

    public AbstractResultSetRowIterator(ResultSet resultSet) {
        this.resultSet = resultSet;
        this.max = resultSet.length();
    }

    @Override
    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public boolean hasNext() {
        return this.position < this.max - 1;
    }

    @Override
    public boolean allowsReverse() {
        return true;
    }

    @Override
    public boolean hasPrevious() {
        return this.position > 0;
    }

    @Override
    public abstract ResultSetRow next();

    protected int moveToNextPosition() {
        return ++this.position;
    }

    @Override
    public abstract ResultSetRow previous();

    protected int moveToPreviousPosition() {
        return --this.position;
    }

    @Override
    public int nextIndex() {
        return this.position + 1;
    }

    @Override
    public int previousIndex() {
        return this.position - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(ResultSetRow o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(ResultSetRow o) {
        throw new UnsupportedOperationException();
    }
}

