/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracterTest;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.RFC822MetadataExtracter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class RFC822MetadataExtracterTest
extends AbstractMetadataExtracterTest {
    private RFC822MetadataExtracter extracter;
    private RFC822MetadataExtracter rmExtracter;
    @Mock
    private NodeService mockNodeService;
    private NodeRef nodeRefWithDodRecord = new NodeRef("workspace://spacesStore/test-dod");
    private NodeRef nodeRefWithRecord = new NodeRef("workspace://spacesStore/test-rm");
    private NodeRef nodeRefWithBoth = new NodeRef("workspace://spacesStore/test-both");
    private NodeRef nodeRefWithNeither = new NodeRef("workspace://spacesStore/test-neither");
    private static final QName MESSAGE_FROM_TEST_PROPERTY = QName.createQName((String)"MessageToTest");
    private static final QName MESSAGE_TO_TEST_PROPERTY = QName.createQName((String)"MessageFromTest");
    private static final QName MESSAGE_CC_TEST_PROPERTY = QName.createQName((String)"MessageCCTest");

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.extracter = (RFC822MetadataExtracter)this.ctx.getBean("extracter.RFC822");
        MockitoAnnotations.initMocks((Object)((Object)this));
        Mockito.when((Object)this.mockNodeService.hasAspect(this.nodeRefWithDodRecord, RFC822MetadataExtracter.ASPECT_DOD_5015_RECORD)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNodeService.hasAspect(this.nodeRefWithRecord, RFC822MetadataExtracter.ASPECT_RECORD)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNodeService.hasAspect(this.nodeRefWithBoth, RFC822MetadataExtracter.ASPECT_DOD_5015_RECORD)).thenReturn((Object)true);
        Mockito.when((Object)this.mockNodeService.hasAspect(this.nodeRefWithBoth, RFC822MetadataExtracter.ASPECT_RECORD)).thenReturn((Object)true);
        this.rmExtracter = new RFC822MetadataExtracter(){

            protected Map<String, Set<QName>> getDefaultMapping() {
                return Collections.emptyMap();
            }
        };
        this.rmExtracter.setNodeService(this.mockNodeService);
        this.rmExtracter.init();
    }

    @Override
    protected MetadataExtracter getExtracter() {
        return this.extracter;
    }

    @Override
    protected void testFileSpecificMetadata(String mimetype, Map<QName, Serializable> properties) {
    }

    public void testMatch() {
        RFC822MetadataExtracterTest.assertFalse((String)"Normal class should never match", (boolean)this.extracter.match("message/rfc822"));
        RFC822MetadataExtracterTest.assertTrue((String)"RM class should match with correct type", (boolean)this.rmExtracter.match("message/rfc822"));
        RFC822MetadataExtracterTest.assertFalse((String)"RM class should not match with other types", (boolean)this.rmExtracter.match("application/pdf"));
    }

    public void testGetExtractMapping() {
        Properties properties = new Properties();
        properties.put("namespace.prefix.rm", RFC822MetadataExtracter.RM_URI);
        properties.put("namespace.prefix.dod", RFC822MetadataExtracter.DOD_URI);
        properties.put("namespace.prefix.cm", "http://www.alfresco.org/model/content/1.0");
        properties.put("a", "cm:a");
        properties.put("b", "rm:b, dod:b");
        properties.put("c", "rm:c");
        properties.put("d", "cm:d, rm:d1, rm:d2");
        this.rmExtracter.setMappingProperties(properties);
        RFC822MetadataExtracterTest.assertEquals((String)"No properties should have been removed", (int)7, (int)this.countSystemProperties(this.nodeRefWithBoth));
        RFC822MetadataExtracterTest.assertEquals((String)"The 1 dod and 4 record properties should have been removed", (int)2, (int)this.countSystemProperties(this.nodeRefWithNeither));
        RFC822MetadataExtracterTest.assertEquals((String)"The 4 record properties should have been removed", (int)3, (int)this.countSystemProperties(this.nodeRefWithDodRecord));
        RFC822MetadataExtracterTest.assertEquals((String)"The 1 dod property should have been removed", (int)6, (int)this.countSystemProperties(this.nodeRefWithRecord));
        RFC822MetadataExtracterTest.assertEquals((String)"{http://www.alfresco.org/model/content/1.0}d, {http://www.alfresco.org/model/content/1.0}a, {http://www.alfresco.org/model/dod5015/1.0}b", (String)this.getSystemProperties(this.nodeRefWithDodRecord));
    }

    private int countSystemProperties(NodeRef nodeRef) {
        Map extractMapping = this.rmExtracter.getExtractMapping(nodeRef);
        AtomicInteger count = new AtomicInteger();
        extractMapping.forEach((k, v) -> {
            int n = count.addAndGet(v.size());
        });
        return count.get();
    }

    private String getSystemProperties(NodeRef nodeRef) {
        Map extractMapping = this.rmExtracter.getExtractMapping(nodeRef);
        StringJoiner sj = new StringJoiner(", ");
        extractMapping.forEach((k, v) -> v.forEach(p -> {
            StringJoiner stringJoiner2 = sj.add(p.toString());
        }));
        return sj.toString();
    }
}

