/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.config;

import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.config.RepositoryPathConfigBean;

public class RepositoryFolderConfigBean
extends RepositoryPathConfigBean {
    private String folderPath = "";

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Folder Path: ").append(super.getStoreRef()).append(super.getRootPath()).append("/").append(this.folderPath);
        return sb.toString();
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public void setFolderPath(String folderPath) {
        if (!PropertyCheck.isValidPropertyString((String)folderPath)) {
            throw new IllegalArgumentException("Invalid folder name path for property 'folderPath': " + folderPath);
        }
        StringTokenizer tokenizer = new StringTokenizer(folderPath, "/");
        StringBuilder pathBuff = new StringBuilder(folderPath.length());
        while (tokenizer.hasMoreTokens()) {
            String folderName = tokenizer.nextToken();
            if (folderName.length() == 0) {
                throw new IllegalArgumentException("Invalid folder name path for property 'folderPath': " + folderPath);
            }
            pathBuff.append(folderName);
            if (!tokenizer.hasMoreTokens()) continue;
            pathBuff.append('/');
        }
        this.folderPath = pathBuff.toString();
    }

    public NodeRef getFolderPath(NamespaceService namespaceService, NodeService nodeService, SearchService searchService, FileFolderService fileFolderService) {
        return this.getFolderPathImpl(namespaceService, nodeService, searchService, fileFolderService, true);
    }

    public NodeRef getFolderPathOrNull(NamespaceService namespaceService, NodeService nodeService, SearchService searchService, FileFolderService fileFolderService) {
        return this.getFolderPathImpl(namespaceService, nodeService, searchService, fileFolderService, false);
    }

    private NodeRef getFolderPathImpl(NamespaceService namespaceService, NodeService nodeService, SearchService searchService, FileFolderService fileFolderService, boolean throwException) {
        NodeRef pathStartNodeRef = super.resolveNodePath(namespaceService, nodeService, searchService);
        if (pathStartNodeRef == null) {
            return this.getNullOrThrowAlfrescoRuntimeExcpetion("Folder path resolution requires an existing base path. \n   Base path: " + this.getRootPath(), throwException);
        }
        if (this.folderPath.length() == 0) {
            return pathStartNodeRef;
        }
        List nodeRefs = searchService.selectNodes(pathStartNodeRef, this.folderPath, null, (NamespacePrefixResolver)namespaceService, true);
        if (nodeRefs.size() == 0) {
            return this.getNullOrThrowAlfrescoRuntimeExcpetion("Folder not found: " + String.valueOf(this), throwException);
        }
        NodeRef nodeRef = (NodeRef)nodeRefs.get(0);
        FileInfo folderInfo = fileFolderService.getFileInfo(nodeRef);
        if (!folderInfo.isFolder()) {
            return this.getNullOrThrowAlfrescoRuntimeExcpetion("Not a folder: " + String.valueOf(this), throwException);
        }
        return nodeRef;
    }

    private NodeRef getNullOrThrowAlfrescoRuntimeExcpetion(String exceptionMessage, boolean throwException) {
        if (throwException) {
            throw new AlfrescoRuntimeException(exceptionMessage);
        }
        return null;
    }

    public NodeRef getOrCreateFolderPath(NamespaceService namespaceService, NodeService nodeService, SearchService searchService, FileFolderService fileFolderService) {
        NodeRef pathStartNodeRef = super.resolveNodePath(namespaceService, nodeService, searchService);
        if (pathStartNodeRef == null) {
            throw new AlfrescoRuntimeException("Folder path resolution requires an existing base path. \n   Base path: " + this.getRootPath());
        }
        if (this.folderPath.length() == 0) {
            return pathStartNodeRef;
        }
        StringTokenizer folders = new StringTokenizer(this.folderPath, "/");
        NodeRef nodeRef = pathStartNodeRef;
        while (folders.hasMoreTokens()) {
            QName folderQName = QName.createQName((String)folders.nextToken(), (NamespacePrefixResolver)namespaceService);
            List children = nodeService.getChildAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)folderQName);
            nodeRef = children.isEmpty() ? fileFolderService.create(nodeRef, folderQName.getLocalName(), ContentModel.TYPE_FOLDER, folderQName).getNodeRef() : ((ChildAssociationRef)children.get(0)).getChildRef();
        }
        return nodeRef;
    }
}

