/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.icegreen.greenmail.store.SimpleStoredMessage;
import jakarta.mail.Flags;
import jakarta.transaction.UserTransaction;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.imap.AlfrescoImapFolder;
import org.alfresco.repo.imap.AlfrescoImapUser;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.imap.ImapServiceImpl;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.view.ImportPackageHandler;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.config.RepositoryFolderConfigBean;
import org.alfresco.util.testing.category.PerformanceTests;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;

@Category(value={PerformanceTests.class})
public class LoadTester
extends TestCase {
    private Log logger = LogFactory.getLog(LoadTester.class);
    private static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private ImapService imapService;
    private ImporterService importerService;
    private MutableAuthenticationService authenticationService;
    private AlfrescoImapUser user;
    private static final String USER_NAME = "admin";
    private static final String USER_PASSWORD = "admin";
    private static final String TEST_IMAP_ROOT_FOLDER_NAME = "aaa";
    private static final String TEST_DATA_FOLDER_NAME = "test_data";
    private static final String TEST_FOLDER_NAME = "test_imap1000";
    private static final long MESSAGE_QUANTITY = 1000L;
    private String anotherUserName;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.authenticationService = serviceRegistry.getAuthenticationService();
        this.imapService = serviceRegistry.getImapService();
        this.importerService = serviceRegistry.getImporterService();
        NodeService nodeService = serviceRegistry.getNodeService();
        SearchService searchService = serviceRegistry.getSearchService();
        NamespaceService namespaceService = serviceRegistry.getNamespaceService();
        PersonService personService = serviceRegistry.getPersonService();
        FileFolderService fileFolderService = serviceRegistry.getFileFolderService();
        TransactionService transactionService = serviceRegistry.getTransactionService();
        PermissionService permissionService = serviceRegistry.getPermissionService();
        UserTransaction txn = transactionService.getUserTransaction();
        txn.begin();
        this.authenticationService.authenticate("admin", "admin".toCharArray());
        this.anotherUserName = "test_imap_user";
        NodeRef person = personService.getPerson(this.anotherUserName);
        if (person != null) {
            personService.deletePerson(this.anotherUserName);
            PropertyMap testUser = new PropertyMap();
            testUser.put((Object)ContentModel.PROP_USERNAME, (Object)this.anotherUserName);
            testUser.put((Object)ContentModel.PROP_FIRSTNAME, (Object)this.anotherUserName);
            testUser.put((Object)ContentModel.PROP_LASTNAME, (Object)this.anotherUserName);
            testUser.put((Object)ContentModel.PROP_EMAIL, (Object)(this.anotherUserName + "@alfresco.com"));
            testUser.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            personService.createPerson((Map)testUser);
        }
        if (this.authenticationService.authenticationExists(this.anotherUserName)) {
            this.authenticationService.deleteAuthentication(this.anotherUserName);
        }
        this.authenticationService.createAuthentication(this.anotherUserName, this.anotherUserName.toCharArray());
        this.user = new AlfrescoImapUser(this.anotherUserName + "@alfresco.com", this.anotherUserName, this.anotherUserName);
        String storePath = "workspace://SpacesStore";
        String companyHomePathInStore = "/app:company_home";
        StoreRef storeRef = new StoreRef(storePath);
        NodeRef storeRootNodeRef = nodeService.getRootNode(storeRef);
        List nodeRefs = searchService.selectNodes(storeRootNodeRef, companyHomePathInStore, null, (NamespacePrefixResolver)namespaceService, false);
        NodeRef companyHomeNodeRef = (NodeRef)nodeRefs.get(0);
        ChildApplicationContextFactory imap = (ChildApplicationContextFactory)ctx.getBean("imap");
        ApplicationContext imapCtx = imap.getApplicationContext();
        ImapServiceImpl imapServiceImpl = (ImapServiceImpl)imapCtx.getBean("imapService");
        nodeRefs = searchService.selectNodes(storeRootNodeRef, companyHomePathInStore + "/cm:aaa", null, (NamespacePrefixResolver)namespaceService, false);
        if (nodeRefs.size() == 1) {
            NodeRef ch = (NodeRef)nodeRefs.get(0);
            nodeService.deleteNode(ch);
        }
        LinkedList<String> folders = new LinkedList<String>();
        folders.add(TEST_IMAP_ROOT_FOLDER_NAME);
        FileFolderServiceImpl.makeFolders((FileFolderService)fileFolderService, (NodeRef)companyHomeNodeRef, folders, (QName)ContentModel.TYPE_FOLDER);
        RepositoryFolderConfigBean imapHome = new RepositoryFolderConfigBean();
        imapHome.setStore(storePath);
        imapHome.setRootPath(companyHomePathInStore);
        imapHome.setFolderPath(TEST_IMAP_ROOT_FOLDER_NAME);
        imapServiceImpl.setImapHome(imapHome);
        imapServiceImpl.startupInTxn(true);
        nodeRefs = searchService.selectNodes(storeRootNodeRef, companyHomePathInStore + "/cm:aaa", null, (NamespacePrefixResolver)namespaceService, false);
        NodeRef userFolderRef = this.imapService.getUserImapHomeRef(this.anotherUserName);
        permissionService.setPermission(userFolderRef, this.anotherUserName, "All", true);
        this.importTestData("imap/load_test_data.acp", userFolderRef);
        this.reauthenticate(this.anotherUserName, this.anotherUserName);
        AlfrescoImapFolder testDataFolder = this.imapService.getOrCreateMailbox(this.user, TEST_DATA_FOLDER_NAME, true, false);
        SimpleStoredMessage m = (SimpleStoredMessage)testDataFolder.getMessages().get(0);
        m = testDataFolder.getMessage(m.getUid());
        AlfrescoImapFolder folder = this.imapService.getOrCreateMailbox(this.user, TEST_FOLDER_NAME, false, true);
        this.logger.info((Object)"Creating folders...");
        long t = System.currentTimeMillis();
        try {
            int i = 0;
            while ((long)i < 1000L) {
                System.out.println("i = " + i);
                folder.appendMessage(m.getMimeMessage(), new Flags(), new Date());
                ++i;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
        }
        t = System.currentTimeMillis() - t;
        this.logger.info((Object)("Create time: " + t + " ms (" + t / 1000L + " s (" + t / 60000L + " min))"));
        txn.commit();
    }

    private void reauthenticate(String name, String password) {
        this.authenticationService.invalidateTicket(this.authenticationService.getCurrentTicket());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.authenticate(name, password.toCharArray());
    }

    public void tearDown() throws Exception {
    }

    public void testList() {
        this.logger.info((Object)"Listing folders...");
        long t = System.currentTimeMillis();
        List list = this.imapService.listMailboxes(this.user, "test_imap1000*", false);
        t = System.currentTimeMillis() - t;
        this.logger.info((Object)("List time: " + t + " ms (" + t / 1000L + " s)"));
        this.logger.info((Object)("List size: " + list.size()));
    }

    private void importTestData(String acpName, NodeRef space) throws IOException {
        ClassPathResource acpResource = new ClassPathResource(acpName);
        ACPImportPackageHandler acpHandler = new ACPImportPackageHandler(acpResource.getFile(), null);
        Location importLocation = new Location(space);
        this.importerService.importView((ImportPackageHandler)acpHandler, importLocation, null, null);
    }
}

