/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.alfresco.repo.transfer.HttpClientTransmitterImpl;
import org.alfresco.repo.transfer.HttpMethodFactory;
import org.alfresco.repo.transfer.Transfer;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.TransferTargetImpl;
import org.alfresco.repo.transfer.TransferVersionImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.service.cmr.transfer.TransferVersion;
import org.alfresco.util.json.ExceptionJsonSerializer;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.json.JSONObject;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class HttpClientTransmitterImplTest
extends TestCase {
    private static final String TARGET_HOST = "my.testhost.com";
    private static final String HTTP_PROTOCOL = "HTTP";
    private static final String HTTPS_PROTOCOL = "HTTPS";
    private static final String TRANSFER_SERVICE_PATH = "/api/transfer";
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;
    private static final String TARGET_USERNAME = "transferuser";
    private static final char[] TARGET_PASSWORD = "password".toCharArray();
    private HttpClientTransmitterImpl transmitter;
    private HttpClient mockedHttpClient;
    private TransferTargetImpl target;
    private MockableHttpMethodFactory mockedHttpMethodFactory;
    private NodeService mockedNodeService;

    protected void setUp() throws Exception {
        super.setUp();
        this.transmitter = new HttpClientTransmitterImpl();
        this.mockedHttpClient = (HttpClient)Mockito.mock(HttpClient.class);
        this.mockedHttpMethodFactory = new MockableHttpMethodFactory();
        this.transmitter.setHttpClient(this.mockedHttpClient);
        this.transmitter.setHttpMethodFactory((HttpMethodFactory)this.mockedHttpMethodFactory);
        this.mockedNodeService = (NodeService)Mockito.mock(NodeService.class);
        Mockito.when((Object)this.mockedNodeService.getType((NodeRef)ArgumentMatchers.any(NodeRef.class))).thenReturn((Object)TransferModel.TYPE_TRANSFER_TARGET);
        this.transmitter.setNodeService(this.mockedNodeService);
        this.target = new TransferTargetImpl();
        this.target.setEndpointHost(TARGET_HOST);
        this.target.setEndpointProtocol(HTTP_PROTOCOL);
        this.target.setEndpointPath(TRANSFER_SERVICE_PATH);
        this.target.setEndpointPort(80);
        this.target.setUsername(TARGET_USERNAME);
        this.target.setPassword(TARGET_PASSWORD);
    }

    public void testSuccessfulVerifyTargetOverHttp() throws Exception {
        Mockito.when((Object)this.mockedHttpClient.executeMethod((HostConfiguration)ArgumentMatchers.any(HostConfiguration.class), (HttpMethod)ArgumentMatchers.any(HttpMethod.class), (HttpState)ArgumentMatchers.any(HttpState.class))).thenReturn((Object)200);
        this.transmitter.verifyTarget((TransferTarget)this.target);
        ArgumentCaptor hostConfig = ArgumentCaptor.forClass(HostConfiguration.class);
        ArgumentCaptor httpMethod = ArgumentCaptor.forClass(HttpMethod.class);
        ArgumentCaptor httpState = ArgumentCaptor.forClass(HttpState.class);
        ((HttpClient)Mockito.verify((Object)this.mockedHttpClient)).executeMethod((HostConfiguration)hostConfig.capture(), (HttpMethod)httpMethod.capture(), (HttpState)httpState.capture());
        HttpClientTransmitterImplTest.assertTrue((String)"post method", (boolean)(httpMethod.getValue() instanceof PostMethod));
        HttpClientTransmitterImplTest.assertEquals((String)"host name", (String)TARGET_HOST, (String)((HostConfiguration)hostConfig.getValue()).getHost());
        HttpClientTransmitterImplTest.assertEquals((String)"port", (int)80, (int)((HostConfiguration)hostConfig.getValue()).getPort());
        HttpClientTransmitterImplTest.assertEquals((String)"protocol", (String)HTTP_PROTOCOL.toLowerCase(), (String)((HostConfiguration)hostConfig.getValue()).getProtocol().getScheme().toLowerCase());
        HttpClientTransmitterImplTest.assertEquals((String)"path", (String)"/api/transfer/test", (String)((HttpMethod)httpMethod.getValue()).getPath());
    }

    public void testSuccessfulVerifyTargetOverHttps() throws Exception {
        Mockito.when((Object)this.mockedHttpClient.executeMethod((HostConfiguration)ArgumentMatchers.any(HostConfiguration.class), (HttpMethod)ArgumentMatchers.any(HttpMethod.class), (HttpState)ArgumentMatchers.any(HttpState.class))).thenReturn((Object)200);
        this.target.setEndpointProtocol(HTTPS_PROTOCOL);
        this.target.setEndpointPort(443);
        this.transmitter.verifyTarget((TransferTarget)this.target);
        ArgumentCaptor hostConfig = ArgumentCaptor.forClass(HostConfiguration.class);
        ArgumentCaptor httpMethod = ArgumentCaptor.forClass(HttpMethod.class);
        ArgumentCaptor httpState = ArgumentCaptor.forClass(HttpState.class);
        ((HttpClient)Mockito.verify((Object)this.mockedHttpClient)).executeMethod((HostConfiguration)hostConfig.capture(), (HttpMethod)httpMethod.capture(), (HttpState)httpState.capture());
        HttpClientTransmitterImplTest.assertEquals((String)"port", (int)443, (int)((HostConfiguration)hostConfig.getValue()).getPort());
        HttpClientTransmitterImplTest.assertTrue((String)"socket factory", (boolean)(((HostConfiguration)hostConfig.getValue()).getProtocol().getSocketFactory() instanceof SecureProtocolSocketFactory));
        HttpClientTransmitterImplTest.assertEquals((String)"protocol", (String)HTTPS_PROTOCOL.toLowerCase(), (String)((HostConfiguration)hostConfig.getValue()).getProtocol().getScheme().toLowerCase());
    }

    public void testHttpsVerifyTargetWithCustomSocketFactory() throws Exception {
        CustomSocketFactory socketFactory = new CustomSocketFactory();
        this.transmitter.setHttpsSocketFactory((ProtocolSocketFactory)socketFactory);
        this.target.setEndpointProtocol(HTTPS_PROTOCOL);
        this.target.setEndpointPort(443);
        Mockito.when((Object)this.mockedHttpClient.executeMethod((HostConfiguration)ArgumentMatchers.any(HostConfiguration.class), (HttpMethod)ArgumentMatchers.any(HttpMethod.class), (HttpState)ArgumentMatchers.any(HttpState.class))).thenReturn((Object)200);
        this.transmitter.verifyTarget((TransferTarget)this.target);
        ArgumentCaptor hostConfig = ArgumentCaptor.forClass(HostConfiguration.class);
        ArgumentCaptor httpMethod = ArgumentCaptor.forClass(HttpMethod.class);
        ArgumentCaptor httpState = ArgumentCaptor.forClass(HttpState.class);
        ((HttpClient)Mockito.verify((Object)this.mockedHttpClient)).executeMethod((HostConfiguration)hostConfig.capture(), (HttpMethod)httpMethod.capture(), (HttpState)httpState.capture());
        HttpClientTransmitterImplTest.assertEquals((String)"port", (int)443, (int)((HostConfiguration)hostConfig.getValue()).getPort());
        HttpClientTransmitterImplTest.assertTrue((String)"socket factory", (((HostConfiguration)hostConfig.getValue()).getProtocol().getSocketFactory() == socketFactory ? 1 : 0) != 0);
        HttpClientTransmitterImplTest.assertEquals((String)"protocol", (String)HTTPS_PROTOCOL.toLowerCase(), (String)((HostConfiguration)hostConfig.getValue()).getProtocol().getScheme().toLowerCase());
    }

    public void testVerifyTargetWithInvalidProtocol() throws Exception {
        this.target.setEndpointProtocol("invalidprotocol");
        try {
            this.transmitter.verifyTarget((TransferTarget)this.target);
            HttpClientTransmitterImplTest.fail((String)"invalid protocol");
        }
        catch (TransferException transferException) {}
    }

    public void testUnauthorisedVerifyTarget() throws Exception {
        Mockito.when((Object)this.mockedHttpClient.executeMethod((HostConfiguration)ArgumentMatchers.any(HostConfiguration.class), (HttpMethod)ArgumentMatchers.any(HttpMethod.class), (HttpState)ArgumentMatchers.any(HttpState.class))).thenReturn((Object)401);
        try {
            this.transmitter.verifyTarget((TransferTarget)this.target);
        }
        catch (TransferException transferException) {}
    }

    public void testGetStatusErrorRehydration() throws Exception {
        final ExceptionJsonSerializer errorSerializer = new ExceptionJsonSerializer();
        final TransferException expectedException = new TransferException("my message id", new Object[]{"param1", "param2"});
        Mockito.when((Object)this.mockedHttpClient.executeMethod((HostConfiguration)ArgumentMatchers.any(HostConfiguration.class), (HttpMethod)ArgumentMatchers.any(HttpMethod.class), (HttpState)ArgumentMatchers.any(HttpState.class))).thenReturn((Object)200);
        ((PostMethod)Mockito.doAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                JSONObject progressObject = new JSONObject();
                progressObject.put("transferId", (Object)"mytransferid");
                progressObject.put("status", (Object)TransferProgress.Status.ERROR);
                progressObject.put("currentPosition", 1);
                progressObject.put("endPosition", 10);
                JSONObject errorObject = errorSerializer.serialize((Throwable)expectedException);
                progressObject.put("error", (Object)errorObject);
                return progressObject.toString();
            }
        }).when((Object)this.mockedHttpMethodFactory.latestPostMethod)).getResponseBodyAsString();
        Transfer transfer = new Transfer();
        transfer.setTransferId("mytransferid");
        transfer.setTransferTarget((TransferTarget)this.target);
        TransferProgress progress = this.transmitter.getStatus(transfer);
        HttpClientTransmitterImplTest.assertTrue((progress.getError() != null ? 1 : 0) != 0);
        HttpClientTransmitterImplTest.assertEquals(((Object)((Object)expectedException)).getClass(), progress.getError().getClass());
        TransferException receivedException = (TransferException)progress.getError();
        HttpClientTransmitterImplTest.assertEquals((String)expectedException.getMsgId(), (String)receivedException.getMsgId());
        HttpClientTransmitterImplTest.assertTrue((boolean)Arrays.deepEquals(expectedException.getMsgParams(), receivedException.getMsgParams()));
    }

    public void testBeginFailure() throws Exception {
        final ExceptionJsonSerializer errorSerializer = new ExceptionJsonSerializer();
        final TransferException expectedException = new TransferException("my message id", new Object[]{"param1", "param2"});
        Mockito.when((Object)this.mockedHttpClient.executeMethod((HostConfiguration)ArgumentMatchers.any(HostConfiguration.class), (HttpMethod)ArgumentMatchers.any(HttpMethod.class), (HttpState)ArgumentMatchers.any(HttpState.class))).thenReturn((Object)500);
        ((PostMethod)Mockito.doAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                JSONObject errorObject = errorSerializer.serialize((Throwable)expectedException);
                return errorObject.toString();
            }
        }).when((Object)this.mockedHttpMethodFactory.latestPostMethod)).getResponseBodyAsString();
        try {
            this.transmitter.begin((TransferTarget)this.target, "1234", (TransferVersion)new TransferVersionImpl("2", "2", "2", "Dummy"));
            HttpClientTransmitterImplTest.fail();
        }
        catch (TransferException ex) {
            HttpClientTransmitterImplTest.assertEquals(((Object)((Object)expectedException)).getClass(), ((Object)((Object)ex)).getClass());
            HttpClientTransmitterImplTest.assertEquals((String)expectedException.getMsgId(), (String)ex.getMsgId());
            HttpClientTransmitterImplTest.assertTrue((boolean)Arrays.deepEquals(expectedException.getMsgParams(), ex.getMsgParams()));
        }
    }

    private static class CustomSocketFactory
    implements SecureProtocolSocketFactory {
        private CustomSocketFactory() {
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return null;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return null;
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
            return null;
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
            return null;
        }
    }

    private static class MockableHttpMethodFactory
    implements HttpMethodFactory {
        private PostMethod latestPostMethod;

        public MockableHttpMethodFactory() {
            this.reset();
        }

        public PostMethod createPostMethod() {
            return this.latestPostMethod;
        }

        public void reset() {
            this.latestPostMethod = (PostMethod)Mockito.spy((Object)new PostMethod());
        }
    }
}

