/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.RemoveFeaturesActionExecuter;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
public class RemoveFeaturesActionExecuterTest
extends BaseSpringTest {
    private NodeService nodeService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private RemoveFeaturesActionExecuter executer;
    private static final String ID = GUID.generate();

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setCurrentUser(authenticationComponent.getSystemUserName());
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_CLASSIFIABLE, null);
        this.executer = (RemoveFeaturesActionExecuter)this.applicationContext.getBean("remove-features");
    }

    @Test
    public void testExecution() {
        RemoveFeaturesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_CLASSIFIABLE));
        ActionImpl action = new ActionImpl(null, ID, "remove-features", null);
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_CLASSIFIABLE);
        this.executer.execute((Action)action, this.nodeRef);
        RemoveFeaturesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_CLASSIFIABLE));
        ActionImpl action2 = new ActionImpl(null, ID, "remove-features", null);
        action2.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        this.executer.execute((Action)action2, this.nodeRef);
    }

    @Test
    public void testRemovingAspectPropertiesAfterExecution() {
        QName QNAME_PUBLISHER = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"publisher");
        QName QNAME_SUBJECT = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"subject");
        PropertyMap dublinCoreProperties = new PropertyMap(2);
        dublinCoreProperties.put((Object)QNAME_PUBLISHER, (Object)"publisher");
        dublinCoreProperties.put((Object)QNAME_SUBJECT, (Object)"subject");
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_DUBLINCORE, (Map)dublinCoreProperties);
        RemoveFeaturesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_DUBLINCORE));
        RemoveFeaturesActionExecuterTest.assertTrue((boolean)this.nodeService.getProperties(this.nodeRef).containsKey(QNAME_PUBLISHER));
        RemoveFeaturesActionExecuterTest.assertTrue((boolean)this.nodeService.getProperties(this.nodeRef).containsKey(QNAME_SUBJECT));
        ActionImpl action = new ActionImpl(null, ID, "remove-features", null);
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_DUBLINCORE);
        this.executer.execute((Action)action, this.nodeRef);
        RemoveFeaturesActionExecuterTest.assertFalse((boolean)this.nodeService.getProperties(this.nodeRef).containsKey(QNAME_PUBLISHER));
        RemoveFeaturesActionExecuterTest.assertFalse((boolean)this.nodeService.getProperties(this.nodeRef).containsKey(QNAME_SUBJECT));
    }

    @Test
    public void testRemovingNotAddedChildAspect() {
        QName QNAME_TITLE = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"title");
        PropertyMap titledProperties = new PropertyMap(1);
        titledProperties.put((Object)QNAME_TITLE, (Object)"title");
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_TITLED, (Map)titledProperties);
        ActionImpl action = new ActionImpl(null, ID, "remove-features", null);
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_DUBLINCORE);
        this.executer.execute((Action)action, this.nodeRef);
        RemoveFeaturesActionExecuterTest.assertTrue((boolean)this.nodeService.getProperties(this.nodeRef).containsKey(QNAME_TITLE));
    }
}

