/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.directurl.SystemWideDirectUrlConfig;
import org.alfresco.repo.version.BaseVersionStoreTest;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.transaction.annotation.Transactional;

@Category(value={OwnJVMTestsCategory.class})
@Transactional
public class ContentServiceImplTest
extends BaseVersionStoreTest {
    private static final Boolean ENABLED = Boolean.TRUE;
    private static final String UPDATED_CONTENT = "This content has been updated with a new value.";
    private static final QName QNAME = ContentModel.PROP_CONTENT;
    @InjectMocks
    private ContentService contentService;
    private ContentStore contentStore;
    @Mock
    private SystemWideDirectUrlConfig mockSystemWideDirectUrlConfig;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.contentStore = (ContentStore)ReflectionTestUtils.getField((Object)this.contentService, (String)"store");
    }

    @Test
    public void testGetReader() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version = this.createVersion(versionableNode, this.versionProperties);
        NodeRef versionNodeRef = version.getFrozenStateNodeRef();
        ContentReader contentReader = this.contentService.getReader(versionNodeRef, ContentModel.PROP_CONTENT);
        ContentServiceImplTest.assertNotNull((Object)contentReader);
        ContentServiceImplTest.assertEquals((String)"This is the versioned test content.", (String)contentReader.getContentString());
        ContentWriter contentWriter = this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
        ContentServiceImplTest.assertNotNull((Object)contentWriter);
        contentWriter.putContent(UPDATED_CONTENT);
        Version version2 = this.createVersion(versionableNode, this.versionProperties);
        NodeRef version2NodeRef = version2.getFrozenStateNodeRef();
        ContentReader contentReader2 = this.contentService.getReader(version2NodeRef, ContentModel.PROP_CONTENT);
        ContentServiceImplTest.assertNotNull((Object)contentReader2);
        ContentServiceImplTest.assertEquals((String)UPDATED_CONTENT, (String)contentReader2.getContentString());
    }

    @Test
    public void testGetWriter() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version = this.createVersion(versionableNode, this.versionProperties);
        try {
            ContentWriter contentWriter = this.contentService.getWriter(version.getFrozenStateNodeRef(), ContentModel.PROP_CONTENT, true);
            contentWriter.putContent("bobbins");
            ContentServiceImplTest.fail((String)"This operation is not supported.");
        }
        catch (Exception exception) {}
    }

    @Test
    public void testWhenRequestContentDirectUrlIsNotSupported() {
        MockitoAnnotations.openMocks((Object)((Object)this));
        Mockito.when((Object)this.mockSystemWideDirectUrlConfig.isEnabled()).thenReturn((Object)ENABLED);
        Mockito.when((Object)this.mockSystemWideDirectUrlConfig.getDefaultExpiryTimeInSec()).thenReturn((Object)30L);
        Mockito.when((Object)this.mockSystemWideDirectUrlConfig.getMaxExpiryTimeInSec()).thenReturn((Object)300L);
        ContentServiceImplTest.assertFalse((boolean)this.contentStore.isContentDirectUrlEnabled());
        Long validFor = 60L;
        Assert.assertThrows((String)"nodeRef has no content", IllegalArgumentException.class, () -> {
            NodeRef nodeRef = this.dbNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyNoContentNode"), BaseVersionStoreTest.TEST_TYPE_QNAME, (Map)this.nodeProperties).getChildRef();
            ContentServiceImplTest.assertNull((Object)this.contentService.requestContentDirectUrl(nodeRef, QNAME, true, validFor));
        });
        Assert.assertThrows((String)"nodeRef is null", IllegalArgumentException.class, () -> ContentServiceImplTest.assertNull((Object)this.contentService.requestContentDirectUrl(null, null, true, null)));
        Assert.assertThrows((String)"propertyQName has no content", NullPointerException.class, () -> {
            NodeRef nodeRef = this.dbNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyNoContentNode"), BaseVersionStoreTest.TEST_TYPE_QNAME, (Map)this.nodeProperties).getChildRef();
            this.contentService.requestContentDirectUrl(nodeRef, null, true, validFor);
        });
        NodeRef nodeRef = this.createNewVersionableNode();
        ContentServiceImplTest.assertNull((Object)this.contentService.requestContentDirectUrl(nodeRef, QNAME, true, null));
        ContentServiceImplTest.assertNull((Object)this.contentService.requestContentDirectUrl(nodeRef, QNAME, true, validFor));
    }
}

