/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.copy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.copy.AbstractCopyBehaviourCallback;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompoundCopyBehaviourCallback
extends AbstractCopyBehaviourCallback {
    private static Log logger = LogFactory.getLog(CompoundCopyBehaviourCallback.class);
    private QName classQName;
    private List<CopyBehaviourCallback> callbacks;

    public CompoundCopyBehaviourCallback(QName classQName) {
        this.classQName = classQName;
        this.callbacks = new ArrayList<CopyBehaviourCallback>(2);
    }

    public void addBehaviour(CopyBehaviourCallback callback) {
        this.callbacks.add(callback);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("\n").append("CompoundCopyBehaviourCallback: \n").append("      Model Class: ").append(this.classQName);
        boolean first = true;
        for (CopyBehaviourCallback callback : this.callbacks) {
            if (first) {
                first = false;
                sb.append("\n");
            }
            sb.append("      ").append(callback.getClass().getName());
        }
        return sb.toString();
    }

    @Override
    public Pair<CopyBehaviourCallback.AssocCopySourceAction, CopyBehaviourCallback.AssocCopyTargetAction> getAssociationCopyAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyAssociationDetails assocCopyDetails) {
        CopyBehaviourCallback.AssocCopySourceAction bestSourceAction = CopyBehaviourCallback.AssocCopySourceAction.COPY;
        CopyBehaviourCallback.AssocCopyTargetAction bestTargetAction = CopyBehaviourCallback.AssocCopyTargetAction.USE_ORIGINAL_TARGET;
        for (CopyBehaviourCallback callback : this.callbacks) {
            Pair<CopyBehaviourCallback.AssocCopySourceAction, CopyBehaviourCallback.AssocCopyTargetAction> action = callback.getAssociationCopyAction(classQName, copyDetails, assocCopyDetails);
            if (((CopyBehaviourCallback.AssocCopySourceAction)action.getFirst()).compareTo(bestSourceAction) > 0) {
                bestSourceAction = (CopyBehaviourCallback.AssocCopySourceAction)action.getFirst();
            }
            if (((CopyBehaviourCallback.AssocCopyTargetAction)action.getSecond()).compareTo(bestTargetAction) <= 0) continue;
            bestTargetAction = (CopyBehaviourCallback.AssocCopyTargetAction)action.getSecond();
        }
        Pair bestAction = new Pair((Object)bestSourceAction, (Object)bestTargetAction);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Association copy behaviour: " + String.valueOf(bestAction) + "\n   " + String.valueOf(assocCopyDetails) + "\n   " + String.valueOf(copyDetails) + "\n   " + String.valueOf(this)));
        }
        return bestAction;
    }

    @Override
    public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
        Object firstVeto = null;
        for (CopyBehaviourCallback callback : this.callbacks) {
            boolean mustCopyLocal = callback.getMustCopy(classQName, copyDetails);
            if (firstVeto == null && !mustCopyLocal) {
                firstVeto = callback;
            }
            if (!mustCopyLocal || firstVeto == null) continue;
            logger.warn((Object)("CopyBehaviourCallback '" + callback.getClass().getName() + "' is attempting to induce a copy when callback '" + firstVeto.getClass().getName() + "' has already vetoed it.  Copying of '" + String.valueOf(copyDetails.getSourceNodeRef()) + "' will not occur."));
        }
        if (firstVeto == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("All copy behaviours voted for a copy of node \n   " + String.valueOf(copyDetails) + "\n   " + String.valueOf(this)));
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Copy behaviour vetoed for node " + String.valueOf(copyDetails.getSourceNodeRef()) + "\n   First veto: " + firstVeto.getClass().getName() + "\n   " + String.valueOf(copyDetails) + "\n   " + String.valueOf(this)));
        }
        return false;
    }

    @Override
    public CopyBehaviourCallback.ChildAssocCopyAction getChildAssociationCopyAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyChildAssociationDetails childAssocCopyDetails) {
        CopyBehaviourCallback.ChildAssocCopyAction bestAction = CopyBehaviourCallback.ChildAssocCopyAction.IGNORE;
        for (CopyBehaviourCallback callback : this.callbacks) {
            CopyBehaviourCallback.ChildAssocCopyAction action = callback.getChildAssociationCopyAction(classQName, copyDetails, childAssocCopyDetails);
            if (action.compareTo(bestAction) <= 0) continue;
            bestAction = action;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Child association copy behaviour: " + String.valueOf(bestAction) + "\n   " + String.valueOf(childAssocCopyDetails) + "\n   " + String.valueOf(copyDetails) + "\n   " + String.valueOf(this)));
        }
        return bestAction;
    }

    @Override
    public CopyBehaviourCallback.ChildAssocRecurseAction getChildAssociationRecurseAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyChildAssociationDetails childAssocCopyDetails) {
        CopyBehaviourCallback.ChildAssocRecurseAction bestAction = CopyBehaviourCallback.ChildAssocRecurseAction.RESPECT_RECURSE_FLAG;
        for (CopyBehaviourCallback callback : this.callbacks) {
            CopyBehaviourCallback.ChildAssocRecurseAction action = callback.getChildAssociationRecurseAction(classQName, copyDetails, childAssocCopyDetails);
            if (action.compareTo(bestAction) <= 0) continue;
            bestAction = action;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Child association recursion behaviour: " + String.valueOf(bestAction) + "\n   " + String.valueOf(childAssocCopyDetails) + "\n   " + String.valueOf(copyDetails) + "\n   " + String.valueOf(this)));
        }
        return bestAction;
    }

    @Override
    public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
        HashMap<QName, Serializable> copyProperties = new HashMap<QName, Serializable>(properties);
        for (CopyBehaviourCallback callback : this.callbacks) {
            Map<QName, Serializable> propsToCopy = callback.getCopyProperties(classQName, copyDetails, copyProperties);
            if (propsToCopy == copyProperties) continue;
            copyProperties = new HashMap<QName, Serializable>(propsToCopy);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Copy properties: \n   " + String.valueOf(copyDetails) + "\n   " + String.valueOf(this) + "\n   Before: " + String.valueOf(properties) + "\n   After:  " + String.valueOf(copyProperties)));
        }
        return copyProperties;
    }
}

