/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.CheckOutActionExecuter;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class, NeverRunsTests.class})
@Transactional
public class CheckOutActionExecuterTest
extends BaseSpringTest {
    private NodeService nodeService;
    private CheckOutCheckInService checkOutCheckInService;
    private CheckOutActionExecuter executer;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRefContent;
    private NodeRef nodeRefFolder;
    private static final String ID = GUID.generate();

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.checkOutCheckInService = (CheckOutCheckInService)this.applicationContext.getBean("checkOutCheckInService");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setCurrentUser(authenticationComponent.getSystemUserName());
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.nodeRefContent = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}contenttestnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeRefFolder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}foldertestnode"), ContentModel.TYPE_FOLDER).getChildRef();
        this.executer = (CheckOutActionExecuter)this.applicationContext.getBean("check-out");
    }

    public void testExecution() {
        ActionImpl action = new ActionImpl(null, ID, "check-out", null);
        this.executer.execute((Action)action, this.nodeRefContent);
        this.executer.execute((Action)action, this.nodeRefFolder);
        CheckOutActionExecuterTest.assertNotNull((Object)this.checkOutCheckInService.getWorkingCopy(this.nodeRefContent));
        CheckOutActionExecuterTest.assertNull((Object)this.checkOutCheckInService.getWorkingCopy(this.nodeRefFolder));
    }
}

