/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.TransitionSimpleWorkflowActionExecuter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.Before;
import org.junit.experimental.categories.Category;

@Category(value={BaseSpringTestsCategory.class, NeverRunsTests.class})
public class TransitionSimpleWorkflowActionExecuterTest
extends BaseAlfrescoSpringTest {
    private FileFolderService fileFolderService;
    private NodeRef sourceFolder;
    private NodeRef destinationFolder;
    private NodeRef node;
    private TransitionSimpleWorkflowActionExecuter acceptExecuter;
    private TransitionSimpleWorkflowActionExecuter rejectExecuter;
    private static final String ID = GUID.generate();

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("fileFolderService");
        NodeRef container = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.sourceFolder = this.fileFolderService.create(container, "my source folder", ContentModel.TYPE_FOLDER).getNodeRef();
        this.destinationFolder = this.fileFolderService.create(container, "my destination folder", ContentModel.TYPE_FOLDER).getNodeRef();
        this.node = this.fileFolderService.create(this.sourceFolder, "my node.txt", ContentModel.TYPE_CONTENT).getNodeRef();
        this.acceptExecuter = (TransitionSimpleWorkflowActionExecuter)this.applicationContext.getBean("accept-simpleworkflow");
        this.rejectExecuter = (TransitionSimpleWorkflowActionExecuter)this.applicationContext.getBean("reject-simpleworkflow");
    }

    public void testExecutionApprove() {
        this.addWorkflowAspect(this.node, this.destinationFolder, Boolean.TRUE, Boolean.FALSE);
        TransitionSimpleWorkflowActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(this.node, ApplicationModel.ASPECT_SIMPLE_WORKFLOW));
        NodeRef pParent = this.nodeService.getPrimaryParent(this.node).getParentRef();
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((Object)this.sourceFolder, (Object)pParent);
        ActionImpl action = new ActionImpl(null, ID, "accept-simpleworkflow", null);
        this.acceptExecuter.execute((Action)action, this.node);
        TransitionSimpleWorkflowActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(this.node, ApplicationModel.ASPECT_SIMPLE_WORKFLOW));
        pParent = this.nodeService.getPrimaryParent(this.node).getParentRef();
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((Object)this.destinationFolder, (Object)pParent);
    }

    public void testExecutionReject() {
        this.addWorkflowAspect(this.node, this.destinationFolder, Boolean.TRUE, Boolean.FALSE);
        TransitionSimpleWorkflowActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(this.node, ApplicationModel.ASPECT_SIMPLE_WORKFLOW));
        NodeRef pParent = this.nodeService.getPrimaryParent(this.node).getParentRef();
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((Object)this.sourceFolder, (Object)pParent);
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(this.destinationFolder).size());
        ActionImpl action = new ActionImpl(null, ID, "reject-simpleworkflow", null);
        this.rejectExecuter.execute((Action)action, this.node);
        TransitionSimpleWorkflowActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(this.node, ApplicationModel.ASPECT_SIMPLE_WORKFLOW));
        pParent = this.nodeService.getPrimaryParent(this.node).getParentRef();
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((Object)this.sourceFolder, (Object)pParent);
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.destinationFolder).size());
    }

    public void testExecutionApproveWhenDestinationSameAsSource() {
        this.addWorkflowAspect(this.node, this.sourceFolder, Boolean.FALSE, Boolean.FALSE);
        TransitionSimpleWorkflowActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(this.node, ApplicationModel.ASPECT_SIMPLE_WORKFLOW));
        NodeRef pParent = this.nodeService.getPrimaryParent(this.node).getParentRef();
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((Object)this.sourceFolder, (Object)pParent);
        ActionImpl action = new ActionImpl(null, ID, "accept-simpleworkflow", null);
        this.acceptExecuter.execute((Action)action, this.node);
        String copyName = QName.createValidLocalName((String)"Copy of my node.txt");
        NodeRef nodeRef = this.nodeService.getChildByName(this.sourceFolder, ContentModel.ASSOC_CONTAINS, copyName);
        TransitionSimpleWorkflowActionExecuterTest.assertNotNull((Object)nodeRef);
    }

    public void testExecutionRejectWhenDestinationSameAsSource() {
        this.addWorkflowAspect(this.node, this.sourceFolder, Boolean.FALSE, Boolean.FALSE);
        TransitionSimpleWorkflowActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(this.node, ApplicationModel.ASPECT_SIMPLE_WORKFLOW));
        NodeRef pParent = this.nodeService.getPrimaryParent(this.node).getParentRef();
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((Object)this.sourceFolder, (Object)pParent);
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(this.destinationFolder).size());
        ActionImpl action = new ActionImpl(null, ID, "reject-simpleworkflow", null);
        this.rejectExecuter.execute((Action)action, this.node);
        TransitionSimpleWorkflowActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(this.node, ApplicationModel.ASPECT_SIMPLE_WORKFLOW));
        pParent = this.nodeService.getPrimaryParent(this.node).getParentRef();
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((Object)this.sourceFolder, (Object)pParent);
        TransitionSimpleWorkflowActionExecuterTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(this.destinationFolder).size());
        String copyName = QName.createValidLocalName((String)"Copy of my node.txt");
        NodeRef nodeRef = this.nodeService.getChildByName(this.sourceFolder, ContentModel.ASSOC_CONTAINS, copyName);
        TransitionSimpleWorkflowActionExecuterTest.assertNotNull((Object)nodeRef);
    }

    private void addWorkflowAspect(NodeRef node, NodeRef destinationFolder, Boolean moveOnApprove, Boolean moveOnReject) {
        Map<QName, Serializable> propertyValues = this.createWorkflowProperties(destinationFolder, moveOnApprove, moveOnReject);
        this.nodeService.addAspect(node, ApplicationModel.ASPECT_SIMPLE_WORKFLOW, propertyValues);
    }

    private Map<QName, Serializable> createWorkflowProperties(NodeRef destinationFolder, Boolean moveOnApprove, Boolean moveOnReject) {
        HashMap<QName, Serializable> propertyValues = new HashMap<QName, Serializable>();
        propertyValues.put(ApplicationModel.PROP_APPROVE_STEP, (Serializable)((Object)"Approve"));
        propertyValues.put(ApplicationModel.PROP_APPROVE_FOLDER, (Serializable)destinationFolder);
        propertyValues.put(ApplicationModel.PROP_APPROVE_MOVE, moveOnApprove);
        propertyValues.put(ApplicationModel.PROP_REJECT_STEP, (Serializable)((Object)"Reject"));
        propertyValues.put(ApplicationModel.PROP_REJECT_FOLDER, (Serializable)destinationFolder);
        propertyValues.put(ApplicationModel.PROP_REJECT_MOVE, moveOnReject);
        return propertyValues;
    }
}

