/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.bulkimport.BulkImportParameters;
import org.alfresco.repo.bulkimport.NodeImporter;
import org.alfresco.repo.bulkimport.impl.MultiThreadedBulkFilesystemImporter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={LuceneTests.class})
public abstract class AbstractBulkImportTests {
    protected static ApplicationContext ctx;
    protected FileFolderService fileFolderService;
    protected NodeService nodeService;
    protected TransactionService transactionService;
    protected ContentService contentService;
    protected UserTransaction txn = null;
    protected RuleService ruleService;
    protected ActionService actionService;
    protected VersionService versionService;
    protected MultiThreadedBulkFilesystemImporter bulkImporter;
    protected NodeRef rootNodeRef;
    protected FileInfo topLevelFolder;
    protected NodeRef top;

    protected static void startContext() {
        ctx = ApplicationContextHelper.getApplicationContext();
    }

    protected static void startContext(String[] configLocations) {
        ctx = ApplicationContextHelper.getApplicationContext((String[])configLocations);
    }

    protected static void stopContext() {
        ApplicationContextHelper.closeApplicationContext();
    }

    @Before
    public void setup() throws SystemException, NotSupportedException {
        try {
            this.nodeService = (NodeService)ctx.getBean("nodeService");
            this.fileFolderService = (FileFolderService)ctx.getBean("fileFolderService");
            this.transactionService = (TransactionService)ctx.getBean("transactionService");
            this.bulkImporter = (MultiThreadedBulkFilesystemImporter)ctx.getBean("bulkFilesystemImporter");
            this.contentService = (ContentService)ctx.getBean("contentService");
            this.actionService = (ActionService)ctx.getBean("actionService");
            this.ruleService = (RuleService)ctx.getBean("ruleService");
            this.versionService = (VersionService)ctx.getBean("versionService");
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
            String s = "BulkFilesystemImport" + System.currentTimeMillis();
            this.txn = this.transactionService.getUserTransaction();
            this.txn.begin();
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
            StoreRef storeRef = this.nodeService.createStore("workspace", s);
            this.rootNodeRef = this.nodeService.getRootNode(storeRef);
            this.top = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}top"), ContentModel.TYPE_FOLDER).getChildRef();
            this.topLevelFolder = this.fileFolderService.create(this.top, s, ContentModel.TYPE_FOLDER);
            this.txn.commit();
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void teardown() throws Exception {
        AuthenticationUtil.popAuthentication();
        if (this.txn != null) {
            this.txn.commit();
        }
    }

    protected List<FileInfo> getFolders(NodeRef parent, String pattern) {
        PagingResults page = this.fileFolderService.list(parent, false, true, pattern, null, null, new PagingRequest(Integer.MAX_VALUE));
        List folders = page.getPage();
        return folders;
    }

    protected void testCanVersionDocsWithoutSpecialInputFileNameExtension(Function<String, NodeImporter> importerFun) throws IOException, SystemException, NotSupportedException, HeuristicRollbackException, HeuristicMixedException, RollbackException {
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        NodeRef folderNode = this.topLevelFolder.getNodeRef();
        NodeImporter nodeImporter = importerFun.apply("pass1");
        BulkImportParameters bulkImportParameters = new BulkImportParameters();
        bulkImportParameters.setTarget(folderNode);
        bulkImportParameters.setExistingFileMode(BulkImportParameters.ExistingFileMode.ADD_VERSION);
        bulkImportParameters.setBatchSize(Integer.valueOf(1));
        ExpectedFile[] expectedFiles = new ExpectedFile[]{new ExpectedFile("example.txt", "text/plain", "This is an example file. This content is version 1.")};
        ExpectedFolder[] expectedFolders = new ExpectedFolder[]{};
        this.bulkImporter.bulkImport(bulkImportParameters, nodeImporter);
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        Assert.assertEquals((Object)false, (Object)this.bulkImporter.getStatus().inProgress());
        this.checkFiles(folderNode, null, expectedFiles, expectedFolders);
        Map<String, FileInfo> files = this.toMap(this.getFiles(folderNode, null));
        NodeRef fileNodeRef = files.get("example.txt").getNodeRef();
        Assert.assertFalse((String)"Imported file should not yet be versioned:", (boolean)this.versionService.isVersioned(fileNodeRef));
        nodeImporter = importerFun.apply("pass2");
        this.bulkImporter.bulkImport(bulkImportParameters, nodeImporter);
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        expectedFiles = new ExpectedFile[]{new ExpectedFile("example.txt", "text/plain", "This is an example file. This content is version 3.")};
        this.checkFiles(folderNode, null, expectedFiles, expectedFolders);
        nodeImporter = importerFun.apply("pass3");
        this.bulkImporter.bulkImport(bulkImportParameters, nodeImporter);
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        expectedFiles = new ExpectedFile[]{new ExpectedFile("example.txt", "text/plain", "This is an example file. This content is version 4.")};
        expectedFolders = new ExpectedFolder[]{new ExpectedFolder("banana")};
        this.checkFiles(folderNode, null, expectedFiles, expectedFolders);
        NodeRef subFolder = this.fileFolderService.searchSimple(folderNode, "banana");
        expectedFiles = new ExpectedFile[]{new ExpectedFile("file.txt", "text/plain", "Version 2")};
        expectedFolders = new ExpectedFolder[]{};
        this.checkFiles(subFolder, null, expectedFiles, expectedFolders);
        Assert.assertTrue((String)"Imported file should be versioned:", (boolean)this.versionService.isVersioned(fileNodeRef));
        VersionHistory history = this.versionService.getVersionHistory(fileNodeRef);
        Assert.assertNotNull((Object)history);
        Assert.assertEquals((String)"Incorrect number of versions.", (long)4L, (long)history.getAllVersions().size());
        Version[] versions = history.getAllVersions().toArray(new Version[4]);
        ContentReader contentReader = this.contentService.getReader(versions[0].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"4.0", (Object)versions[0].getVersionLabel());
        Assert.assertEquals((Object)"This is an example file. This content is version 4.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[1].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"3.0", (Object)versions[1].getVersionLabel());
        Assert.assertEquals((Object)"This is an example file. This content is version 3.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[2].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"2.0", (Object)versions[2].getVersionLabel());
        Assert.assertEquals((Object)"This is an example file. This content is version 2.", (Object)contentReader.getContentString());
        contentReader = this.contentService.getReader(versions[3].getFrozenStateNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)"1.0", (Object)versions[3].getVersionLabel());
        Assert.assertEquals((Object)"This is an example file. This content is version 1.", (Object)contentReader.getContentString());
    }

    protected List<FileInfo> getFiles(NodeRef parent, String pattern) {
        PagingResults page = this.fileFolderService.list(parent, true, false, pattern, null, null, new PagingRequest(Integer.MAX_VALUE));
        List files = page.getPage();
        return files;
    }

    protected Map<String, FileInfo> toMap(List<FileInfo> list) {
        HashMap<String, FileInfo> map = new HashMap<String, FileInfo>(list.size());
        for (FileInfo fileInfo : list) {
            map.put(fileInfo.getName(), fileInfo);
        }
        return map;
    }

    protected void checkFolder(NodeRef folderNode, String childFolderName, String pattern, int numExpectedFolders, int numExpectedFiles, ExpectedFolder[] expectedFolders, ExpectedFile[] expectedFiles) {
        List<FileInfo> folders = this.getFolders(folderNode, childFolderName);
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder1 = folders.get(0).getNodeRef();
        this.checkFiles(folder1, pattern, numExpectedFolders, numExpectedFiles, expectedFiles, expectedFolders);
    }

    protected void checkFiles(NodeRef parent, String pattern, ExpectedFile[] expectedFiles, ExpectedFolder[] expectedFolders) {
        int expectedFilesLength = expectedFiles != null ? expectedFiles.length : 0;
        int expectedFoldersLength = expectedFolders != null ? expectedFolders.length : 0;
        this.checkFiles(parent, pattern, expectedFoldersLength, expectedFilesLength, expectedFiles, expectedFolders);
    }

    protected void checkFiles(NodeRef parent, String pattern, int expectedNumFolders, int expectedNumFiles, ExpectedFile[] expectedFiles, ExpectedFolder[] expectedFolders) {
        FileInfo fileInfo;
        int n;
        int n2;
        Object[] objectArray;
        Map<String, FileInfo> folders = this.toMap(this.getFolders(parent, pattern));
        Map<String, FileInfo> files = this.toMap(this.getFiles(parent, pattern));
        Assert.assertEquals((String)"Incorrect number of folders", (long)expectedNumFolders, (long)folders.size());
        Assert.assertEquals((String)"Incorrect number of files", (long)expectedNumFiles, (long)files.size());
        if (expectedFiles != null) {
            objectArray = expectedFiles;
            n2 = expectedFiles.length;
            n = 0;
            while (n < n2) {
                Object expectedFile = objectArray[n];
                fileInfo = files.get(((ExpectedFile)expectedFile).getName());
                Assert.assertNotNull((String)("Couldn't find expected file: " + ((ExpectedFile)expectedFile).getName() + ", found: " + String.valueOf(files.keySet())), (Object)fileInfo);
                Assert.assertNotNull((String)("Content data unexpected null for " + ((ExpectedFile)expectedFile).getName()), (Object)fileInfo.getContentData());
                Assert.assertEquals((Object)((ExpectedFile)expectedFile).getMimeType(), (Object)fileInfo.getContentData().getMimetype());
                if (fileInfo.getContentData().getMimetype().equals("text/plain") && ((ExpectedFile)expectedFile).getContentContains() != null) {
                    ContentReader reader = this.contentService.getReader(fileInfo.getNodeRef(), ContentModel.PROP_CONTENT);
                    String contentContains = ((ExpectedFile)expectedFile).getContentContains();
                    String actualContent = reader.getContentString();
                    Assert.assertTrue((String)("Expected contents doesn't include text: " + contentContains + ", full text:\n" + actualContent), (boolean)actualContent.contains(contentContains));
                }
                ++n;
            }
        }
        if (expectedFolders != null) {
            objectArray = expectedFolders;
            n2 = expectedFolders.length;
            n = 0;
            while (n < n2) {
                Object expectedFolder = objectArray[n];
                fileInfo = folders.get(((ExpectedFolder)expectedFolder).getName());
                Assert.assertNotNull((String)"", (Object)fileInfo);
                ++n;
            }
        }
    }

    protected void checkContent(FileInfo file, String name, String mimeType) {
        Assert.assertEquals((String)"", (Object)name, (Object)file.getName());
        Assert.assertEquals((String)"", (Object)mimeType, (Object)file.getContentData().getMimetype());
    }

    protected static class ExpectedFile {
        private String name;
        private String mimeType;
        private String contentContains = null;

        public ExpectedFile(String name, String mimeType, String contentContains) {
            this(name, mimeType);
            this.contentContains = contentContains;
        }

        public ExpectedFile(String name, String mimeType) {
            this.name = name;
            this.mimeType = mimeType;
        }

        public String getName() {
            return this.name;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getContentContains() {
            return this.contentContains;
        }
    }

    protected static class ExpectedFolder {
        private String name;

        public ExpectedFolder(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

