/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.cleanup;

import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.cleanup.ContentStoreCleanerListener;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeletedContentBackupCleanerListener
implements ContentStoreCleanerListener {
    private static Log logger = LogFactory.getLog(DeletedContentBackupCleanerListener.class);
    private ContentStore store;

    public void setStore(ContentStore store) {
        this.store = store;
    }

    @Override
    public void beforeDelete(ContentStore sourceStore, String contentUrl) throws ContentIOException {
        if (this.store.isContentUrlSupported(contentUrl)) {
            ContentContext context = new ContentContext(null, contentUrl);
            ContentReader reader = sourceStore.getReader(contentUrl);
            if (!reader.exists()) {
                return;
            }
            ContentWriter writer = this.store.getWriter(context);
            writer.putContent(reader);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Moved content before deletion: \n   URL:    " + contentUrl + "\n   Source: " + String.valueOf(sourceStore) + "\n   Target: " + String.valueOf(this.store)));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Content cannot be moved during deletion.  A backup will not be made: \n   URL:    " + contentUrl + "\n   Source: " + String.valueOf(sourceStore) + "\n   Target: " + String.valueOf(this.store)));
        }
    }
}

