/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.client.config.ClientAppConfig;
import org.alfresco.repo.client.config.ClientAppNotFoundException;
import org.alfresco.repo.security.authentication.ResetPasswordService;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowModelResetPassword;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EmailHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.UrlUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

@Deprecated
public class ResetPasswordServiceImpl
implements ResetPasswordService {
    private static final Log LOGGER = LogFactory.getLog(ResetPasswordServiceImpl.class);
    private static final String TIMER_END = "PT1H";
    private static final String WORKFLOW_DESCRIPTION_KEY = "resetpasswordwf_resetpassword.resetpassword.workflow.description";
    private static final String FTL_TEMPLATE_ASSETS_URL = "template_assets_url";
    private static final String FTL_RESET_PASSWORD_URL = "reset_password_url";
    private static final String FTL_USER_NAME = "userName";
    private WorkflowService workflowService;
    private HistoryService activitiHistoryService;
    private ActionService actionService;
    private PersonService personService;
    private NodeService nodeService;
    private SysAdminParams sysAdminParams;
    private MutableAuthenticationService authenticationService;
    private TaskService activitiTaskService;
    private EmailHelper emailHelper;
    private ClientAppConfig clientAppConfig;
    private String timerEnd = "PT1H";
    private String defaultEmailSender;
    private boolean sendEmailAsynchronously = true;

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setActivitiHistoryService(HistoryService activitiHistoryService) {
        this.activitiHistoryService = activitiHistoryService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setActivitiTaskService(TaskService activitiTaskService) {
        this.activitiTaskService = activitiTaskService;
    }

    public void setEmailHelper(EmailHelper emailHelper) {
        this.emailHelper = emailHelper;
    }

    public void setClientAppConfig(ClientAppConfig clientAppConfig) {
        this.clientAppConfig = clientAppConfig;
    }

    public void setTimerEnd(String timerEnd) {
        if (StringUtils.isNotEmpty((CharSequence)timerEnd)) {
            this.timerEnd = timerEnd;
        }
    }

    public void setDefaultEmailSender(String defaultEmailSender) {
        this.defaultEmailSender = defaultEmailSender;
    }

    public void setSendEmailAsynchronously(boolean sendEmailAsynchronously) {
        this.sendEmailAsynchronously = sendEmailAsynchronously;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"workflowService", (Object)this.workflowService);
        PropertyCheck.mandatory((Object)this, (String)"activitiHistoryService", (Object)this.activitiHistoryService);
        PropertyCheck.mandatory((Object)this, (String)"actionService", (Object)this.actionService);
        PropertyCheck.mandatory((Object)this, (String)"personService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"sysAdminParams", (Object)this.sysAdminParams);
        PropertyCheck.mandatory((Object)this, (String)"authenticationService", (Object)this.authenticationService);
        PropertyCheck.mandatory((Object)this, (String)"activitiTaskService", (Object)this.activitiTaskService);
        PropertyCheck.mandatory((Object)this, (String)"emailHelper", (Object)this.emailHelper);
        PropertyCheck.mandatory((Object)this, (String)"clientAppConfig", (Object)((Object)this.clientAppConfig));
        PropertyCheck.mandatory((Object)this, (String)"defaultEmailSender", (Object)this.defaultEmailSender);
    }

    @Override
    public void requestReset(String userId, String clientName) {
        ParameterCheck.mandatoryString((String)"userId", (String)userId);
        ParameterCheck.mandatoryString((String)"clientName", (String)clientName);
        String userEmail = this.validateUserAndGetEmail(userId);
        WorkflowDefinition wfDefinition = this.workflowService.getDefinitionByName("activiti$resetPassword");
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(7);
        props.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, (Serializable)((Object)I18NUtil.getMessage((String)WORKFLOW_DESCRIPTION_KEY)));
        props.put(WorkflowModelResetPassword.WF_PROP_USERNAME, (Serializable)((Object)userId));
        props.put(WorkflowModelResetPassword.WF_PROP_USER_EMAIL, (Serializable)((Object)userEmail));
        props.put(WorkflowModelResetPassword.WF_PROP_CLIENT_NAME, (Serializable)((Object)clientName));
        props.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)this.workflowService.createPackage(null));
        String guid = GUID.generate();
        props.put(WorkflowModelResetPassword.WF_PROP_KEY, (Serializable)((Object)guid));
        props.put(WorkflowModelResetPassword.WF_PROP_TIMER_END, (Serializable)((Object)this.timerEnd));
        WorkflowPath path = this.workflowService.startWorkflow(wfDefinition.getId(), props);
        if (path.isActive()) {
            WorkflowTask startTask = this.workflowService.getStartTask(path.getInstance().getId());
            this.workflowService.endTask(startTask.getId(), null);
        }
    }

    protected String validateUserAndGetEmail(String userId) {
        if (!this.personService.personExists(userId)) {
            throw new ResetPasswordWorkflowInvalidUserException("User does not exist: " + userId);
        }
        if (!this.personService.isEnabled(userId)) {
            throw new ResetPasswordWorkflowInvalidUserException("User is disabled: " + userId);
        }
        NodeRef personNode = this.personService.getPerson(userId, false);
        return (String)((Object)this.nodeService.getProperty(personNode, ContentModel.PROP_EMAIL));
    }

    @Override
    public void initiateResetPassword(ResetPasswordDetails resetDetails) {
        ParameterCheck.mandatory((String)"resetDetails", (Object)resetDetails);
        this.validateIdAndKey(resetDetails.getWorkflowId(), resetDetails.getWorkflowKey(), resetDetails.getUserId());
        if (StringUtils.isBlank((CharSequence)resetDetails.getPassword())) {
            throw new IllegalArgumentException("Invalid password value [" + resetDetails.getPassword() + "]");
        }
        WorkflowTaskQuery processTaskQuery = new WorkflowTaskQuery();
        processTaskQuery.setProcessId(resetDetails.getWorkflowId());
        List<WorkflowTask> tasks = this.workflowService.queryTasks(processTaskQuery, false);
        if (tasks.isEmpty()) {
            throw new InvalidResetPasswordWorkflowException("Invalid workflow identifier: " + resetDetails.getWorkflowId() + ", " + resetDetails.getWorkflowKey());
        }
        WorkflowTask task = tasks.get(0);
        Map<QName, String> props = Collections.singletonMap(WorkflowModelResetPassword.WF_PROP_PASSWORD, resetDetails.getPassword());
        String taskId = task.getId();
        this.workflowService.updateTask(taskId, props, null, null);
        this.workflowService.endTask(taskId, null);
        String activitiTaskId = taskId.replace("activiti$", "");
        this.activitiHistoryService.deleteHistoricTaskInstance(activitiTaskId);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Deleting historical task for security reasons " + activitiTaskId));
        }
    }

    private void validateIdAndKey(String id, String key, String userId) {
        ParameterCheck.mandatory((String)"id", (Object)id);
        ParameterCheck.mandatory((String)"key", (Object)key);
        ParameterCheck.mandatory((String)"userId", (Object)userId);
        WorkflowInstance workflowInstance = null;
        try {
            workflowInstance = this.workflowService.getWorkflowById(id);
        }
        catch (WorkflowException workflowException) {}
        if (workflowInstance == null) {
            throw new ResetPasswordWorkflowNotFoundException("The reset password workflow instance with the id [" + id + "] is not found.");
        }
        if (!workflowInstance.isActive()) {
            throw new InvalidResetPasswordWorkflowException("The reset password workflow instance with the id [" + id + "] is not active (it might be expired or has already been used).");
        }
        Map<QName, Serializable> pathProps = this.workflowService.getPathProperties(id);
        String username = (String)((Object)pathProps.get(WorkflowModelResetPassword.WF_PROP_USERNAME));
        String recoveredKey = (String)((Object)pathProps.get(WorkflowModelResetPassword.WF_PROP_KEY));
        if (username == null || recoveredKey == null || !recoveredKey.equals(key)) {
            String msg = username == null ? "The recovered user name is null for the reset password workflow instance with the id [" + id + "]" : (recoveredKey == null ? "The recovered key is null for the reset password workflow instance with the id [" + id + "]" : "The recovered key [" + recoveredKey + "] does not match the given workflow key [" + key + "] for the reset password workflow instance with the id [" + id + "]");
            throw new InvalidResetPasswordWorkflowException(msg);
        }
        if (!username.equals(userId)) {
            throw new InvalidResetPasswordWorkflowException("The given user id [" + userId + "] does not match the person's user id [" + username + "] who requested the password reset.");
        }
    }

    @Override
    public ClientAppConfig.ClientApp getClientAppConfig(String clientName) {
        ParameterCheck.mandatoryString((String)"clientName", (String)clientName);
        ClientAppConfig.ClientApp clientApp = this.clientAppConfig.getClient(clientName);
        if (clientApp == null) {
            throw new ClientAppNotFoundException("Client was not found [" + clientName + "]");
        }
        return clientApp;
    }

    @Override
    public void sendResetPasswordEmail(DelegateExecution execution, String fallbackEmailTemplatePath, String emailSubject) {
        Map variables = execution.getVariables();
        String userName = (String)variables.get("resetpasswordwf_userName");
        String toEmail = (String)variables.get("resetpasswordwf_userEmail");
        String clientName = (String)variables.get("resetpasswordwf_clientName");
        String key = (String)variables.get("resetpasswordwf_key");
        String id = execution.getProcessInstanceId();
        ClientAppConfig.ClientApp clientApp = this.getClientAppConfig(clientName);
        Map<String, String> emailTemplateModel = Collections.singletonMap(FTL_RESET_PASSWORD_URL, this.createResetPasswordUrl(clientApp, id, key));
        String templatePath = this.emailHelper.getEmailTemplate(clientName, this.getResetPasswordEmailTemplate(clientApp), fallbackEmailTemplatePath);
        ResetPasswordEmailDetails emailRequest = new ResetPasswordEmailDetails().setUserName(userName).setUserEmail(toEmail).setTemplatePath(templatePath).setTemplateAssetsUrl(clientApp.getTemplateAssetsUrl()).setEmailSubject(emailSubject).setTemplateModel(emailTemplateModel);
        this.sendEmail(emailRequest);
    }

    @Override
    public void performResetPassword(DelegateExecution execution) {
        String userName = (String)execution.getVariable("resetpasswordwf_userName");
        List activitiTasks = ((TaskQuery)((TaskQuery)this.activitiTaskService.createTaskQuery().taskDefinitionKey("resetPasswordTask")).processInstanceId(execution.getProcessInstanceId())).list();
        if (activitiTasks.size() != 1) {
            throw new ResetPasswordWorkflowException("Unexpected count of task instances: " + activitiTasks.size());
        }
        Task activitiTask = (Task)activitiTasks.get(0);
        String activitiTaskId = activitiTask.getId();
        String password = (String)this.activitiTaskService.getVariable(activitiTaskId, "resetpasswordwf_password");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Retrieved new password from task " + activitiTaskId));
        }
        ParameterCheck.mandatoryString((String)"resetpasswordwf_userName", (String)userName);
        ParameterCheck.mandatoryString((String)"resetpasswordwf_password", (String)password);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Changing password for " + userName));
        }
        this.authenticationService.setAuthentication(userName, password.toCharArray());
    }

    @Override
    public void sendResetPasswordConfirmationEmail(DelegateExecution execution, String fallbackEmailTemplatePath, String emailSubject) {
        Map variables = execution.getVariables();
        String userName = (String)variables.get("resetpasswordwf_userName");
        String userEmail = (String)variables.get("resetpasswordwf_userEmail");
        String clientName = (String)variables.get("resetpasswordwf_clientName");
        ClientAppConfig.ClientApp clientApp = this.getClientAppConfig(clientName);
        Map<String, String> emailTemplateModel = Collections.singletonMap(FTL_USER_NAME, userName);
        String templatePath = this.emailHelper.getEmailTemplate(clientName, this.getConfirmResetPasswordEmailTemplate(clientApp), fallbackEmailTemplatePath);
        ResetPasswordEmailDetails emailRequest = new ResetPasswordEmailDetails().setUserName(userName).setUserEmail(userEmail).setTemplatePath(templatePath).setTemplateAssetsUrl(clientApp.getTemplateAssetsUrl()).setEmailSubject(emailSubject).setTemplateModel(emailTemplateModel);
        this.sendEmail(emailRequest);
    }

    protected void sendEmail(ResetPasswordEmailDetails emailRequest) {
        HashMap<String, Object> templateModel = new HashMap<String, Object>();
        String templateAssetsUrl = this.getUrl(emailRequest.getTemplateAssetsUrl(), "templateAssetsUrl");
        templateModel.put(FTL_TEMPLATE_ASSETS_URL, templateAssetsUrl);
        if (emailRequest.getTemplateModel() != null) {
            templateModel.putAll(emailRequest.getTemplateModel());
        }
        HashMap<String, Serializable> actionParams = new HashMap<String, Serializable>(7);
        String fromEmail = emailRequest.getFromEmail();
        if (StringUtils.isEmpty((CharSequence)fromEmail)) {
            fromEmail = this.defaultEmailSender;
        }
        actionParams.put("from", (Serializable)((Object)fromEmail));
        actionParams.put("to", (Serializable)((Object)emailRequest.getUserEmail()));
        actionParams.put("subject", (Serializable)((Object)emailRequest.getEmailSubject()));
        actionParams.put("template", (Serializable)((Object)emailRequest.getTemplatePath()));
        actionParams.put("template_model", templateModel);
        Locale locale = this.emailHelper.getUserLocaleOrDefault(emailRequest.getUserName());
        actionParams.put("locale", locale);
        actionParams.put("ignore_send_failure", Boolean.valueOf(emailRequest.ignoreSendFailure));
        Action mailAction = this.actionService.createAction("mail", actionParams);
        this.actionService.executeAction(mailAction, null, false, this.sendEmailAsynchronously);
    }

    private String getUrl(String url, String propName) {
        if (url == null) {
            LOGGER.warn((Object)("The url for the property [" + propName + "] is not configured."));
            return "";
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return UrlUtil.replaceShareUrlPlaceholder(url, this.sysAdminParams);
    }

    protected String getResetPasswordEmailTemplate(ClientAppConfig.ClientApp clientApp) {
        return clientApp.getProperty("requestResetPasswordTemplatePath");
    }

    protected String getConfirmResetPasswordEmailTemplate(ClientAppConfig.ClientApp clientApp) {
        return clientApp.getProperty("confirmResetPasswordTemplatePath");
    }

    protected String createResetPasswordUrl(ClientAppConfig.ClientApp clientApp, String id, String key) {
        StringBuilder sb = new StringBuilder(100);
        String pageUrl = clientApp.getProperty("resetPasswordPageUrl");
        if (StringUtils.isEmpty((CharSequence)pageUrl)) {
            sb.append(UrlUtil.getShareUrl(this.sysAdminParams));
            LOGGER.warn((Object)("'resetPasswordPageUrl' property is not set for the client [" + clientApp.getName() + "]. The default base url of Share will be used [" + sb.toString() + "]"));
        } else {
            sb.append(this.getUrl(pageUrl, ""));
        }
        sb.append("?key=").append(key).append("&id=").append(BPMEngineRegistry.createGlobalId("activiti", id));
        return sb.toString();
    }

    public static class InvalidResetPasswordWorkflowException
    extends ResetPasswordWorkflowException {
        private static final long serialVersionUID = -4685359036247580984L;

        public InvalidResetPasswordWorkflowException(String msgId) {
            super(msgId);
        }
    }

    public static class ResetPasswordDetails {
        private String userId;
        private String password;
        private String workflowId;
        private String workflowKey;

        public String getUserId() {
            return this.userId;
        }

        public ResetPasswordDetails setUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public String getPassword() {
            return this.password;
        }

        public ResetPasswordDetails setPassword(String password) {
            this.password = password;
            return this;
        }

        public String getWorkflowId() {
            return this.workflowId;
        }

        public ResetPasswordDetails setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public String getWorkflowKey() {
            return this.workflowKey;
        }

        public ResetPasswordDetails setWorkflowKey(String workflowKey) {
            this.workflowKey = workflowKey;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(100);
            sb.append("ResetPasswordDetails [userId=").append(this.userId).append(", workflowId=").append(this.workflowId).append(", workflowKey=").append(this.workflowKey).append(']');
            return sb.toString();
        }
    }

    public static class ResetPasswordEmailDetails {
        private String userName;
        private String userEmail;
        private String fromEmail;
        private String templatePath;
        private String templateAssetsUrl;
        private Map<String, Serializable> templateModel;
        private String emailSubject;
        private boolean ignoreSendFailure = true;

        public String getUserName() {
            return this.userName;
        }

        public ResetPasswordEmailDetails setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public String getUserEmail() {
            return this.userEmail;
        }

        public ResetPasswordEmailDetails setUserEmail(String userEmail) {
            this.userEmail = userEmail;
            return this;
        }

        public String getFromEmail() {
            return this.fromEmail;
        }

        public ResetPasswordEmailDetails setFromEmail(String fromEmail) {
            this.fromEmail = fromEmail;
            return this;
        }

        public String getTemplatePath() {
            return this.templatePath;
        }

        public ResetPasswordEmailDetails setTemplatePath(String templatePath) {
            this.templatePath = templatePath;
            return this;
        }

        public String getTemplateAssetsUrl() {
            return this.templateAssetsUrl;
        }

        public ResetPasswordEmailDetails setTemplateAssetsUrl(String templateAssetsUrl) {
            this.templateAssetsUrl = templateAssetsUrl;
            return this;
        }

        public Map<String, Serializable> getTemplateModel() {
            return this.templateModel;
        }

        public ResetPasswordEmailDetails setTemplateModel(Map<String, Serializable> templateModel) {
            this.templateModel = templateModel;
            return this;
        }

        public String getEmailSubject() {
            return this.emailSubject;
        }

        public ResetPasswordEmailDetails setEmailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
            return this;
        }

        public boolean isIgnoreSendFailure() {
            return this.ignoreSendFailure;
        }

        public ResetPasswordEmailDetails setIgnoreSendFailure(boolean ignoreSendFailure) {
            this.ignoreSendFailure = ignoreSendFailure;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(250);
            sb.append("ResetPasswordEmailDetails [userName=").append(this.userName).append(", userEmail=").append(this.userEmail).append(", fromEmail=").append(this.fromEmail).append(", templatePath=").append(this.templatePath).append(", templateAssetsUrl=").append(this.templateAssetsUrl).append(", templateModel=").append(this.templateModel).append(", emailSubject=").append(this.emailSubject).append(", ignoreSendFailure=").append(this.ignoreSendFailure).append(']');
            return sb.toString();
        }
    }

    public static class ResetPasswordWorkflowException
    extends AlfrescoRuntimeException {
        private static final long serialVersionUID = -694208478609278943L;

        public ResetPasswordWorkflowException(String msgId) {
            super(msgId);
        }
    }

    public static class ResetPasswordWorkflowInvalidUserException
    extends ResetPasswordWorkflowException {
        private static final long serialVersionUID = -6524046975575636256L;

        public ResetPasswordWorkflowInvalidUserException(String msgId) {
            super(msgId);
        }
    }

    public static class ResetPasswordWorkflowNotFoundException
    extends ResetPasswordWorkflowException {
        private static final long serialVersionUID = -7492264073778098895L;

        public ResetPasswordWorkflowNotFoundException(String msgId) {
            super(msgId);
        }
    }
}

