/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import org.alfresco.util.ParameterCheck;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.junit.rules.ExternalResource;
import org.springframework.context.ApplicationContext;

public abstract class AbstractRule
extends ExternalResource {
    protected final ApplicationContext appContext;
    protected final ApplicationContextInit appContextRule;

    protected AbstractRule(ApplicationContext appContext) {
        ParameterCheck.mandatory((String)"appContext", (Object)appContext);
        this.appContext = appContext;
        this.appContextRule = null;
    }

    protected AbstractRule(ApplicationContextInit appContextRule) {
        ParameterCheck.mandatory((String)"appContextRule", (Object)((Object)appContextRule));
        this.appContext = null;
        this.appContextRule = appContextRule;
    }

    protected ApplicationContext getApplicationContext() {
        ApplicationContext result = null;
        if (this.appContext != null) {
            result = this.appContext;
        } else {
            ApplicationContext contextFromRule = this.appContextRule.getApplicationContext();
            if (contextFromRule != null) {
                result = contextFromRule;
            } else {
                throw new NullPointerException("Cannot retrieve application context from provided rule.");
            }
        }
        return result;
    }
}

