/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.WorkflowDeployer;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.workflow.WorkflowAdminService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.surf.util.I18NUtil;

public class GenericWorkflowPatch
extends AbstractPatch
implements ApplicationContextAware {
    private static final String MSG_DEPLOYED = "patch.genericWorkflow.result.deployed";
    private static final String MSG_UNDEPLOYED = "patch.genericWorkflow.result.undeployed";
    private static final String ERR_PROPERTY_REQUIRED = "patch.genericWorkflow.property_required";
    private static final String MSG_ERROR_ENGINE_DEACTIVATED = "patch.genericWorkflow.error_engine_deactivated";
    private ApplicationContext applicationContext;
    private List<Properties> workflowDefinitions;
    private List<String> undeployWorkflowNames;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setWorkflowDefinitions(List<Properties> workflowDefinitions) {
        this.workflowDefinitions = workflowDefinitions;
    }

    public void setUndeployWorkflowNames(List<String> undeployWorkflowNames) {
        this.undeployWorkflowNames = undeployWorkflowNames;
    }

    @Override
    protected void checkProperties() {
        if (this.workflowDefinitions == null && this.undeployWorkflowNames == null) {
            throw new PatchException(ERR_PROPERTY_REQUIRED, "workflowDefinitions", "undeployWorkflowNames", this);
        }
        super.checkProperties();
    }

    @Override
    protected String applyInternal() throws Exception {
        WorkflowDeployer deployer = (WorkflowDeployer)((Object)this.applicationContext.getBean("workflowPatchDeployer"));
        WorkflowAdminService workflowAdminService = (WorkflowAdminService)this.applicationContext.getBean("workflowAdminService");
        if (this.workflowDefinitions != null) {
            for (Properties props : this.workflowDefinitions) {
                props.put("redeploy", "true");
            }
            deployer.setWorkflowDefinitions(this.workflowDefinitions);
            deployer.init();
        }
        int undeployed = 0;
        StringBuilder errorMessages = new StringBuilder();
        if (this.undeployWorkflowNames != null) {
            ArrayList<String> undeployableWorkflows = new ArrayList<String>(this.undeployWorkflowNames);
            for (String workflowName : this.undeployWorkflowNames) {
                String engineId = BPMEngineRegistry.getEngineId(workflowName);
                if (workflowAdminService.isEngineEnabled(engineId)) {
                    undeployableWorkflows.add(workflowName);
                    continue;
                }
                errorMessages.append(I18NUtil.getMessage((String)MSG_ERROR_ENGINE_DEACTIVATED, (Object[])new Object[]{workflowName, engineId}));
            }
            undeployed = deployer.undeploy(undeployableWorkflows);
        }
        StringBuilder msg = new StringBuilder();
        if (this.workflowDefinitions != null) {
            msg.append(I18NUtil.getMessage((String)MSG_DEPLOYED, (Object[])new Object[]{this.workflowDefinitions.size()}));
        }
        if (this.undeployWorkflowNames != null) {
            if (msg.length() > 0) {
                msg.append(' ');
            }
            msg.append(I18NUtil.getMessage((String)MSG_UNDEPLOYED, (Object[])new Object[]{undeployed}));
        }
        if (errorMessages.length() > 0) {
            msg.append((CharSequence)errorMessages);
        }
        return msg.toString();
    }
}

