/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.copy.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQuery;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.repo.copy.query.AbstractCopyCannedQueryFactory;
import org.alfresco.repo.copy.query.CopyEntity;
import org.alfresco.repo.copy.query.CopyParametersEntity;
import org.alfresco.repo.security.permissions.impl.acegi.AbstractCannedQueryPermissions;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class GetCopiesCannedQueryFactory
extends AbstractCopyCannedQueryFactory<CopyService.CopyInfo> {
    public CannedQuery<CopyService.CopyInfo> getCannedQuery(CannedQueryParameters parameters) {
        return new GetCopiesCannedQuery(parameters, this.methodSecurity);
    }

    private class GetCopiesCannedQuery
    extends AbstractCannedQueryPermissions<CopyService.CopyInfo> {
        private GetCopiesCannedQuery(CannedQueryParameters parameters, MethodSecurityBean<CopyService.CopyInfo> methodSecurity) {
            super(parameters, methodSecurity);
        }

        protected List<CopyService.CopyInfo> queryAndFilter(CannedQueryParameters parameters) {
            AbstractCopyCannedQueryFactory.CopyCannedQueryDetail detail = GetCopiesCannedQueryFactory.this.getDetail(parameters);
            CopyParametersEntity queryParameters = new CopyParametersEntity();
            Pair<Long, NodeRef> originalNodePair = GetCopiesCannedQueryFactory.this.nodeDAO.getNodePair(detail.originalNodeRef);
            if (originalNodePair == null) {
                return Collections.emptyList();
            }
            queryParameters.setOriginalNodeId((Long)originalNodePair.getFirst());
            Pair<Long, QName> assocTypeQNamePair = GetCopiesCannedQueryFactory.this.qnameDAO.getQName(ContentModel.ASSOC_ORIGINAL);
            if (assocTypeQNamePair == null) {
                return Collections.emptyList();
            }
            queryParameters.setOriginalAssocTypeId((Long)assocTypeQNamePair.getFirst());
            Pair<Long, QName> propQNamePair = GetCopiesCannedQueryFactory.this.qnameDAO.getQName(ContentModel.PROP_NAME);
            if (propQNamePair == null) {
                return Collections.emptyList();
            }
            queryParameters.setNamePropId((Long)propQNamePair.getFirst());
            if (detail.copyParentNodeRef != null) {
                Pair<Long, NodeRef> copyParentNodePair = GetCopiesCannedQueryFactory.this.nodeDAO.getNodePair(detail.copyParentNodeRef);
                if (copyParentNodePair == null) {
                    return Collections.emptyList();
                }
                queryParameters.setCopyParentNodeId((Long)copyParentNodePair.getFirst());
            }
            int resultsRequired = parameters.getResultsRequired();
            List copies = GetCopiesCannedQueryFactory.this.cannedQueryDAO.executeQuery("alfresco.query.copy", "select_GetCopies", queryParameters, 0, resultsRequired);
            ArrayList<CopyService.CopyInfo> results = new ArrayList<CopyService.CopyInfo>(copies.size());
            for (CopyEntity copy : copies) {
                CopyService.CopyInfo result = new CopyService.CopyInfo(copy.getCopy().getNodeRef(), copy.getCopyName());
                results.add(result);
            }
            return results;
        }
    }
}

