/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import jakarta.transaction.UserTransaction;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.nodelocator.NodeLocatorService;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.ClassFilter;
import org.alfresco.repo.policy.ClassPolicy;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.Policy;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyDefinition;
import org.alfresco.repo.policy.PolicyType;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class PolicyComponentTransactionTest
extends TestCase {
    private static final String TEST_MODEL = "org/alfresco/repo/policy/policycomponenttest_model.xml";
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";
    private static QName BASE_TYPE = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"base");
    private static QName FILE_TYPE = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"file");
    private static QName A_TYPE = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"a_type");
    private static QName B_TYPE = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"b_type");
    private static QName C_TYPE = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"c_type");
    private static QName ASPECT = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"aspect");
    private ApplicationContext applicationContext;
    private static ClassPolicyDelegate<SideEffectTestPolicy> sideEffectDelegate = null;
    private PolicyComponent policyComponent;
    private BehaviourFilter behaviourFilter;
    private TransactionService trxService;
    private AuthenticationComponent authenticationComponent;
    private NodeService nodeService;
    private NodeLocatorService nodeLocatorService;
    private NodeRef companyHome;
    private TestOnCreateNodePolicy aTypeBehavior;
    private TestOnCreateNodePolicy bTypeBehavior;
    private TestOnCreateNodePolicy cTypeBehavior;
    private TestOnUpdateNodePolicy aTypeUpdateBehavior;
    private TestOnUpdateNodePolicy bTypeUpdateBehavior;
    private TestOnUpdateNodePolicy cTypeUpdateBehavior;

    protected void setUp() throws Exception {
        this.applicationContext = ApplicationContextHelper.getApplicationContext();
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add(TEST_MODEL);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO((DictionaryDAO)this.applicationContext.getBean("dictionaryDAO"));
        bootstrap.setTenantService((TenantService)this.applicationContext.getBean("tenantService"));
        bootstrap.bootstrap();
        this.policyComponent = (PolicyComponent)this.applicationContext.getBean("policyComponent");
        this.behaviourFilter = (BehaviourFilter)this.applicationContext.getBean("policyBehaviourFilter");
        this.trxService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.nodeLocatorService = (NodeLocatorService)this.applicationContext.getBean("nodeLocatorService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        if (sideEffectDelegate == null) {
            sideEffectDelegate = this.policyComponent.registerClassPolicy(SideEffectTestPolicy.class);
            QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"sideEffect");
            JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "sideEffectTest", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
            this.policyComponent.bindClassBehaviour(policyName, BASE_TYPE, (Behaviour)baseBehaviour);
        }
        this.companyHome = this.nodeLocatorService.getNode("companyhome", null, null);
        this.createAndEnableBehaviours();
    }

    private void createAndEnableBehaviours() {
        this.aTypeBehavior = new TestOnCreateNodePolicy();
        this.aTypeUpdateBehavior = new TestOnUpdateNodePolicy();
        this.bTypeBehavior = new TestOnCreateNodePolicy();
        this.bTypeUpdateBehavior = new TestOnUpdateNodePolicy();
        this.cTypeBehavior = new TestOnCreateNodePolicy();
        this.cTypeUpdateBehavior = new TestOnUpdateNodePolicy();
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, A_TYPE, (Behaviour)new JavaBehaviour((Object)this.aTypeBehavior, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdateNodePolicy.QNAME, A_TYPE, (Behaviour)new JavaBehaviour((Object)this.aTypeUpdateBehavior, "onUpdateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, B_TYPE, (Behaviour)new JavaBehaviour((Object)this.bTypeBehavior, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdateNodePolicy.QNAME, B_TYPE, (Behaviour)new JavaBehaviour((Object)this.bTypeUpdateBehavior, "onUpdateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, C_TYPE, (Behaviour)new JavaBehaviour((Object)this.cTypeBehavior, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdateNodePolicy.QNAME, C_TYPE, (Behaviour)new JavaBehaviour((Object)this.cTypeUpdateBehavior, "onUpdateNode"));
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    public void testStartTransactionPolicy() throws Exception {
        ClassPolicyDelegate startDelegate = this.policyComponent.registerClassPolicy(StartTestPolicy.class);
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"start");
        PolicyDefinition definition = this.policyComponent.getRegisteredPolicy(PolicyType.Class, policyName);
        PolicyComponentTransactionTest.assertNotNull((Object)definition);
        Policy.Arg arg0 = definition.getArgument(0);
        PolicyComponentTransactionTest.assertEquals((Object)Policy.Arg.KEY, (Object)arg0);
        Policy.Arg arg1 = definition.getArgument(1);
        PolicyComponentTransactionTest.assertEquals((Object)Policy.Arg.KEY, (Object)arg1);
        Policy.Arg arg2 = definition.getArgument(2);
        PolicyComponentTransactionTest.assertEquals((Object)Policy.Arg.START_VALUE, (Object)arg2);
        Policy.Arg arg3 = definition.getArgument(3);
        PolicyComponentTransactionTest.assertEquals((Object)Policy.Arg.END_VALUE, (Object)arg3);
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "startTransactionTest", Behaviour.NotificationFrequency.FIRST_EVENT);
        this.policyComponent.bindClassBehaviour(policyName, BASE_TYPE, (Behaviour)baseBehaviour);
        UserTransaction userTransaction1 = this.trxService.getUserTransaction();
        try {
            userTransaction1.begin();
            ArrayList<TestResult> results = new ArrayList<TestResult>();
            StartTestPolicy basePolicy = (StartTestPolicy)startDelegate.get(BASE_TYPE);
            String baseResult1 = basePolicy.start("1", "2", "value1a", "value2a", false, results);
            TestResult result1 = new TestResult("startTransactionTest", "1", "2", "value1a", "value2a");
            PolicyComponentTransactionTest.assertEquals((String)result1.toString(), (String)baseResult1);
            PolicyComponentTransactionTest.assertEquals((int)1, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result1, results.get(0));
            String baseResult2 = basePolicy.start("2", "1", "value1b", "value2b", false, results);
            TestResult result2 = new TestResult("startTransactionTest", "2", "1", "value1b", "value2b");
            PolicyComponentTransactionTest.assertEquals((String)result2.toString(), (String)baseResult2);
            PolicyComponentTransactionTest.assertEquals((int)2, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result2, results.get(1));
            String baseResult3 = basePolicy.start("1", "2", "value1c", "value2c", false, results);
            PolicyComponentTransactionTest.assertEquals((String)result1.toString(), (String)baseResult3);
            PolicyComponentTransactionTest.assertEquals((int)2, (int)results.size());
            userTransaction1.commit();
            PolicyComponentTransactionTest.assertEquals((int)2, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result1, results.get(0));
            PolicyComponentTransactionTest.assertEquals((Object)result2, results.get(1));
        }
        catch (Exception e) {
            try {
                userTransaction1.rollback();
            }
            catch (IllegalStateException illegalStateException) {}
            throw e;
        }
        UserTransaction userTransaction2 = this.trxService.getUserTransaction();
        try {
            userTransaction2.begin();
            ArrayList<TestResult> results = new ArrayList<TestResult>();
            StartTestPolicy basePolicy = (StartTestPolicy)startDelegate.get(BASE_TYPE);
            String baseResult1 = basePolicy.start("1", "2", "value1a", "value2a", true, results);
            TestResult result1 = new TestResult("startTransactionTest", "1", "2", "value1a", "value2a");
            PolicyComponentTransactionTest.assertEquals((String)result1.toString(), (String)baseResult1);
            PolicyComponentTransactionTest.assertEquals((int)1, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result1, results.get(0));
            String baseResult2 = basePolicy.start("2", "1", "value1b", "value2b", true, results);
            TestResult result2 = new TestResult("startTransactionTest", "2", "1", "value1b", "value2b");
            PolicyComponentTransactionTest.assertEquals((String)result2.toString(), (String)baseResult2);
            PolicyComponentTransactionTest.assertEquals((int)2, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result2, results.get(1));
            String baseResult3 = basePolicy.start("1", "2", "value1c", "value2c", true, results);
            PolicyComponentTransactionTest.assertEquals((String)result1.toString(), (String)baseResult3);
            PolicyComponentTransactionTest.assertEquals((int)2, (int)results.size());
            TestResult result3 = new TestResult("sideEffectTest", "1", "2", "value1a", "value2a");
            TestResult result4 = new TestResult("sideEffectTest", "2", "1", "value1b", "value2b");
            userTransaction2.commit();
            PolicyComponentTransactionTest.assertEquals((int)4, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result1, results.get(0));
            PolicyComponentTransactionTest.assertEquals((Object)result2, results.get(1));
            PolicyComponentTransactionTest.assertEquals((Object)result3, results.get(2));
            PolicyComponentTransactionTest.assertEquals((Object)result4, results.get(3));
        }
        catch (Exception e) {
            try {
                userTransaction2.rollback();
            }
            catch (IllegalStateException illegalStateException) {}
            throw e;
        }
    }

    public void testEndTransactionPolicy() throws Exception {
        ClassPolicyDelegate endDelegate = this.policyComponent.registerClassPolicy(EndTestPolicy.class);
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"end");
        PolicyDefinition definition = this.policyComponent.getRegisteredPolicy(PolicyType.Class, policyName);
        PolicyComponentTransactionTest.assertNotNull((Object)definition);
        Policy.Arg arg0 = definition.getArgument(0);
        PolicyComponentTransactionTest.assertEquals((Object)Policy.Arg.KEY, (Object)arg0);
        Policy.Arg arg1 = definition.getArgument(1);
        PolicyComponentTransactionTest.assertEquals((Object)Policy.Arg.KEY, (Object)arg1);
        Policy.Arg arg2 = definition.getArgument(2);
        PolicyComponentTransactionTest.assertEquals((Object)Policy.Arg.START_VALUE, (Object)arg2);
        Policy.Arg arg3 = definition.getArgument(3);
        PolicyComponentTransactionTest.assertEquals((Object)Policy.Arg.END_VALUE, (Object)arg3);
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "endTransactionTest", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
        this.policyComponent.bindClassBehaviour(policyName, BASE_TYPE, (Behaviour)baseBehaviour);
        UserTransaction userTransaction1 = this.trxService.getUserTransaction();
        try {
            userTransaction1.begin();
            ArrayList<TestResult> results = new ArrayList<TestResult>();
            EndTestPolicy basePolicy = (EndTestPolicy)endDelegate.get(BASE_TYPE);
            String baseResult1 = basePolicy.end("1", "2", "value1a", "value2a", false, results);
            PolicyComponentTransactionTest.assertEquals(null, (String)baseResult1);
            PolicyComponentTransactionTest.assertEquals((int)0, (int)results.size());
            String baseResult2 = basePolicy.end("2", "1", "value1b", "value2b", false, results);
            PolicyComponentTransactionTest.assertEquals(null, (String)baseResult2);
            PolicyComponentTransactionTest.assertEquals((int)0, (int)results.size());
            String baseResult3 = basePolicy.end("1", "2", "value1a", "value2c", false, results);
            PolicyComponentTransactionTest.assertEquals(null, (String)baseResult3);
            PolicyComponentTransactionTest.assertEquals((int)0, (int)results.size());
            TestResult result1 = new TestResult("endTransactionTest", "1", "2", "value1a", "value2c");
            TestResult result2 = new TestResult("endTransactionTest", "2", "1", "value1b", "value2b");
            userTransaction1.commit();
            PolicyComponentTransactionTest.assertEquals((int)2, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result1, results.get(0));
            PolicyComponentTransactionTest.assertEquals((Object)result2, results.get(1));
        }
        catch (Exception e) {
            try {
                userTransaction1.rollback();
            }
            catch (IllegalStateException illegalStateException) {}
            throw e;
        }
        UserTransaction userTransaction2 = this.trxService.getUserTransaction();
        try {
            userTransaction2.begin();
            ArrayList<TestResult> results = new ArrayList<TestResult>();
            EndTestPolicy basePolicy = (EndTestPolicy)endDelegate.get(BASE_TYPE);
            String baseResult1 = basePolicy.end("1", "2", "value1a", "value2a", true, results);
            PolicyComponentTransactionTest.assertEquals(null, (String)baseResult1);
            PolicyComponentTransactionTest.assertEquals((int)0, (int)results.size());
            String baseResult2 = basePolicy.end("2", "1", "value1b", "value2b", true, results);
            PolicyComponentTransactionTest.assertEquals(null, (String)baseResult2);
            PolicyComponentTransactionTest.assertEquals((int)0, (int)results.size());
            String baseResult3 = basePolicy.end("1", "2", "value1a", "value2c", true, results);
            PolicyComponentTransactionTest.assertEquals(null, (String)baseResult3);
            PolicyComponentTransactionTest.assertEquals((int)0, (int)results.size());
            TestResult result1 = new TestResult("endTransactionTest", "1", "2", "value1a", "value2c");
            TestResult result2 = new TestResult("endTransactionTest", "2", "1", "value1b", "value2b");
            TestResult result3 = new TestResult("sideEffectTest", "1", "2", "value1a", "value2c");
            TestResult result4 = new TestResult("sideEffectTest", "2", "1", "value1b", "value2b");
            userTransaction2.commit();
            PolicyComponentTransactionTest.assertEquals((int)4, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result1, results.get(0));
            PolicyComponentTransactionTest.assertEquals((Object)result2, results.get(1));
            PolicyComponentTransactionTest.assertEquals((Object)result3, results.get(2));
            PolicyComponentTransactionTest.assertEquals((Object)result4, results.get(3));
        }
        catch (Exception e) {
            try {
                userTransaction2.rollback();
            }
            catch (IllegalStateException illegalStateException) {}
            throw e;
        }
        NodeRef nodeRef = new NodeRef(TEST_NAMESPACE, "test", "123");
        UserTransaction userTransaction3 = this.trxService.getUserTransaction();
        try {
            userTransaction3.begin();
            this.checkBehaviour(BASE_TYPE, nodeRef, true, true, true, true);
            this.behaviourFilter.enableBehaviour(nodeRef);
            this.checkBehaviour(BASE_TYPE, nodeRef, true, true, true, true);
            this.behaviourFilter.disableBehaviour(nodeRef);
            this.checkBehaviour(BASE_TYPE, nodeRef, true, true, false, false);
            this.behaviourFilter.disableBehaviour(nodeRef);
            this.checkBehaviour(BASE_TYPE, nodeRef, true, true, false, false);
            this.behaviourFilter.enableBehaviour(nodeRef);
            this.checkBehaviour(BASE_TYPE, nodeRef, true, true, false, false);
            this.behaviourFilter.enableBehaviour(nodeRef);
            this.checkBehaviour(BASE_TYPE, nodeRef, true, true, true, true);
            this.behaviourFilter.enableBehaviour(nodeRef, BASE_TYPE);
            this.checkBehaviour(BASE_TYPE, nodeRef, true, true, true, true);
            this.behaviourFilter.disableBehaviour(nodeRef, BASE_TYPE);
            this.checkBehaviour(BASE_TYPE, nodeRef, true, true, false, true);
            this.behaviourFilter.disableBehaviour(nodeRef, BASE_TYPE);
            this.checkBehaviour(BASE_TYPE, nodeRef, true, true, false, true);
            this.behaviourFilter.enableBehaviour(nodeRef, BASE_TYPE);
            this.checkBehaviour(BASE_TYPE, nodeRef, true, true, false, true);
            this.behaviourFilter.enableBehaviour(nodeRef, BASE_TYPE);
            this.checkBehaviour(BASE_TYPE, nodeRef, true, true, true, true);
            this.behaviourFilter.enableBehaviour(BASE_TYPE);
            this.checkBehaviour(BASE_TYPE, nodeRef, true, true, true, true);
            this.behaviourFilter.disableBehaviour(BASE_TYPE);
            this.checkBehaviour(BASE_TYPE, nodeRef, true, false, false, true);
            this.behaviourFilter.disableBehaviour(BASE_TYPE);
            this.checkBehaviour(BASE_TYPE, nodeRef, true, false, false, true);
            this.behaviourFilter.enableBehaviour(BASE_TYPE);
            this.checkBehaviour(BASE_TYPE, nodeRef, true, false, false, true);
            this.behaviourFilter.enableBehaviour(BASE_TYPE);
            this.checkBehaviour(BASE_TYPE, nodeRef, true, true, true, true);
            this.behaviourFilter.enableBehaviour();
            this.checkBehaviour(BASE_TYPE, nodeRef, true, true, true, true);
            this.behaviourFilter.disableBehaviour();
            this.checkBehaviour(BASE_TYPE, nodeRef, false, false, false, false);
            this.behaviourFilter.disableBehaviour();
            this.checkBehaviour(BASE_TYPE, nodeRef, false, false, false, false);
            this.behaviourFilter.enableBehaviour();
            this.checkBehaviour(BASE_TYPE, nodeRef, false, false, false, false);
            this.behaviourFilter.enableBehaviour();
            this.checkBehaviour(BASE_TYPE, nodeRef, true, true, true, true);
            userTransaction3.commit();
        }
        catch (Exception e) {
            try {
                userTransaction3.rollback();
            }
            catch (IllegalStateException illegalStateException) {}
            throw e;
        }
    }

    public void behaviourHierarchyTestWork(QName createDocType, ClassFilter ... disableTypes) throws Exception {
        UserTransaction transaction = this.trxService.getUserTransaction();
        try {
            transaction.begin();
            this.disableBehaviours(disableTypes);
            try {
                this.createDocOfType(createDocType);
            }
            finally {
                this.enableBehaviours(disableTypes);
            }
            transaction.commit();
        }
        catch (Exception e) {
            try {
                transaction.rollback();
            }
            catch (IllegalStateException illegalStateException) {}
            throw e;
        }
    }

    public void behaviourHierarchyNodeTestWork(QName createDocType, QName ... disableTypes) throws Exception {
        UserTransaction transaction = this.trxService.getUserTransaction();
        try {
            transaction.begin();
            NodeRef nodeRef = this.createDocOfType(createDocType);
            this.disableBehaviours(nodeRef, disableTypes);
            try {
                this.nodeService.addAspect(nodeRef, ASPECT, null);
            }
            finally {
                this.enableBehaviours(nodeRef, disableTypes);
            }
            transaction.commit();
        }
        catch (Exception e) {
            try {
                transaction.rollback();
            }
            catch (IllegalStateException illegalStateException) {}
            throw e;
        }
    }

    public void testBehaviourHierarchyEnableAll1() throws Exception {
        this.behaviourHierarchyTestWork(A_TYPE, new ClassFilter[0]);
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyNodeEnableAll1() throws Exception {
        this.behaviourHierarchyNodeTestWork(A_TYPE, new QName[0]);
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a type.", (boolean)this.aTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeUpdateBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyEnableAll2() throws Exception {
        this.behaviourHierarchyTestWork(B_TYPE, new ClassFilter[0]);
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyNodeEnableAll2() throws Exception {
        this.behaviourHierarchyNodeTestWork(B_TYPE, new QName[0]);
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a type.", (boolean)this.aTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for b type.", (boolean)this.bTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.bTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeUpdateBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyEnableAll3() throws Exception {
        this.behaviourHierarchyTestWork(C_TYPE, new ClassFilter[0]);
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyNodeEnableAll3() throws Exception {
        this.behaviourHierarchyNodeTestWork(C_TYPE, new QName[0]);
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a type.", (boolean)this.aTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for b type.", (boolean)this.bTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.bTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for c type.", (boolean)this.cTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.cTypeUpdateBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableAllUpHierarchy1() throws Exception {
        this.behaviourHierarchyTestWork(A_TYPE, new ClassFilter(A_TYPE, false), new ClassFilter(B_TYPE, false), new ClassFilter(C_TYPE, false));
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableAllUpHierarchy2() throws Exception {
        this.behaviourHierarchyTestWork(B_TYPE, new ClassFilter(A_TYPE, false), new ClassFilter(B_TYPE, false), new ClassFilter(C_TYPE, false));
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableAllUpHierarchy3() throws Exception {
        this.behaviourHierarchyTestWork(C_TYPE, new ClassFilter(A_TYPE, false), new ClassFilter(B_TYPE, false), new ClassFilter(C_TYPE, false));
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableAllDownHierarchy1() throws Exception {
        this.behaviourHierarchyTestWork(A_TYPE, new ClassFilter(A_TYPE, true), new ClassFilter(B_TYPE, true), new ClassFilter(C_TYPE, true));
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableAllDownHierarchy2() throws Exception {
        this.behaviourHierarchyTestWork(B_TYPE, new ClassFilter(A_TYPE, true), new ClassFilter(B_TYPE, true), new ClassFilter(C_TYPE, true));
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableAllDownHierarchy3() throws Exception {
        this.behaviourHierarchyTestWork(C_TYPE, new ClassFilter(A_TYPE, true), new ClassFilter(B_TYPE, true), new ClassFilter(C_TYPE, true));
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableSuper1() throws Exception {
        this.behaviourHierarchyTestWork(A_TYPE, new ClassFilter(A_TYPE, false));
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableSuper2() throws Exception {
        this.behaviourHierarchyTestWork(B_TYPE, new ClassFilter(A_TYPE, false));
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableSuper3() throws Exception {
        this.behaviourHierarchyTestWork(C_TYPE, new ClassFilter(A_TYPE, false));
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableSuper4() throws Exception {
        this.behaviourHierarchyTestWork(A_TYPE, new ClassFilter(A_TYPE, true));
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyNodeDisableSuper1() throws Exception {
        this.behaviourHierarchyNodeTestWork(A_TYPE, A_TYPE);
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeUpdateBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableSuper5() throws Exception {
        this.behaviourHierarchyTestWork(B_TYPE, new ClassFilter(A_TYPE, true));
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyNodeDisableSuper2() throws Exception {
        this.behaviourHierarchyNodeTestWork(B_TYPE, A_TYPE);
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeUpdateBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableSuper6() throws Exception {
        this.behaviourHierarchyTestWork(C_TYPE, new ClassFilter(A_TYPE, true));
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyNodeDisableSuper3() throws Exception {
        this.behaviourHierarchyNodeTestWork(C_TYPE, A_TYPE);
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeUpdateBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableMiddle1() throws Exception {
        this.behaviourHierarchyTestWork(A_TYPE, new ClassFilter(B_TYPE, false));
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableMiddle2() throws Exception {
        this.behaviourHierarchyTestWork(B_TYPE, new ClassFilter(B_TYPE, false));
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableMiddle3() throws Exception {
        this.behaviourHierarchyTestWork(C_TYPE, new ClassFilter(B_TYPE, false));
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableMiddle4() throws Exception {
        this.behaviourHierarchyTestWork(A_TYPE, new ClassFilter(B_TYPE, true));
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyNodeDisableMiddle1() throws Exception {
        this.behaviourHierarchyNodeTestWork(A_TYPE, B_TYPE);
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeUpdateBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableMiddle5() throws Exception {
        this.behaviourHierarchyTestWork(B_TYPE, new ClassFilter(B_TYPE, true));
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should notbe executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior not should be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyNodeDisableMiddle2() throws Exception {
        this.behaviourHierarchyNodeTestWork(B_TYPE, B_TYPE);
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeUpdateBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableMiddle6() throws Exception {
        this.behaviourHierarchyTestWork(C_TYPE, new ClassFilter(B_TYPE, true));
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyNodeDisableMiddle3() throws Exception {
        this.behaviourHierarchyNodeTestWork(C_TYPE, B_TYPE);
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeUpdateBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableSub1() throws Exception {
        this.behaviourHierarchyTestWork(A_TYPE, new ClassFilter(C_TYPE, false));
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableSub2() throws Exception {
        this.behaviourHierarchyTestWork(B_TYPE, new ClassFilter(C_TYPE, false));
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableSub3() throws Exception {
        this.behaviourHierarchyTestWork(C_TYPE, new ClassFilter(C_TYPE, false));
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableSub4() throws Exception {
        this.behaviourHierarchyTestWork(A_TYPE, new ClassFilter(C_TYPE, true));
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyNodeDisableSub1() throws Exception {
        this.behaviourHierarchyNodeTestWork(A_TYPE, C_TYPE);
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeUpdateBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableSub5() throws Exception {
        this.behaviourHierarchyTestWork(B_TYPE, new ClassFilter(C_TYPE, true));
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyNodeDisableSub2() throws Exception {
        this.behaviourHierarchyNodeTestWork(B_TYPE, C_TYPE);
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for b_type.", (boolean)this.bTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.bTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeUpdateBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyDisableSub6() throws Exception {
        this.behaviourHierarchyTestWork(C_TYPE, new ClassFilter(C_TYPE, true));
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchyNodeDisableSub3() throws Exception {
        this.behaviourHierarchyNodeTestWork(C_TYPE, C_TYPE);
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeUpdateBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeUpdateBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeUpdateBehavior.getExecutionCount());
    }

    public void testIsEnabled1() throws Exception {
        UserTransaction transaction = this.trxService.getUserTransaction();
        try {
            transaction.begin();
            this.disableBehaviours(new ClassFilter(B_TYPE, true));
            try {
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: global: ", (boolean)true, (boolean)this.behaviourFilter.isEnabled());
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: class: ", (boolean)true, (boolean)this.behaviourFilter.isEnabled(A_TYPE));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: classAndInstance", (boolean)true, (boolean)this.behaviourFilter.isEnabled(this.companyHome, A_TYPE));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: instance", (boolean)true, (boolean)this.behaviourFilter.isEnabled(this.companyHome));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: class: ", (boolean)false, (boolean)this.behaviourFilter.isEnabled(B_TYPE));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: classAndInstance", (boolean)false, (boolean)this.behaviourFilter.isEnabled(this.companyHome, B_TYPE));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: instance", (boolean)true, (boolean)this.behaviourFilter.isEnabled(this.companyHome));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: class: ", (boolean)false, (boolean)this.behaviourFilter.isEnabled(C_TYPE));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: classAndInstance", (boolean)false, (boolean)this.behaviourFilter.isEnabled(this.companyHome, C_TYPE));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: instance", (boolean)true, (boolean)this.behaviourFilter.isEnabled(this.companyHome));
            }
            finally {
                this.behaviourFilter.enableBehaviour(B_TYPE);
            }
            transaction.commit();
        }
        catch (Exception e) {
            try {
                transaction.rollback();
            }
            catch (IllegalStateException illegalStateException) {}
            throw e;
        }
    }

    public void testIsEnabled2() throws Exception {
        UserTransaction transaction = this.trxService.getUserTransaction();
        try {
            transaction.begin();
            this.disableBehaviours(new ClassFilter(B_TYPE, false));
            try {
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: global: ", (boolean)true, (boolean)this.behaviourFilter.isEnabled());
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: class: ", (boolean)true, (boolean)this.behaviourFilter.isEnabled(A_TYPE));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: classAndInstance", (boolean)true, (boolean)this.behaviourFilter.isEnabled(this.companyHome, A_TYPE));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: instance", (boolean)true, (boolean)this.behaviourFilter.isEnabled(this.companyHome));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: class: ", (boolean)false, (boolean)this.behaviourFilter.isEnabled(B_TYPE));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: classAndInstance", (boolean)false, (boolean)this.behaviourFilter.isEnabled(this.companyHome, B_TYPE));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: instance", (boolean)true, (boolean)this.behaviourFilter.isEnabled(this.companyHome));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: class: ", (boolean)true, (boolean)this.behaviourFilter.isEnabled(C_TYPE));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: classAndInstance", (boolean)true, (boolean)this.behaviourFilter.isEnabled(this.companyHome, C_TYPE));
                PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: instance", (boolean)true, (boolean)this.behaviourFilter.isEnabled(this.companyHome));
            }
            finally {
                this.behaviourFilter.enableBehaviour(B_TYPE);
            }
            transaction.commit();
        }
        catch (Exception e) {
            try {
                transaction.rollback();
            }
            catch (IllegalStateException illegalStateException) {}
            throw e;
        }
    }

    public void testBehaviourHierarchySequence1() throws Exception {
        UserTransaction transaction = this.trxService.getUserTransaction();
        try {
            transaction.begin();
            this.disableBehaviours(new ClassFilter(A_TYPE, true), new ClassFilter(B_TYPE, true));
            this.behaviourFilter.enableBehaviour(B_TYPE);
            this.checkBehaviour(B_TYPE, this.companyHome, true, false, false, true);
            try {
                this.createDocOfType(C_TYPE);
            }
            catch (Throwable throwable) {
                this.enableBehaviours(new ClassFilter(A_TYPE, true), new ClassFilter(B_TYPE, true));
                throw throwable;
            }
            this.enableBehaviours(new ClassFilter(A_TYPE, true), new ClassFilter(B_TYPE, true));
            transaction.commit();
        }
        catch (Exception e) {
            try {
                transaction.rollback();
            }
            catch (IllegalStateException illegalStateException) {}
            throw e;
        }
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertFalse((String)"Behavior should not be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)0, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchySequence2() throws Exception {
        UserTransaction transaction = this.trxService.getUserTransaction();
        try {
            transaction.begin();
            this.disableBehaviours(new ClassFilter(A_TYPE, false), new ClassFilter(B_TYPE, true));
            this.behaviourFilter.enableBehaviour(B_TYPE);
            PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: class: ", (boolean)true, (boolean)this.behaviourFilter.isEnabled(B_TYPE));
            PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: classAndInstance", (boolean)true, (boolean)this.behaviourFilter.isEnabled(this.companyHome, B_TYPE));
            PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: instance", (boolean)true, (boolean)this.behaviourFilter.isEnabled(this.companyHome));
            try {
                this.createDocOfType(C_TYPE);
            }
            catch (Throwable throwable) {
                this.enableBehaviours(new ClassFilter(A_TYPE, true), new ClassFilter(B_TYPE, true));
                throw throwable;
            }
            this.enableBehaviours(new ClassFilter(A_TYPE, true), new ClassFilter(B_TYPE, true));
            transaction.commit();
        }
        catch (Exception e) {
            try {
                transaction.rollback();
            }
            catch (IllegalStateException illegalStateException) {}
            throw e;
        }
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.cTypeBehavior.getExecutionCount());
    }

    public void testBehaviourHierarchySequence3() throws Exception {
        UserTransaction transaction = this.trxService.getUserTransaction();
        try {
            transaction.begin();
            this.disableBehaviours(new ClassFilter(A_TYPE, false), new ClassFilter(B_TYPE, false));
            try {
                this.createDocOfType(C_TYPE);
            }
            catch (Throwable throwable) {
                this.enableBehaviours(new ClassFilter(A_TYPE, true), new ClassFilter(B_TYPE, true));
                throw throwable;
            }
            this.enableBehaviours(new ClassFilter(A_TYPE, true), new ClassFilter(B_TYPE, true));
            transaction.commit();
        }
        catch (Exception e) {
            try {
                transaction.rollback();
            }
            catch (IllegalStateException illegalStateException) {}
            throw e;
        }
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for a_type.", (boolean)this.aTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.aTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for b_type.", (boolean)this.bTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.bTypeBehavior.getExecutionCount());
        PolicyComponentTransactionTest.assertTrue((String)"Behavior should be executed for c_type.", (boolean)this.cTypeBehavior.isExecuted());
        PolicyComponentTransactionTest.assertEquals((int)1, (int)this.cTypeBehavior.getExecutionCount());
    }

    private void disableBehaviours(ClassFilter ... classFilters) {
        int i = 0;
        while (i < classFilters.length) {
            this.behaviourFilter.disableBehaviour(classFilters[i].getClassName(), classFilters[i].isDisableSubClasses());
            this.checkBehaviour(classFilters[i].getClassName(), this.companyHome, true, false, false, true);
            ++i;
        }
    }

    private void disableBehaviours(NodeRef nodeRef, QName ... classNames) {
        int i = 0;
        while (i < classNames.length) {
            this.behaviourFilter.disableBehaviour(nodeRef, classNames[i]);
            this.checkBehaviour(classNames[i], nodeRef, true, true, false, true);
            ++i;
        }
    }

    private void enableBehaviours(ClassFilter ... types) {
        int i = 0;
        while (i < types.length) {
            this.behaviourFilter.enableBehaviour(types[i].getClassName());
            ++i;
        }
        i = 0;
        while (i < types.length) {
            this.checkBehaviour(types[i].getClassName(), this.companyHome, true, true, true, true);
            ++i;
        }
    }

    private void enableBehaviours(NodeRef nodeRef, QName ... types) {
        int i = 0;
        while (i < types.length) {
            this.behaviourFilter.enableBehaviour(nodeRef, types[i]);
            ++i;
        }
        i = 0;
        while (i < types.length) {
            this.checkBehaviour(types[i], this.companyHome, true, true, true, true);
            ++i;
        }
    }

    private NodeRef createDocOfType(QName type) {
        String name = "Test (" + System.currentTimeMillis() + ").docx";
        HashMap<QName, CallSite> contentProps = new HashMap<QName, CallSite>();
        contentProps.put(ContentModel.PROP_NAME, (CallSite)((Object)name));
        return this.nodeService.createNode(this.companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)name), type, contentProps).getChildRef();
    }

    private void checkBehaviour(QName className, NodeRef nodeRef, boolean globalEnabled, boolean classEnabled, boolean classInstanceEnabled, boolean instanceEnabled) {
        PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: global: ", (boolean)globalEnabled, (boolean)this.behaviourFilter.isEnabled());
        PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: class: ", (boolean)classEnabled, (boolean)this.behaviourFilter.isEnabled(className));
        PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: classAndInstance", (boolean)classInstanceEnabled, (boolean)this.behaviourFilter.isEnabled(nodeRef, className));
        PolicyComponentTransactionTest.assertEquals((String)"Incorrect behaviour state: instance", (boolean)instanceEnabled, (boolean)this.behaviourFilter.isEnabled(nodeRef));
        PolicyComponentTransactionTest.assertEquals((String)"'Active' flag incorrect: ", (!globalEnabled || !classEnabled || !classInstanceEnabled || !instanceEnabled ? 1 : 0) != 0, (boolean)this.behaviourFilter.isActivated());
    }

    public String startTransactionTest(String key1, String key2, String arg1, String arg2, boolean sideEffect, List<TestResult> results) {
        TestResult result = new TestResult("startTransactionTest", key1, key2, arg1, arg2);
        results.add(result);
        if (sideEffect) {
            SideEffectTestPolicy policy = (SideEffectTestPolicy)sideEffectDelegate.get(BASE_TYPE);
            policy.sideEffect(key1, key2, arg1, arg2, results);
        }
        return result.toString();
    }

    public String endTransactionTest(String key1, String key2, String arg1, String arg2, boolean sideEffect, List<TestResult> results) {
        TestResult result = new TestResult("endTransactionTest", key1, key2, arg1, arg2);
        results.add(result);
        if (sideEffect) {
            SideEffectTestPolicy policy = (SideEffectTestPolicy)sideEffectDelegate.get(BASE_TYPE);
            policy.sideEffect(key1, key2, arg1, arg2, results);
        }
        return result.toString();
    }

    public String sideEffectTest(String key1, String key2, String arg1, String arg2, List<TestResult> results) {
        TestResult result = new TestResult("sideEffectTest", key1, key2, arg1, arg2);
        results.add(result);
        return result.toString();
    }

    public static interface EndTestPolicy
    extends ClassPolicy {
        public static final String NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";
        public static final Policy.Arg ARG_0 = Policy.Arg.KEY;
        public static final Policy.Arg ARG_1 = Policy.Arg.KEY;
        public static final Policy.Arg ARG_2 = Policy.Arg.START_VALUE;
        public static final Policy.Arg ARG_3 = Policy.Arg.END_VALUE;

        public String end(String var1, String var2, String var3, String var4, boolean var5, List<TestResult> var6);
    }

    public static interface SideEffectTestPolicy
    extends ClassPolicy {
        public static final String NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";
        public static final Policy.Arg ARG_0 = Policy.Arg.KEY;
        public static final Policy.Arg ARG_1 = Policy.Arg.KEY;

        public String sideEffect(String var1, String var2, String var3, String var4, List<TestResult> var5);
    }

    public static interface StartTestPolicy
    extends ClassPolicy {
        public static final String NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";
        public static final Policy.Arg ARG_0 = Policy.Arg.KEY;
        public static final Policy.Arg ARG_1 = Policy.Arg.KEY;
        public static final Policy.Arg ARG_2 = Policy.Arg.START_VALUE;
        public static final Policy.Arg ARG_3 = Policy.Arg.END_VALUE;

        public String start(String var1, String var2, String var3, String var4, boolean var5, List<TestResult> var6);
    }

    private abstract class TestExecutionPolicy {
        private boolean executed;
        private int executionCount;

        private TestExecutionPolicy() {
        }

        protected void execute() {
            this.executed = true;
            ++this.executionCount;
        }

        public boolean isExecuted() {
            return this.executed;
        }

        public int getExecutionCount() {
            return this.executionCount;
        }
    }

    private class TestOnCreateNodePolicy
    extends TestExecutionPolicy
    implements NodeServicePolicies.OnCreateNodePolicy {
        private TestOnCreateNodePolicy() {
        }

        public void onCreateNode(ChildAssociationRef childAssocRef) {
            this.execute();
        }
    }

    private class TestOnUpdateNodePolicy
    extends TestExecutionPolicy
    implements NodeServicePolicies.OnUpdateNodePolicy {
        private TestOnUpdateNodePolicy() {
        }

        public void onUpdateNode(NodeRef nodeRef) {
            this.execute();
        }
    }

    private class TestResult {
        private String trxId = AlfrescoTransactionSupport.getTransactionId();
        private String behaviour;
        private String key1;
        private String key2;
        private String arg1;
        private String arg2;

        public TestResult(String behaviour, String key1, String key2, String arg1, String arg2) {
            this.behaviour = behaviour;
            this.key1 = key1;
            this.key2 = key2;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TestResult) {
                TestResult that = (TestResult)obj;
                return this.trxId.equals(that.trxId) && this.behaviour.equals(that.behaviour) && this.key1.equals(that.key1) && this.key2.equals(that.key2) && this.arg1.equals(that.arg1) && this.arg2.equals(that.arg2);
            }
            return false;
        }

        public String toString() {
            return "trxId=" + this.trxId + ", behaviour=" + this.behaviour + ", key1=" + this.key1 + ", key2=" + this.key2 + ", arg1=" + this.arg1 + ", arg2=" + this.arg2;
        }
    }
}

