/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import java.io.InputStream;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.virtual.VirtualContentModel;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.store.SystemVirtualizationMethod;
import org.alfresco.repo.virtual.store.VirtualStoreImplTest;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SystemVirtualizationMethodTest
extends VirtualizationIntegrationTest {
    private static Log logger = LogFactory.getLog(VirtualStoreImplTest.class);
    private SystemVirtualizationMethod systemVirtualizationMethod;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.systemVirtualizationMethod = (SystemVirtualizationMethod)this.ctx.getBean("systemVirtualizationMethod", SystemVirtualizationMethod.class);
    }

    @Test
    public void testDefaultSyspath() throws Exception {
        NodeRef vf = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "SystemVirtualizationMethodTest_testDefaultSyspath", null);
        Assert.assertFalse((boolean)this.systemVirtualizationMethod.canVirtualize(this.environment, vf));
        try {
            this.systemVirtualizationMethod.virtualize(this.environment, vf);
            Assert.fail((String)"Should not be able to virtualize non-virtualizable nodes.");
        }
        catch (VirtualizationException e) {
            logger.info((Object)e);
        }
    }

    @Test
    public void testNonExistentClassPathResource() throws Exception {
        NodeRef vf = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "SystemVirtualizationMethodTest_testNonExistentClassPathResource", "C/org/alfresco/repo/virtual/template/nonExistetJsonTemplate.json");
        Assert.assertFalse((boolean)this.systemVirtualizationMethod.canVirtualize(this.environment, vf));
    }

    @Test
    public void testNonExistentRepoResource() throws Exception {
        NodeRef vf = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "SystemVirtualizationMethodTest_testNonExistentRepoResource", "Nworkspace://SpacesStore/nonExistentRepoNode");
        Assert.assertFalse((boolean)this.systemVirtualizationMethod.canVirtualize(this.environment, vf));
    }

    @Test
    public void testTemplateFromRepository() throws Exception {
        InputStream openContentStream = this.environment.openContentStream("/org/alfresco/repo/virtual/template/testTemplate1.json");
        NodeRef repositoryTemplate = this.fileAndFolderService.create(this.testRootFolder.getNodeRef(), "test1.json", VirtualContentModel.TYPE_VIRTUAL_FOLDER_TEMPLATE).getNodeRef();
        ContentWriter writer = this.contentService.getWriter(repositoryTemplate, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("application/json");
        writer.putContent(openContentStream);
        NodeRef vf = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "repositoryVirtualizedFolder", "N" + repositoryTemplate.toString());
        Assert.assertTrue((boolean)this.systemVirtualizationMethod.canVirtualize(this.environment, vf));
        Reference ref = this.systemVirtualizationMethod.virtualize(this.environment, vf);
        Assert.assertNotNull((Object)ref);
        Assert.assertNotNull((Object)this.nodeService.getChildByName(ref.toNodeRef(), ContentModel.ASSOC_CONTAINS, "Node1"));
        Assert.assertNotNull((Object)this.nodeService.getChildByName(ref.toNodeRef(), ContentModel.ASSOC_CONTAINS, "Node2"));
    }

    @Test
    public void testTemplateFromClassPath() throws Exception {
        NodeRef vf = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "classpathVirtualizedFolder", "C/org/alfresco/repo/virtual/template/testTemplate1.json");
        Assert.assertTrue((boolean)this.systemVirtualizationMethod.canVirtualize(this.environment, vf));
        Reference ref = this.systemVirtualizationMethod.virtualize(this.environment, vf);
        Assert.assertNotNull((Object)ref);
        Assert.assertNotNull((Object)this.nodeService.getChildByName(ref.toNodeRef(), ContentModel.ASSOC_CONTAINS, "Node1"));
        Assert.assertNotNull((Object)this.nodeService.getChildByName(ref.toNodeRef(), ContentModel.ASSOC_CONTAINS, "Node2"));
    }
}

