/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.List;
import org.alfresco.filesys.repo.rules.EvaluatorContext;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.Scenario;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.ScenarioOpenFileInstance;
import org.alfresco.filesys.repo.rules.operations.CreateFileOperation;
import org.alfresco.filesys.repo.rules.operations.OpenFileOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScenarioOpenFile
implements Scenario {
    private static Log logger = LogFactory.getLog(ScenarioOpenFile.class);
    private String pattern;
    private long timeout = 300000L;
    private ScenarioInstance.Ranking ranking = ScenarioInstance.Ranking.HIGH;

    @Override
    public ScenarioInstance createInstance(EvaluatorContext ctx, Operation operation) {
        if (operation instanceof CreateFileOperation) {
            CreateFileOperation c = (CreateFileOperation)operation;
            if (c.getName() == null) {
                logger.debug((Object)"c.getName is null! - scenario not active");
                return null;
            }
            if (c.getName().matches(this.pattern)) {
                if (this.checkScenarioActive(c.getName(), ctx.getScenarioInstances())) {
                    logger.debug((Object)("scenario already active for name" + c.getName()));
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("New Open File Instance for CreateFileOperation:" + String.valueOf(c)));
                }
                ScenarioOpenFileInstance instance = new ScenarioOpenFileInstance();
                instance.setTimeout(this.timeout);
                instance.setRanking(this.ranking);
                return instance;
            }
        }
        if (operation instanceof OpenFileOperation) {
            OpenFileOperation o = (OpenFileOperation)operation;
            if (o.getName() == null) {
                logger.debug((Object)"o.getName is null! - scenario not active");
                return null;
            }
            if (o.getName().matches(this.pattern)) {
                if (this.checkScenarioActive(o.getName(), ctx.getScenarioInstances())) {
                    logger.debug((Object)("scenario already active for name" + o.getName()));
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("New Open File Instance for OpenFileOperation:" + String.valueOf(o)));
                }
                ScenarioOpenFileInstance instance = new ScenarioOpenFileInstance();
                instance.setTimeout(this.timeout);
                instance.setRanking(this.ranking);
                return instance;
            }
        }
        return null;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }

    private boolean checkScenarioActive(String name, List<ScenarioInstance> currentInstances) {
        for (ScenarioInstance instance : currentInstances) {
            ScenarioOpenFileInstance i;
            if (!(instance instanceof ScenarioOpenFileInstance) || (i = (ScenarioOpenFileInstance)instance).getName() == null || name == null || !i.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

