/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.util.ArrayList;
import java.util.Arrays;
import org.alfresco.error.ExceptionStackUtil;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.coci.CheckOutCheckInServiceException;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.model.FileExistsException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlfrescoCmisExceptionInterceptor
implements MethodInterceptor {
    public static final Class[] EXCEPTIONS_OF_INTEREST;
    private static Log logger;

    static {
        Class[] coreClasses = new Class[]{AuthenticationException.class, CheckOutCheckInServiceException.class, FileExistsException.class, IntegrityException.class, AccessDeniedException.class, NodeLockedException.class};
        ArrayList<Class> retryExceptions = new ArrayList<Class>();
        retryExceptions.addAll(Arrays.asList(coreClasses));
        EXCEPTIONS_OF_INTEREST = retryExceptions.toArray(new Class[0]);
        logger = LogFactory.getLog(AlfrescoCmisExceptionInterceptor.class);
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        try {
            return mi.proceed();
        }
        catch (Exception e) {
            Throwable cmisAffecting = ExceptionStackUtil.getCause((Throwable)e, (Class[])EXCEPTIONS_OF_INTEREST);
            if (cmisAffecting == null) {
                if (e instanceof CmisBaseException) {
                    throw (CmisBaseException)e;
                }
                throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
            }
            if (cmisAffecting instanceof AuthenticationException) {
                throw new CmisPermissionDeniedException(cmisAffecting.getMessage(), (Throwable)e);
            }
            if (cmisAffecting instanceof CheckOutCheckInServiceException) {
                throw new CmisVersioningException("Check out failed: " + cmisAffecting.getMessage(), (Throwable)e);
            }
            if (cmisAffecting instanceof FileExistsException) {
                throw new CmisContentAlreadyExistsException("An object with this name already exists: " + cmisAffecting.getMessage(), (Throwable)e);
            }
            if (cmisAffecting instanceof IntegrityException) {
                throw new CmisConstraintException("Constraint violation: " + cmisAffecting.getMessage(), (Throwable)e);
            }
            if (cmisAffecting instanceof AccessDeniedException) {
                throw new CmisPermissionDeniedException("Permission denied: " + cmisAffecting.getMessage(), (Throwable)e);
            }
            if (cmisAffecting instanceof NodeLockedException) {
                throw new CmisUpdateConflictException("Update conflict: " + cmisAffecting.getMessage(), (Throwable)e);
            }
            logger.error((Object)("Exception type not handled correctly: " + e.getClass().getName()));
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

