/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.List;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.HashEncodingArtefact;
import org.alfresco.repo.virtual.ref.HashStore;
import org.alfresco.repo.virtual.ref.NodeRefHasher;
import org.alfresco.repo.virtual.ref.NodeRefRadixHasher;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.PathHasher;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceEncodingException;
import org.alfresco.repo.virtual.ref.ReferenceParameter;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryPath;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.StoredPathHasher;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.alfresco.repo.virtual.ref.Stringifier;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;

public abstract class ProtocolHashStringifier
implements HashEncodingArtefact,
Stringifier {
    private static final long serialVersionUID = 6471653470842760043L;
    private NodeRefHasher nodeRefHasher = NodeRefRadixHasher.RADIX_36_HASHER;
    private PathHasher classpathHasher;
    private PathHasher repositoryPathHasher;
    private Stringifier referenceDispatcher;

    public ProtocolHashStringifier(HashStore classpathHashStore, Stringifier referenceDispatcher) {
        this.classpathHasher = new StoredPathHasher(classpathHashStore);
        this.repositoryPathHasher = new StoredPathHasher(classpathHashStore);
        this.referenceDispatcher = referenceDispatcher;
    }

    protected String dispatchStringifyReference(Reference reference) {
        return this.referenceDispatcher.stringify(reference);
    }

    @Override
    public String stringify(Resource resource) throws ReferenceEncodingException {
        return resource.stringify(this);
    }

    @Override
    public String stringifyResource(Resource resource) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown resource type " + String.valueOf(resource));
    }

    @Override
    public String stringifyResource(RepositoryResource resource) throws ReferenceEncodingException {
        RepositoryLocation location = resource.getLocation();
        return location.stringify(this);
    }

    @Override
    public String stringifyResource(ClasspathResource resource) throws ReferenceEncodingException {
        String cp = resource.getClasspath();
        Pair<String, String> hash = this.classpathHasher.hash(cp);
        String hashed = (String)hash.getFirst();
        String nonHashed = (String)hash.getSecond();
        if (nonHashed == null) {
            return "6-" + hashed;
        }
        if (hashed == null) {
            return "5-" + nonHashed;
        }
        return "7-" + hashed + "-" + nonHashed;
    }

    @Override
    public String stringify(RepositoryLocation repositoryLocation) throws ReferenceEncodingException {
        return repositoryLocation.stringify(this);
    }

    @Override
    public String stringifyRepositoryLocation(RepositoryLocation repositoryLocation) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown repository location  " + String.valueOf(repositoryLocation));
    }

    @Override
    public String stringifyRepositoryLocation(RepositoryNodeRef repositoryNodeRef) throws ReferenceEncodingException {
        NodeRef nodeRef = repositoryNodeRef.getNodeRef();
        Pair<String, String> hash = this.nodeRefHasher.hash(nodeRef);
        return "1-" + (String)hash.getFirst() + (String)hash.getSecond();
    }

    @Override
    public String stringifyRepositoryLocation(RepositoryPath repositoryPath) throws ReferenceEncodingException {
        String cp = repositoryPath.getPath();
        Pair<String, String> hash = this.repositoryPathHasher.hash(cp);
        String hashed = (String)hash.getFirst();
        String nonHashed = (String)hash.getSecond();
        if (nonHashed == null) {
            return "3-" + hashed;
        }
        if (hashed == null) {
            return "2-" + nonHashed;
        }
        return "4-" + hashed + "-" + nonHashed;
    }

    @Override
    public String stringify(List<Parameter> parameters) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Invalid stringifier cotext " + String.valueOf(parameters));
    }

    @Override
    public String stringify(Parameter parameter) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Invalid stringifier cotext " + String.valueOf(parameter));
    }

    @Override
    public String stringifyParameter(Parameter parameter) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Invalid stringifier cotext " + String.valueOf(parameter));
    }

    @Override
    public String stringifyParameter(ResourceParameter resourceParameter) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Invalid stringifier cotext " + String.valueOf(resourceParameter));
    }

    @Override
    public String stringifyParameter(StringParameter stringParameter) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Invalid stringifier cotext " + String.valueOf(stringParameter));
    }

    @Override
    public String stringifyParameter(ReferenceParameter referenceParameter) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Invalid stringifier cotext " + String.valueOf(referenceParameter));
    }
}

