/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remotecredentials;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.remotecredentials.OAuth1CredentialsInfoImpl;
import org.alfresco.repo.remotecredentials.OAuth2CredentialsInfoImpl;
import org.alfresco.repo.remotecredentials.PasswordCredentialsInfoImpl;
import org.alfresco.repo.remotecredentials.RemoteCredentialsInfoFactory;
import org.alfresco.repo.remotecredentials.RemoteCredentialsModel;
import org.alfresco.repo.remotecredentials.RemoteCredentialsServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.remotecredentials.BaseCredentialsInfo;
import org.alfresco.service.cmr.remotecredentials.RemoteCredentialsService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.alfresco.util.test.junitrules.WellKnownNodes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class RemoteCredentialsServicesTest {
    private static final String TEST_REMOTE_SYSTEM_ONE = "TestRemoteSystemOne";
    private static final String TEST_REMOTE_SYSTEM_TWO = "TestRemoteSystemTwo";
    private static final String TEST_REMOTE_SYSTEM_THREE = "aAaAaTestRemoteSystemThree";
    private static final String TEST_REMOTE_USERNAME_ONE = "test@example.com";
    private static final String TEST_REMOTE_USERNAME_TWO = "test2@example.com";
    private static final String TEST_REMOTE_USERNAME_THREE = "test3@example.com";
    private static final String SHARED_SYSTEM_CONTAINER_NAME = "test-remote-credentials";
    @ClassRule
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    @ClassRule
    public static WellKnownNodes knownNodes = new WellKnownNodes(APP_CONTEXT_INIT);
    @ClassRule
    public static TemporaryNodes classTestNodes = new TemporaryNodes(APP_CONTEXT_INIT);
    @Rule
    public TemporaryNodes testNodes = new TemporaryNodes(APP_CONTEXT_INIT);
    private static MutableAuthenticationService AUTHENTICATION_SERVICE;
    private static BehaviourFilter BEHAVIOUR_FILTER;
    private static RemoteCredentialsService REMOTE_CREDENTIALS_SERVICE;
    private static RemoteCredentialsService PRIVATE_REMOTE_CREDENTIALS_SERVICE;
    private static DictionaryService DICTIONARY_SERVICE;
    private static NodeService NODE_SERVICE;
    private static NodeService PUBLIC_NODE_SERVICE;
    private static NamespaceService NAMESPACE_SERVICE;
    private static Repository REPOSITORY_HELPER;
    private static PersonService PERSON_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static TransactionService TRANSACTION_SERVICE;
    private static PermissionService PERMISSION_SERVICE;
    private static final String TEST_USER_ONE;
    private static final String TEST_USER_TWO;
    private static final String TEST_USER_THREE;
    private static final String ADMIN_USER;

    static {
        TEST_USER_ONE = RemoteCredentialsServicesTest.class.getSimpleName() + "_testuser1";
        TEST_USER_TWO = RemoteCredentialsServicesTest.class.getSimpleName() + "_testuser2";
        TEST_USER_THREE = RemoteCredentialsServicesTest.class.getSimpleName() + "_testuser3";
        ADMIN_USER = AuthenticationUtil.getAdminUserName();
    }

    @BeforeClass
    public static void initTestsContext() throws Exception {
        ApplicationContext testContext = APP_CONTEXT_INIT.getApplicationContext();
        PRIVATE_REMOTE_CREDENTIALS_SERVICE = (RemoteCredentialsService)testContext.getBean("remoteCredentialsService");
        REMOTE_CREDENTIALS_SERVICE = (RemoteCredentialsService)testContext.getBean("RemoteCredentialsService");
        AUTHENTICATION_SERVICE = (MutableAuthenticationService)testContext.getBean("authenticationService");
        BEHAVIOUR_FILTER = (BehaviourFilter)testContext.getBean("policyBehaviourFilter");
        DICTIONARY_SERVICE = (DictionaryService)testContext.getBean("dictionaryService");
        NAMESPACE_SERVICE = (NamespaceService)testContext.getBean("namespaceService");
        REPOSITORY_HELPER = (Repository)testContext.getBean("repositoryHelper");
        NODE_SERVICE = (NodeService)testContext.getBean("nodeService");
        PUBLIC_NODE_SERVICE = (NodeService)testContext.getBean("NodeService");
        PERSON_SERVICE = (PersonService)testContext.getBean("personService");
        TRANSACTION_HELPER = (RetryingTransactionHelper)testContext.getBean("retryingTransactionHelper");
        TRANSACTION_SERVICE = (TransactionService)testContext.getBean("TransactionService");
        PERMISSION_SERVICE = (PermissionService)testContext.getBean("permissionService");
        RemoteCredentialsServiceImpl.setSharedCredentialsSystemContainerName((String)SHARED_SYSTEM_CONTAINER_NAME);
    }

    @Before
    public void setupUsers() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        RemoteCredentialsServicesTest.createUser(TEST_USER_ONE);
        RemoteCredentialsServicesTest.createUser(TEST_USER_TWO);
        RemoteCredentialsServicesTest.createUser(TEST_USER_THREE);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
    }

    @Test
    public void testSharedCredentialsContainer() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        NodeRef container = ((RemoteCredentialsServiceImpl)PRIVATE_REMOTE_CREDENTIALS_SERVICE).getSharedContainerNodeRef(false);
        if (container != null) {
            AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
            PUBLIC_NODE_SERVICE.deleteNode(container);
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        container = ((RemoteCredentialsServiceImpl)PRIVATE_REMOTE_CREDENTIALS_SERVICE).getSharedContainerNodeRef(false);
        Assert.assertEquals(null, (Object)container);
        PasswordCredentialsInfoImpl credentials = new PasswordCredentialsInfoImpl();
        REMOTE_CREDENTIALS_SERVICE.createSharedCredentials(TEST_REMOTE_SYSTEM_ONE, (BaseCredentialsInfo)credentials);
        container = ((RemoteCredentialsServiceImpl)PRIVATE_REMOTE_CREDENTIALS_SERVICE).getSharedContainerNodeRef(false);
        Assert.assertNotNull((Object)container);
        Set cAspects = PUBLIC_NODE_SERVICE.getAspects(container);
        Assert.assertEquals((String)("Aspect missing, found " + String.valueOf(cAspects)), (Object)true, (Object)cAspects.contains(RemoteCredentialsModel.ASPECT_REMOTE_CREDENTIALS_SYSTEM_CONTAINER));
        Assert.assertEquals((Object)SHARED_SYSTEM_CONTAINER_NAME, (Object)PUBLIC_NODE_SERVICE.getProperty(container, ContentModel.PROP_NAME));
        Assert.assertEquals((long)1L, (long)PUBLIC_NODE_SERVICE.getChildAssocs(container).size());
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        PUBLIC_NODE_SERVICE.deleteNode(container);
    }

    @Test
    public void testCreateCredentialsAndSystemListing() throws Exception {
        PagingResults systems = null;
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((String)("No systems should be found, got " + String.valueOf(systems.getPage())), (long)0L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((String)("No systems should be found, got " + String.valueOf(systems.getPage())), (long)0L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listAllRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((String)("No systems should be found, got " + String.valueOf(systems.getPage())), (long)0L, (long)systems.getPage().size());
        PasswordCredentialsInfoImpl credentials = new PasswordCredentialsInfoImpl();
        credentials.setRemoteUsername(TEST_REMOTE_USERNAME_ONE);
        REMOTE_CREDENTIALS_SERVICE.createPersonCredentials(TEST_REMOTE_SYSTEM_ONE, (BaseCredentialsInfo)credentials);
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((String)("Unexpected systems " + String.valueOf(systems.getPage())), (long)1L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((String)("Unexpected systems " + String.valueOf(systems.getPage())), (long)0L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listAllRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((String)("Unexpected systems " + String.valueOf(systems.getPage())), (long)1L, (long)systems.getPage().size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listAllRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)systems.getPage().size());
        credentials = new PasswordCredentialsInfoImpl();
        credentials.setRemoteUsername(TEST_REMOTE_USERNAME_TWO);
        REMOTE_CREDENTIALS_SERVICE.createPersonCredentials(TEST_REMOTE_SYSTEM_TWO, (BaseCredentialsInfo)credentials);
        credentials = new PasswordCredentialsInfoImpl();
        credentials.setRemoteUsername(TEST_REMOTE_USERNAME_THREE);
        REMOTE_CREDENTIALS_SERVICE.createPersonCredentials(TEST_REMOTE_SYSTEM_THREE, (BaseCredentialsInfo)credentials);
        credentials = new PasswordCredentialsInfoImpl();
        credentials.setRemoteUsername(TEST_REMOTE_USERNAME_THREE);
        BaseCredentialsInfo cc = REMOTE_CREDENTIALS_SERVICE.createSharedCredentials(TEST_REMOTE_SYSTEM_THREE, (BaseCredentialsInfo)credentials);
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listAllRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)systems.getPage().size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listAllRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)systems.getPage().size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        PERMISSION_SERVICE.setInheritParentPermissions(cc.getRemoteSystemContainerNodeRef(), false);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listAllRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)systems.getPage().size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listAllRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)systems.getPage().size());
        Assert.assertEquals((Object)true, (Object)systems.getPage().contains(TEST_REMOTE_SYSTEM_TWO));
        Assert.assertEquals((Object)true, (Object)systems.getPage().contains(TEST_REMOTE_SYSTEM_THREE));
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        Assert.assertEquals((Object)true, (Object)systems.getPage().contains(TEST_REMOTE_SYSTEM_THREE));
        systems = REMOTE_CREDENTIALS_SERVICE.listAllRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)systems.getPage().size());
        Assert.assertEquals((Object)true, (Object)systems.getPage().contains(TEST_REMOTE_SYSTEM_TWO));
        Assert.assertEquals((Object)true, (Object)systems.getPage().contains(TEST_REMOTE_SYSTEM_THREE));
    }

    @Test
    public void testPersonCredentialsCRUD() throws Exception {
        PagingResults systems = null;
        PagingResults creds = null;
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((String)("No systems should be found, got " + String.valueOf(systems.getPage())), (long)0L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((String)("No systems should be found, got " + String.valueOf(systems.getPage())), (long)0L, (long)systems.getPage().size());
        PasswordCredentialsInfoImpl pwCred = new PasswordCredentialsInfoImpl();
        pwCred.setRemoteUsername(TEST_REMOTE_USERNAME_ONE);
        BaseCredentialsInfo credentials = REMOTE_CREDENTIALS_SERVICE.createPersonCredentials(TEST_REMOTE_SYSTEM_ONE, (BaseCredentialsInfo)pwCred);
        Assert.assertNotNull((Object)credentials);
        Assert.assertNotNull((Object)credentials.getNodeRef());
        Assert.assertNotNull((Object)credentials.getRemoteSystemContainerNodeRef());
        Assert.assertEquals((Object)TEST_REMOTE_SYSTEM_ONE, (Object)credentials.getRemoteSystemName());
        Assert.assertEquals((Object)TEST_REMOTE_USERNAME_ONE, (Object)credentials.getRemoteUsername());
        Assert.assertEquals((Object)RemoteCredentialsModel.TYPE_PASSWORD_CREDENTIALS, (Object)credentials.getCredentialsType());
        credentials = REMOTE_CREDENTIALS_SERVICE.getPersonCredentials(TEST_REMOTE_SYSTEM_ONE);
        Assert.assertNotNull((Object)credentials);
        Assert.assertNotNull((Object)credentials.getNodeRef());
        Assert.assertNotNull((Object)credentials.getRemoteSystemContainerNodeRef());
        Assert.assertEquals((Object)TEST_REMOTE_SYSTEM_ONE, (Object)credentials.getRemoteSystemName());
        Assert.assertEquals((Object)TEST_REMOTE_USERNAME_ONE, (Object)credentials.getRemoteUsername());
        Assert.assertEquals((Object)RemoteCredentialsModel.TYPE_PASSWORD_CREDENTIALS, (Object)credentials.getCredentialsType());
        credentials = REMOTE_CREDENTIALS_SERVICE.getPersonCredentials(TEST_REMOTE_SYSTEM_TWO);
        Assert.assertEquals(null, (Object)credentials);
        credentials = REMOTE_CREDENTIALS_SERVICE.getPersonCredentials(TEST_REMOTE_SYSTEM_THREE);
        Assert.assertEquals(null, (Object)credentials);
        credentials = REMOTE_CREDENTIALS_SERVICE.getPersonCredentials(TEST_REMOTE_SYSTEM_ONE);
        Assert.assertEquals(PasswordCredentialsInfoImpl.class, credentials.getClass());
        pwCred = (PasswordCredentialsInfoImpl)credentials;
        pwCred.setRemoteUsername(TEST_REMOTE_USERNAME_TWO);
        pwCred.setRemotePassword("testing");
        credentials = REMOTE_CREDENTIALS_SERVICE.updateCredentials((BaseCredentialsInfo)pwCred);
        Assert.assertNotNull((Object)credentials);
        Assert.assertEquals((Object)TEST_REMOTE_USERNAME_TWO, (Object)credentials.getRemoteUsername());
        pwCred = (PasswordCredentialsInfoImpl)REMOTE_CREDENTIALS_SERVICE.getPersonCredentials(TEST_REMOTE_SYSTEM_ONE);
        Assert.assertNotNull((Object)pwCred);
        Assert.assertEquals((Object)TEST_REMOTE_USERNAME_TWO, (Object)pwCred.getRemoteUsername());
        Assert.assertEquals((Object)"testing", (Object)pwCred.getRemotePassword());
        credentials = REMOTE_CREDENTIALS_SERVICE.getPersonCredentials(TEST_REMOTE_SYSTEM_ONE);
        Assert.assertEquals((Object)true, (Object)credentials.getLastAuthenticationSucceeded());
        credentials = REMOTE_CREDENTIALS_SERVICE.updateCredentialsAuthenticationSucceeded(true, credentials);
        Assert.assertEquals((Object)true, (Object)credentials.getLastAuthenticationSucceeded());
        credentials = REMOTE_CREDENTIALS_SERVICE.getPersonCredentials(TEST_REMOTE_SYSTEM_ONE);
        Assert.assertEquals((Object)true, (Object)credentials.getLastAuthenticationSucceeded());
        credentials = REMOTE_CREDENTIALS_SERVICE.updateCredentialsAuthenticationSucceeded(false, credentials);
        Assert.assertEquals((Object)false, (Object)credentials.getLastAuthenticationSucceeded());
        credentials = REMOTE_CREDENTIALS_SERVICE.getPersonCredentials(TEST_REMOTE_SYSTEM_ONE);
        Assert.assertEquals((Object)false, (Object)credentials.getLastAuthenticationSucceeded());
        credentials = REMOTE_CREDENTIALS_SERVICE.updateCredentialsAuthenticationSucceeded(true, credentials);
        Assert.assertEquals((Object)true, (Object)credentials.getLastAuthenticationSucceeded());
        credentials = REMOTE_CREDENTIALS_SERVICE.getPersonCredentials(TEST_REMOTE_SYSTEM_ONE);
        Assert.assertEquals((Object)true, (Object)credentials.getLastAuthenticationSucceeded());
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listAllRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listPersonCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        Assert.assertEquals((Object)TEST_REMOTE_USERNAME_TWO, (Object)((BaseCredentialsInfo)creds.getPage().get(0)).getRemoteUsername());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listAllCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        Assert.assertEquals((Object)TEST_REMOTE_USERNAME_TWO, (Object)((BaseCredentialsInfo)creds.getPage().get(0)).getRemoteUsername());
        REMOTE_CREDENTIALS_SERVICE.deleteCredentials(credentials);
        credentials = REMOTE_CREDENTIALS_SERVICE.getPersonCredentials(TEST_REMOTE_SYSTEM_ONE);
        Assert.assertEquals(null, (Object)credentials);
        creds = REMOTE_CREDENTIALS_SERVICE.listPersonCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listAllCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)creds.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listAllRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        pwCred = new PasswordCredentialsInfoImpl();
        pwCred.setRemoteUsername(TEST_REMOTE_USERNAME_ONE);
        REMOTE_CREDENTIALS_SERVICE.createPersonCredentials(TEST_REMOTE_SYSTEM_TWO, (BaseCredentialsInfo)pwCred);
        OAuth1CredentialsInfoImpl oa1Cred = new OAuth1CredentialsInfoImpl();
        oa1Cred.setRemoteUsername(TEST_REMOTE_USERNAME_TWO);
        oa1Cred.setOAuthToken("test");
        REMOTE_CREDENTIALS_SERVICE.createPersonCredentials(TEST_REMOTE_SYSTEM_TWO, (BaseCredentialsInfo)oa1Cred);
        OAuth2CredentialsInfoImpl oa2Cred = new OAuth2CredentialsInfoImpl();
        oa2Cred.setRemoteUsername(TEST_REMOTE_USERNAME_THREE);
        oa2Cred.setOauthAccessToken("testA");
        oa2Cred.setOauthRefreshToken("testR");
        REMOTE_CREDENTIALS_SERVICE.createPersonCredentials(TEST_REMOTE_SYSTEM_TWO, (BaseCredentialsInfo)oa2Cred);
        creds = REMOTE_CREDENTIALS_SERVICE.listPersonCredentials(TEST_REMOTE_SYSTEM_TWO, null, new PagingRequest(10));
        Assert.assertEquals((long)3L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_TWO, null, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listAllCredentials(TEST_REMOTE_SYSTEM_TWO, null, new PagingRequest(10));
        Assert.assertEquals((long)3L, (long)creds.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listAllRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)systems.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listPersonCredentials(TEST_REMOTE_SYSTEM_TWO, null, new PagingRequest(10));
        Assert.assertEquals((long)3L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listPersonCredentials(TEST_REMOTE_SYSTEM_TWO, RemoteCredentialsModel.TYPE_PASSWORD_CREDENTIALS, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        Assert.assertEquals((Object)TEST_REMOTE_USERNAME_ONE, (Object)((BaseCredentialsInfo)creds.getPage().get(0)).getRemoteUsername());
        creds = REMOTE_CREDENTIALS_SERVICE.listPersonCredentials(TEST_REMOTE_SYSTEM_TWO, RemoteCredentialsModel.TYPE_OAUTH1_CREDENTIALS, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        Assert.assertEquals((Object)TEST_REMOTE_USERNAME_TWO, (Object)((BaseCredentialsInfo)creds.getPage().get(0)).getRemoteUsername());
        creds = REMOTE_CREDENTIALS_SERVICE.listPersonCredentials(TEST_REMOTE_SYSTEM_TWO, RemoteCredentialsModel.TYPE_OAUTH2_CREDENTIALS, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        Assert.assertEquals((Object)TEST_REMOTE_USERNAME_THREE, (Object)((BaseCredentialsInfo)creds.getPage().get(0)).getRemoteUsername());
    }

    @Test
    public void testSharedCredentialsCRUD() throws Exception {
        PagingResults systems = null;
        PagingResults creds = null;
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((String)("No systems should be found, got " + String.valueOf(systems.getPage())), (long)0L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((String)("No systems should be found, got " + String.valueOf(systems.getPage())), (long)0L, (long)systems.getPage().size());
        PasswordCredentialsInfoImpl pwCred = new PasswordCredentialsInfoImpl();
        pwCred.setRemoteUsername(TEST_REMOTE_USERNAME_ONE);
        BaseCredentialsInfo credentials = REMOTE_CREDENTIALS_SERVICE.createSharedCredentials(TEST_REMOTE_SYSTEM_ONE, (BaseCredentialsInfo)pwCred);
        Assert.assertNotNull((Object)credentials);
        Assert.assertNotNull((Object)credentials.getNodeRef());
        Assert.assertNotNull((Object)credentials.getRemoteSystemContainerNodeRef());
        Assert.assertEquals((Object)TEST_REMOTE_SYSTEM_ONE, (Object)credentials.getRemoteSystemName());
        Assert.assertEquals((Object)TEST_REMOTE_USERNAME_ONE, (Object)credentials.getRemoteUsername());
        Assert.assertEquals((Object)RemoteCredentialsModel.TYPE_PASSWORD_CREDENTIALS, (Object)credentials.getCredentialsType());
        pwCred = (PasswordCredentialsInfoImpl)credentials;
        pwCred.setRemoteUsername(TEST_REMOTE_USERNAME_TWO);
        credentials = REMOTE_CREDENTIALS_SERVICE.updateCredentials((BaseCredentialsInfo)pwCred);
        Assert.assertNotNull((Object)credentials);
        Assert.assertNotNull((Object)credentials.getNodeRef());
        Assert.assertNotNull((Object)credentials.getRemoteSystemContainerNodeRef());
        Assert.assertEquals((Object)TEST_REMOTE_SYSTEM_ONE, (Object)credentials.getRemoteSystemName());
        Assert.assertEquals((Object)TEST_REMOTE_USERNAME_TWO, (Object)credentials.getRemoteUsername());
        Assert.assertEquals((Object)RemoteCredentialsModel.TYPE_PASSWORD_CREDENTIALS, (Object)credentials.getCredentialsType());
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listAllRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listPersonCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        Assert.assertEquals((Object)TEST_REMOTE_USERNAME_TWO, (Object)((BaseCredentialsInfo)creds.getPage().get(0)).getRemoteUsername());
        creds = REMOTE_CREDENTIALS_SERVICE.listAllCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        Assert.assertEquals((Object)TEST_REMOTE_USERNAME_TWO, (Object)((BaseCredentialsInfo)creds.getPage().get(0)).getRemoteUsername());
        REMOTE_CREDENTIALS_SERVICE.deleteCredentials(credentials);
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listAllRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listPersonCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listAllCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)creds.getPage().size());
    }

    @Test
    public void testListingPermissionsAndPaging() throws Exception {
        PagingResults systems = null;
        PagingResults creds = null;
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((String)("No systems should be found, got " + String.valueOf(systems.getPage())), (long)0L, (long)systems.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((String)("No systems should be found, got " + String.valueOf(systems.getPage())), (long)0L, (long)systems.getPage().size());
        PasswordCredentialsInfoImpl pwCred = new PasswordCredentialsInfoImpl();
        pwCred.setRemoteUsername(TEST_REMOTE_USERNAME_ONE);
        REMOTE_CREDENTIALS_SERVICE.createSharedCredentials(TEST_REMOTE_SYSTEM_ONE, (BaseCredentialsInfo)pwCred);
        pwCred = new PasswordCredentialsInfoImpl();
        pwCred.setRemoteUsername(TEST_REMOTE_USERNAME_TWO);
        REMOTE_CREDENTIALS_SERVICE.createSharedCredentials(TEST_REMOTE_SYSTEM_ONE, (BaseCredentialsInfo)pwCred);
        pwCred = new PasswordCredentialsInfoImpl();
        pwCred.setRemoteUsername(TEST_REMOTE_USERNAME_TWO);
        REMOTE_CREDENTIALS_SERVICE.createSharedCredentials(TEST_REMOTE_SYSTEM_TWO, (BaseCredentialsInfo)pwCred);
        pwCred = new PasswordCredentialsInfoImpl();
        pwCred.setRemoteUsername(TEST_REMOTE_USERNAME_TWO);
        REMOTE_CREDENTIALS_SERVICE.createPersonCredentials(TEST_REMOTE_SYSTEM_TWO, (BaseCredentialsInfo)pwCred);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        pwCred = new PasswordCredentialsInfoImpl();
        pwCred.setRemoteUsername(TEST_REMOTE_USERNAME_TWO);
        REMOTE_CREDENTIALS_SERVICE.createSharedCredentials(TEST_REMOTE_SYSTEM_TWO, (BaseCredentialsInfo)pwCred);
        pwCred = new PasswordCredentialsInfoImpl();
        pwCred.setRemoteUsername(TEST_REMOTE_USERNAME_THREE);
        REMOTE_CREDENTIALS_SERVICE.createSharedCredentials(TEST_REMOTE_SYSTEM_THREE, (BaseCredentialsInfo)pwCred);
        pwCred = new PasswordCredentialsInfoImpl();
        pwCred.setRemoteUsername(TEST_REMOTE_USERNAME_THREE);
        REMOTE_CREDENTIALS_SERVICE.createPersonCredentials(TEST_REMOTE_SYSTEM_THREE, (BaseCredentialsInfo)pwCred);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        Assert.assertEquals((Object)TEST_REMOTE_SYSTEM_TWO, systems.getPage().get(0));
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        systems = REMOTE_CREDENTIALS_SERVICE.listPersonRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        Assert.assertEquals((Object)TEST_REMOTE_SYSTEM_THREE, systems.getPage().get(0));
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)3L, (long)systems.getPage().size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)3L, (long)systems.getPage().size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        creds = REMOTE_CREDENTIALS_SERVICE.listPersonCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listPersonCredentials(TEST_REMOTE_SYSTEM_TWO, null, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        Assert.assertEquals((Object)TEST_REMOTE_SYSTEM_TWO, (Object)((BaseCredentialsInfo)creds.getPage().get(0)).getRemoteSystemName());
        creds = REMOTE_CREDENTIALS_SERVICE.listPersonCredentials(TEST_REMOTE_SYSTEM_THREE, null, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)creds.getPage().size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        creds = REMOTE_CREDENTIALS_SERVICE.listPersonCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listPersonCredentials(TEST_REMOTE_SYSTEM_TWO, null, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listPersonCredentials(TEST_REMOTE_SYSTEM_THREE, null, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        Assert.assertEquals((Object)TEST_REMOTE_SYSTEM_THREE, (Object)((BaseCredentialsInfo)creds.getPage().get(0)).getRemoteSystemName());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_TWO, null, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_THREE, null, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_TWO, null, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_THREE, null, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(10));
        Assert.assertEquals((long)3L, (long)systems.getPage().size());
        Assert.assertEquals((Object)false, (Object)systems.hasMoreItems());
        Assert.assertEquals((long)3L, (long)((Integer)systems.getTotalResultCount().getFirst()).intValue());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(1));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        Assert.assertEquals((Object)true, (Object)systems.hasMoreItems());
        Assert.assertEquals((long)3L, (long)((Integer)systems.getTotalResultCount().getFirst()).intValue());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(1, 2));
        Assert.assertEquals((long)2L, (long)systems.getPage().size());
        Assert.assertEquals((Object)false, (Object)systems.hasMoreItems());
        Assert.assertEquals((long)3L, (long)((Integer)systems.getTotalResultCount().getFirst()).intValue());
        systems = REMOTE_CREDENTIALS_SERVICE.listSharedRemoteSystems(new PagingRequest(2, 2));
        Assert.assertEquals((long)1L, (long)systems.getPage().size());
        Assert.assertEquals((Object)false, (Object)systems.hasMoreItems());
        Assert.assertEquals((long)3L, (long)((Integer)systems.getTotalResultCount().getFirst()).intValue());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)creds.getPage().size());
        Assert.assertEquals((Object)false, (Object)creds.hasMoreItems());
        Assert.assertEquals((long)2L, (long)((Integer)creds.getTotalResultCount().getFirst()).intValue());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(1));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        Assert.assertEquals((Object)true, (Object)creds.hasMoreItems());
        Assert.assertEquals((long)2L, (long)((Integer)creds.getTotalResultCount().getFirst()).intValue());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(1, 1));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        Assert.assertEquals((Object)false, (Object)creds.hasMoreItems());
        Assert.assertEquals((long)2L, (long)((Integer)creds.getTotalResultCount().getFirst()).intValue());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_TWO, null, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_THREE, null, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(1));
        NodeRef sharedS1 = ((BaseCredentialsInfo)creds.getPage().get(0)).getRemoteSystemContainerNodeRef();
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_TWO, null, new PagingRequest(1));
        NodeRef sharedS2 = ((BaseCredentialsInfo)creds.getPage().get(0)).getRemoteSystemContainerNodeRef();
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        PERMISSION_SERVICE.setInheritParentPermissions(sharedS1, false);
        PERMISSION_SERVICE.setInheritParentPermissions(sharedS2, false);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_TWO, null, new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_THREE, null, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_ONE, null, new PagingRequest(10));
        Assert.assertEquals((long)2L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_TWO, null, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
        creds = REMOTE_CREDENTIALS_SERVICE.listSharedCredentials(TEST_REMOTE_SYSTEM_THREE, null, new PagingRequest(10));
        Assert.assertEquals((long)1L, (long)creds.getPage().size());
    }

    @Test
    public void testRealSharedCredentialsContainer() throws Exception {
        RemoteCredentialsServiceImpl realService = new RemoteCredentialsServiceImpl();
        realService.setDictionaryService(DICTIONARY_SERVICE);
        realService.setNamespaceService(NAMESPACE_SERVICE);
        realService.setNodeService(PUBLIC_NODE_SERVICE);
        realService.setRepositoryHelper(REPOSITORY_HELPER);
        for (Map.Entry e : ((RemoteCredentialsServiceImpl)PRIVATE_REMOTE_CREDENTIALS_SERVICE).getCredentialsFactories().entrySet()) {
            realService.registerCredentialsFactory((QName)e.getKey(), (RemoteCredentialsInfoFactory)e.getValue());
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        PasswordCredentialsInfoImpl pwCredI = new PasswordCredentialsInfoImpl();
        pwCredI.setRemoteUsername(TEST_REMOTE_USERNAME_ONE);
        pwCredI.setRemotePassword(TEST_USER_THREE);
        BaseCredentialsInfo credentials = null;
        try {
            credentials = realService.createSharedCredentials(TEST_REMOTE_SYSTEM_ONE, (BaseCredentialsInfo)pwCredI);
            Assert.assertEquals((Object)TEST_REMOTE_USERNAME_ONE, (Object)credentials.getRemoteUsername());
            ((PasswordCredentialsInfoImpl)credentials).setRemoteUsername(TEST_REMOTE_USERNAME_TWO);
            ((PasswordCredentialsInfoImpl)credentials).setRemotePassword(TEST_USER_ONE);
            credentials = realService.updateCredentials(credentials);
            Assert.assertEquals((Object)TEST_REMOTE_USERNAME_TWO, (Object)credentials.getRemoteUsername());
            realService.deleteCredentials(credentials);
            PUBLIC_NODE_SERVICE.deleteNode(credentials.getRemoteSystemContainerNodeRef());
            credentials = null;
        }
        finally {
            if (credentials != null) {
                AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
                PUBLIC_NODE_SERVICE.deleteNode(credentials.getNodeRef());
                PUBLIC_NODE_SERVICE.deleteNode(credentials.getRemoteSystemContainerNodeRef());
            }
        }
    }

    @Before
    public void setAdminUser() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
    }

    @After
    public void deleteTestNodes() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        NodeRef container = ((RemoteCredentialsServiceImpl)PRIVATE_REMOTE_CREDENTIALS_SERVICE).getSharedContainerNodeRef(false);
        if (container != null) {
            ArrayList<NodeRef> children = new ArrayList<NodeRef>();
            for (ChildAssociationRef child : PUBLIC_NODE_SERVICE.getChildAssocs(container)) {
                children.add(child.getChildRef());
            }
            RemoteCredentialsServicesTest.performDeletionOfNodes(children);
        }
        RemoteCredentialsServicesTest.deleteUser(TEST_USER_ONE);
        RemoteCredentialsServicesTest.deleteUser(TEST_USER_TWO);
        RemoteCredentialsServicesTest.deleteUser(TEST_USER_THREE);
    }

    @AfterClass
    public static void remoteTestSharedCredentialsContainer() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        NodeRef container = ((RemoteCredentialsServiceImpl)PRIVATE_REMOTE_CREDENTIALS_SERVICE).getSharedContainerNodeRef(false);
        if (container != null) {
            RemoteCredentialsServicesTest.performDeletionOfNodes(Collections.singletonList(container));
        }
    }

    private static void performDeletionOfNodes(final List<NodeRef> nodesToDelete) {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                for (NodeRef node : nodesToDelete) {
                    if (!NODE_SERVICE.exists(node)) continue;
                    NODE_SERVICE.deleteNode(node);
                }
                return null;
            }
        });
    }

    private static void createUser(final String userName) {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (!AUTHENTICATION_SERVICE.authenticationExists(userName)) {
                    AUTHENTICATION_SERVICE.createAuthentication(userName, "PWD".toCharArray());
                }
                if (!PERSON_SERVICE.personExists(userName)) {
                    PropertyMap ppOne = new PropertyMap();
                    ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
                    ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
                    ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
                    ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
                    ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
                    PERSON_SERVICE.createPerson((Map)ppOne);
                }
                return null;
            }
        });
    }

    private static void deleteUser(final String userName) {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (PERSON_SERVICE.personExists(userName)) {
                    PERSON_SERVICE.deletePerson(userName);
                }
                return null;
            }
        });
    }
}

