/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ScriptableHashMap;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.UserNameGenerator;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.security.person.PersonServiceImpl;
import org.alfresco.repo.security.sync.UserRegistrySynchronizer;
import org.alfresco.repo.tenant.TenantDomainMismatchException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.usage.ContentUsageService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.ScriptPagingDetails;
import org.alfresco.util.ValueDerivingMapFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ParameterCheck;

public class People
extends BaseScopableProcessorExtension
implements InitializingBean {
    private static Log logger = LogFactory.getLog(People.class);
    private ServiceRegistry services;
    private AuthorityDAO authorityDAO;
    private AuthorityService authorityService;
    private PersonService personService;
    private MutableAuthenticationService authenticationService;
    private ContentUsageService contentUsageService;
    private UserNameGenerator usernameGenerator;
    private UserRegistrySynchronizer userRegistrySynchronizer;
    protected TenantService tenantService;
    private StoreRef storeRef;
    private ValueDerivingMapFactory<ScriptNode, String, Boolean> valueDerivingMapFactory;
    private int numRetries = 10;
    private int defaultListMaxResults = 5000;
    private boolean honorHintUseCQ = true;
    protected static final String HINT_CQ_SUFFIX = " [hint:useCQ]";

    public void afterPropertiesSet() throws Exception {
        HashMap<String, ValueDerivingMapFactory.ValueDeriver<ScriptNode, Boolean>> capabilityTesters = new HashMap<String, ValueDerivingMapFactory.ValueDeriver<ScriptNode, Boolean>>(5);
        capabilityTesters.put("isAdmin", new ValueDerivingMapFactory.ValueDeriver<ScriptNode, Boolean>(){

            @Override
            public Boolean deriveValue(ScriptNode source) {
                return People.this.isAdmin(source);
            }
        });
        capabilityTesters.put("isGuest", new ValueDerivingMapFactory.ValueDeriver<ScriptNode, Boolean>(){

            @Override
            public Boolean deriveValue(ScriptNode source) {
                return People.this.isGuest(source);
            }
        });
        capabilityTesters.put("isMutable", new ValueDerivingMapFactory.ValueDeriver<ScriptNode, Boolean>(){

            @Override
            public Boolean deriveValue(ScriptNode source) {
                String sourceUser = (String)source.getProperties().get(ContentModel.PROP_USERNAME);
                if (!People.this.authenticationService.isAuthenticationMutable(sourceUser)) {
                    return false;
                }
                String currentUser = People.this.authenticationService.getCurrentUserName();
                if (currentUser.equals(sourceUser) || People.this.authorityService.isAdminAuthority(currentUser)) {
                    return true;
                }
                return false;
            }
        });
        this.valueDerivingMapFactory = new ValueDerivingMapFactory(capabilityTesters);
    }

    public void setStoreUrl(String storeRef) {
        if (this.storeRef != null) {
            throw new IllegalStateException("Default store URL can only be set once.");
        }
        this.storeRef = new StoreRef(storeRef);
    }

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.services = serviceRegistry;
    }

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setContentUsageService(ContentUsageService contentUsageService) {
        this.contentUsageService = contentUsageService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setUserNameGenerator(UserNameGenerator userNameGenerator) {
        this.usernameGenerator = userNameGenerator;
    }

    public void setUserRegistrySynchronizer(UserRegistrySynchronizer userRegistrySynchronizer) {
        this.userRegistrySynchronizer = userRegistrySynchronizer;
    }

    public void setDefaultListMaxResults(int defaultListMaxResults) {
        this.defaultListMaxResults = defaultListMaxResults;
    }

    public void setHonorHintUseCQ(boolean honorHintUseCQ) {
        this.honorHintUseCQ = honorHintUseCQ;
    }

    public void deletePerson(String username) {
        this.personService.deletePerson(username);
    }

    public ScriptNode createPerson(String userName, String firstName, String lastName, String emailAddress, String password, boolean setAccountEnabled) {
        return this.createPerson(userName, firstName, lastName, emailAddress, password, setAccountEnabled, false);
    }

    public ScriptNode createPerson(String userName, String firstName, String lastName, String emailAddress, String password, boolean setAccountEnabled, boolean notifyByEmail) {
        ParameterCheck.mandatory((String)"firstName", (Object)firstName);
        ParameterCheck.mandatory((String)"emailAddress", (Object)emailAddress);
        ScriptNode person = null;
        if (userName == null) {
            int i = 0;
            while (i < this.numRetries) {
                userName = this.usernameGenerator.generateUserName(firstName, lastName, emailAddress, i);
                if (!this.personService.personExists(userName)) break;
                ++i;
            }
        }
        if (userName != null) {
            try {
                userName = PersonServiceImpl.updateUsernameForTenancy(userName, this.tenantService);
            }
            catch (TenantDomainMismatchException re) {
                throw new AuthenticationException("User must belong to same domain as admin: " + re.getTenantA());
            }
            person = this.createPerson(userName, firstName, lastName, emailAddress);
            if (person != null && password != null) {
                this.authenticationService.createAuthentication(userName, password.toCharArray());
                this.authenticationService.setAuthenticationEnabled(userName, setAccountEnabled);
                person.save();
                if (notifyByEmail) {
                    this.personService.notifyPerson(userName, password);
                }
            }
        }
        return person;
    }

    public void enableAccount(String userName) {
        if (this.authorityService.isAdminAuthority(AuthenticationUtil.getFullyAuthenticatedUser())) {
            this.authenticationService.setAuthenticationEnabled(userName, true);
        }
    }

    public void disableAccount(String userName) {
        if (this.authorityService.isAdminAuthority(AuthenticationUtil.getFullyAuthenticatedUser())) {
            this.authenticationService.setAuthenticationEnabled(userName, false);
        }
    }

    public boolean isAccountEnabled(String userName) {
        return this.authenticationService.getAuthenticationEnabled(userName);
    }

    public void changePassword(String oldPassword, String newPassword) {
        ParameterCheck.mandatoryString((String)"oldPassword", (String)oldPassword);
        ParameterCheck.mandatoryString((String)"newPassword", (String)newPassword);
        this.services.getAuthenticationService().updateAuthentication(AuthenticationUtil.getFullyAuthenticatedUser(), oldPassword.toCharArray(), newPassword.toCharArray());
    }

    public void setPassword(String userName, String password) {
        ParameterCheck.mandatoryString((String)"userName", (String)userName);
        ParameterCheck.mandatoryString((String)"password", (String)password);
        MutableAuthenticationService authService = this.services.getAuthenticationService();
        if (this.authorityService.hasAdminAuthority() && !userName.equalsIgnoreCase(authService.getCurrentUserName())) {
            authService.setAuthentication(userName, password.toCharArray());
        }
    }

    public ScriptNode createPerson(String userName) {
        ParameterCheck.mandatoryString((String)"userName", (String)userName);
        ScriptNode person = null;
        PropertyMap properties = new PropertyMap();
        properties.put(ContentModel.PROP_USERNAME, userName);
        if (!this.personService.personExists(userName)) {
            NodeRef personRef = this.personService.createPerson(properties);
            person = new ScriptNode(personRef, this.services, this.getScope());
        }
        return person;
    }

    public ScriptNode createPerson(String userName, String firstName, String lastName, String emailAddress) {
        ParameterCheck.mandatoryString((String)"userName", (String)userName);
        ParameterCheck.mandatoryString((String)"firstName", (String)firstName);
        ParameterCheck.mandatoryString((String)"emailAddress", (String)emailAddress);
        ScriptNode person = null;
        PropertyMap properties = new PropertyMap();
        properties.put(ContentModel.PROP_USERNAME, userName);
        properties.put(ContentModel.PROP_FIRSTNAME, firstName);
        properties.put(ContentModel.PROP_LASTNAME, lastName);
        properties.put(ContentModel.PROP_EMAIL, emailAddress);
        if (!this.personService.personExists(userName)) {
            NodeRef personRef = this.personService.createPerson(properties);
            person = new ScriptNode(personRef, this.services, this.getScope());
        }
        return person;
    }

    public void setQuota(ScriptNode person, String quota) {
        if (this.authorityService.isAdminAuthority(AuthenticationUtil.getFullyAuthenticatedUser())) {
            this.contentUsageService.setUserQuota((String)person.getProperties().get(ContentModel.PROP_USERNAME), Long.parseLong(quota));
        }
    }

    public Scriptable getPeople(String filter) {
        return this.getPeople(filter, 0);
    }

    public Scriptable getPeople(String filter, int maxResults) {
        return this.getPeople(filter, maxResults, null, true);
    }

    public Scriptable getPeople(String filter, int maxResults, String sortBy, boolean sortAsc) {
        return this.getPeoplePaging(filter, new ScriptPagingDetails(maxResults, 0), sortBy, sortAsc);
    }

    public Scriptable getPeoplePaging(String filter, ScriptPagingDetails pagingRequest, String sortBy, Boolean sortAsc) {
        List<PersonService.PersonInfo> persons = this.getPeopleImpl(filter, pagingRequest, sortBy, sortAsc);
        Object[] peopleRefs = new Object[persons.size()];
        int i = 0;
        while (i < peopleRefs.length) {
            peopleRefs[i] = persons.get(i).getNodeRef();
            ++i;
        }
        return Context.getCurrentContext().newArray(this.getScope(), peopleRefs);
    }

    protected List<PersonService.PersonInfo> getPeopleImpl(String filter, ScriptPagingDetails pagingRequest, String sortBy, Boolean sortAsc) {
        List<Object> persons;
        block10: {
            ParameterCheck.mandatory((String)"pagingRequest", (Object)((Object)pagingRequest));
            boolean useCQ = false;
            if (filter != null) {
                if (filter.endsWith(HINT_CQ_SUFFIX)) {
                    useCQ = this.honorHintUseCQ;
                    filter = filter.substring(0, filter.length() - HINT_CQ_SUFFIX.length());
                }
            } else {
                filter = "*";
            }
            persons = null;
            int maxResults = pagingRequest.getMaxItems();
            if (maxResults <= 0 || maxResults > this.defaultListMaxResults) {
                maxResults = this.defaultListMaxResults;
                pagingRequest.setMaxItems(maxResults);
            }
            if (filter == null || filter.trim().isEmpty() || useCQ) {
                persons = this.getPeopleImplDB(filter, pagingRequest, sortBy, sortAsc);
            } else {
                filter = filter.trim();
                String term = filter.replace("\"", "");
                String[] tokens = term.split("(?<!\\\\) ");
                int propIndex = term.lastIndexOf(58);
                int wildPosition = term.indexOf(42);
                useCQ = tokens.length == 1 && propIndex == -1 && (wildPosition == -1 || wildPosition == term.length() - 1);
                try {
                    List<NodeRef> personRefs = this.getPeopleImplSearch(term, tokens, pagingRequest, sortBy, sortAsc);
                    if (personRefs != null) {
                        persons = new ArrayList(personRefs.size());
                        for (NodeRef personRef : personRefs) {
                            persons.add(this.personService.getPerson(personRef));
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!useCQ) break block10;
                    persons = this.getPeopleImplDB(filter, pagingRequest, sortBy, sortAsc);
                }
            }
        }
        return persons != null ? persons : new ArrayList(0);
    }

    protected List<PersonService.PersonInfo> getPeopleImplDB(String filter, ScriptPagingDetails pagingRequest, String sortBy, Boolean sortAsc) {
        ArrayList<QName> filterProps = null;
        if (filter != null && filter.length() > 0 && !(filter = filter.trim()).equals("*")) {
            filter = filter.replace("\\", "").replace("\"", "");
            filterProps = new ArrayList<QName>(3);
            filterProps.add(ContentModel.PROP_FIRSTNAME);
            filterProps.add(ContentModel.PROP_LASTNAME);
            filterProps.add(ContentModel.PROP_USERNAME);
        }
        ArrayList<Pair<QName, Boolean>> sort = new ArrayList<Pair<QName, Boolean>>();
        if ("lastName".equals(sortBy)) {
            sort.add(new Pair((Object)ContentModel.PROP_LASTNAME, (Object)sortAsc));
            sort.add(new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)sortAsc));
            sort.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)sortAsc));
        } else if ("firstName".equals(sortBy)) {
            sort.add(new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)sortAsc));
            sort.add(new Pair((Object)ContentModel.PROP_LASTNAME, (Object)sortAsc));
            sort.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)sortAsc));
        } else {
            sort.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)sortAsc));
            sort.add(new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)sortAsc));
            sort.add(new Pair((Object)ContentModel.PROP_LASTNAME, (Object)sortAsc));
        }
        return this.personService.getPeople(filter, filterProps, sort, (PagingRequest)pagingRequest).getPage();
    }

    protected List<NodeRef> getPeopleImplSearch(String term, String[] tokens, ScriptPagingDetails pagingRequest, String sortBy, Boolean sortAsc) throws Throwable {
        List<NodeRef> personRefs = null;
        Long start = logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        int propIndex = term.indexOf(58);
        int maxResults = pagingRequest.getMaxItems();
        int skipCount = pagingRequest.getSkipCount();
        SearchParameters params = new SearchParameters();
        params.addQueryTemplate("_PERSON", "|%firstName OR |%lastName OR |%userName");
        params.setDefaultFieldName("_PERSON");
        params.setExcludeTenantFilter(this.getExcludeTenantFilter());
        params.setPermissionEvaluation(this.getPermissionEvaluationMode());
        StringBuilder query = new StringBuilder(256);
        query.append("TYPE:\"").append(ContentModel.TYPE_PERSON).append("\" AND (");
        if (tokens.length == 1) {
            query.append(term.substring(0, propIndex + 1)).append('\"');
            if (propIndex < 0) {
                query.append('*');
            }
            query.append(term.substring(propIndex + 1));
            if (propIndex > 0) {
                query.append('\"');
            } else {
                query.append("*\"");
            }
        } else {
            int nonFtsTokens = 0;
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (token.indexOf(58) == -1) {
                    ++nonFtsTokens;
                }
                ++n2;
            }
            tokens = term.split("(?<!\\\\) ");
            params.setDefaultOperator(SearchParameters.Operator.AND);
            boolean propertySearch = false;
            StringBuilder multiPartNames = new StringBuilder(tokens.length);
            boolean firstToken = true;
            String[] stringArray2 = tokens;
            int n3 = tokens.length;
            int n4 = 0;
            while (n4 < n3) {
                String token = stringArray2[n4];
                if (!propertySearch && token.indexOf(58) == -1) {
                    if (nonFtsTokens == 1) {
                        query.append("_PERSON:\"*");
                        query.append(token);
                        query.append("*\" ");
                    } else {
                        if (token.endsWith("*")) {
                            token = token.substring(0, token.lastIndexOf("*"));
                        }
                        multiPartNames.append("\"*");
                        multiPartNames.append(token);
                        multiPartNames.append("*\"");
                        if (firstToken) {
                            multiPartNames.append(' ');
                        }
                        firstToken = false;
                    }
                } else {
                    propIndex = token.lastIndexOf(58);
                    query.append(token.substring(0, propIndex + 1)).append('\"').append(token.substring(propIndex + 1)).append('\"').append(' ');
                    propertySearch = true;
                }
                ++n4;
            }
            if (multiPartNames.length() > 0) {
                query.append("firstName:");
                query.append((CharSequence)multiPartNames);
                query.append(" OR lastName:");
                query.append((CharSequence)multiPartNames);
            }
        }
        query.append(")");
        params.setLanguage("fts-alfresco");
        params.addStore(this.storeRef);
        params.setQuery(query.toString());
        if (logger.isDebugEnabled() && sortBy != null && !sortBy.isEmpty()) {
            logger.debug((Object)("getPeopleImplSearch: ignoring sortBy (" + sortBy + ")- not yet supported by model for search"));
        }
        if (maxResults > 0) {
            params.setLimitBy(LimitBy.FINAL_SIZE);
            params.setLimit(maxResults);
        }
        if (skipCount > 0) {
            params.setSkipCount(skipCount);
        }
        try (ResultSet results = null;){
            try {
                results = this.services.getSearchService().query(params);
                personRefs = this.getSortedPeopleObjects(results.getNodeRefs(), sortBy, sortAsc);
                if (start != null) {
                    logger.debug((Object)("getPeople: search - " + personRefs.size() + " items (in " + (System.currentTimeMillis() - start) + " msecs)"));
                }
            }
            catch (Throwable err) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Failed to execute people search: " + query.toString()), err);
                }
                throw err;
            }
        }
        return personRefs;
    }

    private List<NodeRef> getSortedPeopleObjects(List<NodeRef> peopleRefs, final String sortBy, Boolean sortAsc) {
        if (sortBy == null) {
            return peopleRefs;
        }
        ArrayList<NodeRef> sortedPeopleRefs = new ArrayList<NodeRef>(peopleRefs);
        final Collator col = Collator.getInstance(I18NUtil.getLocale());
        final NodeService nodeService = this.services.getNodeService();
        final int orderMultiplicator = sortAsc == null || sortAsc != false ? 1 : -1;
        Collections.sort(sortedPeopleRefs, new Comparator<NodeRef>(){

            @Override
            public int compare(NodeRef n1, NodeRef n2) {
                Serializable p1 = this.getProperty(n1);
                Serializable p2 = this.getProperty(n2);
                if (p1 instanceof Long && p2 instanceof Long) {
                    return Long.compare((Long)p1, (Long)p2) * orderMultiplicator;
                }
                return col.compare((Object)p1.toString(), p2) * orderMultiplicator;
            }

            public Serializable getProperty(NodeRef nodeRef) {
                Object result;
                if ("fullName".equalsIgnoreCase(sortBy)) {
                    String firstName = (String)((Object)nodeService.getProperty(nodeRef, ContentModel.PROP_FIRSTNAME));
                    String lastName = (String)((Object)nodeService.getProperty(nodeRef, ContentModel.PROP_LASTNAME));
                    Object fullName = firstName;
                    if (lastName != null && lastName.length() > 0) {
                        fullName = (String)fullName + " " + lastName;
                    }
                    result = fullName;
                } else {
                    result = "jobtitle".equalsIgnoreCase(sortBy) ? nodeService.getProperty(nodeRef, ContentModel.PROP_JOBTITLE) : ("email".equalsIgnoreCase(sortBy) ? nodeService.getProperty(nodeRef, ContentModel.PROP_EMAIL) : ("usage".equalsIgnoreCase(sortBy) ? nodeService.getProperty(nodeRef, ContentModel.PROP_SIZE_CURRENT) : ("quota".equalsIgnoreCase(sortBy) ? nodeService.getProperty(nodeRef, ContentModel.PROP_SIZE_QUOTA) : nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME))));
                }
                if (result == null) {
                    result = "";
                }
                return result;
            }
        });
        return sortedPeopleRefs;
    }

    public ScriptNode getPerson(String username) {
        NodeRef personRef = null;
        ParameterCheck.mandatory((String)"Username", (Object)username);
        try {
            personRef = this.personService.getPersonOrNull(username);
        }
        catch (AccessDeniedException accessDeniedException) {}
        return personRef == null ? null : new ScriptNode(personRef, this.services, this.getScope());
    }

    public String getPersonFullName(String username) {
        String name = null;
        ParameterCheck.mandatoryString((String)"Username", (String)username);
        NodeRef personRef = this.personService.getPersonOrNull(username);
        if (personRef != null) {
            NodeService nodeService = this.services.getNodeService();
            String firstName = (String)((Object)nodeService.getProperty(personRef, ContentModel.PROP_FIRSTNAME));
            String lastName = (String)((Object)nodeService.getProperty(personRef, ContentModel.PROP_LASTNAME));
            name = (String)(firstName != null ? firstName + " " : "") + (lastName != null ? lastName : "");
        }
        return name;
    }

    public ScriptNode getGroup(String groupName) {
        ParameterCheck.mandatoryString((String)"GroupName", (String)groupName);
        ScriptNode group = null;
        NodeRef groupRef = this.authorityDAO.getAuthorityNodeRefOrNull(groupName);
        if (groupRef != null) {
            group = new ScriptNode(groupRef, this.services, this.getScope());
        }
        return group;
    }

    public void deleteGroup(ScriptNode group) {
        ParameterCheck.mandatory((String)"Group", (Object)group);
        if (group.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER)) {
            String groupName = (String)group.getProperties().get(ContentModel.PROP_AUTHORITY_NAME);
            this.authorityService.deleteAuthority(groupName);
        }
    }

    public ScriptNode createGroup(String groupName) {
        return this.createGroup(null, groupName);
    }

    public ScriptNode createGroup(ScriptNode parentGroup, String groupName) {
        ParameterCheck.mandatoryString((String)"GroupName", (String)groupName);
        ScriptNode group = null;
        String actualName = this.services.getAuthorityService().getName(AuthorityType.GROUP, groupName);
        if (!this.authorityService.authorityExists(actualName)) {
            String parentGroupName;
            String result = this.authorityService.createAuthority(AuthorityType.GROUP, groupName);
            if (parentGroup != null && (parentGroupName = (String)parentGroup.getProperties().get(ContentModel.PROP_AUTHORITY_NAME)) != null) {
                this.authorityService.addAuthority(parentGroupName, actualName);
            }
            group = this.getGroup(result);
        }
        return group;
    }

    public void addAuthority(ScriptNode parentGroup, ScriptNode authority) {
        ParameterCheck.mandatory((String)"Authority", (Object)authority);
        ParameterCheck.mandatory((String)"ParentGroup", (Object)parentGroup);
        if (parentGroup.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER)) {
            String parentGroupName = (String)parentGroup.getProperties().get(ContentModel.PROP_AUTHORITY_NAME);
            String authorityName = authority.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER) ? (String)authority.getProperties().get(ContentModel.PROP_AUTHORITY_NAME) : (String)authority.getProperties().get(ContentModel.PROP_USERNAME);
            this.authorityService.addAuthority(parentGroupName, authorityName);
        }
    }

    public void removeAuthority(ScriptNode parentGroup, ScriptNode authority) {
        ParameterCheck.mandatory((String)"Authority", (Object)authority);
        ParameterCheck.mandatory((String)"ParentGroup", (Object)parentGroup);
        if (parentGroup.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER)) {
            String parentGroupName = (String)parentGroup.getProperties().get(ContentModel.PROP_AUTHORITY_NAME);
            String authorityName = authority.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER) ? (String)authority.getProperties().get(ContentModel.PROP_AUTHORITY_NAME) : (String)authority.getProperties().get(ContentModel.PROP_USERNAME);
            this.authorityService.removeAuthority(parentGroupName, authorityName);
        }
    }

    public Scriptable getMembers(ScriptNode group) {
        ParameterCheck.mandatory((String)"Group", (Object)group);
        Object[] members = this.getContainedAuthorities(group, AuthorityType.USER, true);
        return Context.getCurrentContext().newArray(this.getScope(), members);
    }

    public Scriptable getMembers(ScriptNode group, boolean recurse) {
        ParameterCheck.mandatory((String)"Group", (Object)group);
        Object[] members = this.getContainedAuthorities(group, AuthorityType.USER, recurse);
        return Context.getCurrentContext().newArray(this.getScope(), members);
    }

    public Scriptable getContainerGroups(ScriptNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        Object[] parents = null;
        Set<String> authorities = this.authorityService.getContainingAuthoritiesInZone(AuthorityType.GROUP, (String)person.getProperties().get(ContentModel.PROP_USERNAME), "APP.DEFAULT", null, 1000);
        parents = new Object[authorities.size()];
        int i = 0;
        for (String authority : authorities) {
            ScriptNode group = this.getGroup(authority);
            if (group == null) continue;
            parents[i++] = group;
        }
        return Context.getCurrentContext().newArray(this.getScope(), parents);
    }

    public boolean isAdmin(ScriptNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        return this.authorityService.isAdminAuthority((String)person.getProperties().get(ContentModel.PROP_USERNAME));
    }

    public boolean isGuest(ScriptNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        return this.authorityService.isGuestAuthority((String)person.getProperties().get(ContentModel.PROP_USERNAME));
    }

    public Map<String, Boolean> getCapabilities(ScriptNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        ScriptableHashMap<String, Boolean> retVal = new ScriptableHashMap<String, Boolean>();
        retVal.putAll(this.valueDerivingMapFactory.getMap(person));
        return retVal;
    }

    public ScriptableHashMap getImmutableProperties(String username) {
        Set<QName> props = this.userRegistrySynchronizer.getPersonMappedProperties(username);
        ScriptableHashMap<String, Boolean> propMap = new ScriptableHashMap<String, Boolean>();
        for (QName prop : props) {
            propMap.put(prop.toString(), Boolean.TRUE);
        }
        return propMap;
    }

    private Object[] getContainedAuthorities(ScriptNode container, AuthorityType type, boolean recurse) {
        Object[] members = null;
        if (container.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER)) {
            String groupName = (String)container.getProperties().get(ContentModel.PROP_AUTHORITY_NAME);
            Set<String> authorities = this.authorityService.getContainedAuthorities(type, groupName, !recurse);
            members = new Object[authorities.size()];
            int i = 0;
            for (String authority : authorities) {
                ScriptNode person;
                AuthorityType authorityType = AuthorityType.getAuthorityType((String)authority);
                if (authorityType.equals((Object)AuthorityType.GROUP)) {
                    ScriptNode group = this.getGroup(authority);
                    if (group == null) continue;
                    members[i++] = group;
                    continue;
                }
                if (!authorityType.equals((Object)AuthorityType.USER) || (person = this.getPerson(authority)) == null) continue;
                members[i++] = person;
            }
        }
        return members != null ? members : new Object[]{};
    }

    public boolean getExcludeTenantFilter() {
        return false;
    }

    public PermissionEvaluationMode getPermissionEvaluationMode() {
        return PermissionEvaluationMode.EAGER;
    }
}

