/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DefaultComparisonUtils;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.validator.DbValidator;

public abstract class AbstractDbObject
implements DbObject {
    private DbObject parent;
    private String name;
    protected ComparisonUtils comparisonUtils = new DefaultComparisonUtils();
    private final List<DbValidator> validators = new ArrayList<DbValidator>();

    public AbstractDbObject(DbObject parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean sameAs(DbObject other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        if (this.getName() != null && other != null && other.getName() != null) {
            boolean sameParent = false;
            if (this.getParent() == null && other.getParent() == null) {
                sameParent = true;
            } else if (this.getParent() != null && this.getParent().sameAs(other.getParent())) {
                sameParent = true;
            }
            return sameParent && this.getName().equalsIgnoreCase(other.getName());
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDbObject other = (AbstractDbObject)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append("[name=");
        if (this.getName() != null) {
            sb.append(this.getName());
        } else {
            sb.append("null");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void diff(DbObject right, DiffContext ctx) {
        DbProperty leftNameProp = new DbProperty(this, "name");
        DbProperty rightNameProp = new DbProperty(right, "name");
        this.comparisonUtils.compareSimple(leftNameProp, rightNameProp, ctx);
        this.doDiff(right, ctx);
    }

    @Override
    public DbObject getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DbObject parent) {
        this.parent = parent;
    }

    protected void doDiff(DbObject right, DiffContext ctx) {
    }

    public void setComparisonUtils(ComparisonUtils comparisonUtils) {
        this.comparisonUtils = comparisonUtils;
    }

    @Override
    public List<DbValidator> getValidators() {
        return this.validators;
    }

    @Override
    public void setValidators(List<DbValidator> validators) {
        this.validators.clear();
        if (validators != null) {
            this.validators.addAll(validators);
        }
    }

    @Override
    public boolean hasValidators() {
        return this.getValidators().size() > 0;
    }

    @Override
    public boolean hasObjectLevelValidator() {
        for (DbValidator validator : this.getValidators()) {
            if (!validator.validatesFullObject()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTypeName() {
        return this.getClass().getSimpleName().toLowerCase();
    }
}

