/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.NodePermissionEntry;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.repo.virtual.store.VirtualStoreImpl;
import org.alfresco.repo.virtual.store.VirtualUserPermissions;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@Category(value={LuceneTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class VirtualPermissionServiceExtensionTest
extends VirtualizationIntegrationTest {
    private PermissionServiceSPI permissionService;
    private String user1;
    private String user2;
    private NodeRef vf1Node2;
    private NodeRef virtualContent;
    private VirtualStoreImpl smartStore;
    private VirtualUserPermissions savedUserPermissions;
    private NodeRef testSiteFolder = null;
    private NodeRef smartFolder = null;
    private NodeRef contributionDocsFolder = null;
    private SiteService siteService;
    private String sName = "mytestsite_ace_5162";
    private NodeRef myContentSMF;
    private NodeRef contributionsSMF;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.smartStore = (VirtualStoreImpl)this.ctx.getBean("smartStore", VirtualStoreImpl.class);
        this.permissionService = (PermissionServiceSPI)this.ctx.getBean("permissionServiceImpl", PermissionServiceSPI.class);
        this.siteService = (SiteService)this.ctx.getBean("siteService", SiteService.class);
        this.user1 = "user1";
        this.user2 = "user2";
        this.vf1Node2 = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node2");
        this.virtualContent = this.createContent(this.vf1Node2, "virtualContent").getChildRef();
        this.permissionService.setPermission(this.virtualFolder1NodeRef, this.user1, "DeleteChildren", true);
        this.permissionService.setPermission(this.virtualFolder1NodeRef, this.user2, "DeleteChildren", false);
        this.permissionService.setPermission(this.virtualFolder1NodeRef, this.user1, "ReadPermissions", true);
        this.permissionService.setPermission(this.virtualFolder1NodeRef, this.user2, "ReadPermissions", true);
        this.permissionService.setPermission(this.virtualFolder1NodeRef, this.user1, "ReadProperties", true);
        this.permissionService.setPermission(this.virtualFolder1NodeRef, this.user1, "CreateChildren", false);
        this.permissionService.setPermission(this.virtualFolder1NodeRef, this.user1, "Delete", true);
    }

    protected void setUpTestPermissions() {
        this.savedUserPermissions = this.smartStore.getUserPermissions();
        VirtualUserPermissions testPermissions = new VirtualUserPermissions(this.savedUserPermissions);
        HashSet<String> allowSmartNodes = new HashSet<String>(this.savedUserPermissions.getAllowSmartNodes());
        allowSmartNodes.add("CreateChildren");
        testPermissions.setAllowSmartNodes(allowSmartNodes);
        testPermissions.init();
        this.smartStore.setUserPermissions(testPermissions);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.savedUserPermissions != null) {
            this.smartStore.setUserPermissions(this.savedUserPermissions);
            this.savedUserPermissions = null;
        }
        super.tearDown();
    }

    private AccessStatus hasPermissionAs(final NodeRef nodeRef, final String permission, String asUser) {
        AuthenticationUtil.RunAsWork<AccessStatus> hasPermissionAs = new AuthenticationUtil.RunAsWork<AccessStatus>(){

            public AccessStatus doWork() throws Exception {
                return VirtualPermissionServiceExtensionTest.this.permissionService.hasPermission(nodeRef, permission);
            }
        };
        return (AccessStatus)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)hasPermissionAs, (String)asUser);
    }

    @Test
    public void testHasPermissionAdherence_actualPath() throws Exception {
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.hasPermissionAs(this.virtualFolder1NodeRef, "DeleteChildren", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(this.virtualFolder1NodeRef, "DeleteChildren", this.user2));
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.hasPermissionAs(this.vf1Node2, "DeleteChildren", this.user1));
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.hasPermissionAs(this.virtualContent, "DeleteChildren", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(this.vf1Node2, "DeleteChildren", this.user2));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(this.virtualContent, "DeleteChildren", this.user2));
        this.permissionService.setPermission(this.virtualFolder1NodeRef, this.user1, "DeleteChildren", false);
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(this.vf1Node2, "DeleteChildren", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(this.virtualContent, "DeleteChildren", this.user1));
    }

    @Test
    public void testHasPermissionAdherence_missingFolderPath() throws Exception {
        NodeRef virtualFolderT5 = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "VirtualFolderT5", "C/org/alfresco/repo/virtual/template/testTemplate5.json");
        NodeRef filingFolderVirtualNodeRef = this.nodeService.getChildByName(virtualFolderT5, ContentModel.ASSOC_CONTAINS, "FilingFolder_filing_path");
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderVirtualNodeRef, "Delete", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderVirtualNodeRef, this.asTypedPermission("Delete"), this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderVirtualNodeRef, "CreateChildren", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderVirtualNodeRef, this.asTypedPermission("CreateChildren"), this.user1));
    }

    @Test
    public void testHasPermissionAdherence_folderPath() throws Exception {
        NodeRef virtualFolderT5 = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "VirtualFolderT5", "C/org/alfresco/repo/virtual/template/testTemplate5.json");
        NodeRef filingFolderVirtualNodeRef = this.nodeService.getChildByName(virtualFolderT5, ContentModel.ASSOC_CONTAINS, "FilingFolder_filing_path");
        ChildAssociationRef filingFolderChildAssoc = this.createFolder(this.rootNodeRef, "FilingFolder");
        NodeRef filingFolderNodeRef = filingFolderChildAssoc.getChildRef();
        this.permissionService.setPermission(filingFolderNodeRef, this.user1, "ReadPermissions", true);
        this.permissionService.setPermission(filingFolderNodeRef, this.user1, "CreateChildren", true);
        this.permissionService.setPermission(filingFolderNodeRef, this.user2, "CreateChildren", false);
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderNodeRef, "Delete", this.user1));
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.hasPermissionAs(filingFolderNodeRef, "CreateChildren", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderNodeRef, "CreateChildren", this.user2));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderVirtualNodeRef, "Delete", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderVirtualNodeRef, this.asTypedPermission("Delete"), this.user1));
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.hasPermissionAs(filingFolderVirtualNodeRef, "CreateChildren", this.user1));
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.hasPermissionAs(filingFolderVirtualNodeRef, this.asTypedPermission("CreateChildren"), this.user1));
        this.permissionService.setPermission(filingFolderNodeRef, this.user1, "DeleteChildren", true);
        this.permissionService.setPermission(filingFolderNodeRef, this.user2, "DeleteChildren", false);
        this.permissionService.setPermission(filingFolderNodeRef, this.user1, "ReadProperties", true);
        this.permissionService.setPermission(filingFolderNodeRef, this.user1, "CreateChildren", false);
        this.permissionService.setPermission(filingFolderNodeRef, this.user1, "Delete", true);
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.hasPermissionAs(filingFolderNodeRef, "Delete", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderNodeRef, "CreateChildren", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderVirtualNodeRef, "Delete", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderVirtualNodeRef, this.asTypedPermission("Delete"), this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderVirtualNodeRef, "CreateChildren", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderVirtualNodeRef, this.asTypedPermission("CreateChildren"), this.user1));
    }

    @Test
    public void testHasPermission() throws Exception {
        this.setUpTestPermissions();
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.hasPermissionAs(this.virtualFolder1NodeRef, "Delete", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(this.virtualFolder1NodeRef, "CreateChildren", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(this.vf1Node2, "Delete", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(this.vf1Node2, this.asTypedPermission("Delete"), this.user1));
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.hasPermissionAs(this.vf1Node2, "CreateChildren", this.user1));
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.hasPermissionAs(this.vf1Node2, this.asTypedPermission("CreateChildren"), this.user1));
    }

    @Test
    public void testReadonlyNodeHasPermission() throws Exception {
        NodeRef aVFTestTemplate2 = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "aVFTestTemplate2", "C/org/alfresco/repo/virtual/template/testTemplate2.json");
        NodeRef vf2Node2 = this.nodeService.getChildByName(aVFTestTemplate2, ContentModel.ASSOC_CONTAINS, "Node2");
        String[] deniedReadOnly = new String[]{"Unlock", "CancelCheckOut", "ChangePermissions", "CreateChildren", "Delete", "Write", "DeleteNode", "WriteProperties", "WriteContent", "CreateAssociations"};
        StringBuilder nonDeniedTrace = new StringBuilder();
        int i = 0;
        while (i < deniedReadOnly.length) {
            AccessStatus accessStatus = this.hasPermissionAs(vf2Node2, deniedReadOnly[i], this.user1);
            if (!AccessStatus.DENIED.equals((Object)accessStatus)) {
                if (nonDeniedTrace.length() > 0) {
                    nonDeniedTrace.append(",");
                }
                nonDeniedTrace.append(deniedReadOnly[i]);
            }
            ++i;
        }
        Assert.assertTrue((String)("Non-denied permissions on RO virtual nodes : " + String.valueOf(nonDeniedTrace)), (nonDeniedTrace.length() == 0 ? 1 : 0) != 0);
    }

    private Map<String, List<? extends PermissionEntry>> mapPermissionsByName(List<? extends PermissionEntry> entries) {
        HashMap<String, List<? extends PermissionEntry>> nameMap = new HashMap<String, List<? extends PermissionEntry>>();
        for (PermissionEntry permissionEntry : entries) {
            String name = permissionEntry.getPermissionReference().getName();
            ArrayList<PermissionEntry> permissions = (ArrayList<PermissionEntry>)nameMap.get(name);
            if (permissions == null) {
                permissions = new ArrayList<PermissionEntry>();
                nameMap.put(name, permissions);
            }
            permissions.add(permissionEntry);
        }
        return nameMap;
    }

    private Map<String, List<AccessPermission>> mapAccessPermissionsByName(Set<AccessPermission> accessPermissions) {
        HashMap<String, List<AccessPermission>> nameMap = new HashMap<String, List<AccessPermission>>();
        for (AccessPermission accessPermission : accessPermissions) {
            String name = accessPermission.getPermission();
            ArrayList<AccessPermission> permissions = (ArrayList<AccessPermission>)nameMap.get(name);
            if (permissions == null) {
                permissions = new ArrayList<AccessPermission>();
                nameMap.put(name, permissions);
            }
            permissions.add(accessPermission);
        }
        return nameMap;
    }

    protected void assertUniquePermission(String permissionName, AccessStatus accessStatus, String authority, List<? extends PermissionEntry> permissionEntries) {
        Map<String, List<? extends PermissionEntry>> entriesByName = this.mapPermissionsByName(permissionEntries);
        Assert.assertNotNull((String)("Not null permission " + permissionName + " expected."), entriesByName.get(permissionName));
        Assert.assertEquals((long)1L, (long)entriesByName.get(permissionName).size());
        PermissionEntry permission = entriesByName.get(permissionName).get(0);
        Assert.assertEquals((Object)accessStatus, (Object)permission.getAccessStatus());
        Assert.assertEquals((Object)authority, (Object)permission.getAuthority());
    }

    protected void assertUniqueAccessPermission(String permissionName, AccessStatus accessStatus, String authority, Set<AccessPermission> accessPermissions) {
        Map<String, List<AccessPermission>> apByName = this.mapAccessPermissionsByName(accessPermissions);
        Assert.assertNotNull((String)("Not null permission " + permissionName + " expected."), apByName.get(permissionName));
        List<AccessPermission> oneAccessPermission = apByName.get(permissionName);
        Assert.assertEquals((String)("Expected single AccessPermission but found " + String.valueOf(oneAccessPermission)), (long)1L, (long)oneAccessPermission.size());
        AccessPermission permission = apByName.get(permissionName).get(0);
        Assert.assertEquals((Object)accessStatus, (Object)permission.getAccessStatus());
        Assert.assertEquals((Object)authority, (Object)permission.getAuthority());
    }

    @Test
    public void testGetAllSetPermissions() throws Exception {
        this.setUpTestPermissions();
        Set allVf1SetPermissions = this.permissionService.getAllSetPermissions(this.virtualFolder1NodeRef);
        AccessPermission vf1ReadProperties = this.mapAccessPermissionsByName(allVf1SetPermissions).get("ReadProperties").get(0);
        this.assertUniqueAccessPermission("Delete", AccessStatus.ALLOWED, this.user1, allVf1SetPermissions);
        this.assertUniqueAccessPermission("CreateChildren", AccessStatus.DENIED, this.user1, allVf1SetPermissions);
        Set allNode2SetPermissions = this.permissionService.getAllSetPermissions(this.vf1Node2);
        this.assertUniqueAccessPermission("Delete", AccessStatus.DENIED, "GROUP_EVERYONE", allNode2SetPermissions);
        this.assertUniqueAccessPermission("CreateChildren", AccessStatus.ALLOWED, "GROUP_EVERYONE", allNode2SetPermissions);
        this.assertUniqueAccessPermission("ReadProperties", vf1ReadProperties.getAccessStatus(), vf1ReadProperties.getAuthority(), allNode2SetPermissions);
    }

    @Test
    public void testGetSetPermissions() throws Exception {
        this.setUpTestPermissions();
        NodePermissionEntry vf1SetPermissions = this.permissionService.getSetPermissions(this.virtualFolder1NodeRef);
        Assert.assertEquals((Object)this.virtualFolder1NodeRef, (Object)vf1SetPermissions.getNodeRef());
        List vf1Entries = vf1SetPermissions.getPermissionEntries();
        this.assertUniquePermission("Delete", AccessStatus.ALLOWED, this.user1, vf1Entries);
        this.assertUniquePermission("CreateChildren", AccessStatus.DENIED, this.user1, vf1Entries);
        NodePermissionEntry node2SetPermissions = this.permissionService.getSetPermissions(this.vf1Node2);
        Assert.assertEquals((Object)this.vf1Node2, (Object)node2SetPermissions.getNodeRef());
        List node2Entries = node2SetPermissions.getPermissionEntries();
        this.assertUniquePermission("Delete", AccessStatus.DENIED, "GROUP_EVERYONE", node2Entries);
        this.assertUniquePermission("CreateChildren", AccessStatus.ALLOWED, "GROUP_EVERYONE", node2Entries);
    }

    @Test
    public void testNodes_WithfilingPath_withNoReadPermissions_hasReadonlyPermission() throws Exception {
        String[] deniedReadOnly = new String[]{"Unlock", "CancelCheckOut", "ChangePermissions", "CreateChildren", "Delete", "Write", "DeleteNode", "WriteProperties", "WriteContent", "CreateAssociations"};
        NodeRef virtualFolderT5 = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "VirtualFolderT5", "C/org/alfresco/repo/virtual/template/testTemplate5.json");
        NodeRef filingFolderVirtualNodeRef = this.nodeService.getChildByName(virtualFolderT5, ContentModel.ASSOC_CONTAINS, "FilingFolder_filing_path");
        ChildAssociationRef filingFolderChildAssoc = this.createFolder(this.rootNodeRef, "FilingFolder");
        NodeRef filingFolderNodeRef = filingFolderChildAssoc.getChildRef();
        this.permissionService.setPermission(filingFolderNodeRef, this.user1, "ReadPermissions", false);
        this.permissionService.setPermission(filingFolderNodeRef, this.user1, "CreateChildren", true);
        this.permissionService.setPermission(filingFolderNodeRef, this.user2, "CreateChildren", false);
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderNodeRef, "Delete", this.user1));
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.hasPermissionAs(filingFolderNodeRef, "CreateChildren", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderNodeRef, "CreateChildren", this.user2));
        StringBuilder nonDeniedTrace = new StringBuilder();
        int i = 0;
        while (i < deniedReadOnly.length) {
            AccessStatus accessStatus = this.hasPermissionAs(filingFolderVirtualNodeRef, deniedReadOnly[i], this.user1);
            if (!AccessStatus.DENIED.equals((Object)accessStatus)) {
                if (nonDeniedTrace.length() > 0) {
                    nonDeniedTrace.append(",");
                }
                nonDeniedTrace.append(deniedReadOnly[i]);
            }
            ++i;
        }
        Assert.assertTrue((String)("Non-denied permissions on RO virtual nodes : " + String.valueOf(nonDeniedTrace)), (nonDeniedTrace.length() == 0 ? 1 : 0) != 0);
        this.permissionService.setPermission(filingFolderNodeRef, this.user1, "DeleteChildren", true);
        this.permissionService.setPermission(filingFolderNodeRef, this.user2, "DeleteChildren", false);
        this.permissionService.setPermission(filingFolderNodeRef, this.user1, "ReadProperties", true);
        this.permissionService.setPermission(filingFolderNodeRef, this.user1, "CreateChildren", false);
        this.permissionService.setPermission(filingFolderNodeRef, this.user1, "Delete", true);
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.hasPermissionAs(filingFolderNodeRef, "Delete", this.user1));
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)this.hasPermissionAs(filingFolderNodeRef, "CreateChildren", this.user1));
        StringBuilder nonDeniedTrace1 = new StringBuilder();
        int i2 = 0;
        while (i2 < deniedReadOnly.length) {
            AccessStatus accessStatus = this.hasPermissionAs(filingFolderVirtualNodeRef, deniedReadOnly[i2], this.user1);
            if (!AccessStatus.DENIED.equals((Object)accessStatus)) {
                if (nonDeniedTrace1.length() > 0) {
                    nonDeniedTrace1.append(",");
                }
                nonDeniedTrace1.append(deniedReadOnly[i2]);
            }
            ++i2;
        }
        Assert.assertTrue((String)("Non-denied permissions on RO virtual nodes : " + String.valueOf(nonDeniedTrace1)), (nonDeniedTrace1.length() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPerm_ace_5162() throws Exception {
        String[] deniedReadOnly = new String[]{"Unlock", "CancelCheckOut", "ChangePermissions", "CreateChildren", "Delete", "Write", "DeleteNode", "WriteProperties", "WriteContent", "CreateAssociations"};
        try {
            this.siteService.createSite("testSitePreset", this.sName, this.sName, this.sName, SiteVisibility.PUBLIC);
            this.testSiteFolder = this.siteService.createContainer(this.sName, "TestSiteFolder", ContentModel.TYPE_FOLDER, null);
            this.smartFolder = this.createVirtualizedFolder(this.testSiteFolder, "SmartFolder", "C/org/alfresco/repo/virtual/template/testTemplate7.json");
            this.contributionDocsFolder = this.createFolder(this.testSiteFolder, "Contribution Docs").getChildRef();
            this.permissionService.setInheritParentPermissions(this.contributionDocsFolder, false);
            this.myContentSMF = this.nodeService.getChildByName(this.smartFolder, ContentModel.ASSOC_CONTAINS, "My content");
            Assert.assertNotNull((Object)this.myContentSMF);
            this.contributionsSMF = this.nodeService.getChildByName(this.myContentSMF, ContentModel.ASSOC_CONTAINS, "Contributions");
            Assert.assertNotNull((Object)this.contributionsSMF);
            StringBuilder nonDeniedTrace = new StringBuilder();
            int i = 0;
            while (i < deniedReadOnly.length) {
                AccessStatus accessStatus = this.hasPermissionAs(this.contributionsSMF, deniedReadOnly[i], this.user1);
                if (!AccessStatus.DENIED.equals((Object)accessStatus)) {
                    if (nonDeniedTrace.length() > 0) {
                        nonDeniedTrace.append(",");
                    }
                    nonDeniedTrace.append(deniedReadOnly[i]);
                }
                ++i;
            }
            Assert.assertTrue((String)("Non-denied permissions on RO virtual nodes : " + String.valueOf(nonDeniedTrace)), (nonDeniedTrace.length() == 0 ? 1 : 0) != 0);
            FileInfo t1File = this.fileAndFolderService.create(this.contributionsSMF, "T1", ContentModel.TYPE_CONTENT);
            this.prepareMocks("cm:Contribution", this.smartStore.materializeIfPossible(t1File.getNodeRef()));
            NodeRef childContet = this.nodeService.getChildByName(this.contributionsSMF, ContentModel.ASSOC_CONTAINS, "T1");
            Assert.assertNotNull((Object)childContet);
            Assert.assertTrue((this.nodeService.getChildAssocs(this.contributionsSMF).size() > 0 ? 1 : 0) != 0);
            AuthenticationUtil.RunAsWork<Boolean> hasChildAssocs = new AuthenticationUtil.RunAsWork<Boolean>(){

                public Boolean doWork() throws Exception {
                    if (VirtualPermissionServiceExtensionTest.this.nodeService.getChildAssocs(VirtualPermissionServiceExtensionTest.this.contributionsSMF).size() > 0) {
                        return true;
                    }
                    return false;
                }
            };
            boolean value = (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)hasChildAssocs, (String)this.user1);
            Assert.assertFalse((boolean)value);
        }
        finally {
            this.resetMocks();
            if (this.contributionDocsFolder != null) {
                this.nodeService.deleteNode(this.contributionDocsFolder);
            }
            if (this.smartFolder != null) {
                this.nodeService.deleteNode(this.smartFolder);
            }
            if (this.testSiteFolder != null) {
                this.nodeService.deleteNode(this.testSiteFolder);
            }
            this.siteService.deleteSite(this.sName);
        }
    }

    private String asTypedPermission(String perm) {
        return String.valueOf(this.smartStore.getUserPermissions().getPermissionTypeQName()) + "." + perm;
    }
}

