/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.EmptyContentReader;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryListener;
import org.alfresco.repo.dictionary.DictionaryRepositoryBootstrappedEvent;
import org.alfresco.repo.dictionary.DynamicCreateRepositoryLocation;
import org.alfresco.repo.dictionary.DynamicModelPolicies;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.i18n.MessageDeployer;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class DictionaryRepositoryBootstrap
extends AbstractLifecycleBean
implements TenantDeployer,
DictionaryListener,
MessageDeployer {
    private static Log logger = LogFactory.getLog(DictionaryRepositoryBootstrap.class);
    private List<RepositoryLocation> repositoryModelsLocations = new ArrayList<RepositoryLocation>();
    private List<RepositoryLocation> repositoryMessagesLocations = new ArrayList<RepositoryLocation>();
    private DictionaryDAO dictionaryDAO = null;
    private ContentService contentService;
    private NodeService nodeService;
    private TenantAdminService tenantAdminService;
    private NamespaceService namespaceService;
    private MessageService messageService;
    private TransactionService transactionService;
    private PolicyComponent policyComponent;
    private ClassPolicyDelegate<DynamicModelPolicies.OnLoadDynamicModel> onLoadDynamicModelDelegate;

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public PolicyComponent getPolicyComponent() {
        return this.policyComponent;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setRepositoryModelsLocations(List<RepositoryLocation> repositoryLocations) {
        this.repositoryModelsLocations = repositoryLocations;
    }

    public void setRepositoryMessagesLocations(List<RepositoryLocation> repositoryLocations) {
        this.repositoryMessagesLocations = repositoryLocations;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"dictionaryDAO", (Object)this.dictionaryDAO);
        PropertyCheck.mandatory((Object)this, (String)"contentService", (Object)this.contentService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"tenantAdminService", (Object)this.tenantAdminService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"messageService", (Object)this.messageService);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        if (this.onLoadDynamicModelDelegate == null) {
            this.onLoadDynamicModelDelegate = this.policyComponent.registerClassPolicy(DynamicModelPolicies.OnLoadDynamicModel.class);
        }
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                DictionaryRepositoryBootstrap.this.onDictionaryInit();
                DictionaryRepositoryBootstrap.this.initMessages();
                return null;
            }
        }, this.transactionService.isReadOnly(), false);
    }

    public void destroy() {
    }

    private void onDictionaryInitInTxn() {
        Collection modelsAfter;
        int n;
        Collection modelsBefore;
        if (AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new IllegalStateException("The Repository-based dictionary initialization has to be done in the context of a transaction.");
        }
        long startTime = System.currentTimeMillis();
        if (logger.isTraceEnabled()) {
            String tenantDomain = this.tenantAdminService.getCurrentUserDomain();
            logger.trace((Object)("onDictionaryInit: [" + String.valueOf(Thread.currentThread()) + "]" + (String)(tenantDomain.equals("") ? "" : " (Tenant: " + tenantDomain + ")")));
        }
        int modelsBeforeCnt = (modelsBefore = this.dictionaryDAO.getModels(true)) != null ? modelsBefore.size() : 0;
        ArrayList<String> loadedModels = new ArrayList<String>();
        if (this.repositoryModelsLocations != null) {
            HashMap<String, DynamicModelInfo> modelMap = new HashMap<String, DynamicModelInfo>();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("onDictionaryInit: locations=" + String.valueOf(this.repositoryModelsLocations)));
            }
            for (RepositoryLocation repositoryLocation : this.repositoryModelsLocations) {
                StoreRef storeRef = repositoryLocation.getStoreRef();
                if (!this.nodeService.exists(storeRef)) {
                    logger.info((Object)("StoreRef '" + String.valueOf(storeRef) + "' does not exist"));
                    continue;
                }
                List<NodeRef> nodeRefs = null;
                if (repositoryLocation.getQueryLanguage().equals("path")) {
                    nodeRefs = this.getNodes(storeRef, repositoryLocation, ContentModel.TYPE_DICTIONARY_MODEL);
                    if (nodeRefs.size() <= 0) continue;
                    for (NodeRef dictionaryModel : nodeRefs) {
                        try {
                            M2Model model;
                            Boolean isActive;
                            if (this.nodeService.hasAspect(dictionaryModel, ContentModel.ASPECT_WORKING_COPY) || this.nodeService.hasAspect(dictionaryModel, ContentModel.ASPECT_ARCHIVED) || (isActive = (Boolean)this.nodeService.getProperty(dictionaryModel, ContentModel.PROP_MODEL_ACTIVE)) == null || !isActive.booleanValue() || (model = this.createM2Model(dictionaryModel)) == null) continue;
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("onDictionaryInit: " + model.getName() + " (" + String.valueOf(dictionaryModel) + ")"));
                            }
                            for (M2Namespace namespace : model.getNamespaces()) {
                                modelMap.put(namespace.getUri(), new DynamicModelInfo(repositoryLocation, model, dictionaryModel));
                            }
                        }
                        catch (InvalidNodeRefException inre) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("onDictionaryInit: " + String.valueOf((Object)inre) + " (assume concurrently deleted)"));
                        }
                    }
                    continue;
                }
                logger.error((Object)("Unsupported query language for models location: " + repositoryLocation.getQueryLanguage()));
            }
            for (Map.Entry entry : modelMap.entrySet()) {
                RepositoryLocation importedLocation = ((DynamicModelInfo)entry.getValue()).location;
                M2Model importedModel = ((DynamicModelInfo)entry.getValue()).model;
                this.loadModel(modelMap, loadedModels, importedModel, importedLocation);
                this.notifyDynamicModelLoaded((DynamicModelInfo)entry.getValue());
            }
        }
        int n2 = n = (modelsAfter = this.dictionaryDAO.getModels(true)) != null ? modelsAfter.size() : 0;
        if (logger.isDebugEnabled()) {
            String tenantDomain = this.tenantAdminService.getCurrentUserDomain();
            logger.debug((Object)("Model count: before=" + modelsBeforeCnt + ", load/update=" + loadedModels.size() + ", after=" + n + " in " + (System.currentTimeMillis() - startTime) + " msecs [" + String.valueOf(Thread.currentThread()) + "] " + (String)(tenantDomain.equals("") ? "" : " (Tenant: " + tenantDomain + ")")));
        }
    }

    public void notifyDynamicModelLoaded(DynamicModelInfo entry) {
        if (this.onLoadDynamicModelDelegate == null) {
            this.onLoadDynamicModelDelegate = this.policyComponent.registerClassPolicy(DynamicModelPolicies.OnLoadDynamicModel.class);
        }
        DynamicModelPolicies.OnLoadDynamicModel policy = this.onLoadDynamicModelDelegate.get(ContentModel.TYPE_CONTENT);
        try {
            policy.onLoadDynamicModel(entry.model, entry.nodeRef);
        }
        catch (RuntimeException e) {
            logger.warn((Object)("Failed to notify dynamic model loaded'" + (entry.model != null ? entry.model.getName() : "null") + "' : " + String.valueOf(e)), (Throwable)e);
        }
    }

    @Override
    public void initMessages() {
        if (this.repositoryMessagesLocations != null) {
            for (RepositoryLocation repositoryLocation : this.repositoryMessagesLocations) {
                StoreRef storeRef = repositoryLocation.getStoreRef();
                if (!this.nodeService.exists(storeRef)) {
                    logger.info((Object)("StoreRef '" + String.valueOf(storeRef) + "' does not exist"));
                    continue;
                }
                if (repositoryLocation.getQueryLanguage().equals("path")) {
                    List<NodeRef> nodeRefs = this.getNodes(storeRef, repositoryLocation, ContentModel.TYPE_CONTENT);
                    if (nodeRefs.size() <= 0) continue;
                    ArrayList<String> resourceBundleBaseNames = new ArrayList<String>();
                    for (NodeRef messageResource : nodeRefs) {
                        String messageResourcePath = this.nodeService.getPath(messageResource).toPrefixString((NamespacePrefixResolver)this.namespaceService);
                        String bundleBasePrefixedName = messageResourcePath.substring(messageResourcePath.lastIndexOf("/"));
                        String bundleBaseName = this.messageService.getBaseBundleName(bundleBasePrefixedName);
                        if (resourceBundleBaseNames.contains(bundleBaseName)) continue;
                        this.messageService.registerResourceBundle(storeRef.toString() + repositoryLocation.getPath() + bundleBaseName);
                        resourceBundleBaseNames.add(bundleBaseName);
                    }
                    continue;
                }
                logger.error((Object)("Unsupported query language for messages location: " + repositoryLocation.getQueryLanguage()));
            }
        }
    }

    public List<NodeRef> getModelRefs() {
        ArrayList<NodeRef> modelRefs = new ArrayList<NodeRef>();
        for (RepositoryLocation repositoryLocation : this.repositoryModelsLocations) {
            StoreRef storeRef = repositoryLocation.getStoreRef();
            if (!this.nodeService.exists(storeRef)) {
                logger.info((Object)("StoreRef '" + String.valueOf(storeRef) + "' does not exist"));
                continue;
            }
            if (repositoryLocation.getQueryLanguage().equals("path")) {
                List<NodeRef> nodeRefs = this.getNodes(storeRef, repositoryLocation, ContentModel.TYPE_DICTIONARY_MODEL);
                if (nodeRefs.size() <= 0) continue;
                for (NodeRef dictionaryModel : nodeRefs) {
                    try {
                        if (this.nodeService.hasAspect(dictionaryModel, ContentModel.ASPECT_WORKING_COPY) || this.nodeService.hasAspect(dictionaryModel, ContentModel.ASPECT_ARCHIVED)) continue;
                        modelRefs.add(dictionaryModel);
                    }
                    catch (InvalidNodeRefException inre) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("getModelRefs: " + String.valueOf((Object)inre) + " (assume concurrently deleted)"));
                    }
                }
                continue;
            }
            logger.error((Object)("Unsupported query language for models location: " + repositoryLocation.getQueryLanguage()));
        }
        return modelRefs;
    }

    protected List<NodeRef> getNodes(StoreRef storeRef, RepositoryLocation repositoryLocation, QName nodeType) {
        ArrayList<Object> nodeRefs = new ArrayList<NodeRef>();
        NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
        if (!this.nodeService.exists(rootNodeRef)) {
            return nodeRefs;
        }
        if (repositoryLocation instanceof DynamicCreateRepositoryLocation) {
            ((DynamicCreateRepositoryLocation)repositoryLocation).checkAndCreate(rootNodeRef);
        }
        String[] pathElements = repositoryLocation.getPathElements();
        NodeRef folderNodeRef = rootNodeRef;
        if (pathElements.length > 0) {
            folderNodeRef = this.resolveQNamePath(rootNodeRef, pathElements);
        }
        if (folderNodeRef != null) {
            HashSet<QName> types = new HashSet<QName>(1);
            types.add(nodeType);
            List childAssocRefs = this.nodeService.getChildAssocs(folderNodeRef, types);
            if (childAssocRefs.size() > 0) {
                nodeRefs = new ArrayList(childAssocRefs.size());
                for (ChildAssociationRef childAssocRef : childAssocRefs) {
                    nodeRefs.add(childAssocRef.getChildRef());
                }
            }
        }
        return nodeRefs;
    }

    private void loadModel(Map<String, DynamicModelInfo> modelMap, List<String> loadedModels, M2Model model, RepositoryLocation modelLocation) {
        String modelName = model.getName();
        if (!loadedModels.contains(modelName)) {
            for (M2Namespace importNamespace : model.getImports()) {
                DynamicModelInfo entry = modelMap.get(importNamespace.getUri());
                if (entry == null) continue;
                RepositoryLocation importedLocation = entry.location;
                M2Model importedModel = entry.model;
                this.loadModel(modelMap, loadedModels, importedModel, importedLocation);
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Loading model: " + modelName + " (from [" + String.valueOf(modelLocation.getStoreRef()) + "]" + modelLocation.getPath() + ")"));
                }
                this.dictionaryDAO.putModel(model);
                loadedModels.add(modelName);
            }
            catch (AlfrescoRuntimeException e) {
                logger.warn((Object)("Failed to load model '" + modelName + "' : " + String.valueOf((Object)e)), (Throwable)e);
            }
        }
    }

    public M2Model createM2Model(NodeRef nodeRef) {
        M2Model model = null;
        ContentReader contentReader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        if (contentReader != null) {
            if (contentReader instanceof EmptyContentReader) {
                logger.error((Object)("Failed to create model (due to EmptyContentReader): " + String.valueOf(nodeRef)));
            } else {
                InputStream is = null;
                try {
                    is = contentReader.getContentInputStream();
                    model = M2Model.createModel((InputStream)is);
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {
                            logger.error((Object)("Failed to close input stream for " + String.valueOf(nodeRef)));
                        }
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        logger.error((Object)("Failed to close input stream for " + String.valueOf(nodeRef)));
                    }
                }
            }
        }
        return model;
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.dictionaryDAO.reset();
        this.register();
        this.dictionaryDAO.init();
        ((ApplicationContext)event.getSource()).publishEvent((ApplicationEvent)new DictionaryRepositoryBootstrappedEvent(this));
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public void onEnableTenant() {
        this.init();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    public void register() {
        this.dictionaryDAO.registerListener((DictionaryListener)this);
        this.messageService.register(this);
        if (this.tenantAdminService.isEnabled()) {
            this.tenantAdminService.register(this);
            this.tenantAdminService.register(this.messageService);
        }
    }

    protected void unregister() {
        if (this.tenantAdminService.isEnabled()) {
            this.tenantAdminService.unregister(this);
            this.tenantAdminService.unregister(this.messageService);
        }
    }

    protected NodeRef resolveQNamePath(NodeRef rootNodeRef, String[] pathPrefixQNameStrings) {
        if (pathPrefixQNameStrings.length == 0) {
            throw new IllegalArgumentException("Path array is empty");
        }
        NodeRef parentNodeRef = rootNodeRef;
        int i = 0;
        while (i < pathPrefixQNameStrings.length) {
            String pathPrefixQNameString = pathPrefixQNameStrings[i];
            QName pathQName = null;
            if (this.tenantAdminService.isEnabled()) {
                String[] parts = QName.splitPrefixedQName((String)pathPrefixQNameString);
                if (parts.length == 2 && parts[0].equals("app")) {
                    String pathUriQNameString = new StringBuilder(64).append('{').append("http://www.alfresco.org/model/application/1.0").append('}').append(parts[1]).toString();
                    pathQName = QName.createQName((String)pathUriQNameString);
                } else {
                    pathQName = QName.createQName((String)pathPrefixQNameString, (NamespacePrefixResolver)this.namespaceService);
                }
            } else {
                pathQName = QName.createQName((String)pathPrefixQNameString, (NamespacePrefixResolver)this.namespaceService);
            }
            List childAssocRefs = this.nodeService.getChildAssocs(parentNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)pathQName);
            if (childAssocRefs.size() != 1) {
                return null;
            }
            parentNodeRef = ((ChildAssociationRef)childAssocRefs.get(0)).getChildRef();
            ++i;
        }
        return parentNodeRef;
    }

    public void onDictionaryInit() {
        if (this.onLoadDynamicModelDelegate == null) {
            this.onLoadDynamicModelDelegate = this.policyComponent.registerClassPolicy(DynamicModelPolicies.OnLoadDynamicModel.class);
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> initCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                DictionaryRepositoryBootstrap.this.onDictionaryInitInTxn();
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(initCallback, true, false);
    }

    public void afterDictionaryDestroy() {
    }

    public void afterDictionaryInit() {
    }

    private class DynamicModelInfo {
        RepositoryLocation location;
        M2Model model;
        NodeRef nodeRef;

        DynamicModelInfo(RepositoryLocation location, M2Model model, NodeRef nodeRef) {
            this.location = location;
            this.model = model;
            this.nodeRef = nodeRef;
        }
    }
}

