/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.HashSet;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.db.traitextender.NodeServiceTrait;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.ActualEnvironmentException;
import org.alfresco.repo.virtual.VirtualContentModel;
import org.alfresco.repo.virtual.ref.AbstractProtocolMethod;
import org.alfresco.repo.virtual.ref.NodeProtocol;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.VirtualProtocol;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class GetAspectsMethod
extends AbstractProtocolMethod<Set<QName>> {
    private NodeServiceTrait nodeServiceTrait;
    private ActualEnvironment environment;

    public GetAspectsMethod(NodeServiceTrait nodeServiceTrait, ActualEnvironment environment) {
        this.nodeServiceTrait = nodeServiceTrait;
        this.environment = environment;
    }

    private Set<QName> createVirtualAspects() {
        HashSet<QName> aspects = new HashSet<QName>();
        aspects.add(VirtualContentModel.ASPECT_VIRTUAL);
        aspects.add(ContentModel.ASPECT_TITLED);
        return aspects;
    }

    private Set<QName> createVirtualDocumentAspects() {
        HashSet<QName> aspects = new HashSet<QName>();
        aspects.add(VirtualContentModel.ASPECT_VIRTUAL_DOCUMENT);
        return aspects;
    }

    @Override
    public Set<QName> execute(NodeProtocol protocol, Reference reference) throws ProtocolMethodException {
        NodeRef nodeRef = protocol.getNodeRef(reference);
        Set nodeAspects = this.nodeServiceTrait.getAspects(nodeRef);
        Set<QName> aspects = this.createVirtualDocumentAspects();
        aspects.addAll(nodeAspects);
        return aspects;
    }

    @Override
    public Set<QName> execute(VirtualProtocol virtualProtocol, Reference reference) throws ProtocolMethodException {
        try {
            Set<QName> aspects = this.createVirtualAspects();
            String path = virtualProtocol.getTemplatePath(reference);
            if ("/".equals(path.trim())) {
                NodeRef nodeRef = virtualProtocol.getActualNodeLocation(reference).asNodeRef(this.environment);
                Set nodeAspects = this.nodeServiceTrait.getAspects(nodeRef);
                aspects.addAll(nodeAspects);
            }
            return aspects;
        }
        catch (ActualEnvironmentException e) {
            throw new ProtocolMethodException(e);
        }
    }
}

