/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.locale;

import java.util.Locale;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.locale.LocaleDAO;
import org.alfresco.repo.domain.locale.LocaleEntity;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.util.Pair;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class AbstractLocaleDAOImpl
implements LocaleDAO {
    private static final String CACHE_REGION_LOCALE = "Locale";
    private EntityLookupCache<Long, String, String> localeEntityCache = new EntityLookupCache<Long, String, String>(new LocaleEntityCallbackDAO());

    public void setLocaleEntityCache(SimpleCache<Long, String> localeEntityCache) {
        this.localeEntityCache = new EntityLookupCache<Long, String, String>(localeEntityCache, CACHE_REGION_LOCALE, new LocaleEntityCallbackDAO());
    }

    protected AbstractLocaleDAOImpl() {
    }

    @Override
    public Pair<Long, Locale> getLocalePair(Locale locale) {
        return this.getLocalePairImpl(locale);
    }

    @Override
    public Pair<Long, Locale> getDefaultLocalePair() {
        return this.getLocalePairImpl(null);
    }

    @Override
    public Pair<Long, Locale> getLocalePair(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot look up entity by null ID.");
        }
        Pair<Long, String> entityPair = this.localeEntityCache.getByKey(id);
        if (entityPair == null) {
            throw new DataIntegrityViolationException("No locale exists for ID " + String.valueOf(id));
        }
        String localeStr = (String)entityPair.getSecond();
        Locale locale = null;
        locale = ".default".equals(localeStr) ? I18NUtil.getLocale() : (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, entityPair.getSecond());
        return new Pair((Object)id, (Object)locale);
    }

    @Override
    public Pair<Long, Locale> getOrCreateLocalePair(Locale locale) {
        return this.getOrCreateLocalePairImpl(locale);
    }

    @Override
    public Pair<Long, Locale> getOrCreateDefaultLocalePair() {
        return this.getOrCreateLocalePairImpl(null);
    }

    private Pair<Long, Locale> getLocalePairImpl(Locale locale) {
        String localeStr;
        if (locale == null) {
            localeStr = ".default";
            locale = I18NUtil.getLocale();
        } else {
            localeStr = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)locale);
        }
        if (localeStr == null) {
            throw new IllegalArgumentException("Cannot look up entity by null locale.");
        }
        Pair<Long, String> entityPair = this.localeEntityCache.getByValue(localeStr);
        if (entityPair == null) {
            return null;
        }
        return new Pair((Object)((Long)entityPair.getFirst()), (Object)locale);
    }

    private Pair<Long, Locale> getOrCreateLocalePairImpl(Locale locale) {
        String localeStr;
        if (locale == null) {
            localeStr = ".default";
            locale = I18NUtil.getLocale();
        } else {
            localeStr = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)locale);
        }
        if (localeStr == null) {
            throw new IllegalArgumentException("Cannot look up entity by null locale.");
        }
        Pair<Long, String> entityPair = this.localeEntityCache.getOrCreateByValue(localeStr);
        if (entityPair == null) {
            throw new RuntimeException("Locale should have been created.");
        }
        return new Pair((Object)((Long)entityPair.getFirst()), (Object)locale);
    }

    protected abstract LocaleEntity getLocaleEntity(Long var1);

    protected abstract LocaleEntity getLocaleEntity(String var1);

    protected abstract LocaleEntity createLocaleEntity(String var1);

    private class LocaleEntityCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, String, String> {
        private LocaleEntityCallbackDAO() {
        }

        @Override
        public String getValueKey(String value) {
            return value;
        }

        @Override
        public Pair<Long, String> findByKey(Long id) {
            LocaleEntity entity = AbstractLocaleDAOImpl.this.getLocaleEntity(id);
            if (entity == null) {
                return null;
            }
            return new Pair((Object)id, (Object)entity.getLocaleStr());
        }

        @Override
        public Pair<Long, String> findByValue(String localeStr) {
            LocaleEntity entity = AbstractLocaleDAOImpl.this.getLocaleEntity(localeStr);
            if (entity == null) {
                return null;
            }
            return new Pair((Object)entity.getId(), (Object)localeStr);
        }

        @Override
        public Pair<Long, String> createValue(String localeStr) {
            LocaleEntity entity = AbstractLocaleDAOImpl.this.createLocaleEntity(localeStr);
            return new Pair((Object)entity.getId(), (Object)localeStr);
        }
    }
}

