/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.workflow;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.forms.processor.workflow.DataKeyInfo;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class DataKeyMatcher {
    private static final Pattern propertyNamePattern = Pattern.compile("(^[a-zA-Z0-9-]+)_([a-zA-Z0-9_]+$)");
    private static final Pattern associationNamePattern = Pattern.compile("(^[a-zA-Z0-9-]+)_([a-zA-Z0-9_]+)(_[a-zA-Z]+$)");
    private static final Pattern transientAssociationPattern = Pattern.compile("(^[a-zA-Z0-9]+)(_[a-zA-Z]+$)");
    private final NamespaceService namespaceService;

    public DataKeyMatcher(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public DataKeyInfo match(String dataKey) {
        if (dataKey.startsWith("prop_")) {
            return this.matchProperty(dataKey);
        }
        if (dataKey.startsWith("assoc_")) {
            return this.matchAssociation(dataKey);
        }
        return null;
    }

    private DataKeyInfo matchAssociation(String dataKey) {
        String keyName = dataKey.substring("assoc_".length());
        Matcher matcher = associationNamePattern.matcher(keyName);
        if (matcher.matches()) {
            QName qName = this.getQName(matcher);
            boolean isAdd = this.isAdd(matcher, 3);
            String name = qName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
            return DataKeyInfo.makeAssociationDataKeyInfo(name, qName, isAdd);
        }
        return this.matchTransientAssociation(keyName);
    }

    private DataKeyInfo matchTransientAssociation(String keyName) {
        Matcher matcher = transientAssociationPattern.matcher(keyName);
        if (matcher.matches()) {
            boolean isAdd = this.isAdd(matcher, 2);
            String name = matcher.group(1);
            return DataKeyInfo.makeTransientAssociationDataKeyInfo(name, isAdd);
        }
        return null;
    }

    private boolean isAdd(Matcher matcher, int suffixPos) {
        String suffix = matcher.group(suffixPos);
        boolean isAdd = !"_removed".equals(suffix);
        return isAdd;
    }

    private DataKeyInfo matchProperty(String dataKey) {
        String keyName = dataKey.substring("prop_".length());
        Matcher matcher = propertyNamePattern.matcher(keyName);
        if (matcher.matches()) {
            QName qName = this.getQName(matcher);
            String name = qName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
            return DataKeyInfo.makePropertyDataKeyInfo(name, qName);
        }
        return DataKeyInfo.makeTransientPropertyDataKeyInfo(keyName);
    }

    private QName getQName(Matcher matcher) {
        String prefix = matcher.group(1);
        String localName = matcher.group(2);
        QName qName = QName.createQName((String)prefix, (String)localName, (NamespacePrefixResolver)this.namespaceService);
        return qName;
    }
}

