/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationManager;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.CompositePasswordEncoder;
import org.alfresco.repo.security.authentication.HashPasswordTransactionListener;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authentication.RepositoryAuthenticatedUser;
import org.alfresco.repo.tenant.TenantContextHolder;
import org.alfresco.repo.tenant.TenantDisabledException;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationComponentImpl
extends AbstractAuthenticationComponent {
    private Log logger = LogFactory.getLog(this.getClass());
    private MutableAuthenticationDao authenticationDao;
    AuthenticationManager authenticationManager;
    CompositePasswordEncoder passwordEncoder;

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthenticationDao(MutableAuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    public void setCompositePasswordEncoder(CompositePasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Override
    protected void authenticateImpl(String userNameIn, final char[] password) throws AuthenticationException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Authentication for user: " + AuthenticationUtil.maskUsername((String)userNameIn)));
        }
        try {
            Pair userTenant = AuthenticationUtil.getUserTenant((String)userNameIn);
            final String userName = (String)userTenant.getFirst();
            final String tenantDomain = (String)userTenant.getSecond();
            String normalized = this.getTransactionService().getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                @Override
                public String execute() throws Throwable {
                    return (String)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<String>(){

                        public String doWork() throws Exception {
                            List<String> hashIndicator;
                            String normalized = AuthenticationComponentImpl.this.getPersonService().getUserIdentifier(userName);
                            String finalUserName = normalized == null ? userName : normalized;
                            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)finalUserName, (Object)new String(password));
                            (this).AuthenticationComponentImpl.this.authenticationManager.authenticate((Authentication)authentication);
                            UserDetails userDetails = (this).AuthenticationComponentImpl.this.authenticationDao.loadUserByUsername(finalUserName);
                            if (!(!(userDetails instanceof RepositoryAuthenticatedUser) || (hashIndicator = ((RepositoryAuthenticatedUser)userDetails).getHashIndicator()) == null || hashIndicator.isEmpty() || hashIndicator.size() <= 1 && (this).AuthenticationComponentImpl.this.passwordEncoder.lastEncodingIsPreferred(hashIndicator))) {
                                HashPasswordTransactionListener txListener = new HashPasswordTransactionListener(userName, password);
                                txListener.setTransactionService(AuthenticationComponentImpl.this.getTransactionService());
                                txListener.setAuthenticationDao((this).AuthenticationComponentImpl.this.authenticationDao);
                                AlfrescoTransactionSupport.bindListener(txListener);
                                if ((this).AuthenticationComponentImpl.this.logger.isDebugEnabled()) {
                                    (this).AuthenticationComponentImpl.this.logger.debug((Object)("New hashed password for user '" + AuthenticationUtil.maskUsername((String)userName) + "' has been requested"));
                                }
                            }
                            return normalized;
                        }
                    }, (String)tenantDomain);
                }
            }, true);
            if (normalized == null) {
                this.setCurrentUser(userName, AuthenticationComponent.UserNameValidationMode.CHECK_AND_FIX);
            } else {
                this.setCurrentUser(normalized, AuthenticationComponent.UserNameValidationMode.NONE);
            }
            TenantContextHolder.setTenantDomain((String)tenantDomain);
        }
        catch (TenantDisabledException tde) {
            throw new AuthenticationException(tde.getMessage(), (Throwable)((Object)tde));
        }
        catch (net.sf.acegisecurity.AuthenticationException ae) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            out.println(ae.toString());
            ae.printStackTrace(out);
            out.close();
            throw new AuthenticationException(sw.toString());
        }
    }

    @Override
    protected UserDetails getUserDetails(String userName) {
        if (AuthenticationUtil.isMtEnabled()) {
            Authentication originalFullAuthentication = AuthenticationUtil.getFullAuthentication();
            try {
                if (originalFullAuthentication == null) {
                    AuthenticationUtil.setFullyAuthenticatedUser((String)this.getSystemUserName(this.getUserDomain(userName)));
                }
                UserDetails userDetails = this.authenticationDao.loadUserByUsername(userName);
                return userDetails;
            }
            finally {
                if (originalFullAuthentication == null) {
                    ContextHolder.setContext(null);
                }
            }
        }
        return this.authenticationDao.loadUserByUsername(userName);
    }

    public String getMD4HashedPassword(String userName) {
        return this.authenticationDao.getMD4HashedPassword(userName);
    }

    public Authentication authenticate(Authentication token) throws AuthenticationException {
        throw new AlfrescoRuntimeException("Authentication via token not supported");
    }

    @Override
    protected boolean implementationAllowsGuestLogin() {
        return true;
    }

    @Override
    public Set<String> getDefaultAdministratorUserNames() {
        return Collections.singleton(AuthenticationUtil.getAdminUserName());
    }
}

