/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.client.config;

import java.util.Collections;
import java.util.Map;
import org.alfresco.repo.client.config.ClientAppConfig;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={LuceneTests.class})
public class ClientAppConfigTest {
    private ApplicationContext context;
    private ClientAppConfig clientAppConfig;

    @Before
    public void setUp() throws Exception {
        ApplicationContextHelper.closeApplicationContext();
        this.context = ApplicationContextHelper.getApplicationContext((String[])new String[]{ApplicationContextHelper.CONFIG_LOCATIONS[0], "classpath:org/alfresco/repo/client/config/test-repo-clients-apps-context.xml"});
        this.clientAppConfig = (ClientAppConfig)this.context.getBean("clientAppConfigTest", ClientAppConfig.class);
    }

    @Test
    public void testClients() throws Exception {
        Map clients = this.clientAppConfig.getClients();
        Assert.assertNotNull((Object)clients);
        Assert.assertEquals((String)"Incorrect number of clients", (long)4L, (long)clients.size());
        ClientAppConfig.ClientApp client1 = this.clientAppConfig.getClient("test-client1");
        Assert.assertNotNull((Object)client1);
        Assert.assertEquals((Object)"test-client1", (Object)client1.getName());
        Assert.assertEquals((Object)"http://localhost:8081/test-client1/o", (Object)client1.getProperty("sharedLinkBaseUrl"));
        Assert.assertEquals((Object)"http://localhost:8081/test-client1", (Object)client1.getTemplateAssetsUrl());
        ClientAppConfig.ClientApp client2 = this.clientAppConfig.getClient("test-client2");
        Assert.assertNotNull((Object)client2);
        Assert.assertEquals((Object)"test-client2", (Object)client2.getName());
        Assert.assertEquals((Object)"https://127.0.0.1:8082/test-client2/t", (Object)client2.getProperty("sharedLinkBaseUrl"));
        Assert.assertEquals((Object)"https://127.0.0.1:8082/test-client2", (Object)client2.getTemplateAssetsUrl());
        ClientAppConfig.ClientApp client3 = this.clientAppConfig.getClient("test-client5");
        Assert.assertNotNull((Object)client3);
        Assert.assertEquals((Object)"test-client5", (Object)client3.getName());
        Assert.assertEquals((Object)"http://localhost:8085/test-client5/f", (Object)client3.getProperty("myProp1"));
        Assert.assertEquals((Object)"http://localhost:8085/test-client5", (Object)client3.getProperty("myProp2"));
        Assert.assertEquals((Object)"test prop3", (Object)client3.getProperty("myProp3"));
        Assert.assertEquals((Object)"test prop4", (Object)client3.getProperty("myProp4"));
        Assert.assertEquals((Object)"test prop5", (Object)client3.getProperty("myProp5-with-hyphen"));
        Assert.assertNull((Object)client3.getTemplateAssetsUrl());
        ClientAppConfig.ClientApp client4 = this.clientAppConfig.getClient("test-client11");
        Assert.assertNotNull((Object)client4);
        Assert.assertEquals((Object)"test-client11", (Object)client4.getName());
        Assert.assertEquals((Object)"http://localhost:8811/test-client11/t", (Object)client4.getProperty("myClientRequiredConfigUrl"));
        Assert.assertNull((Object)client4.getTemplateAssetsUrl());
        try {
            client4.getProperties().put("newProperty", " test value");
            Assert.fail((String)"Shouldn't be able to modify the client's processed properties.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        ClientAppConfig.ClientApp newClient = new ClientAppConfig.ClientApp("testClient" + System.currentTimeMillis(), "http://localhost:8085/testclient", Collections.singletonMap("sharedLinkBaseUrl", "http://localhost:8085/test-client/s"));
        try {
            clients.put(newClient.getName(), newClient);
            Assert.fail((String)"Shouldn't be able to modify the clients map.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }
}

