/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.AssertionFailedError;
import org.alfresco.repo.rendition2.AbstractRenditionIntegrationTest;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.transform.registry.AbstractTransformRegistry;
import org.alfresco.transform.registry.SupportedTransform;
import org.alfresco.util.testing.category.DebugTests;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class AbstractRenditionTest
extends AbstractRenditionIntegrationTest {
    public static final List<String> TAS_REST_API_SOURCE_EXTENSIONS = Arrays.asList("gif", "jpg", "png", "msg", "doc", "ppt", "xls", "docx", "pptx", "xlsx");
    public static final List<String> TAS_REST_API_EXCLUDE_LIST = Collections.EMPTY_LIST;
    public static final List<String> ALL_SOURCE_EXTENSIONS_EXCLUDE_LIST_LEGACY = Arrays.asList("key jpg imgpreview", "key jpg medium", "key png doclib", "key png avatar", "key png avatar32", "pages jpg imgpreview", "pages jpg medium", "pages png doclib", "pages png avatar", "pages png avatar32", "numbers jpg imgpreview", "numbers jpg medium", "numbers png doclib", "numbers png avatar", "numbers png avatar32", "tiff jpg imgpreview", "tiff jpg medium", "tiff png doclib", "tiff png avatar", "tiff png avatar32", "wpd pdf pdf", "wpd jpg medium", "wpd png doclib", "wpd png avatar", "wpd png avatar32", "wpd jpg imgpreview");

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getAdminUserName());
    }

    private Set<String> getThumbnailNames(List<ThumbnailDefinition> thumbnailDefinitions) {
        HashSet<String> names = new HashSet<String>();
        for (ThumbnailDefinition thumbnailDefinition : thumbnailDefinitions) {
            String name = thumbnailDefinition.getName();
            names.add(name);
        }
        return names;
    }

    private void assertRenditionsOkayFromSourceExtension(List<String> sourceExtensions, List<String> excludeList, List<String> expectedToFail, int expectedRenditionCount, int expectedFailedCount) throws Exception {
        int renditionCount = 0;
        int failedCount = 0;
        int successCount = 0;
        int excludedCount = 0;
        RenditionDefinitionRegistry2 renditionDefinitionRegistry2 = this.renditionService2.getRenditionDefinitionRegistry2();
        StringJoiner failures = new StringJoiner("\n");
        StringJoiner successes = new StringJoiner("\n");
        for (String sourceExtension : sourceExtensions) {
            String sourceMimetype = this.mimetypeMap.getMimetype(sourceExtension);
            String testFileName = this.getTestFileName(sourceMimetype);
            if (testFileName == null) continue;
            Set renditionNames = renditionDefinitionRegistry2.getRenditionNamesFrom(sourceMimetype, -1L);
            List thumbnailDefinitions = this.thumbnailRegistry.getThumbnailDefinitions(sourceMimetype, -1L);
            Set<String> thumbnailNames = this.getThumbnailNames(thumbnailDefinitions);
            AbstractRenditionTest.assertEquals((String)("There should be the same renditions (" + String.valueOf(renditionNames) + ") as deprecated thumbnails (" + String.valueOf(thumbnailNames) + ")"), thumbnailNames, (Object)renditionNames);
            renditionCount += renditionNames.size();
            for (String renditionName : renditionNames) {
                RenditionDefinition2 renditionDefinition = renditionDefinitionRegistry2.getRenditionDefinition(renditionName);
                String targetMimetype = renditionDefinition.getTargetMimetype();
                String targetExtension = this.mimetypeMap.getExtension(targetMimetype);
                String sourceTragetRendition = sourceExtension + " " + targetExtension + " " + renditionName;
                if (excludeList.contains(sourceTragetRendition)) {
                    ++excludedCount;
                    continue;
                }
                try {
                    this.checkRendition(testFileName, renditionName, !expectedToFail.contains(sourceTragetRendition));
                    successes.add(sourceTragetRendition);
                    ++successCount;
                }
                catch (AssertionFailedError e) {
                    failures.add(sourceTragetRendition + " " + e.getMessage());
                    ++failedCount;
                }
            }
        }
        int expectedSuccessCount = expectedRenditionCount - excludedCount - expectedFailedCount;
        System.out.println("FAILURES:\n" + String.valueOf(failures) + "\n");
        System.out.println("SUCCESSES:\n" + String.valueOf(successes) + "\n");
        System.out.println("renditionCount: " + renditionCount + " expected " + expectedRenditionCount);
        System.out.println("   failedCount: " + failedCount + " expected " + expectedFailedCount);
        System.out.println("  successCount: " + successCount + " expected " + expectedSuccessCount);
        AbstractRenditionTest.assertEquals((String)"Rendition count has changed", (int)expectedRenditionCount, (int)renditionCount);
        AbstractRenditionTest.assertEquals((String)"Failed rendition count has changed", (int)expectedFailedCount, (int)failedCount);
        AbstractRenditionTest.assertEquals((String)"Successful rendition count has changed", (int)expectedSuccessCount, (int)successCount);
        if (failures.length() > 0) {
            AbstractRenditionTest.fail((String)failures.toString());
        }
    }

    private void assertMetadataExtractsOkayFromSourceExtension(List<String> sourceExtensions, List<String> excludeList, List<String> expectedToFail, int expectedExtractCount, int expectedFailedCount) throws Exception {
        int extractCount = 0;
        int failedCount = 0;
        int successCount = 0;
        int excludedCount = 0;
        this.renditionService2.getRenditionDefinitionRegistry2();
        StringJoiner failures = new StringJoiner("\n");
        StringJoiner successes = new StringJoiner("\n");
        for (String sourceExtension : sourceExtensions) {
            String sourceMimetype = this.mimetypeMap.getMimetype(sourceExtension);
            String testFileName = this.getTestFileName(sourceMimetype);
            if (testFileName == null) continue;
            ++extractCount;
            if (excludeList.contains(sourceExtension)) {
                ++excludedCount;
                continue;
            }
            try {
                this.checkExtract(testFileName, !expectedToFail.contains(sourceExtension));
                successes.add(sourceExtension);
                ++successCount;
            }
            catch (AssertionFailedError assertionFailedError) {
                failures.add(sourceExtension);
                ++failedCount;
            }
        }
        int expectedSuccessCount = expectedExtractCount - excludedCount - expectedFailedCount;
        System.out.println("FAILURES:\n" + String.valueOf(failures) + "\n");
        System.out.println("SUCCESSES:\n" + String.valueOf(successes) + "\n");
        System.out.println("extractCount: " + extractCount + " expected " + expectedExtractCount);
        System.out.println(" failedCount: " + failedCount + " expected " + expectedFailedCount);
        System.out.println("successCount: " + successCount + " expected " + expectedSuccessCount);
        AbstractRenditionTest.assertEquals((String)"Extract count has changed", (int)expectedExtractCount, (int)extractCount);
        AbstractRenditionTest.assertEquals((String)"Failed extract count has changed", (int)expectedFailedCount, (int)failedCount);
        AbstractRenditionTest.assertEquals((String)"Successful extract count has changed", (int)expectedSuccessCount, (int)successCount);
    }

    @Test
    public void testExpectedNumberOfRenditions() throws Exception {
        RenditionDefinitionRegistry2 renditionDefinitionRegistry21 = this.renditionService2.getRenditionDefinitionRegistry2();
        Set renditionNames = renditionDefinitionRegistry21.getRenditionNames();
        AbstractRenditionTest.assertEquals((String)"Added or removed a definition (rendition-service2-contex.xml)?", (int)7, (int)renditionNames.size());
    }

    @Category(value={DebugTests.class})
    public void testTasRestApiRenditions() throws Exception {
        this.internalTestTasRestApiRenditions(62, 0);
    }

    protected void internalTestTasRestApiRenditions(int expectedRenditionCount, int expectedFailedCount) throws Exception {
        this.assertRenditionsOkayFromSourceExtension(TAS_REST_API_SOURCE_EXTENSIONS, TAS_REST_API_EXCLUDE_LIST, Collections.emptyList(), expectedRenditionCount, expectedFailedCount);
    }

    @Category(value={DebugTests.class})
    @Test
    public void testAllSourceExtensions() throws Exception {
        this.internalTestAllSourceExtensions(196, 0, ALL_SOURCE_EXTENSIONS_EXCLUDE_LIST_LEGACY);
    }

    protected void internalTestAllSourceExtensions(int expectedRenditionCount, int expectedFailedCount, List<String> excludeList) throws Exception {
        List<String> sourceExtensions = this.getAllSourceMimetypes();
        this.assertRenditionsOkayFromSourceExtension(sourceExtensions, excludeList, Collections.emptyList(), expectedRenditionCount, expectedFailedCount);
    }

    private List<String> getAllSourceMimetypes() {
        ArrayList<String> sourceExtensions = new ArrayList<String>();
        for (String sourceMimetype : this.mimetypeMap.getMimetypes()) {
            String sourceExtension = this.mimetypeMap.getExtension(sourceMimetype);
            sourceExtensions.add(sourceExtension);
        }
        return sourceExtensions;
    }

    @Test
    public void testGifRenditions() throws Exception {
        this.internalTestGifRenditions(5, 0);
    }

    protected void internalTestGifRenditions(int expectedRenditionCount, int expectedFailedCount) throws Exception {
        this.assertRenditionsOkayFromSourceExtension(Arrays.asList("gif"), Collections.emptyList(), Collections.emptyList(), expectedRenditionCount, expectedFailedCount);
    }

    @Test
    public void testSelectedMetadataExtracts() throws Exception {
        this.internalTestSelectedMetadataExtracts(7, 0);
    }

    protected void internalTestSelectedMetadataExtracts(int expectedExtractCount, int expectedFailedCount) throws Exception {
        this.assertMetadataExtractsOkayFromSourceExtension(Arrays.asList("msg", "doc", "odt", "pdf", "docx", "mp4", "png"), Collections.emptyList(), Collections.emptyList(), expectedExtractCount, expectedFailedCount);
    }

    @Test
    @Category(value={DebugTests.class})
    public void testCountTotalTransforms() {
        StringBuilder sourceTargetList = new StringBuilder();
        StringBuilder sourceTargetPriorityList = new StringBuilder();
        AtomicInteger count = new AtomicInteger(0);
        int textTargetCount = 0;
        this.mimetypeService.getMimetypesByExtension();
        ArrayList<String> mimetypes = new ArrayList<String>(this.mimetypeMap.getMimetypes());
        this.sortMimetypesByExtension(mimetypes);
        for (String sourceMimetype : mimetypes) {
            for (String targetMimetype : mimetypes) {
                if (!this.transformServiceRegistry.isSupported(sourceMimetype, 1L, targetMimetype, Collections.emptyMap(), null)) continue;
                this.logSourceTarget(sourceTargetList, sourceTargetPriorityList, count, sourceMimetype, targetMimetype);
                if (!"text/plain".equals(targetMimetype)) continue;
                ++textTargetCount;
            }
        }
        System.out.println("Number of source to target mimetype transforms: " + String.valueOf(count));
        System.out.println("Number of source to plain text transforms: " + textTargetCount);
        System.out.println(sourceTargetList);
        if (sourceTargetPriorityList.length() > 0) {
            System.out.println("");
            System.out.println("Alternate transforms");
            System.out.println(sourceTargetPriorityList);
        }
    }

    @Test
    @Category(value={DebugTests.class})
    public void testCountTotalRenditionTransforms() {
        StringBuilder sourceTargetList = new StringBuilder();
        AtomicInteger count = new AtomicInteger(0);
        RenditionDefinitionRegistry2 renditionDefinitionRegistry = this.renditionService2.getRenditionDefinitionRegistry2();
        ArrayList<String> sourceMimetypes = new ArrayList<String>(this.mimetypeMap.getMimetypes());
        this.sortMimetypesByExtension(sourceMimetypes);
        for (String sourceMimetype : sourceMimetypes) {
            HashSet<String> targetMimetypes = new HashSet<String>();
            for (String renditionName : renditionDefinitionRegistry.getRenditionNamesFrom(sourceMimetype, 1L)) {
                RenditionDefinition2 renditionDefinition = renditionDefinitionRegistry.getRenditionDefinition(renditionName);
                String targetMimetype = renditionDefinition.getTargetMimetype();
                targetMimetypes.add(targetMimetype);
            }
            ArrayList<String> targetMimetypesSorted = new ArrayList<String>(targetMimetypes);
            this.sortMimetypesByExtension(targetMimetypesSorted);
            for (String targetMimetype : targetMimetypesSorted) {
                this.logSourceTarget(sourceTargetList, null, count, sourceMimetype, targetMimetype);
            }
        }
        System.out.println("Number of source to target mimetype transforms via renditions: " + count.get());
        System.out.println(sourceTargetList);
    }

    private void logSourceTarget(StringBuilder sourceTargetList, StringBuilder sourceTargetPriorityList, AtomicInteger count, String sourceMimetype, String targetMimetype) {
        AbstractTransformRegistry registry;
        count.incrementAndGet();
        String sourceExtension = this.mimetypeService.getExtension(sourceMimetype);
        String targetExtension = this.mimetypeService.getExtension(targetMimetype);
        String line = String.format("%4d %4s %4s\n", count.get(), sourceExtension, targetExtension);
        sourceTargetList.append(line);
        if (sourceTargetPriorityList != null && (registry = this.getAbstractTransformRegistry()) != null) {
            Map supportedTransformsByTargetMimetype = registry.getData().retrieveTransforms(sourceMimetype);
            ArrayList supportedTransforms = new ArrayList((Collection)supportedTransformsByTargetMimetype.get(targetMimetype));
            supportedTransforms.sort((t1, t2) -> t1.getPriority() - t2.getPriority());
            char a = 'a';
            int prevPriority = Integer.MAX_VALUE;
            for (SupportedTransform supportedTransform : supportedTransforms) {
                int priority = supportedTransform.getPriority();
                long maxSourceSizeBytes = supportedTransform.getMaxSourceSizeBytes();
                String priorityUnchanged = prevPriority == priority ? "*" : "";
                String transformName = supportedTransform.getName();
                Object[] objectArray = new Object[8];
                objectArray[0] = count.get();
                objectArray[1] = sourceExtension;
                objectArray[2] = targetExtension;
                char c = a;
                a = (char)(c + 1);
                objectArray[3] = Character.valueOf(c);
                objectArray[4] = priority;
                objectArray[5] = priorityUnchanged;
                objectArray[6] = transformName;
                objectArray[7] = maxSourceSizeBytes;
                line = String.format("%4d %4s %4s %c) [%d%s] %s %d\n", objectArray);
                sourceTargetPriorityList.append(line);
                prevPriority = priority;
            }
        }
    }

    protected AbstractTransformRegistry getAbstractTransformRegistry() {
        return null;
    }

    private void sortMimetypesByExtension(List<String> mimetypes) {
        ArrayList<String> extensions = new ArrayList<String>(mimetypes.size());
        for (String mimetype : mimetypes) {
            extensions.add(this.mimetypeMap.getExtension(mimetype));
        }
        Collections.sort(extensions);
        mimetypes.clear();
        for (String extension : extensions) {
            mimetypes.add(this.mimetypeService.getMimetype(extension));
        }
    }
}

