/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.util.ArrayList;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.Pair;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@ContextConfiguration(value={"classpath:alfresco/application-context.xml", "classpath:org/alfresco/repo/site/site-custom-context.xml"})
@Category(value={NeverRunsTests.class})
public class CustomRoleTest
extends BaseAlfrescoSpringTest {
    private static final String USER_ONE = "UserOne_CustomRoleTest";
    private static final String USER_TWO = "UserTwo_CustomRoleTest";
    private SiteService siteService;
    private PersonService personService;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.siteService = (SiteService)this.applicationContext.getBean("SiteService");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.createUser(USER_ONE, "UserOne");
        this.createUser(USER_TWO, "UserTwo");
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    public void testCustomRole() {
        try {
            this.siteService.createSite("customrolessite", "customrolessite", "Test custom role", "Test custom role", SiteVisibility.PUBLIC);
            this.siteService.setMembership("customrolessite", USER_TWO, "SiteCoordinator");
            ArrayList<Pair> sort = new ArrayList<Pair>();
            sort.add(new Pair((Object)SiteService.SortFields.SiteTitle, (Object)Boolean.TRUE));
            sort.add(new Pair((Object)SiteService.SortFields.Role, (Object)Boolean.TRUE));
            PagingResults sites = this.siteService.listSitesPaged(USER_TWO, sort, new PagingRequest(0, 100));
            CustomRoleTest.assertNotNull((Object)sites);
            CustomRoleTest.assertEquals((int)sites.getPage().size(), (int)1);
        }
        catch (Exception ex) {
            CustomRoleTest.fail((String)("Custom role breaks sites API. Take a look on MNT-12873\n" + ex.getMessage()));
        }
    }
}

