/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.schema;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.DialectFactory;
import org.alfresco.repo.domain.dialect.SQLServerDialect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class DataSourceCheck {
    private static Log logger = LogFactory.getLog((String)"org.alfresco.repo.admin");
    private static final String MSG_DB_CONNECTION = "system.config_check.info.db_connection";
    private static final String MSG_DB_VERSION = "system.config_check.info.db_version";
    private static final String ERR_DB_CONNECTION = "system.config_check.err.db_connection";
    private static final String ERR_WRONG_TRANSACTION_ISOLATION_SQL_SERVER = "system.config_check.err.wrong_transaction_isolation_sql_server";
    private static final int SQL_SERVER_TRANSACTION_ISOLATION = 4096;
    private String dbUrl;
    private String dbUsername;
    private int transactionIsolation;
    private DataSource dataSource;

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public void init() {
        logger.info((Object)I18NUtil.getMessage((String)MSG_DB_CONNECTION, (Object[])new Object[]{this.dbUrl, this.dbUsername}));
        Connection con = null;
        try {
            try {
                con = this.dataSource.getConnection();
                con.setAutoCommit(true);
                DatabaseMetaData meta = con.getMetaData();
                logger.info((Object)I18NUtil.getMessage((String)MSG_DB_VERSION, (Object[])new Object[]{meta.getDatabaseProductName(), meta.getDatabaseProductVersion()}));
                Dialect dialect = DialectFactory.buildDialect(meta.getDatabaseProductName(), meta.getDatabaseMajorVersion(), meta.getDriverName());
                if (dialect instanceof SQLServerDialect && this.transactionIsolation != 4096) {
                    throw new AlfrescoRuntimeException(ERR_WRONG_TRANSACTION_ISOLATION_SQL_SERVER, new Object[]{this.transactionIsolation, 4096});
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new AlfrescoRuntimeException(ERR_DB_CONNECTION, new Object[]{e.getMessage()}, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            try {
                con.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            con.close();
        }
        catch (Exception exception) {}
    }
}

