/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.SpringBasedIdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.user.UserInfoAttrMapping;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class SpringBasedIdentityServiceFacadeUnitTest {
    private static final String USER_NAME = "user";
    private static final String PASSWORD = "password";
    private static final String TOKEN = "tEsT-tOkEn";
    private static final UserInfoAttrMapping USER_INFO_ATTR_MAPPING = new UserInfoAttrMapping("preferred_username", "given_name", "family_name", "email");

    @Test
    public void shouldThrowVerificationExceptionOnFailure() {
        RestTemplate restTemplate = (RestTemplate)Mockito.mock(RestTemplate.class);
        Mockito.when((Object)restTemplate.getErrorHandler()).thenReturn((Object)new DefaultResponseErrorHandler());
        JwtDecoder jwtDecoder = (JwtDecoder)Mockito.mock(JwtDecoder.class);
        SpringBasedIdentityServiceFacade facade = new SpringBasedIdentityServiceFacade(restTemplate, this.testRegistration(), jwtDecoder);
        Assertions.assertThatExceptionOfType(IdentityServiceFacade.AuthorizationException.class).isThrownBy(() -> {
            IdentityServiceFacade.AccessTokenAuthorization accessTokenAuthorization = facade.authorize(IdentityServiceFacade.AuthorizationGrant.password((String)USER_NAME, (String)PASSWORD));
        }).withMessageContaining("Failed to obtain access token");
    }

    @Test
    public void shouldThrowTokenExceptionOnFailure() {
        RestTemplate restTemplate = (RestTemplate)Mockito.mock(RestTemplate.class);
        Mockito.when((Object)restTemplate.getErrorHandler()).thenReturn((Object)new DefaultResponseErrorHandler());
        JwtDecoder jwtDecoder = (JwtDecoder)Mockito.mock(JwtDecoder.class);
        Mockito.when((Object)jwtDecoder.decode(TOKEN)).thenThrow(new Throwable[]{new RuntimeException("Expected")});
        SpringBasedIdentityServiceFacade facade = new SpringBasedIdentityServiceFacade(restTemplate, this.testRegistration(), jwtDecoder);
        Assertions.assertThatExceptionOfType(IdentityServiceFacade.TokenDecodingException.class).isThrownBy(() -> {
            IdentityServiceFacade.DecodedAccessToken decodedAccessToken = facade.decodeToken(TOKEN);
        }).havingCause().withNoCause().withMessage("Expected");
    }

    @Test
    public void shouldReturnEmptyOptionalOnFailure() {
        RestTemplate restTemplate = (RestTemplate)Mockito.mock(RestTemplate.class);
        Mockito.when((Object)restTemplate.getErrorHandler()).thenReturn((Object)new DefaultResponseErrorHandler());
        JwtDecoder jwtDecoder = (JwtDecoder)Mockito.mock(JwtDecoder.class);
        SpringBasedIdentityServiceFacade facade = new SpringBasedIdentityServiceFacade(restTemplate, this.testRegistration(), jwtDecoder);
        Assertions.assertThat((boolean)facade.getUserInfo(TOKEN, USER_INFO_ATTR_MAPPING).isEmpty()).isTrue();
    }

    private ClientRegistration testRegistration() {
        return ClientRegistration.withRegistrationId((String)"test").tokenUri("http://localhost").clientId("test").clientSecret("test-secret").userInfoUri("http://localhost/userinfo").authorizationGrantType(AuthorizationGrantType.TOKEN_EXCHANGE).build();
    }
}

