/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.messaging.camel.routes;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RepoNodeEventsRouteBuilder
extends RouteBuilder {
    private static Log logger = LogFactory.getLog(RepoNodeEventsRouteBuilder.class);
    private static final String DEFAULT_SOURCE = "direct:alfresco.events";
    private static final String DEFAULT_TARGET = "amqp:topic:alfresco.repo.events?jmsMessageType=Text";
    @Value(value="${messaging.events.repo.node.sourceQueue.endpoint:direct:alfresco.events}")
    public String sourceQueue;
    @Value(value="${messaging.events.repo.node.targetTopic.endpoint:amqp:topic:alfresco.repo.events?jmsMessageType=Text}")
    public String targetTopic;

    public void configure() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Repo node events routes config: ");
            logger.debug((Object)("SourceQueue is " + this.sourceQueue));
            logger.debug((Object)("targetTopic is " + this.targetTopic));
        }
        ((RouteDefinition)((RouteDefinition)this.from(this.sourceQueue).routeId("alfresco.events -> topic:alfresco.repo.events").marshal("defaultDataFormat")).to(this.targetTopic)).end();
    }
}

