/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2.filter;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.event2.filter.EventFilter;
import org.alfresco.repo.event2.shared.CSVStringToListParser;
import org.alfresco.repo.event2.shared.QNameMatcher;
import org.alfresco.repo.event2.shared.TypeDefExpander;
import org.alfresco.service.namespace.QName;

public abstract class AbstractNodeEventFilter
implements EventFilter<QName> {
    protected TypeDefExpander typeDefExpander;
    private QNameMatcher qNameMatcher;

    public final void init() {
        this.qNameMatcher = new QNameMatcher(this.getExcludedTypes());
    }

    public void setTypeDefExpander(TypeDefExpander typeDefExpander) {
        this.typeDefExpander = typeDefExpander;
    }

    @Override
    public boolean isExcluded(QName qName) {
        return this.qNameMatcher.isMatching(qName);
    }

    protected abstract Set<QName> getExcludedTypes();

    protected List<String> parseFilterList(String unparsedFilterList) {
        return CSVStringToListParser.parse(unparsedFilterList);
    }

    protected Collection<QName> expandTypeDef(String typeDef) {
        return this.typeDefExpander.expand(typeDef);
    }
}

