/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class RunAsTenantInterceptor
implements MethodInterceptor {
    private TENANT_TYPE tenantType;

    public RunAsTenantInterceptor(TENANT_TYPE tenantType) {
        this.tenantType = tenantType;
    }

    public Object invoke(final MethodInvocation mi) throws Throwable {
        TenantUtil.TenantRunAsWork<Object> runAs = new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                try {
                    return mi.proceed();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException("Failed to execute in RunAsTenant context", e);
                }
            }
        };
        if (this.tenantType == TENANT_TYPE.Default) {
            return TenantUtil.runAsDefaultTenant((TenantUtil.TenantRunAsWork)runAs);
        }
        return TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)runAs, (String)((String)AuthenticationUtil.getUserTenant((String)AuthenticationUtil.getFullyAuthenticatedUser()).getSecond()));
    }

    public static enum TENANT_TYPE {
        Default,
        RealUser;

    }
}

