/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import org.alfresco.encryption.MissingKeyException;
import org.alfresco.encryption.ReEncryptor;
import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class BootstrapReEncryptor
extends AbstractLifecycleBean {
    private static Log logger = LogFactory.getLog(BootstrapReEncryptor.class);
    private boolean enabled;
    private ReEncryptor reEncryptor;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setReEncryptor(ReEncryptor reEncryptor) {
        this.reEncryptor = reEncryptor;
    }

    public int reEncrypt() {
        try {
            return this.reEncryptor.bootstrapReEncrypt();
        }
        catch (MissingKeyException e) {
            throw new AlfrescoRuntimeException("Bootstrap re-encryption failed", (Throwable)e);
        }
    }

    protected void onBootstrap(ApplicationEvent event) {
        if (this.enabled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Re-encrypting encryptable properties...");
            }
            int propertiesReEncrypted = this.reEncrypt();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("...done, re-encrypted " + propertiesReEncrypted + " properties."));
            }
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }
}

