/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.caching.BackingStoreAwareCacheWriter;
import org.alfresco.repo.content.caching.CacheMissException;
import org.alfresco.repo.content.caching.CachingContentStoreCreatedEvent;
import org.alfresco.repo.content.caching.ContentCache;
import org.alfresco.repo.content.caching.quota.QuotaManagerStrategy;
import org.alfresco.repo.content.caching.quota.UnlimitedQuotaStrategy;
import org.alfresco.repo.content.filestore.SpoofedTextContentReader;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class CachingContentStore
implements ContentStore,
ApplicationEventPublisherAware,
BeanNameAware {
    private static final Log log = LogFactory.getLog(CachingContentStore.class);
    private static final int numLocks = 256;
    private static final ReentrantReadWriteLock[] locks = new ReentrantReadWriteLock[256];
    private ContentStore backingStore;
    private ContentCache cache;
    private QuotaManagerStrategy quota = new UnlimitedQuotaStrategy();
    private boolean cacheOnInbound;
    private int maxCacheTries = 2;
    private ApplicationEventPublisher eventPublisher;
    private String beanName;

    static {
        int i = 0;
        while (i < 256) {
            CachingContentStore.locks[i] = new ReentrantReadWriteLock();
            ++i;
        }
    }

    public CachingContentStore() {
    }

    public CachingContentStore(ContentStore backingStore, ContentCache cache, boolean cacheOnInbound) {
        this.backingStore = backingStore;
        this.cache = cache;
        this.cacheOnInbound = cacheOnInbound;
    }

    public void init() {
        this.eventPublisher.publishEvent((ApplicationEvent)new CachingContentStoreCreatedEvent(this));
    }

    public boolean isContentUrlSupported(String contentUrl) {
        return this.backingStore.isContentUrlSupported(contentUrl);
    }

    public boolean isWriteSupported() {
        return this.backingStore.isWriteSupported();
    }

    public long getSpaceFree() {
        return this.backingStore.getSpaceFree();
    }

    public long getSpaceTotal() {
        return this.backingStore.getSpaceTotal();
    }

    public String getRootLocation() {
        return this.backingStore.getRootLocation();
    }

    public boolean exists(String contentUrl) {
        if (contentUrl.startsWith("spoof")) {
            return true;
        }
        return this.backingStore.exists(contentUrl);
    }

    public ContentReader getReader(String contentUrl) {
        if (contentUrl.startsWith("spoof")) {
            return new SpoofedTextContentReader(contentUrl);
        }
        ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock(contentUrl).readLock();
        readLock.lock();
        try {
            if (this.cache.contains(contentUrl)) {
                ContentReader contentReader = this.cache.getReader(contentUrl);
                return contentReader;
            }
        }
        catch (CacheMissException cacheMissException) {
        }
        finally {
            readLock.unlock();
        }
        return this.cacheAndRead(contentUrl);
    }

    private ContentReader cacheAndRead(String url) {
        ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock(url).writeLock();
        writeLock.lock();
        try {
            int i = 0;
            while (i < this.maxCacheTries) {
                ContentReader backingStoreReader = this.backingStore.getReader(url);
                long contentSize = backingStoreReader.getSize();
                if (!this.quota.beforeWritingCacheFile(contentSize)) {
                    ContentReader contentReader = backingStoreReader;
                    return contentReader;
                }
                ContentReader reader = this.attemptCacheAndRead(url, backingStoreReader);
                if (reader != null) {
                    boolean keepCacheFile = this.quota.afterWritingCacheFile(contentSize);
                    if (keepCacheFile) {
                        ContentReader contentReader = reader;
                        return contentReader;
                    }
                    this.cache.deleteFile(url);
                    this.cache.remove(url);
                    ContentReader contentReader = this.backingStore.getReader(url);
                    return contentReader;
                }
                ++i;
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)("Attempted " + this.maxCacheTries + " times to cache content item and failed - returning reader from backing store instead [backingStore=" + String.valueOf(this.backingStore) + ", url=" + url + "]"));
            }
            ContentReader contentReader = this.backingStore.getReader(url);
            return contentReader;
        }
        finally {
            writeLock.unlock();
        }
    }

    private ContentReader attemptCacheAndRead(String url, ContentReader backingStoreReader) {
        ContentReader reader = null;
        try {
            if (!this.cache.contains(url)) {
                if (this.cache.put(url, backingStoreReader)) {
                    reader = this.cache.getReader(url);
                }
            } else {
                reader = this.cache.getReader(url);
            }
        }
        catch (CacheMissException cacheMissException) {
            this.cache.remove(url);
        }
        return reader;
    }

    public ContentWriter getWriter(ContentContext context) {
        if (this.cacheOnInbound) {
            final ContentWriter bsWriter = this.backingStore.getWriter(context);
            if (!this.quota.beforeWritingCacheFile(0L)) {
                return bsWriter;
            }
            final String url = bsWriter.getContentUrl();
            final BackingStoreAwareCacheWriter cacheWriter = new BackingStoreAwareCacheWriter(this.cache.getWriter(url), bsWriter);
            cacheWriter.addListener(new ContentStreamListener(){

                public void contentStreamClosed() throws ContentIOException {
                    boolean contentUrlChanged;
                    bsWriter.setEncoding(cacheWriter.getEncoding());
                    bsWriter.setLocale(cacheWriter.getLocale());
                    bsWriter.setMimetype(cacheWriter.getMimetype());
                    bsWriter.putContent(cacheWriter.getReader());
                    boolean bl = contentUrlChanged = !url.equals(bsWriter.getContentUrl());
                    if (!CachingContentStore.this.quota.afterWritingCacheFile(cacheWriter.getSize()) || contentUrlChanged) {
                        if (contentUrlChanged) {
                            CachingContentStore.this.cache.put(bsWriter.getContentUrl(), cacheWriter.getReader());
                        }
                        CachingContentStore.this.cache.deleteFile(url);
                        CachingContentStore.this.cache.remove(url);
                    }
                }
            });
            return cacheWriter;
        }
        return this.backingStore.getWriter(context);
    }

    public boolean delete(String contentUrl) {
        if (contentUrl.startsWith("spoof")) {
            return false;
        }
        ReentrantReadWriteLock readWriteLock = this.readWriteLock(contentUrl);
        ReentrantReadWriteLock.ReadLock readLock = readWriteLock.readLock();
        readLock.lock();
        try {
            if (!this.cache.contains(contentUrl)) {
                boolean bl = this.backingStore.delete(contentUrl);
                return bl;
            }
        }
        finally {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = readWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.cache.contains(contentUrl)) {
                this.cache.remove(contentUrl);
            }
            boolean bl = this.backingStore.delete(contentUrl);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public Map<String, String> getStorageProperties(String contentUrl) {
        return this.backingStore.getStorageProperties(contentUrl);
    }

    public boolean requestSendContentToArchive(String contentUrl, Map<String, Serializable> archiveParams) {
        return this.backingStore.requestSendContentToArchive(contentUrl, archiveParams);
    }

    public boolean requestRestoreContentFromArchive(String contentUrl, Map<String, Serializable> restoreParams) {
        return this.backingStore.requestRestoreContentFromArchive(contentUrl, restoreParams);
    }

    public ReentrantReadWriteLock readWriteLock(String url) {
        return locks[this.lockIndex(url)];
    }

    private int lockIndex(String url) {
        return url.hashCode() & 0xFF;
    }

    public void setBackingStore(ContentStore backingStore) {
        this.backingStore = backingStore;
    }

    public String getBackingStoreType() {
        return this.backingStore.getClass().getName();
    }

    public String getBackingStoreDescription() {
        return this.backingStore.toString();
    }

    public void setCache(ContentCache cache) {
        this.cache = cache;
    }

    public ContentCache getCache() {
        return this.cache;
    }

    public void setCacheOnInbound(boolean cacheOnInbound) {
        this.cacheOnInbound = cacheOnInbound;
    }

    public boolean isCacheOnInbound() {
        return this.cacheOnInbound;
    }

    public int getMaxCacheTries() {
        return this.maxCacheTries;
    }

    public void setMaxCacheTries(int maxCacheTries) {
        this.maxCacheTries = maxCacheTries;
    }

    public void setQuota(QuotaManagerStrategy quota) {
        this.quota = quota;
    }

    public QuotaManagerStrategy getQuota() {
        return this.quota;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public boolean isContentDirectUrlEnabled() {
        return this.backingStore.isContentDirectUrlEnabled();
    }

    public boolean isContentDirectUrlEnabled(String contentUrl) {
        return this.backingStore.isContentDirectUrlEnabled(contentUrl);
    }

    public DirectAccessUrl requestContentDirectUrl(String contentUrl, boolean attachment, String fileName) {
        return this.backingStore.requestContentDirectUrl(contentUrl, attachment, fileName);
    }

    public DirectAccessUrl requestContentDirectUrl(String contentUrl, boolean attachment, String fileName, Long validFor) {
        return this.backingStore.requestContentDirectUrl(contentUrl, attachment, fileName, validFor);
    }

    public DirectAccessUrl requestContentDirectUrl(String contentUrl, boolean attachment, String fileName, String mimeType, Long validFor) {
        return this.backingStore.requestContentDirectUrl(contentUrl, attachment, fileName, mimeType, validFor);
    }
}

