/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.dictionary.Facetable;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.search.impl.solr.facet.Exceptions;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetComparator;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetConfig;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetConfigException;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetModel;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetProperties;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class SolrFacetServiceImpl
extends AbstractLifecycleBean
implements SolrFacetService,
NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private static final Log logger = LogFactory.getLog(SolrFacetServiceImpl.class);
    public static final String ALFRESCO_SEARCH_ADMINISTRATORS_AUTHORITY = "ALFRESCO_SEARCH_ADMINISTRATORS";
    public static final String GROUP_ALFRESCO_SEARCH_ADMINISTRATORS_AUTHORITY = "GROUP_ALFRESCO_SEARCH_ADMINISTRATORS";
    private static final StoreRef FACET_STORE = new StoreRef("workspace://SpacesStore");
    private AuthorityService authorityService;
    private DictionaryService dictionaryService;
    protected NodeService nodeService;
    private NamespaceService namespaceService;
    private SearchService searchService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private BehaviourFilter behaviourFilter;
    private PolicyComponent policyComponent;
    private SolrFacetConfig facetConfig;
    private Repository repositoryHelper;
    private String facetsRootXPath;
    private String facetsRootChildName;
    private ImporterBootstrap importerBootstrap;
    private Properties bootstrapView;
    private SimpleCache<String, Object> singletonCache;
    private final String KEY_FACETS_HOME_NODEREF = "key.facetshome.noderef";
    private SimpleCache<String, NodeRef> facetNodeRefCache;
    private ConcurrentMap<String, SolrFacetProperties> defaultFacetsMap = new ConcurrentHashMap<String, SolrFacetProperties>(10);

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setRepositoryHelper(Repository repository) {
        this.repositoryHelper = repository;
    }

    public void setFacetConfig(SolrFacetConfig facetConfig) {
        this.facetConfig = facetConfig;
    }

    public void setFacetsRootXPath(String facetsRootXPath) {
        this.facetsRootXPath = facetsRootXPath;
    }

    public void setFacetsRootChildName(String facetsRootChildName) {
        this.facetsRootChildName = facetsRootChildName;
    }

    public void setImporterBootstrap(ImporterBootstrap importer) {
        this.importerBootstrap = importer;
    }

    public void setBootstrapView(Properties bootstrapView) {
        this.bootstrapView = bootstrapView;
    }

    public void setSingletonCache(SimpleCache<String, Object> singletonCache) {
        this.singletonCache = singletonCache;
    }

    public void setFacetNodeRefCache(SimpleCache<String, NodeRef> facetNodeRefCache) {
        this.facetNodeRefCache = facetNodeRefCache;
    }

    @Override
    public boolean isSearchAdmin(String userName) {
        if (userName == null) {
            return false;
        }
        return this.authorityService.isAdminAuthority(userName) || this.authorityService.getAuthoritiesForUser(userName).contains(GROUP_ALFRESCO_SEARCH_ADMINISTRATORS_AUTHORITY);
    }

    @Override
    public List<SolrFacetProperties> getFacets() {
        SolrFacetComparator comparator = new SolrFacetComparator(this.getFacetOrder());
        TreeSet<SolrFacetProperties> result = new TreeSet<SolrFacetProperties>(comparator);
        NodeRef facetsRoot = this.getFacetsRoot();
        if (facetsRoot != null) {
            for (ChildAssociationRef ref : this.nodeService.getChildAssocs(facetsRoot)) {
                if (!this.nodeService.getType(ref.getChildRef()).equals((Object)SolrFacetModel.TYPE_FACET_FIELD)) continue;
                result.add(this.getFacetProperties(ref.getChildRef()));
            }
        }
        result.addAll(this.defaultFacetsMap.values());
        return new ArrayList<SolrFacetProperties>(result);
    }

    public List<String> getFacetOrder() {
        NodeRef facetsRoot = this.getFacetsRoot();
        return facetsRoot == null ? new ArrayList<String>(this.facetConfig.getDefaultFacets().keySet()) : (List)((Object)this.nodeService.getProperty(facetsRoot, SolrFacetModel.PROP_FACET_ORDER));
    }

    @Override
    public SolrFacetProperties getFacet(String filterID) {
        NodeRef nodeRef = this.getFacetNodeRef(filterID);
        return nodeRef == null ? (SolrFacetProperties)this.defaultFacetsMap.get(filterID) : this.getFacetProperties(nodeRef);
    }

    @Override
    public NodeRef getFacetNodeRef(final String filterID) {
        ParameterCheck.mandatory((String)"filterID", (Object)filterID);
        NodeRef facetNodeRef = (NodeRef)this.facetNodeRefCache.get((Serializable)((Object)filterID));
        if (facetNodeRef != null) {
            if (!this.nodeService.exists(facetNodeRef)) {
                this.facetNodeRefCache.remove((Serializable)((Object)filterID));
                facetNodeRef = null;
            }
        } else {
            final NodeRef facetRoot = this.getFacetsRoot();
            if (facetRoot != null) {
                facetNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                    public NodeRef doWork() throws Exception {
                        NodeRef nodeRef = SolrFacetServiceImpl.this.nodeService.getChildByName(facetRoot, ContentModel.ASSOC_CONTAINS, filterID);
                        if (nodeRef != null) {
                            SolrFacetServiceImpl.this.facetNodeRefCache.put((Serializable)((Object)filterID), (Object)nodeRef);
                        }
                        return nodeRef;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
            }
        }
        return facetNodeRef;
    }

    private SolrFacetProperties getFacetProperties(NodeRef nodeRef) {
        Map properties = this.nodeService.getProperties(nodeRef);
        if (properties.isEmpty()) {
            return new SolrFacetProperties.Builder().build();
        }
        String filterID = (String)properties.get(ContentModel.PROP_NAME);
        boolean isDefault = (Boolean)properties.get(SolrFacetModel.PROP_IS_DEFAULT);
        SolrFacetProperties defaultFacet = (SolrFacetProperties)this.defaultFacetsMap.get(filterID);
        if (defaultFacet == null) {
            defaultFacet = new SolrFacetProperties.Builder().build();
        }
        QName fieldQName = this.getDefaultIfNull(defaultFacet.getFacetQName(), (QName)properties.get(SolrFacetModel.PROP_FIELD_TYPE));
        String displayName = this.getDefaultIfNull(defaultFacet.getDisplayName(), (String)properties.get(SolrFacetModel.PROP_FIELD_LABEL));
        String displayControl = this.getDefaultIfNull(defaultFacet.getDisplayControl(), (String)properties.get(SolrFacetModel.PROP_DISPLAY_CONTROL));
        int maxFilters = this.getDefaultIfNull(defaultFacet.getMaxFilters(), (Integer)properties.get(SolrFacetModel.PROP_MAX_FILTERS));
        int hitThreshold = this.getDefaultIfNull(defaultFacet.getHitThreshold(), (Integer)properties.get(SolrFacetModel.PROP_HIT_THRESHOLD));
        int minFilterValueLength = this.getDefaultIfNull(defaultFacet.getMinFilterValueLength(), (Integer)properties.get(SolrFacetModel.PROP_MIN_FILTER_VALUE_LENGTH));
        String sortBy = this.getDefaultIfNull(defaultFacet.getSortBy(), (String)properties.get(SolrFacetModel.PROP_SORT_BY));
        String scope = this.getDefaultIfNull(defaultFacet.getScope(), (String)properties.get(SolrFacetModel.PROP_SCOPE));
        Boolean isEnabled = this.getDefaultIfNull(defaultFacet.isEnabled(), (Boolean)properties.get(SolrFacetModel.PROP_IS_ENABLED));
        List scSites = (List)properties.get(SolrFacetModel.PROP_SCOPED_SITES);
        Set scopedSites = this.getDefaultIfNull(defaultFacet.getScopedSites(), scSites == null ? null : new HashSet(scSites));
        Set<SolrFacetProperties.CustomProperties> extraProps = null;
        Map<QName, Serializable> customProperties = this.getFacetCustomProperties(properties);
        boolean hasAspect = this.nodeService.hasAspect(nodeRef, SolrFacetModel.ASPECT_CUSTOM_PROPERTIES);
        if (!hasAspect && customProperties.isEmpty()) {
            extraProps = defaultFacet.getCustomProperties();
        } else {
            extraProps = new HashSet<SolrFacetProperties.CustomProperties>(customProperties.size());
            for (Map.Entry<QName, Serializable> cp : customProperties.entrySet()) {
                extraProps.add(new SolrFacetProperties.CustomProperties(cp.getKey(), cp.getValue()));
            }
        }
        SolrFacetProperties fp = new SolrFacetProperties.Builder().filterID(filterID).facetQName(fieldQName).displayName(displayName).displayControl(displayControl).maxFilters(maxFilters).hitThreshold(hitThreshold).minFilterValueLength(minFilterValueLength).sortBy(sortBy).scope(scope).isEnabled(isEnabled).isDefault(isDefault).scopedSites(scopedSites).customProperties(extraProps).build();
        return fp;
    }

    private <T> T getDefaultIfNull(T defaultValue, T newValue) {
        return newValue == null ? defaultValue : newValue;
    }

    @Override
    public NodeRef createFacetNode(SolrFacetProperties facetProperties) {
        return this.createFacetNodeImpl(facetProperties, true);
    }

    private NodeRef createFacetNodeImpl(final SolrFacetProperties facetProperties, boolean checkDefaultFP) {
        final String filterID = facetProperties.getFilterID();
        NodeRef facetNodeRef = this.getFacetNodeRef(filterID);
        if (facetNodeRef != null || checkDefaultFP && this.defaultFacetsMap.get(filterID) != null) {
            throw new SolrFacetConfigException("Unable to create facet because the filterID [" + filterID + "] is already in use.");
        }
        NodeRef facetRoot = this.getFacetsRoot();
        if (facetRoot == null) {
            facetRoot = this.createFacetsRootFolder();
        }
        final NodeRef finalFacetRoot = facetRoot;
        return (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return SolrFacetServiceImpl.this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                    @Override
                    public NodeRef execute() throws Exception {
                        (this).SolrFacetServiceImpl.this.behaviourFilter.disableBehaviour(finalFacetRoot, ContentModel.ASPECT_AUDITABLE);
                        try {
                            Map<QName, Serializable> properties = SolrFacetServiceImpl.this.createNodeProperties(facetProperties);
                            properties.put(ContentModel.PROP_IS_INDEXED, Boolean.valueOf(false));
                            NodeRef ref = (this).SolrFacetServiceImpl.this.nodeService.createNode(finalFacetRoot, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)filterID), SolrFacetModel.TYPE_FACET_FIELD, properties).getChildRef();
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Created [" + filterID + "] facet node with properties: [" + String.valueOf(properties) + "]"));
                            }
                            NodeRef nodeRef = ref;
                            return nodeRef;
                        }
                        finally {
                            (this).SolrFacetServiceImpl.this.behaviourFilter.enableBehaviour(finalFacetRoot, ContentModel.ASPECT_AUDITABLE);
                        }
                    }
                }, false);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateFacet(SolrFacetProperties facetProperties) {
        String filterID = facetProperties.getFilterID();
        NodeRef facetNodeRef = this.getFacetNodeRef(filterID);
        if (facetNodeRef == null) {
            SolrFacetProperties fp = (SolrFacetProperties)this.defaultFacetsMap.get(filterID);
            if (fp == null) throw new SolrFacetConfigException("Cannot update facet [" + filterID + "] as it does not exist.");
            this.createFacetNodeImpl(facetProperties, false);
        } else {
            Map<QName, Serializable> properties = this.createNodeProperties(facetProperties);
            for (Map.Entry<QName, Serializable> prop : properties.entrySet()) {
                this.nodeService.setProperty(facetNodeRef, prop.getKey(), prop.getValue());
            }
        }
        if (!logger.isDebugEnabled()) return;
        logger.debug((Object)("Updated [" + filterID + "] facet node. Properties: [" + String.valueOf(facetProperties) + "]"));
    }

    @Override
    public void deleteFacet(String filterID) {
        NodeRef facetNodeRef = this.getFacetNodeRef(filterID);
        if (facetNodeRef == null) {
            throw new SolrFacetConfigException("The [" + filterID + "] facet cannot be found.");
        }
        SolrFacetProperties defaultFP = (SolrFacetProperties)this.defaultFacetsMap.get(filterID);
        if (defaultFP != null) {
            throw new SolrFacetConfigException("The default [" + filterID + "] facet cannot be deleted. It can only be disabled.");
        }
        this.nodeService.deleteNode(facetNodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted [" + filterID + "] facet."));
        }
    }

    private Map<QName, Serializable> createNodeProperties(SolrFacetProperties facetProperties) {
        if (facetProperties.getFilterID() == null) {
            throw new SolrFacetConfigException("Filter Id cannot be null.");
        }
        boolean isDefaultFP = this.defaultFacetsMap.containsKey(facetProperties.getFilterID());
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(15);
        properties.put(ContentModel.PROP_NAME, (Serializable)((Object)facetProperties.getFilterID()));
        properties.put(SolrFacetModel.PROP_IS_DEFAULT, Boolean.valueOf(isDefaultFP));
        this.addNodeProperty(properties, SolrFacetModel.PROP_FIELD_TYPE, (Serializable)facetProperties.getFacetQName());
        this.addNodeProperty(properties, SolrFacetModel.PROP_FIELD_LABEL, (Serializable)((Object)facetProperties.getDisplayName()));
        this.addNodeProperty(properties, SolrFacetModel.PROP_DISPLAY_CONTROL, (Serializable)((Object)facetProperties.getDisplayControl()));
        this.addNodeProperty(properties, SolrFacetModel.PROP_MAX_FILTERS, Integer.valueOf(facetProperties.getMaxFilters()));
        this.addNodeProperty(properties, SolrFacetModel.PROP_HIT_THRESHOLD, Integer.valueOf(facetProperties.getHitThreshold()));
        this.addNodeProperty(properties, SolrFacetModel.PROP_MIN_FILTER_VALUE_LENGTH, Integer.valueOf(facetProperties.getMinFilterValueLength()));
        this.addNodeProperty(properties, SolrFacetModel.PROP_SCOPE, (Serializable)((Object)facetProperties.getScope()));
        this.addNodeProperty(properties, SolrFacetModel.PROP_SORT_BY, (Serializable)((Object)facetProperties.getSortBy()));
        this.addNodeProperty(properties, SolrFacetModel.PROP_SCOPED_SITES, (Serializable)((Object)facetProperties.getScopedSites()));
        this.addNodeProperty(properties, SolrFacetModel.PROP_IS_ENABLED, facetProperties.isEnabled());
        Set<SolrFacetProperties.CustomProperties> customProperties = facetProperties.getCustomProperties();
        if (customProperties != null) {
            properties.put(SolrFacetModel.PROP_EXTRA_INFORMATION, new ArrayList<SolrFacetProperties.CustomProperties>(customProperties));
        }
        return properties;
    }

    private void addNodeProperty(Map<QName, Serializable> properties, QName qname, Serializable propValue) {
        if (propValue == null) {
            return;
        }
        if (propValue instanceof Integer && (Integer)propValue < 0) {
            return;
        }
        if (propValue instanceof Collection && ((Collection)((Object)propValue)).isEmpty()) {
            return;
        }
        properties.put(qname, propValue);
    }

    public NodeRef getFacetsRoot() {
        NodeRef facetHomeRef = (NodeRef)this.singletonCache.get((Serializable)((Object)"key.facetshome.noderef"));
        if (facetHomeRef == null && (facetHomeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return SolrFacetServiceImpl.this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                    @Override
                    public NodeRef execute() throws Exception {
                        NodeRef result = null;
                        NodeRef rootNodeRef = (this).SolrFacetServiceImpl.this.nodeService.getRootNode(FACET_STORE);
                        List results = (this).SolrFacetServiceImpl.this.searchService.selectNodes(rootNodeRef, (this).SolrFacetServiceImpl.this.facetsRootXPath, null, (NamespacePrefixResolver)(this).SolrFacetServiceImpl.this.namespaceService, false, "xpath");
                        if (results.size() != 0) {
                            result = (NodeRef)results.get(0);
                        }
                        return result;
                    }
                }, true);
            }
        }, (String)AuthenticationUtil.getSystemUserName())) != null) {
            this.singletonCache.put((Serializable)((Object)"key.facetshome.noderef"), (Object)facetHomeRef);
        }
        return facetHomeRef;
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, SolrFacetModel.TYPE_FACET_FIELD, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, SolrFacetModel.TYPE_FACET_FIELD, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        HashMap<String, SolrFacetProperties> mergedMap = new HashMap<String, SolrFacetProperties>(100);
        Map<String, SolrFacetProperties> defaultFP = this.facetConfig.getDefaultFacets();
        this.defaultFacetsMap.putAll(defaultFP);
        mergedMap.putAll(defaultFP);
        Map<String, SolrFacetProperties> persistedProperties = this.getPersistedFacetProperties();
        for (Map.Entry<String, SolrFacetProperties> entry : persistedProperties.entrySet()) {
            final String facetId = entry.getKey();
            if (entry.getValue().isDefault() && !defaultFP.containsKey(facetId)) {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        return SolrFacetServiceImpl.this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            @Override
                            public Void execute() throws Exception {
                                SolrFacetServiceImpl.this.deleteFacet(facetId);
                                logger.info((Object)("Deleted [" + facetId + "] node, as the filter has been removed from the config file!"));
                                return null;
                            }
                        }, false);
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
                continue;
            }
            mergedMap.put(facetId, entry.getValue());
        }
        List<String> facetOrder = this.getFacetOrder();
        Comparator entryComparator = CollectionUtils.toEntryComparator((Comparator)new SolrFacetComparator(facetOrder));
        Map sortedMap = CollectionUtils.sortMapByValue(mergedMap, (Comparator)entryComparator);
        if (logger.isDebugEnabled() && persistedProperties.size() > 0) {
            logger.debug((Object)("The facets [" + String.valueOf(persistedProperties) + "] have overridden their matched default facets."));
        }
        final LinkedHashSet<String> newFacetOrder = facetOrder == null ? new LinkedHashSet<String>(sortedMap.size()) : new LinkedHashSet<String>(facetOrder);
        for (SolrFacetProperties fp : sortedMap.values()) {
            newFacetOrder.add(fp.getFilterID());
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                return SolrFacetServiceImpl.this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    @Override
                    public Void execute() throws Exception {
                        SolrFacetServiceImpl.this.reorderFacets(new ArrayList<String>(newFacetOrder));
                        return null;
                    }
                }, false);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The facets order [" + String.valueOf(newFacetOrder) + "] have been persisted."));
        }
    }

    private Map<String, SolrFacetProperties> getPersistedFacetProperties() {
        NodeRef facetsRoot = this.getFacetsRoot();
        HashMap<String, SolrFacetProperties> facets = new HashMap<String, SolrFacetProperties>();
        List list = facetsRoot == null ? new ArrayList() : this.nodeService.getChildAssocs(facetsRoot);
        for (ChildAssociationRef associationRef : list) {
            if (!this.nodeService.getType(associationRef.getChildRef()).equals((Object)SolrFacetModel.TYPE_FACET_FIELD)) continue;
            SolrFacetProperties fp = this.getFacetProperties(associationRef.getChildRef());
            facets.put(fp.getFilterID(), fp);
        }
        return facets;
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        SolrFacetProperties fp = this.getFacetProperties(childAssocRef.getChildRef());
        this.facetNodeRefCache.put((Serializable)((Object)fp.getFilterID()), (Object)childAssocRef.getChildRef());
        NodeRef facetsRoot = this.getFacetsRoot();
        ArrayList<String> facetOrder = (ArrayList<String>)this.nodeService.getProperty(facetsRoot, SolrFacetModel.PROP_FACET_ORDER);
        if (facetOrder == null) {
            List<SolrFacetProperties> facets = this.getFacets();
            facetOrder = new ArrayList<String>(facets.size());
            for (SolrFacetProperties facet : facets) {
                facetOrder.add(facet.getFilterID());
            }
        }
        facetOrder.add(fp.getFilterID());
        this.nodeService.setProperty(facetsRoot, SolrFacetModel.PROP_FACET_ORDER, facetOrder);
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        String filterID = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
        this.facetNodeRefCache.remove((Serializable)((Object)filterID));
        NodeRef facetsRoot = this.getFacetsRoot();
        ArrayList facetOrder = (ArrayList)this.nodeService.getProperty(facetsRoot, SolrFacetModel.PROP_FACET_ORDER);
        if (facetOrder.remove(filterID)) {
            this.nodeService.setProperty(facetsRoot, SolrFacetModel.PROP_FACET_ORDER, (Serializable)facetOrder);
        }
    }

    private Map<QName, Serializable> getFacetCustomProperties(Map<QName, Serializable> properties) {
        HashMap<QName, Serializable> customProperties = new HashMap<QName, Serializable>(5);
        for (Map.Entry<QName, Serializable> entry : properties.entrySet()) {
            if (!"http://www.alfresco.org/model/solrfacetcustomproperty/1.0".equals(entry.getKey().getNamespaceURI())) continue;
            Serializable values = entry.getValue();
            if (SolrFacetModel.PROP_EXTRA_INFORMATION.equals((Object)entry.getKey()) && values instanceof List) {
                List list = (List)((Object)values);
                for (SolrFacetProperties.CustomProperties cp : list) {
                    customProperties.put(cp.getName(), cp.getValue());
                }
                continue;
            }
            customProperties.put(entry.getKey(), entry.getValue());
        }
        return customProperties;
    }

    @Override
    public void reorderFacets(List<String> facetIds) {
        NodeRef facetsRoot;
        boolean result;
        if (facetIds == null) {
            throw new NullPointerException("Illegal null facetIds");
        }
        if (facetIds.isEmpty()) {
            throw new Exceptions.MissingFacetId("Illegal empty facetIds");
        }
        List<SolrFacetProperties> existingFacets = this.getFacets();
        LinkedHashMap<String, SolrFacetProperties> sortedFacets = new LinkedHashMap<String, SolrFacetProperties>();
        ArrayList<String> removedFacetIds = new ArrayList<String>();
        for (String facetId : facetIds) {
            SolrFacetProperties facet = this.getFacet(facetId);
            if (facet == null) {
                logger.warn((Object)("Facet with [" + facetId + "] ID does not exist. Removing it from the facets' ordering list"));
                removedFacetIds.add(facetId);
                continue;
            }
            if (sortedFacets.containsKey(facetId)) {
                throw new Exceptions.DuplicateFacetId("Cannot reorder facets as sequence contains duplicate entry for ID:", facetId);
            }
            sortedFacets.put(facetId, facet);
        }
        if (existingFacets.size() != sortedFacets.size()) {
            throw new Exceptions.IllegalArgument("Cannot reorder facets. Expected " + existingFacets.size() + " IDs but only received " + sortedFacets.size());
        }
        ArrayList<String> serializableProp = new ArrayList<String>(facetIds);
        if (removedFacetIds.size() > 0 && (result = serializableProp.removeAll(removedFacetIds))) {
            logger.info((Object)("Removed " + String.valueOf(removedFacetIds) + " from the facets' ordering list."));
        }
        if ((facetsRoot = this.getFacetsRoot()) == null) {
            facetsRoot = this.createFacetsRootFolder();
        }
        this.nodeService.setProperty(facetsRoot, SolrFacetModel.PROP_FACET_ORDER, serializableProp);
    }

    private NodeRef createFacetsRootFolder() {
        return (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                QName facetsRootAssocQName;
                QName appModel;
                NodeRef companyHome = SolrFacetServiceImpl.this.repositoryHelper.getCompanyHome();
                NodeRef dataDict = SolrFacetServiceImpl.this.getSingleChildNodeRef(companyHome, appModel = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"dictionary"));
                NodeRef result = SolrFacetServiceImpl.this.getSingleChildNodeRef(dataDict, facetsRootAssocQName = QName.createQName((String)SolrFacetServiceImpl.this.facetsRootChildName, (NamespacePrefixResolver)SolrFacetServiceImpl.this.namespaceService));
                if (result == null) {
                    ArrayList<Properties> singletonList = new ArrayList<Properties>();
                    singletonList.add(SolrFacetServiceImpl.this.bootstrapView);
                    SolrFacetServiceImpl.this.importerBootstrap.setBootstrapViews(singletonList);
                    SolrFacetServiceImpl.this.importerBootstrap.setUseExistingStore(true);
                    SolrFacetServiceImpl.this.importerBootstrap.bootstrap();
                    result = SolrFacetServiceImpl.this.getSingleChildNodeRef(dataDict, facetsRootAssocQName);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created Facets Root Folder: " + String.valueOf(result)));
                }
                return result;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private NodeRef getSingleChildNodeRef(NodeRef parent, QName assocName) {
        NodeRef result;
        List assocs = this.nodeService.getChildAssocs(parent, RegexQNamePattern.MATCH_ALL, (QNamePattern)assocName, true);
        if (assocs == null || assocs.isEmpty()) {
            result = null;
        } else if (assocs.size() > 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("Expected exactly one child node at: ").append(parent).append("/").append(assocName).append(" but found ").append(assocs == null ? "<null assocs>" : Integer.valueOf(assocs.size()));
            if (logger.isErrorEnabled()) {
                logger.error((Object)msg.toString());
            }
            result = ((ChildAssociationRef)assocs.get(0)).getChildRef();
        } else {
            result = ((ChildAssociationRef)assocs.get(0)).getChildRef();
        }
        return result;
    }

    @Override
    public List<PropertyDefinition> getFacetableProperties() {
        ArrayList<PropertyDefinition> result = new ArrayList<PropertyDefinition>();
        List allContentClasses = CollectionUtils.flatten((Collection[])new Collection[]{this.dictionaryService.getAllAspects(), this.dictionaryService.getAllTypes()});
        for (QName contentClass : allContentClasses) {
            result.addAll(this.getFacetableProperties(contentClass));
        }
        return result;
    }

    @Override
    public List<PropertyDefinition> getFacetableProperties(QName contentClass) {
        ArrayList<PropertyDefinition> result = new ArrayList<PropertyDefinition>();
        Map propertyDefs = this.dictionaryService.getPropertyDefs(contentClass);
        if (propertyDefs != null) {
            block5: for (Map.Entry prop : propertyDefs.entrySet()) {
                PropertyDefinition propDef = (PropertyDefinition)prop.getValue();
                if (!propDef.isIndexed()) continue;
                Facetable propIsFacetable = propDef.getFacetable();
                switch (propIsFacetable) {
                    case TRUE: {
                        result.add(propDef);
                        break;
                    }
                    case FALSE: {
                        break;
                    }
                    case UNSET: {
                        DataTypeDefinition datatype = propDef.getDataType();
                        if (!this.isNumeric(datatype) && !this.isDateLike(datatype) && !this.isFacetableText(datatype)) continue block5;
                        result.add(propDef);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Failed to handle " + Facetable.class.getSimpleName() + " type: " + String.valueOf(propIsFacetable));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public List<SolrFacetService.SyntheticPropertyDefinition> getFacetableSyntheticProperties() {
        ArrayList<SolrFacetService.SyntheticPropertyDefinition> result = new ArrayList<SolrFacetService.SyntheticPropertyDefinition>();
        List allContentClasses = CollectionUtils.flatten((Collection[])new Collection[]{this.dictionaryService.getAllAspects(), this.dictionaryService.getAllTypes()});
        for (QName contentClass : allContentClasses) {
            result.addAll(this.getFacetableSyntheticProperties(contentClass));
        }
        return result;
    }

    @Override
    public List<SolrFacetService.SyntheticPropertyDefinition> getFacetableSyntheticProperties(QName contentClass) {
        ArrayList<SolrFacetService.SyntheticPropertyDefinition> result = new ArrayList<SolrFacetService.SyntheticPropertyDefinition>();
        Map propertyDefs = this.dictionaryService.getPropertyDefs(contentClass);
        if (propertyDefs != null) {
            for (Map.Entry prop : propertyDefs.entrySet()) {
                PropertyDefinition propDef = (PropertyDefinition)prop.getValue();
                if (!DataTypeDefinition.CONTENT.equals((Object)propDef.getDataType().getName())) continue;
                result.add(new SolrFacetService.SyntheticPropertyDefinition(propDef, "size", DataTypeDefinition.LONG));
                result.add(new SolrFacetService.SyntheticPropertyDefinition(propDef, "mimetype", DataTypeDefinition.TEXT));
            }
        }
        return result;
    }

    private boolean isNumeric(DataTypeDefinition datatype) {
        boolean result;
        try {
            Class<?> clazz = Class.forName(datatype.getJavaClassName());
            result = Number.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            result = false;
        }
        return result;
    }

    private boolean isDateLike(DataTypeDefinition datatype) {
        return DataTypeDefinition.DATE.equals((Object)datatype.getName()) || DataTypeDefinition.DATETIME.equals((Object)datatype.getName());
    }

    private boolean isFacetableText(DataTypeDefinition datatype) {
        return DataTypeDefinition.TEXT.equals((Object)datatype.getName());
    }
}

