/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;

public class PasswordGrantFlowHandler {
    private final ClientRegistration clientRegistration;

    public PasswordGrantFlowHandler(ClientRegistration clientRegistration) {
        this.clientRegistration = clientRegistration;
    }

    @Deprecated(since="26.1")
    public IdentityServiceFacade.AccessTokenAuthorization passwordGrantFlow(IdentityServiceFacade.AuthorizationGrant authorizationGrant) throws IOException, ParseException {
        TokenRequest tokenRequest = this.prepareTokenRequest(authorizationGrant);
        AccessTokenResponse passwordGrantToken = PasswordGrantFlowHandler.handleTokenRequest(tokenRequest);
        return new NimbusAccessTokenAuthorization(passwordGrantToken.getTokens());
    }

    private static AccessTokenResponse handleTokenRequest(TokenRequest tokenRequest) throws IOException, ParseException {
        HTTPResponse httpResponse = tokenRequest.toHTTPRequest().send();
        TokenResponse tokenResponse = TokenResponse.parse((HTTPResponse)httpResponse);
        if (!tokenResponse.indicatesSuccess()) {
            TokenErrorResponse errorResponse = tokenResponse.toErrorResponse();
            throw new OAuth2AuthorizationException(new OAuth2Error(errorResponse.getErrorObject().getCode(), errorResponse.getErrorObject().getDescription(), null));
        }
        return tokenResponse.toSuccessResponse();
    }

    private TokenRequest prepareTokenRequest(IdentityServiceFacade.AuthorizationGrant authorizationGrant) {
        Scope scope = Scope.parse((Collection)this.clientRegistration.getScopes());
        TokenRequest.Builder tokenRequestBuilder = new TokenRequest.Builder(URI.create(this.clientRegistration.getProviderDetails().getTokenUri()), this.createClientAuthentication(), (AuthorizationGrant)this.createPasswordGrant(authorizationGrant)).scope(scope);
        this.createRequestMetadata().forEach((string, stringArray) -> {
            TokenRequest.Builder builder2 = tokenRequestBuilder.customParameter(string, stringArray);
        });
        return tokenRequestBuilder.build();
    }

    private ResourceOwnerPasswordCredentialsGrant createPasswordGrant(IdentityServiceFacade.AuthorizationGrant authorizationGrant) {
        return new ResourceOwnerPasswordCredentialsGrant(authorizationGrant.getUsername(), new Secret(authorizationGrant.getPassword()));
    }

    private ClientAuthentication createClientAuthentication() {
        return new ClientSecretBasic(new ClientID(this.clientRegistration.getClientId()), new Secret(this.clientRegistration.getClientSecret()));
    }

    /*
     * Exception decompiling
     */
    private Map<String, String[]> createRequestMetadata() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private record NimbusAccessToken(AccessToken token) implements IdentityServiceFacade.AccessToken
    {
        @Override
        public String getTokenValue() {
            return this.token.getValue();
        }

        @Override
        public Instant getExpiresAt() {
            long lifetime = this.token.getLifetime();
            if (lifetime <= 0L) {
                return null;
            }
            return Instant.now().plusSeconds(lifetime);
        }
    }

    private record NimbusAccessTokenAuthorization(Tokens tokens) implements IdentityServiceFacade.AccessTokenAuthorization
    {
        @Override
        public IdentityServiceFacade.AccessToken getAccessToken() {
            return new NimbusAccessToken(this.tokens.getAccessToken());
        }

        @Override
        public String getRefreshTokenValue() {
            return Optional.ofNullable(this.tokens.getRefreshToken()).map(Identifier::getValue).orElse(null);
        }
    }
}

