/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import com.nimbusds.oauth2.sdk.ParseException;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.PasswordGrantFlowHandler;
import org.alfresco.repo.security.authentication.identityservice.user.DecodedTokenUser;
import org.alfresco.repo.security.authentication.identityservice.user.UserInfoAttrMapping;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.endpoint.RestClientAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.RestClientRefreshTokenTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationExchange;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponse;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

class SpringBasedIdentityServiceFacade
implements IdentityServiceFacade {
    private static final Log LOGGER = LogFactory.getLog(SpringBasedIdentityServiceFacade.class);
    private static final Instant SOME_INSIGNIFICANT_DATE_IN_THE_PAST = Instant.MIN.plusSeconds(12345L);
    private final Map<AuthorizationGrantType, OAuth2AccessTokenResponseClient> clients;
    private final DefaultOAuth2UserService defaultOAuth2UserService;
    private final PasswordGrantFlowHandler passwordGrantFlowHandler;
    private final ClientRegistration clientRegistration;
    private final JwtDecoder jwtDecoder;

    SpringBasedIdentityServiceFacade(RestTemplate restTemplate, ClientRegistration clientRegistration, JwtDecoder jwtDecoder) {
        Objects.requireNonNull(restTemplate);
        this.clientRegistration = Objects.requireNonNull(clientRegistration);
        this.jwtDecoder = Objects.requireNonNull(jwtDecoder);
        this.clients = Map.of(AuthorizationGrantType.AUTHORIZATION_CODE, SpringBasedIdentityServiceFacade.createAuthorizationCodeClient(restTemplate), AuthorizationGrantType.REFRESH_TOKEN, SpringBasedIdentityServiceFacade.createRefreshTokenClient(restTemplate));
        this.defaultOAuth2UserService = SpringBasedIdentityServiceFacade.createOAuth2UserService(restTemplate);
        this.passwordGrantFlowHandler = new PasswordGrantFlowHandler(clientRegistration);
    }

    @Override
    public IdentityServiceFacade.AccessTokenAuthorization authorize(IdentityServiceFacade.AuthorizationGrant authorizationGrant) {
        IdentityServiceFacade.AccessTokenAuthorization response;
        try {
            if (authorizationGrant.isPassword()) {
                response = this.passwordGrantFlowHandler.passwordGrantFlow(authorizationGrant);
            } else {
                AbstractOAuth2AuthorizationGrantRequest request = this.createRequest(authorizationGrant);
                OAuth2AccessTokenResponseClient client = this.getClient(request);
                response = new SpringAccessTokenAuthorization(client.getTokenResponse(request));
            }
        }
        catch (OAuth2AuthorizationException e) {
            LOGGER.debug((Object)("Failed to authorize against Authorization Server. Reason: " + String.valueOf(e.getError()) + "."));
            throw new IdentityServiceFacade.AuthorizationException("Failed to obtain access token. " + String.valueOf(e.getError()), e);
        }
        catch (ParseException | IOException | RuntimeException e) {
            LOGGER.warn((Object)("Failed to authorize against Authorization Server. Reason: " + e.getMessage()));
            throw new IdentityServiceFacade.AuthorizationException("Failed to obtain access token.", e);
        }
        return response;
    }

    @Override
    public Optional<DecodedTokenUser> getUserInfo(String token, UserInfoAttrMapping userInfoAttrMapping) {
        try {
            return Optional.ofNullable(this.defaultOAuth2UserService.loadUser(new OAuth2UserRequest(this.clientRegistration, SpringBasedIdentityServiceFacade.getSpringAccessToken(token)))).flatMap(oAuth2User -> this.mapOAuth2UserToDecodedTokenUser((OAuth2User)oAuth2User, userInfoAttrMapping));
        }
        catch (OAuth2AuthenticationException exception) {
            LOGGER.warn((Object)("User Info Request failed: " + exception.getMessage()));
            return Optional.empty();
        }
    }

    @Override
    public ClientRegistration getClientRegistration() {
        return this.clientRegistration;
    }

    @Override
    public IdentityServiceFacade.DecodedAccessToken decodeToken(String token) {
        Jwt validToken;
        try {
            validToken = this.jwtDecoder.decode(token);
        }
        catch (RuntimeException e) {
            throw new IdentityServiceFacade.TokenDecodingException("Failed to decode token. " + e.getMessage(), e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Bearer token outcome: " + String.valueOf(validToken.getClaims())));
        }
        return new SpringDecodedAccessToken(validToken);
    }

    private AbstractOAuth2AuthorizationGrantRequest createRequest(IdentityServiceFacade.AuthorizationGrant grant) {
        if (grant.isRefreshToken()) {
            OAuth2AccessToken expiredAccessToken = SpringBasedIdentityServiceFacade.getSpringAccessToken("JUST_FOR_FULFILLING_THE_SPRING_API");
            OAuth2RefreshToken refreshToken = new OAuth2RefreshToken(grant.getRefreshToken(), null);
            return new OAuth2RefreshTokenGrantRequest(this.clientRegistration, expiredAccessToken, refreshToken, this.clientRegistration.getScopes());
        }
        if (grant.isAuthorizationCode()) {
            OAuth2AuthorizationExchange authzExchange = new OAuth2AuthorizationExchange(((OAuth2AuthorizationRequest.Builder)((OAuth2AuthorizationRequest.Builder)((OAuth2AuthorizationRequest.Builder)((OAuth2AuthorizationRequest.Builder)OAuth2AuthorizationRequest.authorizationCode().clientId(this.clientRegistration.getClientId())).authorizationUri(this.clientRegistration.getProviderDetails().getAuthorizationUri())).redirectUri(grant.getRedirectUri())).scopes(this.clientRegistration.getScopes())).build(), OAuth2AuthorizationResponse.success((String)grant.getAuthorizationCode()).redirectUri(grant.getRedirectUri()).build());
            return new OAuth2AuthorizationCodeGrantRequest(this.clientRegistration, authzExchange);
        }
        throw new UnsupportedOperationException("Unsupported grant type.");
    }

    private OAuth2AccessTokenResponseClient getClient(AbstractOAuth2AuthorizationGrantRequest request) {
        AuthorizationGrantType grantType = request.getGrantType();
        OAuth2AccessTokenResponseClient client = this.clients.get(grantType);
        if (client == null) {
            throw new UnsupportedOperationException("Unsupported grant type `" + String.valueOf(grantType) + "`.");
        }
        return client;
    }

    private static OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> createAuthorizationCodeClient(RestTemplate rest) {
        RestClientAuthorizationCodeTokenResponseClient client = new RestClientAuthorizationCodeTokenResponseClient();
        client.setRestClient(RestClient.create((RestTemplate)rest));
        return client;
    }

    private static OAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest> createRefreshTokenClient(RestTemplate rest) {
        RestClientRefreshTokenTokenResponseClient client = new RestClientRefreshTokenTokenResponseClient();
        client.setRestClient(RestClient.create((RestTemplate)rest));
        return client;
    }

    private static DefaultOAuth2UserService createOAuth2UserService(RestTemplate rest) {
        DefaultOAuth2UserService userService = new DefaultOAuth2UserService();
        userService.setRestOperations((RestOperations)rest);
        return userService;
    }

    private Optional<DecodedTokenUser> mapOAuth2UserToDecodedTokenUser(OAuth2User oAuth2User, UserInfoAttrMapping userInfoAttrMapping) {
        Optional<String> preferredUsername = Optional.ofNullable(oAuth2User.getAttribute("preferred_username")).filter(String.class::isInstance).map(String.class::cast).filter(StringUtils::isNotEmpty);
        Optional<String> userName = Optional.ofNullable(oAuth2User.getName()).filter(username -> !username.isEmpty()).or(() -> preferredUsername);
        return userName.map(name -> DecodedTokenUser.validateAndCreate(name, oAuth2User.getAttribute(userInfoAttrMapping.firstNameClaim()), oAuth2User.getAttribute(userInfoAttrMapping.lastNameClaim()), oAuth2User.getAttribute(userInfoAttrMapping.emailClaim())));
    }

    private static OAuth2AccessToken getSpringAccessToken(String token) {
        return new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, token, SOME_INSIGNIFICANT_DATE_IN_THE_PAST, SOME_INSIGNIFICANT_DATE_IN_THE_PAST.plusSeconds(1L));
    }

    private static class SpringAccessToken
    implements IdentityServiceFacade.AccessToken {
        private final AbstractOAuth2Token token;

        private SpringAccessToken(AbstractOAuth2Token token) {
            this.token = Objects.requireNonNull(token);
        }

        @Override
        public String getTokenValue() {
            return this.token.getTokenValue();
        }

        @Override
        public Instant getExpiresAt() {
            return this.token.getExpiresAt();
        }
    }

    private static class SpringAccessTokenAuthorization
    implements IdentityServiceFacade.AccessTokenAuthorization {
        private final OAuth2AccessTokenResponse tokenResponse;

        private SpringAccessTokenAuthorization(OAuth2AccessTokenResponse tokenResponse) {
            this.tokenResponse = Objects.requireNonNull(tokenResponse);
        }

        @Override
        public IdentityServiceFacade.AccessToken getAccessToken() {
            return new SpringAccessToken((AbstractOAuth2Token)this.tokenResponse.getAccessToken());
        }

        @Override
        public String getRefreshTokenValue() {
            return Optional.of(this.tokenResponse).map(OAuth2AccessTokenResponse::getRefreshToken).map(AbstractOAuth2Token::getTokenValue).orElse(null);
        }
    }

    private static class SpringDecodedAccessToken
    extends SpringAccessToken
    implements IdentityServiceFacade.DecodedAccessToken {
        private final Jwt jwt;

        private SpringDecodedAccessToken(Jwt jwt) {
            super((AbstractOAuth2Token)jwt);
            this.jwt = jwt;
        }

        @Override
        public Object getClaim(String claim) {
            return this.jwt.getClaim(claim);
        }
    }
}

