/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transfer.AlienProcessor;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlienProcessorImpl
implements AlienProcessor {
    private NodeService nodeService;
    private BehaviourFilter behaviourFilter;
    private DictionaryService dictionaryService;
    private DescriptorService descriptorService;
    private static final Log log = LogFactory.getLog(AlienProcessorImpl.class);

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"behaviourFilter", (Object)this.behaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.getDictionaryService());
        PropertyCheck.mandatory((Object)this, (String)"descriptorService", (Object)this.descriptorService);
    }

    @Override
    public void onCreateChild(ChildAssociationRef childAssocRef, final String repositoryId, boolean isNewNode) {
        String parentFromRepo;
        Collection subAspects;
        log.debug((Object)"on create child association to transferred node");
        ChildAssociationRef currentAssoc = childAssocRef;
        NodeRef parentNodeRef = currentAssoc.getParentRef();
        NodeRef childNodeRef = currentAssoc.getChildRef();
        if (!childAssocRef.isPrimary()) {
            log.debug((Object)"not a primary assoc - do nothing");
            return;
        }
        if (!childAssocRef.getTypeQName().equals((Object)ContentModel.ASSOC_CONTAINS) && !(subAspects = this.dictionaryService.getSubAspects(ContentModel.ASSOC_CONTAINS, true)).contains(childAssocRef.getTypeQName())) {
            log.debug((Object)"not a subtype of cm:contains - do nothing");
            return;
        }
        if (!this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_TRANSFERRED) && !this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_ALIEN)) {
            log.debug((Object)"parent was not transferred or alien - do nothing");
            return;
        }
        if (!this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_ALIEN) && repositoryId.equalsIgnoreCase(parentFromRepo = (String)((Object)this.nodeService.getProperty(parentNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID)))) {
            log.debug((Object)"parent was not alien and this node is from the same repo - do nothing");
            return;
        }
        this.setAlien(childNodeRef, repositoryId);
        while (currentAssoc != null) {
            parentNodeRef = currentAssoc.getParentRef();
            childNodeRef = currentAssoc.getChildRef();
            if (this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_TRANSFERRED) || this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_ALIEN)) {
                if (!this.isInvaded(parentNodeRef, repositoryId)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("alien invades parent node:" + String.valueOf(parentNodeRef) + ", repositoryId:" + repositoryId));
                    }
                    final NodeRef newAlien = parentNodeRef;
                    AuthenticationUtil.RunAsWork<Void> actionRunAs = new AuthenticationUtil.RunAsWork<Void>(){

                        public Void doWork() throws Exception {
                            AlienProcessorImpl.this.getBehaviourFilter().disableBehaviour(newAlien, ContentModel.ASPECT_AUDITABLE);
                            AlienProcessorImpl.this.getBehaviourFilter().disableBehaviour(newAlien, ContentModel.ASPECT_LOCKABLE);
                            AlienProcessorImpl.this.setAlien(newAlien, repositoryId);
                            return null;
                        }
                    };
                    AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)actionRunAs, (String)AuthenticationUtil.getSystemUserName());
                    currentAssoc = this.nodeService.getPrimaryParent(parentNodeRef);
                    continue;
                }
                log.debug((Object)"parent node is already invaded");
                currentAssoc = null;
                continue;
            }
            log.debug((Object)"parent is not a transferred node");
            currentAssoc = null;
        }
        if (log.isTraceEnabled()) {
            this.logInvasionHierarchy(childAssocRef.getParentRef(), childAssocRef.getChildRef());
        }
    }

    protected void logInvasionHierarchy(NodeRef parentRef, NodeRef childRef) {
        Map properties = this.nodeService.getProperties(childRef);
        Map parentProperties = this.nodeService.getProperties(parentRef);
        StringBuilder message = new StringBuilder("Information about '").append(properties.get(ContentModel.PROP_NAME)).append("' node:\n    fromRepositoryId: ").append(properties.get(TransferModel.PROP_FROM_REPOSITORY_ID)).append("\n").append("    invadedBy: ").append(properties.get(TransferModel.PROP_INVADED_BY)).append("\n").append("    alien: ").append(this.nodeService.hasAspect(childRef, TransferModel.ASPECT_ALIEN)).append("\n").append("    repositoryId: ").append(properties.get(TransferModel.PROP_REPOSITORY_ID)).append("\n").append("    parent: ").append(parentProperties.get(ContentModel.PROP_NAME)).append("(").append(parentProperties.get(TransferModel.PROP_FROM_REPOSITORY_ID)).append(")").append(parentProperties.get(TransferModel.PROP_INVADED_BY)).append(": ").append(this.nodeService.hasAspect(parentRef, TransferModel.ASPECT_ALIEN)).append("\n").append("    children:\n");
        List childAssocs = this.nodeService.getChildAssocs(childRef);
        if (childAssocs != null && !childAssocs.isEmpty()) {
            for (ChildAssociationRef child : childAssocs) {
                properties = this.nodeService.getProperties(child.getChildRef());
                message.append("        ").append(properties.get(ContentModel.PROP_NAME)).append("(").append(properties.get(TransferModel.PROP_FROM_REPOSITORY_ID)).append(")").append(properties.get(TransferModel.PROP_INVADED_BY)).append(": ").append(this.nodeService.hasAspect(child.getChildRef(), TransferModel.ASPECT_ALIEN)).append("\n");
            }
        }
        log.trace((Object)message.toString());
    }

    @Override
    public void beforeDeleteAlien(NodeRef deletedNodeRef, ChildAssociationRef oldAssoc) {
        log.debug((Object)"before delete node - need to check for alien invaders");
        List stuff = (List)((Object)this.nodeService.getProperty(deletedNodeRef, TransferModel.PROP_INVADED_BY));
        if (stuff == null) {
            return;
        }
        Vector exInvaders = new Vector(stuff);
        ChildAssociationRef currentAssoc = oldAssoc != null ? oldAssoc : this.nodeService.getPrimaryParent(deletedNodeRef);
        while (currentAssoc != null && exInvaders != null && exInvaders.size() > 0) {
            NodeRef parentNodeRef = currentAssoc.getParentRef();
            NodeRef currentNodeRef = currentAssoc == oldAssoc ? deletedNodeRef : currentAssoc.getChildRef();
            if (this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_ALIEN)) {
                log.debug((Object)"parent node is invaded by aliens");
                String parentRepoId = this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_TRANSFERRED) ? (String)((Object)this.nodeService.getProperty(parentNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID)) : this.descriptorService.getCurrentRepositoryDescriptor().getId();
                exInvaders.remove(parentRepoId);
                ListIterator i = exInvaders.listIterator();
                block1: while (i.hasNext()) {
                    String exInvader = (String)i.next();
                    log.debug((Object)("Checking exInvader:" + exInvader));
                    List refs = this.nodeService.getChildAssocsByPropertyValue(parentNodeRef, TransferModel.PROP_INVADED_BY, (Serializable)((Object)exInvader));
                    for (ChildAssociationRef ref : refs) {
                        NodeRef childRef = ref.getChildRef();
                        List invadedBy = (List)((Object)this.nodeService.getProperty(childRef, TransferModel.PROP_INVADED_BY));
                        if (childRef.equals((Object)currentNodeRef) || invadedBy == null || !invadedBy.contains(exInvader)) continue;
                        log.debug((Object)"yes there is a sibling so it remains an invader");
                        i.remove();
                        continue block1;
                    }
                }
                log.debug((Object)"end of checking siblings");
                if (exInvaders.size() > 0) {
                    log.debug((Object)("removing invaders from parent node:" + String.valueOf(parentNodeRef)));
                    List parentInvaders = (List)((Object)this.nodeService.getProperty(parentNodeRef, TransferModel.PROP_INVADED_BY));
                    final ArrayList<String> newInvaders = new ArrayList<String>(10);
                    for (String invader : parentInvaders) {
                        if (exInvaders.contains(invader)) {
                            log.debug((Object)("removing invader:" + invader));
                            continue;
                        }
                        newInvaders.add(invader);
                    }
                    final NodeRef oldAlien = parentNodeRef;
                    AuthenticationUtil.RunAsWork<Void> actionRunAs = new AuthenticationUtil.RunAsWork<Void>(){

                        public Void doWork() throws Exception {
                            AlienProcessorImpl.this.behaviourFilter.disableBehaviour(oldAlien, ContentModel.ASPECT_AUDITABLE);
                            AlienProcessorImpl.this.behaviourFilter.disableBehaviour(oldAlien, ContentModel.ASPECT_LOCKABLE);
                            if (newInvaders.size() > 0) {
                                AlienProcessorImpl.this.nodeService.setProperty(oldAlien, TransferModel.PROP_INVADED_BY, (Serializable)((Object)newInvaders));
                            } else {
                                log.debug((Object)("parent node is no longer alien nodeRef" + String.valueOf(oldAlien)));
                                AlienProcessorImpl.this.nodeService.removeAspect(oldAlien, TransferModel.ASPECT_ALIEN);
                            }
                            return null;
                        }
                    };
                    AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)actionRunAs, (String)AuthenticationUtil.getSystemUserName());
                }
                currentAssoc = this.nodeService.getPrimaryParent(parentNodeRef);
                continue;
            }
            log.debug((Object)"parent is not an alien node");
            currentAssoc = null;
        }
    }

    @Override
    public void afterMoveAlien(ChildAssociationRef newAssocRef) {
        log.debug((Object)"after move alien: newAssocRef");
        NodeRef parentNodeRef = newAssocRef.getParentRef();
        NodeRef childNodeRef = newAssocRef.getChildRef();
        List childInvadedBy = (List)((Object)this.nodeService.getProperty(childNodeRef, TransferModel.PROP_INVADED_BY));
        if (this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_TRANSFERRED) || this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_ALIEN)) {
            Collection subAspects;
            ArrayList<String> aliensToAdd = new ArrayList<String>();
            log.debug((Object)"new parent is transferred or alien");
            if (!newAssocRef.getTypeQName().equals((Object)ContentModel.ASSOC_CONTAINS) && !(subAspects = this.dictionaryService.getSubAspects(ContentModel.ASSOC_CONTAINS, true)).contains(newAssocRef.getTypeQName())) {
                log.debug((Object)"not a subtype of cm:contains - may need to uninvade");
                String parentRepoId = this.descriptorService.getCurrentRepositoryDescriptor().getId();
                this.retreatDownwards(childNodeRef, parentRepoId);
                return;
            }
            if (this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_ALIEN)) {
                List parentInvadedBy = (List)((Object)this.nodeService.getProperty(parentNodeRef, TransferModel.PROP_INVADED_BY));
                for (String invader : childInvadedBy) {
                    if (parentInvadedBy.contains(invader)) continue;
                    aliensToAdd.add(invader);
                }
            } else {
                String parentFromRepo = (String)((Object)this.nodeService.getProperty(parentNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID));
                for (String invader : childInvadedBy) {
                    if (invader.equalsIgnoreCase(parentFromRepo)) {
                        log.debug((Object)"child node is from the same repo as a non invaded node");
                        this.retreatDownwards(childNodeRef, parentFromRepo);
                        continue;
                    }
                    aliensToAdd.add(invader);
                }
            }
            ChildAssociationRef currentAssoc = newAssocRef;
            while (currentAssoc != null && aliensToAdd.size() > 0) {
                parentNodeRef = currentAssoc.getParentRef();
                childNodeRef = currentAssoc.getChildRef();
                if (this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_TRANSFERRED) || this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_ALIEN)) {
                    Iterator i = aliensToAdd.iterator();
                    while (i.hasNext()) {
                        String alienRepoId = (String)i.next();
                        if (!this.isInvaded(parentNodeRef, alienRepoId)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("alien invades parent node:" + String.valueOf(parentNodeRef) + ", repositoryId:" + alienRepoId));
                            }
                            final NodeRef newAlien = parentNodeRef;
                            final String fAlien = alienRepoId;
                            AuthenticationUtil.RunAsWork<Void> actionRunAs = new AuthenticationUtil.RunAsWork<Void>(){

                                public Void doWork() throws Exception {
                                    AlienProcessorImpl.this.getBehaviourFilter().disableBehaviour(newAlien, ContentModel.ASPECT_AUDITABLE);
                                    AlienProcessorImpl.this.getBehaviourFilter().disableBehaviour(newAlien, ContentModel.ASPECT_LOCKABLE);
                                    AlienProcessorImpl.this.setAlien(newAlien, fAlien);
                                    return null;
                                }
                            };
                            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)actionRunAs, (String)AuthenticationUtil.getSystemUserName());
                        } else {
                            log.debug((Object)("parent node is already invaded by:" + alienRepoId));
                            i.remove();
                        }
                        currentAssoc = this.nodeService.getPrimaryParent(parentNodeRef);
                    }
                    continue;
                }
                log.debug((Object)"parent is not a transferred node");
                currentAssoc = null;
            }
        } else {
            log.debug((Object)"parent was not transferred or alien");
            String parentRepoId = this.descriptorService.getCurrentRepositoryDescriptor().getId();
            this.retreatDownwards(childNodeRef, parentRepoId);
            return;
        }
    }

    private void retreatDownwards(NodeRef nodeRef, String fromRepositoryId) {
        Stack<NodeRef> nodesToRetreat = new Stack<NodeRef>();
        nodesToRetreat.add(nodeRef);
        while (!nodesToRetreat.isEmpty()) {
            String parentRepoId;
            if (log.isDebugEnabled()) {
                log.debug((Object)("retreat :" + String.valueOf(nodeRef) + ", repoId:" + fromRepositoryId));
            }
            NodeRef currentNodeRef = (NodeRef)nodesToRetreat.pop();
            log.debug((Object)("retreatNode:" + String.valueOf(currentNodeRef)));
            if (!this.getNodeService().hasAspect(currentNodeRef, TransferModel.ASPECT_ALIEN)) continue;
            List invadedBy = (List)((Object)this.getNodeService().getProperty(currentNodeRef, TransferModel.PROP_INVADED_BY));
            if (this.nodeService.hasAspect(currentNodeRef, TransferModel.ASPECT_TRANSFERRED)) {
                log.debug((Object)"node is transferred");
                parentRepoId = (String)((Object)this.nodeService.getProperty(currentNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID));
            } else {
                log.debug((Object)"node is local");
                parentRepoId = this.descriptorService.getCurrentRepositoryDescriptor().getId();
            }
            if (!fromRepositoryId.equalsIgnoreCase(parentRepoId)) continue;
            if (invadedBy.size() == 1) {
                log.debug((Object)("no longe alien:" + String.valueOf(currentNodeRef)));
                this.getNodeService().removeAspect(currentNodeRef, TransferModel.ASPECT_ALIEN);
            } else {
                invadedBy.remove(parentRepoId);
                this.getNodeService().setProperty(currentNodeRef, TransferModel.PROP_INVADED_BY, (Serializable)((Object)invadedBy));
            }
            List refs = this.nodeService.getChildAssocsByPropertyValue(currentNodeRef, TransferModel.PROP_INVADED_BY, (Serializable)((Object)fromRepositoryId));
            for (ChildAssociationRef ref : refs) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("will need to check child:" + String.valueOf(ref)));
                }
                nodesToRetreat.push(ref.getChildRef());
            }
        }
    }

    @Override
    public boolean isAlien(NodeRef nodeRef) {
        return this.nodeService.hasAspect(nodeRef, TransferModel.ASPECT_ALIEN);
    }

    @Override
    public void pruneNode(NodeRef nodeToPrune, String fromRepositoryId) {
        Stack<NodeRef> nodesToPrune = new Stack<NodeRef>();
        nodesToPrune.add(nodeToPrune);
        ChildAssociationRef startingParent = this.nodeService.getPrimaryParent(nodeToPrune);
        Stack<NodeRef> foldersToRecalculate = new Stack<NodeRef>();
        while (!nodesToPrune.isEmpty()) {
            String initialRepoId;
            NodeRef currentNodeRef = (NodeRef)nodesToPrune.pop();
            Map properties = null;
            if (log.isDebugEnabled()) {
                properties = this.nodeService.getProperties(currentNodeRef);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Current nodeRef (name: \"" + String.valueOf(properties.get(ContentModel.PROP_NAME)) + "\", fromRepositoryId: \"" + String.valueOf(properties.get(TransferModel.PROP_FROM_REPOSITORY_ID)) + "\", manifestId: \"" + fromRepositoryId + "\")" + String.valueOf(currentNodeRef)));
            }
            log.debug((Object)("pruneNode:" + String.valueOf(currentNodeRef)));
            if (this.getNodeService().hasAspect(currentNodeRef, TransferModel.ASPECT_ALIEN)) {
                List refs;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Current nodeRef has ASPECT_ALIEN (name: \"" + String.valueOf(properties.get(ContentModel.PROP_NAME)) + "\", fromRepositoryId: \"" + String.valueOf(properties.get(TransferModel.PROP_FROM_REPOSITORY_ID)) + "\", manifestId: \"" + fromRepositoryId + "\")"));
                }
                List invadedBy = (List)((Object)this.getNodeService().getProperty(currentNodeRef, TransferModel.PROP_INVADED_BY));
                String initialRepoId2 = (String)((Object)this.getNodeService().getProperty(currentNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Current nodeRef has PROP_INVADED_BY (name: \"" + String.valueOf(properties.get(ContentModel.PROP_NAME)) + "\", fromRepositoryId: \"" + String.valueOf(properties.get(TransferModel.PROP_FROM_REPOSITORY_ID)) + "\", manifestId: \"" + fromRepositoryId + "\"): " + String.valueOf(invadedBy)));
                }
                if (invadedBy != null && invadedBy.contains(fromRepositoryId)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Current nodeRef's PROP_INVADED_BY contains current manifestId (name: \"" + String.valueOf(properties.get(ContentModel.PROP_NAME)) + "\", fromRepositoryId: \"" + String.valueOf(properties.get(TransferModel.PROP_FROM_REPOSITORY_ID)) + "\", manifestId: \"" + fromRepositoryId + "\")"));
                    }
                    if (1 == invadedBy.size() && fromRepositoryId.equalsIgnoreCase(initialRepoId2)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Current nodeRef has only 1 element in PROP_INVADED_BY. Also MANIFEST_ID and INITIAL_REPOSITORY_ID are the same. Deleting the node... (name: \"" + String.valueOf(properties.get(ContentModel.PROP_NAME)) + "\", fromRepositoryId: \"" + String.valueOf(properties.get(TransferModel.PROP_FROM_REPOSITORY_ID)) + "\", manifestId: \"" + fromRepositoryId + "\")"));
                        }
                        this.getNodeService().deleteNode(currentNodeRef);
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Current 'nodeRef' has more than 1 element in PROP_INVADED_BY. Adding its children to 'nodesToPrune' list... (name: \"" + String.valueOf(properties.get(ContentModel.PROP_NAME)) + "\", fromRepositoryId: \"" + String.valueOf(properties.get(TransferModel.PROP_FROM_REPOSITORY_ID)) + "\", manifestId: \"" + fromRepositoryId + "\")"));
                    }
                    refs = this.nodeService.getChildAssocsByPropertyValue(currentNodeRef, TransferModel.PROP_INVADED_BY, (Serializable)((Object)fromRepositoryId));
                    for (ChildAssociationRef ref : refs) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("will need to check child:" + String.valueOf(ref)));
                        }
                        nodesToPrune.push(ref.getChildRef());
                    }
                    if (foldersToRecalculate.contains(currentNodeRef)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Current 'nodeRef' is not in 'foldersToRecalculate' list. Adding it to the list... (name: \"" + String.valueOf(properties.get(ContentModel.PROP_NAME)) + "\", fromRepositoryId: \"" + String.valueOf(properties.get(TransferModel.PROP_FROM_REPOSITORY_ID)) + "\", manifestId: \"" + fromRepositoryId + "\")"));
                    }
                    foldersToRecalculate.push(currentNodeRef);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Current \"nodeRef\"'s PROP_INVADED_BY does not contain current 'manifestId' (name: \"" + String.valueOf(properties.get(ContentModel.PROP_NAME)) + "\", fromRepositoryId: \"" + String.valueOf(properties.get(TransferModel.PROP_FROM_REPOSITORY_ID)) + "\", manifestId: \"" + fromRepositoryId + "\")"));
                }
                this.getNodeService().hasAspect(currentNodeRef, TransferModel.ASPECT_TRANSFERRED);
                if (!fromRepositoryId.equalsIgnoreCase(initialRepoId2)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"folder is from the transferring repository");
                    log.debug((Object)("Current nodeRef has more than 1 element in PROP_INVADED_BY. Adding its children to 'nodesToPrune' list... (name: \"" + String.valueOf(properties.get(ContentModel.PROP_NAME)) + "\", fromRepositoryId: \"" + String.valueOf(properties.get(TransferModel.PROP_FROM_REPOSITORY_ID)) + "\", manifestId: \"" + fromRepositoryId + "\")"));
                }
                refs = this.getNodeService().getChildAssocs(currentNodeRef);
                for (ChildAssociationRef ref : refs) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("will need to check child:" + String.valueOf(ref)));
                    }
                    nodesToPrune.push(ref.getChildRef());
                    if (foldersToRecalculate.contains(currentNodeRef)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Current 'nodeRef' is not in 'foldersToRecalculate' list. Adding it to the list... (name: \"" + String.valueOf(properties.get(ContentModel.PROP_NAME)) + "\", fromRepositoryId: \"" + String.valueOf(properties.get(TransferModel.PROP_FROM_REPOSITORY_ID)) + "\", manifestId: \"" + fromRepositoryId + "\")"));
                    }
                    foldersToRecalculate.push(currentNodeRef);
                }
                continue;
            }
            this.getNodeService().hasAspect(currentNodeRef, TransferModel.ASPECT_TRANSFERRED);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Current 'nodeRef' does not have ASPECT_ALIEN (name: \"" + String.valueOf(properties.get(ContentModel.PROP_NAME)) + "\", fromRepositoryId: \"" + String.valueOf(properties.get(TransferModel.PROP_FROM_REPOSITORY_ID)) + "\", manifestId: \"" + fromRepositoryId + "\")"));
            }
            if (!fromRepositoryId.equalsIgnoreCase(initialRepoId = (String)((Object)this.getNodeService().getProperty(currentNodeRef, TransferModel.PROP_REPOSITORY_ID)))) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Current \"nodeRef\"'s has PROP_FROM_REPOSITORY_ID equal to current 'manifestId'. Deleting the node... (name: \"" + String.valueOf(properties.get(ContentModel.PROP_NAME)) + "\", fromRepositoryId: \"" + String.valueOf(properties.get(TransferModel.PROP_FROM_REPOSITORY_ID)) + "\", manifestId: \"" + fromRepositoryId + "\")"));
                log.debug((Object)("pruned - deleted non alien node:" + String.valueOf(currentNodeRef)));
            }
            this.getNodeService().deleteNode(currentNodeRef);
        }
        while (!foldersToRecalculate.isEmpty()) {
            NodeRef folderNodeRef = (NodeRef)foldersToRecalculate.pop();
            log.debug((Object)("recalculate invadedBy :" + String.valueOf(folderNodeRef)));
            this.recalcInvasion(folderNodeRef, fromRepositoryId);
        }
        log.debug((Object)"now ripple upwards");
        ChildAssociationRef ripple = startingParent;
        while (ripple != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking parent:" + String.valueOf(ripple)));
            }
            if (this.nodeService.hasAspect(ripple.getParentRef(), TransferModel.ASPECT_ALIEN)) {
                if (this.recalcInvasion(ripple.getParentRef(), fromRepositoryId)) {
                    log.debug((Object)"parent is still invaded");
                    ripple = null;
                    continue;
                }
                log.debug((Object)"parent is no longer invaded");
                ripple = this.nodeService.getPrimaryParent(ripple.getParentRef());
                continue;
            }
            ripple = null;
        }
        log.debug((Object)"pruneNode: end");
    }

    private boolean isInvaded(NodeRef nodeRef, String invader) {
        List invadedBy = (List)((Object)this.nodeService.getProperty(nodeRef, TransferModel.PROP_INVADED_BY));
        if (invadedBy == null) {
            return false;
        }
        return invadedBy.contains(invader);
    }

    private void setAlien(NodeRef newAlien, String invader) {
        ArrayList<String> invadedBy = (ArrayList<String>)this.nodeService.getProperty(newAlien, TransferModel.PROP_INVADED_BY);
        if (invadedBy == null) {
            invadedBy = new ArrayList<String>(1);
        }
        if (!invadedBy.contains(invader)) {
            invadedBy.add(invader);
        }
        this.nodeService.setProperty(newAlien, TransferModel.PROP_INVADED_BY, (Serializable)invadedBy);
    }

    private boolean recalcInvasion(NodeRef folderNodeRef, String fromRepositoryId) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"#################");
            log.trace((Object)"#RECALC INVASION#");
            log.trace((Object)"#################");
        }
        List folderInvadedBy = (List)((Object)this.nodeService.getProperty(folderNodeRef, TransferModel.PROP_INVADED_BY));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Node(" + String.valueOf(this.nodeService.getProperty(folderNodeRef, ContentModel.PROP_NAME)) + ")" + String.valueOf(folderInvadedBy) + ": checking '" + fromRepositoryId + "' id..."));
        }
        boolean stillInvaded = false;
        boolean hasAlienChild = false;
        List refs = this.nodeService.getChildAssocs(folderNodeRef);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Children count: " + refs.size()));
            log.debug((Object)("Is alien: " + this.nodeService.hasAspect(folderNodeRef, TransferModel.ASPECT_ALIEN)));
        }
        String parentRepositoryId = (String)((Object)this.nodeService.getProperty(folderNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID));
        for (ChildAssociationRef ref : refs) {
            NodeRef childNode = ref.getChildRef();
            if (log.isTraceEnabled()) {
                this.logInvasionHierarchy(folderNodeRef, childNode);
            }
            Map properties = this.nodeService.getProperties(childNode);
            List childInvadedBy = (List)properties.get(TransferModel.PROP_INVADED_BY);
            String childRepositoryId = (String)properties.get(TransferModel.PROP_FROM_REPOSITORY_ID);
            boolean bl = hasAlienChild = hasAlienChild || !parentRepositoryId.equalsIgnoreCase(childRepositoryId);
            if (stillInvaded || childInvadedBy == null || !childInvadedBy.contains(fromRepositoryId) && !fromRepositoryId.equalsIgnoreCase(childRepositoryId)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"This child contains current 'fromRepositoryId'. Current folder is still invaded by this repository");
            }
            stillInvaded = true;
        }
        if (!stillInvaded) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Current folder is not invaded by this repository. Updating 'invadedBy' property...");
                log.debug((Object)("folder is no longer invaded by this repo:" + String.valueOf(folderNodeRef)));
            }
            folderInvadedBy.remove(fromRepositoryId);
            if (folderInvadedBy.size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Current folder HAS ANOTHER invasions. Updating the 'invadedBy' property...");
                    log.debug((Object)("still invaded by:" + String.valueOf(folderInvadedBy)));
                }
                this.getNodeService().setProperty(folderNodeRef, TransferModel.PROP_INVADED_BY, (Serializable)((Object)folderInvadedBy));
            } else if (!hasAlienChild) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no longer alien:" + String.valueOf(folderNodeRef)));
                    log.debug((Object)"This invasion was the last one for the current folder. Removing aspect 'ALIEN' completely...");
                }
                this.getNodeService().removeAspect(folderNodeRef, TransferModel.ASPECT_ALIEN);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"#################");
            log.trace((Object)"#   COMPLETED   #");
            log.trace((Object)"#################");
        }
        return stillInvaded;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public BehaviourFilter getBehaviourFilter() {
        return this.behaviourFilter;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public DescriptorService getDescriptorService() {
        return this.descriptorService;
    }
}

